/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.dpi.model.client;

import com.google.gson.Gson;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.dpi.model.DPIContext;
import org.jkiss.dbeaver.dpi.model.adapters.DPISerializer;
import org.jkiss.dbeaver.dpi.model.client.DPISmartObjectResponse;
import org.jkiss.dbeaver.dpi.model.client.DPISmartObjectWrapper;
import org.jkiss.dbeaver.model.dpi.DPIClientObject;
import org.jkiss.dbeaver.model.dpi.DPIContainer;
import org.jkiss.dbeaver.model.dpi.DPIController;
import org.jkiss.dbeaver.model.dpi.DPIElement;
import org.jkiss.dbeaver.model.dpi.DPIFactory;
import org.jkiss.dbeaver.model.dpi.DPISmartCallback;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.rest.RestProxy;

public class DPIClientProxy
implements DPIClientObject,
InvocationHandler {
    private static final Log log = Log.getLog(DPIClientProxy.class);
    public static final Object SELF_REFERENCE = new Object();
    public static final Object NULL_VALUE = new Object();
    private final DPIContext context;
    private final String objectId;
    private final String objectType;
    private final String objectToString;
    private final Integer objectHashCode;
    private final transient Object objectInstance;
    private Map<String, Object> objectContainers;
    private Map<String, Object> propertyValues;
    private Map<Class<?>, Object> factoryObjects;

    public DPIClientProxy(@NotNull DPIContext context, @NotNull Class<?>[] allInterfaces, @NotNull String objectId, @Nullable String objectType, @Nullable String objectToString, @Nullable Integer objectHashCode, @Nullable Map<String, Object> objectContainers, @Nullable Map<String, Object> propertyValues) {
        this.context = context;
        this.objectId = objectId;
        this.objectType = objectType;
        this.objectToString = objectToString;
        this.objectHashCode = objectHashCode;
        this.objectContainers = objectContainers;
        this.propertyValues = propertyValues;
        this.objectInstance = Proxy.newProxyInstance(context.getClassLoader(), allInterfaces, (InvocationHandler)this);
    }

    public String dpiObjectId() {
        return this.objectId;
    }

    public String dpiObjectType() {
        return this.objectType;
    }

    public ClassLoader dpiClassLoader() {
        return this.context.getClassLoader();
    }

    public Object dpiPropertyValue(@Nullable DBRProgressMonitor monitor, @NotNull String propertyName) throws DBException {
        Object value;
        Object object = value = this.propertyValues == null ? null : this.propertyValues.get(propertyName);
        if (value == NULL_VALUE) {
            return null;
        }
        if (value != null) {
            return value;
        }
        if (monitor == null) {
            return null;
        }
        DPIController controller = this.context.getDpiController();
        if (controller == null) {
            throw new DBException("No DPI controller in client context");
        }
        if (controller instanceof RestProxy) {
            try {
                Type returnType = null;
                Class<?> localClass = this.dpiClassLoader().loadClass(this.dpiObjectType());
                Method getter = DBXTreeItem.findPropertyReadMethod(localClass, (String)propertyName);
                if (getter != null) {
                    returnType = getter.getGenericReturnType();
                }
                ((RestProxy)controller).setNextCallResultType(returnType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.debug((Object)("Cannot resolve local class '" + this.dpiObjectType() + "'"));
            }
        }
        Object propValue = controller.readProperty(this.objectId, propertyName);
        this.cachePropertyValue(propertyName, DPIClientProxy.wrapObjectValue(propValue));
        return propValue;
    }

    public Object dpiObjectMethod(@Nullable DBRProgressMonitor monitor, @NotNull String methodName, @Nullable Object[] arguments) throws DBException {
        return this.invokeRemoteMethod(methodName, arguments, null);
    }

    public Object getObjectInstance() {
        return this.objectInstance;
    }

    public String toString() {
        return this.objectToString;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?>[] parameterTypes;
        Object result;
        Property propAnnotation;
        boolean isElement;
        String methodName;
        block41: {
            methodName = method.getName();
            if (method.getDeclaringClass() == Object.class) {
                if (methodName.equals("toString") && this.objectToString != null) {
                    return this.objectToString;
                }
                if (methodName.equals("hashCode") && this.objectHashCode != null) {
                    return this.objectHashCode;
                }
                return BeanUtils.handleObjectMethod((Object)proxy, (Method)method, (Object[])args);
            }
            if (method.getDeclaringClass() != DPIClientObject.class) break block41;
            switch (methodName) {
                case "dpiObjectId": {
                    return this.dpiObjectId();
                }
                case "dpiObjectType": {
                    return this.dpiObjectType();
                }
                case "dpiClassLoader": {
                    return this.dpiClassLoader();
                }
                case "dpiPropertyValue": {
                    return this.dpiPropertyValue((DBRProgressMonitor)args[0], (String)args[1]);
                }
                case "dpiObjectMethod": {
                    return this.dpiObjectMethod((DBRProgressMonitor)args[0], (String)args[1], (Object[])args[2]);
                }
            }
            log.debug((Object)("Unsupported DPI method '" + methodName + "'"));
            return null;
        }
        DPIContainer containerAnno = DPISerializer.getMethodAnno(method, DPIContainer.class);
        if (containerAnno != null) {
            Object container;
            if (containerAnno.root()) {
                return this.context.getRootObject();
            }
            if (this.objectContainers != null && (container = this.objectContainers.get(methodName)) != null) {
                if (container == SELF_REFERENCE) {
                    return this.objectInstance;
                }
                return DPIClientProxy.unwrapObjectValue(container);
            }
        }
        boolean bl = isElement = DPISerializer.getMethodAnno(method, DPIElement.class) != null || method.getDeclaringClass().getAnnotation(DPIElement.class) != null;
        if (isElement && this.propertyValues != null) {
            Object result2 = this.propertyValues.get(DPIClientProxy.getElementKey(method, args));
            if (result2 == null && method.getParameterTypes().length == 0) {
                result2 = this.propertyValues.get(BeanUtils.getPropertyNameFromGetter((String)method.getName()));
            }
            if (result2 != null) {
                return DPIClientProxy.unwrapObjectValue(result2);
            }
        }
        if ((propAnnotation = method.getAnnotation(Property.class)) != null && this.propertyValues != null && (result = this.propertyValues.get(DPIClientProxy.getPropertyKey(method, propAnnotation))) != null) {
            return DPIClientProxy.unwrapObjectValue(result);
        }
        DPIFactory dpiFactory = DPISerializer.getMethodAnno(method, DPIFactory.class);
        Type dpiFactoryClass = null;
        if (dpiFactory != null && (parameterTypes = method.getParameterTypes()).length == 1 && parameterTypes[0] == Class.class) {
            Object cachedResult;
            dpiFactoryClass = (Class)args[0];
            if (this.factoryObjects != null && (cachedResult = this.factoryObjects.get(dpiFactoryClass)) != null) {
                return DPIClientProxy.unwrapObjectValue(cachedResult);
            }
        }
        Type returnType = dpiFactoryClass != null ? dpiFactoryClass : method.getGenericReturnType();
        Object result3 = this.invokeRemoteMethod(methodName, args, returnType);
        if (propAnnotation != null) {
            this.cachePropertyValue(DPIClientProxy.getPropertyKey(method, propAnnotation), DPIClientProxy.wrapObjectValue(result3));
        } else if (dpiFactoryClass != null) {
            if (this.factoryObjects == null) {
                this.factoryObjects = new HashMap();
            }
            this.factoryObjects.put((Class<?>)dpiFactoryClass, DPIClientProxy.wrapObjectValue(result3));
        } else if (isElement) {
            this.cachePropertyValue(DPIClientProxy.getElementKey(method, args), DPIClientProxy.wrapObjectValue(result3));
        } else if (containerAnno != null) {
            if (this.objectContainers == null) {
                this.objectContainers = new HashMap<String, Object>();
            }
            this.objectContainers.put(methodName, DPIClientProxy.wrapObjectValue(result3));
        }
        return result3;
    }

    private void cachePropertyValue(String propertyName, Object value) {
        if (this.propertyValues == null) {
            this.propertyValues = new HashMap<String, Object>();
        }
        this.propertyValues.put(propertyName, value);
    }

    private Object invokeRemoteMethod(@NotNull String methodName, @Nullable Object[] args, @Nullable Type returnType) throws DBException {
        boolean expectSmartProxy;
        DPIController controller = this.context.getDpiController();
        if (controller == null) {
            throw new DBException("No DPI controller in client context");
        }
        boolean bl = expectSmartProxy = args != null && Arrays.stream(args).anyMatch(argument -> argument != null && DPISerializer.isSmartObject(argument.getClass()));
        if (controller instanceof RestProxy) {
            RestProxy restProxy = (RestProxy)controller;
            restProxy.setNextCallResultType((Type)(expectSmartProxy ? DPISmartObjectResponse.class : returnType));
        }
        try {
            log.debug((Object)MessageFormat.format("Call method: {0} object: {1}", methodName, this.objectId));
            Object result = controller.callMethod(this.objectId, methodName, args);
            if (expectSmartProxy && result instanceof DPISmartObjectResponse) {
                DPISmartObjectResponse smartResponse = (DPISmartObjectResponse)result;
                Gson gson = this.context.getGson();
                result = gson.fromJson(gson.toJson(smartResponse.getMethodInvocationResult()), returnType);
                for (DPISmartObjectWrapper smartObject : smartResponse.getSmartObjects()) {
                    Object object;
                    Object realObject = args[smartObject.getArgumentNumber()];
                    if (smartObject.getProxyObject() == null || !((object = smartObject.getProxyObject()) instanceof DPISmartCallback)) continue;
                    DPISmartCallback dpiClientSmartObject = (DPISmartCallback)object;
                    dpiClientSmartObject.callback(realObject);
                }
            }
            log.debug((Object)MessageFormat.format("Return method result: {0} object: {1}", methodName, this.objectId));
            return result;
        }
        catch (Throwable e) {
            log.debug((Object)MessageFormat.format("Method invocation error: {0} object: {1}", methodName, this.objectId));
            throw e;
        }
    }

    private static Object wrapObjectValue(Object result) {
        return result == null ? NULL_VALUE : result;
    }

    private static Object unwrapObjectValue(Object result) {
        return result == NULL_VALUE ? null : result;
    }

    private static String getPropertyKey(Method method, Property propAnnotation) {
        String propId = propAnnotation.id();
        if (CommonUtils.isEmpty((String)propId)) {
            propId = BeanUtils.getPropertyNameFromGetter((String)method.getName());
        }
        return propId;
    }

    private static String getElementKey(Method method, Object[] args) {
        if (!ArrayUtils.isEmpty((Object[])args)) {
            StringBuilder buf = new StringBuilder(method.getName());
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object arg = objectArray[n2];
                if (!(arg instanceof DBRProgressMonitor)) {
                    buf.append(":").append(arg);
                }
                ++n2;
            }
            return buf.toString();
        }
        return method.getName();
    }
}

