/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLSourceObject;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSequence;
import org.jkiss.utils.CommonUtils;

public class MySQLSequence
implements DBSSequence,
MySQLSourceObject,
DBPQualifiedObject {
    private static final Log log = Log.getLog(MySQLSequence.class);
    private final long MAX_SEQUENCE_VALUE = 0x7FFFFFFFFFFFFFFEL;
    private final long MIN_SEQUENCE_VALUE = -9223372036854775807L;
    private MySQLCatalog sequenceCatalog;
    private String name;
    private String body;
    private Number incrementBy;
    private Number minValue;
    private Number maxValue;
    private Number startValue;
    private Number cacheSize;
    private boolean isCycle;
    private boolean isPersisted;
    private boolean isInfoLoaded;

    public MySQLSequence(@NotNull MySQLCatalog mySQLCatalog, String sequenceName) {
        this.sequenceCatalog = mySQLCatalog;
        this.name = sequenceName;
        this.isPersisted = true;
    }

    public MySQLSequence(@NotNull MySQLCatalog mySQLCatalog, String sequenceName, boolean persisted) {
        this.sequenceCatalog = mySQLCatalog;
        this.name = sequenceName;
        this.isPersisted = persisted;
        this.incrementBy = 1;
        this.minValue = 1;
        this.maxValue = 0x7FFFFFFFFFFFFFFEL;
        this.cacheSize = 1000;
        this.isCycle = false;
    }

    private void loadInfo(DBRProgressMonitor monitor) {
        if (!this.isInfoLoaded && !CommonUtils.isEmpty((String)this.name)) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Load sequence info");){
                    Throwable throwable2 = null;
                    Object var6_10 = null;
                    try (JDBCStatement dbStat = session.createStatement();){
                        Throwable throwable3 = null;
                        Object var9_15 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery("SELECT * FROM " + this.getFullyQualifiedName(DBPEvaluationContext.DDL));){
                            if (dbResult != null && dbResult.nextRow()) {
                                this.incrementBy = CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"increment"));
                                this.minValue = CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"minimum_value"));
                                this.maxValue = CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"maximum_value"));
                                this.startValue = CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"start_value"));
                                this.cacheSize = CommonUtils.toLong((Object)JDBCUtils.safeGetObject((ResultSet)dbResult, (String)"cache_size"));
                                int cycleOption = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"cycle_option");
                                if (cycleOption == 1) {
                                    this.isCycle = true;
                                }
                                this.isInfoLoaded = true;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException | DBCException e) {
                log.debug((Object)"Error reading sequence info", e);
            }
        }
    }

    public Number getLastValue() {
        return null;
    }

    public Number getIncrementBy() {
        return this.incrementBy;
    }

    @Property(viewable=true, order=2)
    public Number getIncrementBy(DBRProgressMonitor monitor) {
        if (this.incrementBy == null) {
            this.loadInfo(monitor);
        }
        return this.incrementBy;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    @Property(viewable=true, order=3)
    public Number getMinValue(DBRProgressMonitor monitor) {
        if (this.minValue == null) {
            this.loadInfo(monitor);
        }
        return this.minValue;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    @Property(viewable=true, order=4)
    public Number getMaxValue(DBRProgressMonitor monitor) {
        if (this.maxValue == null) {
            this.loadInfo(monitor);
        }
        return this.maxValue;
    }

    @Property(viewable=true, order=5)
    public Number getCache(DBRProgressMonitor monitor) {
        if (this.cacheSize == null) {
            this.loadInfo(monitor);
        }
        return this.cacheSize;
    }

    @Property(viewable=true, order=6)
    public Number getStartValue(DBRProgressMonitor monitor) {
        if (this.startValue == null) {
            this.loadInfo(monitor);
        }
        return this.startValue;
    }

    @Property(viewable=true, order=7)
    public boolean isCycle(DBRProgressMonitor monitor) {
        return this.isCycle;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.sequenceCatalog;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.sequenceCatalog.getDataSource();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.sequenceCatalog, this});
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.body = sourceText;
    }

    @Property(hidden=true, editable=true, updatable=true)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        block40: {
            if (this.body == null && this.isPersisted) {
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read sequence declaration");){
                        Throwable throwable2 = null;
                        Object var7_12 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement("SHOW CREATE SEQUENCE " + this.getFullyQualifiedName(DBPEvaluationContext.DDL));){
                            Throwable throwable3 = null;
                            Object var10_17 = null;
                            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                                if (dbResult.next()) {
                                    String sequenceDDL = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"Create Table");
                                    if (!CommonUtils.isEmpty((String)sequenceDDL)) {
                                        this.body = sequenceDDL.replaceAll("CREATE SEQUENCE", "CREATE OR REPLACE SEQUENCE");
                                    }
                                } else {
                                    this.body = "-- Sequence definition not found in catalog";
                                }
                                break block40;
                            }
                            catch (Throwable throwable4) {
                                if (throwable3 == null) {
                                    throwable3 = throwable4;
                                } else if (throwable3 != throwable4) {
                                    throwable3.addSuppressed(throwable4);
                                }
                                throw throwable3;
                            }
                        }
                        catch (Throwable throwable5) {
                            if (throwable2 == null) {
                                throwable2 = throwable5;
                            } else if (throwable2 != throwable5) {
                                throwable2.addSuppressed(throwable5);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable == null) {
                            throwable = throwable6;
                        } else if (throwable != throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        throw throwable;
                    }
                }
                catch (SQLException e) {
                    this.body = "-- " + e.getMessage();
                    throw new DBDatabaseException((Throwable)e, this.getDataSource());
                }
            }
            if (this.body == null && !CommonUtils.isEmpty((String)this.name)) {
                StringBuilder sb = new StringBuilder();
                sb.append("CREATE OR REPLACE SEQUENCE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DDL)).append(" ");
                if (this.incrementBy != null) {
                    sb.append("INCREMENT BY ").append(this.getIncrementBy()).append(" ");
                }
                if (this.minValue != null && this.minValue.longValue() != -9223372036854775807L) {
                    sb.append("MINVALUE ").append(this.getMinValue()).append(" ");
                }
                if (this.maxValue != null && this.maxValue.longValue() != 0x7FFFFFFFFFFFFFFEL) {
                    sb.append("MAXVALUE ").append(this.getMaxValue()).append(" ");
                }
                if (this.isCycle) {
                    sb.append("CYCLE ");
                } else {
                    sb.append("NOCYCLE ");
                }
                if (this.cacheSize != null && this.cacheSize.longValue() != 1000L) {
                    sb.append("CACHE ").append(this.cacheSize).append(" ");
                }
                return sb.toString();
            }
        }
        return this.body;
    }

    public MySQLCatalog getCatalog() {
        return this.sequenceCatalog;
    }
}

