/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LogSequenceNumber;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.internal.DbLogc;

public class LogCursor {
    DbLogc logc;

    LogCursor(DbLogc dbLogc) {
        this.logc = dbLogc;
    }

    static LogCursor wrap(DbLogc dbLogc) {
        return dbLogc == null ? null : new LogCursor(dbLogc);
    }

    public synchronized void close() throws DatabaseException {
        this.logc.close(0);
    }

    public OperationStatus getCurrent(LogSequenceNumber logSequenceNumber, DatabaseEntry databaseEntry) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(logSequenceNumber, databaseEntry, 6));
    }

    public OperationStatus getNext(LogSequenceNumber logSequenceNumber, DatabaseEntry databaseEntry) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(logSequenceNumber, databaseEntry, 16));
    }

    public OperationStatus getFirst(LogSequenceNumber logSequenceNumber, DatabaseEntry databaseEntry) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(logSequenceNumber, databaseEntry, 7));
    }

    public OperationStatus getLast(LogSequenceNumber logSequenceNumber, DatabaseEntry databaseEntry) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(logSequenceNumber, databaseEntry, 15));
    }

    public OperationStatus getPrev(LogSequenceNumber logSequenceNumber, DatabaseEntry databaseEntry) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(logSequenceNumber, databaseEntry, 24));
    }

    public OperationStatus set(LogSequenceNumber logSequenceNumber, DatabaseEntry databaseEntry) throws DatabaseException {
        return OperationStatus.fromInt(this.logc.get(logSequenceNumber, databaseEntry, 27));
    }

    public int version() throws DatabaseException {
        return this.logc.version(0);
    }
}

