#!/bin/bash -l

# Assemble README and .inp files into a crude manual.
# Usage: bin/assemble_manual.sh > manual.html
# To make PDF, open in Google Chrome browser in an "Incognito Window" (to avoid coloring visited links),
# go to print it, and use "Save as PDF".
# David Strubbe April 2012/November 2013

# Check the list of files here against the output of:
#find . -name "*README*"; find . -name "*.inp"

cd `dirname $0`/..

# FIXME: should be MeanField/ABINIT/README
# FIXME: need docs on data_file2kgrid.py
# FIXME: need implementation papers added, e.g. Godby-Needs, Full Freq
# FIXME: need docs on subsample. add BSE/subsample.inp below with it.

FILES="
SECTION:Preliminaries
README
license.txt
CONTRIBUTORS
documentation/LITERATURE.html
config/README
testsuite/README
library/README
examples/README
END
SECTION:MeanField
MeanField/README
SECTION:ESPRESSO
MeanField/ESPRESSO/README
MeanField/ESPRESSO/kgrid.inp
MeanField/ESPRESSO/version-5.1/INPUT_pw2bgw.html
MeanField/ESPRESSO/version-5.1/INPUT_bgw2pw.html
MeanField/ESPRESSO/version-5.0/INPUT_pw2bgw.html
MeanField/ESPRESSO/version-5.0/INPUT_bgw2pw.html
MeanField/ESPRESSO/version-4.3.2/pw2bgw.inp
MeanField/ESPRESSO/version-4.3.2/bgw2pw.inp
MeanField/ESPRESSO/version-4.3.2/README_patch
MeanField/ESPRESSO/patch_oldversions/README
END
SECTION:PARATEC
MeanField/PARATEC/README
END
SECTION:SIESTA
MeanField/SIESTA/README
MeanField/SIESTA/patch/README
MeanField/SIESTA/siesta2bgw.inp
END
SECTION:Octopus
MeanField/Octopus/README
END
SECTION:EPM
MeanField/EPM/README
MeanField/EPM/epm.inp
END
SECTION:ICM
MeanField/ICM/README
END
SECTION:Utilities
MeanField/Utilities/README
MeanField/Utilities/wfnmerge.inp
MeanField/Utilities/fix_occ.inp"
FILES="$FILES
END
SECTION:SAPO
MeanField/SAPO/README
MeanField/SAPO/sapo.inp
END
END
SECTION:Epsilon
Epsilon/README
Epsilon/epsilon.inp
Epsilon/epsconv.inp
Epsilon/epsomega.inp
Epsilon/epsinvomega.inp
Epsilon/epsmat_merge.inp
Epsilon/epsmat_old2hdf5.inp"
FILES="$FILES
END
SECTION:Sigma
Sigma/README
Sigma/sigma.inp
Sigma/sig2wan.inp
END
SECTION:BSE
BSE/README_kernel
BSE/kernel.inp
BSE/README_absorption
BSE/absorption.inp
BSE/inteqp.inp
BSE/README_inteqp
BSE/summarize_eigenvectors.inp
END
SECTION:PlotXct
PlotXct/README
PlotXct/plotxct.inp
END"
FILES="$FILES
SECTION:Visual
Visual/README
Visual/surface.inp
Visual/gsphere.inp
END
SECTION:Developers
doxygen/README
Common/README
Common/qhull/README"
FILES="$FILES
MeanField/spglib-1.0.9/README
END"

# check for things that can be misinterpreted as HTML, e.g.
#  grep '<' manual.html | grep -v '<pre>' | grep -v '</pre>' | grep -v '<hr>' | grep -v '<h2>' | grep -v '</h2>'

# Including these in the manual doesn't seem especially useful
#
# examples/EPM/silicon/README
# examples/DFT/silicon/README
# examples/DFT/silicon/PREBUILT/README
# examples/DFT/Si2_sapo/README
# examples/DFT/CO/README
# examples/DFT/benzene/README
# examples/DFT/sodium/README
# examples/DFT/swcnt_5-5/README
# examples/DFT/swcnt_8-0/README
# Common/qhull/README.txt

# internal only, not currently useful
#BSE/SSEIG/README
#BSE/full_solver/README

version_string=`bin/printsvninfo.x`
title="BerkeleyGW manual ($version_string)"

# style trick for <pre> courtesy http://labnol.blogspot.com/2006/10/html-css-trick-for-displaying-code.html
echo "<html>"
echo "<title>$title</title>"
echo "<style> pre {
white-space: pre-wrap; /* css-3 */
white-space: -moz-pre-wrap !important; /* Mozilla, since 1999 */
white-space: -pre-wrap; /* Opera 4-6 */
white-space: -o-pre-wrap; /* Opera 7 */
word-wrap: break-word; /* Internet Explorer 5.5+ */
}</style>"
echo "<body>"

echo "<h1>$title</h1>"
logo="data:image/png;base64,`LOGO/encode64.py LOGO/donkey.png`"
echo "<img src='$logo'>"

echo "<h2>Contents</h2>"
echo "<ol>"
for filename in $FILES; do
  if [[ "$filename" =~ "SECTION" ]]; then
      trimname=${filename#SECTION:}
      echo "<li><a href=#$filename>$trimname</a><ol>"
  elif [[ "$filename" == "END" ]]; then
      echo "</ol>"
  else
      echo "<li><a href=#$filename>$filename</a>"
  fi
done
echo "</ol>"

echo "<h2>About</h2>
This manual is assembled automatically from the various documentation files in the BerkeleyGW distribution.
The headings are the paths and filenames. For each executable, consult the corresponding .inp file for information about input parameters.
The homepage is <a href=http://www.berkeleygw.org>http://www.berkeleygw.org</a>."

for filename in $FILES; do
    case $filename in
	"SECTION"*)
	    trimname=${filename#SECTION:}
	    echo "<a id=$filename><h2>$trimname</h2>" ;;
	"END") ;;
	*)
	    echo "<hr>"
	    echo "<a id=$filename><h2>$filename</h2>"
	    # HTML files do not need to be considered pre-formatted text.
	    if [[ ! "$filename" =~ "html" ]]; then
		echo "<pre>"
	    fi
	    # remove style headers from QE documentation to avoid controlling format of whole manual
	    if [[ "$filename" =~ INPUT.*html ]]; then
		tail -n +7 $filename
	    else
		cat $filename
	    fi
	    if [[ ! "$filename" =~ "html" ]]; then
		echo "</pre>"
	    fi
	    echo ;;
    esac
done

# xmp prevents interpreting part of the donkey as HTML tags!
echo "<hr><pre>"
`dirname $0`/../LOGO/print_logo.sh
echo "</pre>"

echo "</body>"
echo "</html>"
