/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import org.basex.api.dom.BXNode;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FComm;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FPI;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenObjectMap;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public abstract class FNode
extends ANode {
    private FNode parent;

    FNode(NodeType type) {
        super(type);
    }

    @Override
    public FNode finish() {
        return this;
    }

    @Override
    public final boolean is(ANode node) {
        return this == node;
    }

    @Override
    public final int compare(ANode node) {
        return this == node ? 0 : (node instanceof FNode ? Integer.signum(this.id - node.id) : FNode.compare(this, node));
    }

    @Override
    public final ANode parent() {
        return this.parent;
    }

    @Override
    public final void parent(FNode par) {
        this.parent = par;
    }

    @Override
    public BasicNodeIter attributeIter() {
        return BasicNodeIter.EMPTY;
    }

    @Override
    public BasicNodeIter childIter() {
        return BasicNodeIter.EMPTY;
    }

    @Override
    public boolean hasChildren() {
        return false;
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    static byte[] string(ANode[] nodes) {
        if (nodes.length == 0) {
            return Token.EMPTY;
        }
        TokenBuilder tb = new TokenBuilder();
        for (ANode node : nodes) {
            if (!node.type.oneOf(NodeType.ELEMENT, NodeType.TEXT)) continue;
            tb.add(node.string());
        }
        return tb.finish();
    }

    static void children(Node node, FBuilder builder, TokenObjectMap<byte[]> nsMap) {
        NodeList ch = node.getChildNodes();
        int cl = ch.getLength();
        block6: for (int c = 0; c < cl; ++c) {
            Node child = ch.item(c);
            switch (child.getNodeType()) {
                case 3: {
                    builder.add(new FTxt((Text)child));
                    continue block6;
                }
                case 8: {
                    builder.add(new FComm((Comment)child));
                    continue block6;
                }
                case 7: {
                    builder.add(new FPI((ProcessingInstruction)child));
                    continue block6;
                }
                case 1: {
                    builder.add(FElem.build((Element)child, nsMap).finish());
                    continue block6;
                }
            }
        }
    }

    @Override
    public final BXNode toJava() {
        return BXNode.get(this);
    }

    public final int hashCode() {
        return this.id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FNode)) return false;
        FNode n = (FNode)obj;
        if (!this.type.eq(n.type)) return false;
        if (this.parent != n.parent) return false;
        return true;
    }
}

