/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.expr.index;

import java.util.Objects;
import org.basex.data.Data;
import org.basex.index.IndexType;
import org.basex.index.query.IndexIterator;
import org.basex.index.query.StringToken;
import org.basex.query.CompileContext;
import org.basex.query.InlineContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.expr.index.IndexAccess;
import org.basex.query.expr.index.IndexDb;
import org.basex.query.expr.path.Axis;
import org.basex.query.expr.path.CachedStep;
import org.basex.query.expr.path.NameTest;
import org.basex.query.func.Function;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.iter.DBNodeIter;
import org.basex.query.iter.Iter;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.ANodeBuilder;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.seq.DBNodeSeq;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.StrSeq;
import org.basex.query.value.type.NodeType;
import org.basex.query.var.Var;
import org.basex.query.var.VarUsage;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.hash.IntObjectMap;
import org.basex.util.hash.TokenSet;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class ValueAccess
extends IndexAccess {
    private final IndexType type;
    private final NameTest test;
    private final TokenSet tokens;
    private Expr expr;

    public ValueAccess(InputInfo info, TokenSet tokens, IndexType type, NameTest test, IndexDb db) {
        this(info, type, test, db, Empty.VALUE, tokens);
    }

    public ValueAccess(InputInfo info, Expr expr, IndexType type, NameTest test, IndexDb db) {
        this(info, type, test, db, expr, null);
    }

    private ValueAccess(InputInfo info, IndexType type, NameTest test, IndexDb db, Expr expr, TokenSet tokens) {
        super(db, info, test != null ? NodeType.ELEMENT : (type == IndexType.TEXT ? NodeType.TEXT : NodeType.ATTRIBUTE));
        this.type = type;
        this.test = test;
        this.expr = expr;
        this.tokens = tokens;
    }

    @Override
    public Iter iter(QueryContext qc) throws QueryException {
        int c;
        TokenSet cache;
        if (this.tokens == null) {
            Item item;
            cache = new TokenSet();
            Iter ir = this.expr.iter(qc);
            while ((item = qc.next(ir)) != null) {
                cache.add(this.toToken(item));
            }
        } else {
            cache = this.tokens;
        }
        if ((c = cache.size()) == 0) {
            return Empty.ITER;
        }
        Data data = this.db.data(qc, this.type);
        if (c == 1) {
            return this.iter(cache.key(1), data);
        }
        ANodeBuilder nodes = new ANodeBuilder();
        for (byte[] token : cache) {
            for (ANode node : this.iter(token, data)) {
                qc.checkStop();
                nodes.add(node);
            }
        }
        return nodes.value(this).iter();
    }

    private BasicNodeIter iter(byte[] term, Data data) {
        IndexIterator iter;
        int tl = term.length;
        if (tl == 0 && this.type == IndexType.TEXT) {
            return this.test == null ? BasicNodeIter.EMPTY : this.scanEmpty(data);
        }
        boolean index = data.meta.index(this.type) && (this.type != IndexType.TEXT && this.type != IndexType.ATTRIBUTE || tl > 0 && tl <= data.meta.maxlen);
        IndexIterator indexIterator = iter = index ? data.iter(new StringToken(this.type, term)) : this.scan(term, data);
        if (iter.size() == 0) {
            return BasicNodeIter.EMPTY;
        }
        final int kind = this.type == IndexType.TEXT ? 2 : 3;
        final DBNode tmp = new DBNode(data, 0, this.test == null ? kind : 1);
        if (this.test != null) {
            return new DBNodeIter(data){

                @Override
                public DBNode next() {
                    while (iter.more()) {
                        tmp.pre(this.data.parent(iter.pre(), kind));
                        if (!ValueAccess.this.test.matches(tmp)) continue;
                        return tmp.finish();
                    }
                    return null;
                }
            };
        }
        if (!index) {
            return new DBNodeIter(data){

                @Override
                public DBNode next() {
                    if (iter.more()) {
                        tmp.pre(iter.pre());
                        return tmp.finish();
                    }
                    return null;
                }
            };
        }
        return new DBNodeIter(data){
            final IntList list;
            {
                super(data);
                this.list = new IntList();
            }

            @Override
            public DBNode next() {
                if (iter.more()) {
                    int pre = iter.pre();
                    tmp.pre(pre);
                    this.list.add(pre);
                    return tmp.finish();
                }
                return null;
            }

            @Override
            public DBNode get(long i) {
                while (i >= (long)this.list.size() && iter.more()) {
                    this.list.add(iter.pre());
                }
                tmp.pre(this.list.get((int)i));
                return tmp.finish();
            }

            @Override
            public long size() {
                return iter.size();
            }

            @Override
            public Value value(QueryContext qc, Expr ex) {
                while (iter.more()) {
                    qc.checkStop();
                    this.list.add(iter.pre());
                }
                return DBNodeSeq.get(this.list.finish(), this.data, ex);
            }
        };
    }

    private IndexIterator scan(final byte[] value, final Data data) {
        return new IndexIterator(){
            final boolean text;
            final byte kind;
            final int sz;
            int pre;
            {
                this.text = ValueAccess.this.type == IndexType.TEXT;
                this.kind = (byte)(this.text ? 2 : 3);
                this.sz = data.meta.size;
                this.pre = -1;
            }

            @Override
            public int pre() {
                return this.pre;
            }

            @Override
            public boolean more() {
                while (++this.pre < this.sz) {
                    if (data.kind(this.pre) != this.kind || !Token.eq(data.text(this.pre, this.text), value)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int size() {
                return Math.max(1, this.sz >>> 1);
            }
        };
    }

    private DBNodeIter scanEmpty(Data data) {
        return new DBNodeIter(data){
            final DBNode tmp;
            final int sz;
            int pre;
            {
                this.tmp = new DBNode(this.data, 0, 1);
                this.sz = this.data.meta.size;
                this.pre = -1;
            }

            @Override
            public DBNode next() {
                while (++this.pre < this.sz) {
                    if (this.data.kind(this.pre) != 1 || this.data.size(this.pre, 1) != 1) continue;
                    this.tmp.pre(this.pre);
                    if (ValueAccess.this.test != null && !ValueAccess.this.test.matches(this.tmp)) continue;
                    return this.tmp.finish();
                }
                return null;
            }
        };
    }

    @Override
    public boolean has(Flag ... flags) {
        return this.expr.has(flags) || super.has(flags);
    }

    @Override
    public boolean inlineable(InlineContext ic) {
        return this.expr.inlineable(ic) && super.inlineable(ic);
    }

    @Override
    public VarUsage count(Var var) {
        return this.expr.count(var).plus(super.count(var));
    }

    @Override
    public Expr inline(InlineContext ic) throws QueryException {
        Expr inlined = this.expr.inline(ic);
        if (inlined != null) {
            this.expr = inlined;
        }
        boolean inlinedDb = this.inlineDb(ic);
        return inlined != null || inlinedDb ? this.optimize(ic.cc) : null;
    }

    @Override
    public Expr copy(CompileContext cc, IntObjectMap<Var> vm) {
        return this.copyType(new ValueAccess(this.info, this.type, this.test, (IndexDb)this.db.copy(cc, (IntObjectMap)vm), this.expr.copy(cc, vm), this.tokens));
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return this.expr.accept(visitor) && super.accept(visitor);
    }

    @Override
    public int exprSize() {
        return this.expr.exprSize() + super.exprSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ValueAccess)) return false;
        ValueAccess va = (ValueAccess)obj;
        if (this.type != va.type) return false;
        if (!Objects.equals(this.tokens, va.tokens)) return false;
        if (!this.expr.equals(obj)) return false;
        if (!Objects.equals(this.test, va.test)) return false;
        if (!super.equals(obj)) return false;
        return true;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, new Object[]{"index", this.type, "name", this.test}), this.db, this.toExpr());
    }

    @Override
    public void toString(QueryString qs) {
        Function function = this.type == IndexType.TEXT ? Function._DB_TEXT : (this.type == IndexType.ATTRIBUTE ? Function._DB_ATTRIBUTE : Function._DB_TOKEN);
        qs.function(function, this.db, this.toExpr());
        if (this.test != null) {
            qs.token('/').token(new CachedStep(this.info, Axis.PARENT, this.test, new Expr[0]));
        }
    }

    private Expr toExpr() {
        if (this.tokens == null) {
            return this.expr;
        }
        TokenList tl = new TokenList(this.tokens.size());
        for (byte[] token : this.tokens) {
            tl.add(token);
        }
        return StrSeq.get(tl);
    }
}

