/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.csv;

import org.basex.build.csv.CsvParserOptions;
import org.basex.io.parse.csv.CsvConverter;
import org.basex.query.QueryContext;
import org.basex.query.QueryText;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public class CsvW3XmlConverter
extends CsvConverter {
    public static final QNm Q_FN_CSV = new QNm("csv", QueryText.FN_URI);
    protected static final QNm Q_FN_ROWS = new QNm("rows", QueryText.FN_URI);
    public static final QNm Q_FN_ROW = new QNm("row", QueryText.FN_URI);
    protected static final QNm Q_FN_FIELD = new QNm("field", QueryText.FN_URI);
    protected static final QNm Q_FN_COLUMNS = new QNm("columns", QueryText.FN_URI);
    public static final QNm Q_FN_COLUMN = new QNm("column", QueryText.FN_URI);
    public static final QNm Q_COLUMN = new QNm("column");
    private FBuilder doc;
    private FBuilder rows;
    private FBuilder record;

    public CsvW3XmlConverter(CsvParserOptions copts) {
        super(copts);
    }

    @Override
    protected final void record() {
        this.finishRecord();
        this.record = FElem.build(Q_FN_ROW);
        this.col = -1;
    }

    @Override
    public final void header(byte[] value) {
        this.headers.add(this.shared.token(value));
    }

    @Override
    protected final void entry(byte[] value) {
        ++this.col;
        if (this.skipEmpty && value.length == 0) {
            return;
        }
        FBuilder elem = FElem.build(Q_FN_FIELD);
        byte[] name = (byte[])this.headers.get(this.col);
        if (name != null && name.length > 0) {
            elem.add(Q_COLUMN, name);
        }
        this.record.add(elem.add(this.shared.token(value)));
    }

    @Override
    protected final void init(String uri) {
        this.doc = FDoc.build(Token.token(uri));
        this.rows = FElem.build(Q_FN_ROWS);
    }

    @Override
    protected final FNode finish(InputInfo ii, QueryContext qc) {
        this.finishRecord();
        FBuilder root = FElem.build(Q_FN_CSV);
        if (!this.headers.isEmpty()) {
            FBuilder columns = FElem.build(Q_FN_COLUMNS);
            for (byte[] h : this.headers) {
                columns.add(FElem.build(Q_FN_COLUMN).add(h));
            }
            root.add(columns);
        }
        return this.doc.add(root.add(this.rows)).finish();
    }

    private void finishRecord() {
        if (this.record != null) {
            this.rows.add(this.record);
        }
    }
}

