/*
 * Decompiled with CFR 0.152.
 */
package net.xqj.core.util.debug;

import java.io.IOException;
import java.io.InputStream;

public class DebugInputStream
extends InputStream {
    private final InputStream in;

    public DebugInputStream(InputStream in) {
        System.out.println("new DebugInputStream(" + in + ")");
        this.in = in;
    }

    @Override
    public int available() throws IOException {
        System.out.print("available() => ");
        int a = this.in.available();
        System.out.println(a);
        return a;
    }

    @Override
    public void close() throws IOException {
        System.out.print("close() => ");
        this.in.close();
        System.out.println("OK");
    }

    @Override
    public void mark(int readlimit) {
        System.out.print("mark(" + readlimit + ") => ");
        this.in.mark(readlimit);
        System.out.println("OK");
    }

    @Override
    public boolean markSupported() {
        System.out.print("markSupported() => ");
        boolean b = this.in.markSupported();
        System.out.println(b);
        return b;
    }

    @Override
    public int read() throws IOException {
        System.out.print("read() => ");
        int b = this.in.read();
        System.out.println(b);
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        System.out.print("read(b[" + b.length + "]) => ");
        int v = this.in.read(b);
        System.out.println(v);
        return v;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        System.out.print("read(b[" + b.length + "], " + off + ", " + len + ") => ");
        int v = this.in.read(b, off, len);
        System.out.println(v);
        return v;
    }

    @Override
    public void reset() throws IOException {
        System.out.print("reset() => ");
        this.in.reset();
        System.out.println("OK");
    }

    @Override
    public long skip(long n) throws IOException {
        System.out.print("skip(" + n + ") => ");
        long v = this.in.skip(n);
        System.out.println(v);
        return v;
    }
}

