/*
 * Decompiled with CFR 0.152.
 */
package org.basex;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.basex.core.BaseXException;
import org.basex.core.CLI;
import org.basex.core.StaticOptions;
import org.basex.core.Text;
import org.basex.http.HTTPContext;
import org.basex.io.IOFile;
import org.basex.io.IOStream;
import org.basex.util.Main;
import org.basex.util.MainParser;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.log.LogType;
import org.basex.util.options.Option;
import org.eclipse.jetty.compression.Compression;
import org.eclipse.jetty.compression.gzip.GzipCompression;
import org.eclipse.jetty.compression.server.CompressionConfig;
import org.eclipse.jetty.compression.server.CompressionHandler;
import org.eclipse.jetty.ee9.servlet.ServletContextHandler;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.eclipse.jetty.ee9.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

public final class BaseXHTTP
extends CLI {
    private final StaticOptions soptions = new StaticOptions(true);
    private final HTTPContext hc;
    private final Server jetty;
    private boolean service;
    private boolean quiet;
    private String password;
    private boolean stop;
    private int port;

    public static void main(String ... args) {
        try {
            new BaseXHTTP(args);
        }
        catch (Exception ex) {
            Util.errln((Object)ex, (Object[])new Object[0]);
            System.exit(1);
        }
    }

    public BaseXHTTP(String ... args) throws Exception {
        super(null, args);
        int stopPort;
        if (!this.quiet) {
            Util.println((Object)this.header(), (Object[])new Object[0]);
        }
        String webapp = this.soptions.get(StaticOptions.WEBPATH);
        WebAppContext wac = new WebAppContext(webapp, "/");
        IOFile webXml = BaseXHTTP.locate("WEB-INF/web.xml", webapp);
        IOFile jettyXml = BaseXHTTP.locate("WEB-INF/jetty.xml", webapp);
        this.hc = HTTPContext.get();
        this.hc.init(this.soptions, webXml);
        URI jettyUri = Paths.get(jettyXml.toString(), new String[0]).toUri();
        Resource resource = new PathResourceFactory().newResource(jettyUri);
        this.jetty = (Server)new XmlConfiguration(resource).configure();
        Object supplier = wac;
        if (this.soptions.get(StaticOptions.GZIP).booleanValue()) {
            String clzz = "org.eclipse.jetty.compression.server.CompressionHandler";
            if (Reflect.available((String)"org.eclipse.jetty.compression.server.CompressionHandler", (Object[])new Object[0])) {
                supplier = BaseXHTTP.gzip(wac);
            } else if (Reflect.available((String)"org.eclipse.jetty.server.handler.gzip.GzipHandler", (Object[])new Object[0])) {
                Util.errln((Object)"Please add org.eclipse.jetty.compression.server.CompressionHandler to the classpath to enable GZIP compression", (Object[])new Object[0]);
            }
        }
        this.jetty.setHandler((Supplier)supplier);
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)wac, null);
        ServerConnector sc = null;
        for (Connector conn : this.jetty.getConnectors()) {
            ServerConnector s;
            if (!(conn instanceof ServerConnector)) continue;
            sc = s = (ServerConnector)conn;
        }
        if (sc == null) {
            throw new BaseXException("No Jetty connector defined in WEB-INF/jetty.xml.", new Object[0]);
        }
        if (this.port != 0) {
            sc.setPort(this.port);
        } else {
            this.port = sc.getPort();
        }
        Function<Boolean, String> msg1 = start -> start != false ? Text.SRV_STARTED_PORT_X : Text.SRV_STOPPED_PORT_X;
        Function<Boolean, String> msg2 = start -> Util.info((Object)("HTTP " + (String)msg1.apply((Boolean)start)), (Object[])new Object[]{this.port});
        Consumer<Boolean> info = start -> {
            Util.println(msg2.apply((Boolean)start), (Object[])new Object[0]);
            if (!this.soptions.get(StaticOptions.HTTPLOCAL).booleanValue()) {
                int serverPort = this.soptions.get(StaticOptions.SERVERPORT);
                Util.println(msg1.apply((Boolean)start), (Object[])new Object[]{serverPort});
            }
            Performance.sleep((long)1000L);
        };
        if (this.stop) {
            this.stop();
            if (!this.quiet) {
                info.accept(false);
            }
            return;
        }
        if (this.service) {
            BaseXHTTP.start(args);
            if (!this.quiet) {
                info.accept(true);
            }
            return;
        }
        try {
            this.jetty.start();
        }
        catch (BindException ex) {
            Util.debug((Throwable)ex);
            throw new BaseXException("HTTP " + Text.SRV_RUNNING_X, new Object[]{this.port});
        }
        IOException ex = this.hc.exception();
        if (ex != null) {
            throw ex;
        }
        this.hc.init((ServletContext)wac.getServletContext());
        this.context = this.hc.context();
        if (this.password != null) {
            this.context.user().password(this.password);
        }
        if ((stopPort = this.soptions.get(StaticOptions.STOPPORT).intValue()) > 0) {
            new StopServer(stopPort).start();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            String message = (String)msg2.apply(false);
            if (!this.quiet) {
                Util.println((Object)message, (Object[])new Object[0]);
            }
            this.context.log.writeServer(LogType.OK, message);
            this.context.close();
        }));
        if (!this.quiet) {
            Util.println((Object)msg2.apply(true), (Object[])new Object[0]);
        }
        this.context.log.writeServer(LogType.OK, msg2.apply(true));
        for (Map.Entry command : this.commands) {
            if (this.execute(command)) continue;
            return;
        }
    }

    public void stop() throws IOException {
        String host = this.soptions.get(StaticOptions.SERVERHOST);
        int stopPort = this.soptions.get(StaticOptions.STOPPORT);
        if (stopPort > 0) {
            BaseXHTTP.stop(host.isEmpty() ? "localhost" : host, stopPort);
        }
    }

    private static IOFile locate(String file, String root) throws IOException {
        byte[] data;
        IOFile target = new IOFile(root, file);
        boolean create = !target.exists();
        IOFile io = new IOFile("src/main/webapp", file);
        if (io.exists()) {
            data = io.read();
            IOFile dir = new IOFile("src/main/resources");
            if (!(!dir.exists() || (dir = new IOFile(dir, file)).exists() && Token.eq((byte[])data, (byte[])dir.read()))) {
                Util.errln((Object)("Updating " + String.valueOf(dir)), (Object[])new Object[0]);
                dir.parent().md();
                dir.write(data);
            }
        } else if (create) {
            try (InputStream is = BaseXHTTP.class.getResourceAsStream("/" + file);){
                if (is == null) {
                    throw new BaseXException(String.valueOf(io) + " not found.", new Object[0]);
                }
                data = new IOStream(is).read();
            }
        } else {
            return target;
        }
        if (create) {
            Util.errln((Object)("Creating " + String.valueOf(target)), (Object[])new Object[0]);
            target.parent().md();
            target.write(data);
        }
        return target;
    }

    private static Supplier<Handler> gzip(WebAppContext wac) {
        return () -> {
            CompressionHandler ch = new CompressionHandler();
            GzipCompression gc = new GzipCompression();
            ch.putCompression((Compression)gc);
            CompressionConfig cc = CompressionConfig.builder().defaults().compressIncludeMethod("PUT").decompressIncludeMethod("PUT").build();
            ch.putConfiguration("/", cc);
            ch.setHandler((Supplier)wac);
            return ch;
        };
    }

    protected void parseArgs() throws IOException {
        MainParser arg = new MainParser((Main)this);
        boolean daemon = true;
        block16: while (arg.more()) {
            if (arg.dash()) {
                switch (arg.next()) {
                    case 'c': {
                        this.commands.add(BaseXHTTP.commands((String)arg.string()));
                        continue block16;
                    }
                    case 'C': {
                        this.commands.add(BaseXHTTP.script((String)arg.string()));
                        continue block16;
                    }
                    case 'd': {
                        Prop.put((Option)StaticOptions.DEBUG, (String)Boolean.toString(true));
                        Prop.debug = true;
                        continue block16;
                    }
                    case 'D': {
                        daemon = false;
                        continue block16;
                    }
                    case 'g': {
                        Prop.put((Option)StaticOptions.GZIP, (String)Boolean.toString(true));
                        continue block16;
                    }
                    case 'h': {
                        this.port = arg.number();
                        continue block16;
                    }
                    case 'l': {
                        Prop.put((Option)StaticOptions.HTTPLOCAL, (String)Boolean.toString(true));
                        continue block16;
                    }
                    case 'n': {
                        String n = arg.string();
                        Prop.put((Option)StaticOptions.HOST, (String)n);
                        Prop.put((Option)StaticOptions.SERVERHOST, (String)n);
                        continue block16;
                    }
                    case 'p': {
                        int p = arg.number();
                        Prop.put((Option)StaticOptions.PORT, (String)Integer.toString(p));
                        Prop.put((Option)StaticOptions.SERVERPORT, (String)Integer.toString(p));
                        continue block16;
                    }
                    case 'q': {
                        this.quiet = true;
                        continue block16;
                    }
                    case 's': {
                        Prop.put((Option)StaticOptions.STOPPORT, (String)Integer.toString(arg.number()));
                        continue block16;
                    }
                    case 'S': {
                        this.service = daemon;
                        continue block16;
                    }
                    case 'U': {
                        Prop.put((Option)StaticOptions.USER, (String)arg.string());
                        continue block16;
                    }
                    case 'z': {
                        Prop.put((Option)StaticOptions.LOG, (String)"");
                        continue block16;
                    }
                }
                throw arg.usage();
            }
            if (!"stop".equalsIgnoreCase(arg.string())) {
                throw arg.usage();
            }
            this.stop = true;
        }
        if (this.service) {
            this.commands.clear();
        }
    }

    public static void start(String ... args) throws BaseXException {
        String error = Util.error((Process)Util.start(BaseXHTTP.class, (String[])args), (int)2000);
        if (error != null) {
            throw new BaseXException(error.trim(), new Object[0]);
        }
    }

    public static void stop(String host, int port) throws IOException {
        IOFile stopFile = BaseXHTTP.stopFile(BaseXHTTP.class, (int)port);
        stopFile.parent().md();
        stopFile.touch();
        try (Socket s = new Socket(host, port);){
            do {
                Performance.sleep((long)10L);
            } while (stopFile.exists());
        }
        catch (IOException ex) {
            Util.debug((Throwable)ex);
            stopFile.delete();
            throw new IOException(Util.info((Object)Text.CONNECTION_ERROR_X, (Object[])new Object[]{port}));
        }
    }

    public String header() {
        return Util.info((Object)Text.S_CONSOLE_X, (Object[])new Object[]{"HTTP Server"});
    }

    public String usage() {
        return Text.S_HTTPINFO;
    }

    private final class StopServer
    extends Thread {
        private final ServerSocket socket;
        private final IOFile stopFile;
        private final int stopPort;

        StopServer(int port) throws IOException {
            this.stopPort = port;
            String host = BaseXHTTP.this.soptions.get(StaticOptions.SERVERHOST);
            InetAddress addr = host.isEmpty() ? null : InetAddress.getByName(host);
            this.socket = new ServerSocket();
            this.socket.setReuseAddress(true);
            this.socket.bind(new InetSocketAddress(addr, this.stopPort));
            this.stopFile = BaseXHTTP.stopFile((Class)BaseXHTTP.class, (int)this.stopPort);
        }

        @Override
        public void run() {
            try {
                do {
                    Util.println((Object)("HTTP STOP " + Text.SRV_STARTED_PORT_X), (Object[])new Object[]{this.stopPort});
                    Socket s = this.socket.accept();
                    if (s == null) continue;
                    s.close();
                } while (!this.stopFile.exists());
                this.socket.close();
                Util.println((Object)("HTTP STOP " + Text.SRV_STOPPED_PORT_X), (Object[])new Object[]{this.stopPort});
                BaseXHTTP.this.jetty.stop();
                BaseXHTTP.this.hc.close();
                Prop.clear();
                if (!this.stopFile.delete()) {
                    BaseXHTTP.this.context.log.writeServer(LogType.ERROR, Util.info((Object)Text.FILE_NOT_DELETED_X, (Object[])new Object[]{this.stopFile}));
                }
            }
            catch (Exception ex) {
                Util.stack((Throwable)ex);
            }
        }
    }
}

