/*
 * Decompiled with CFR 0.152.
 */
package de.bottlecaps.markup.blitz.transform;

import de.bottlecaps.markup.blitz.codepoints.Range;
import de.bottlecaps.markup.blitz.transform.Map2D;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;

public interface TileIterator {
    public int next(int[] var1, int var2);

    public int numberOfTiles();

    public int tileSize();

    public int tileIndexBits();

    public int defaultValue();

    public int end();

    public static TileIterator of(final NavigableMap<Range, Integer> codeByRange, final int end, final int tileIndexBits, final int defaultValue) {
        return new TileIterator(){
            int tileSize;
            int numberOfTiles;
            int currentIndex;
            Iterator<Map.Entry<Range, Integer>> it;
            Range currentRange;
            int firstIndex;
            int lastIndex;
            int value;
            {
                this.tileSize = 1 << tileIndexBits;
                this.numberOfTiles = (end - 1 + this.tileSize) / this.tileSize;
                this.currentIndex = 0;
                this.firstIndex = -1;
                this.lastIndex = -1;
                if (!codeByRange.isEmpty()) {
                    this.it = codeByRange.entrySet().iterator();
                    this.nextRange();
                }
            }

            @Override
            public int numberOfTiles() {
                return this.numberOfTiles;
            }

            @Override
            public int tileSize() {
                return this.tileSize;
            }

            @Override
            public int tileIndexBits() {
                return tileIndexBits;
            }

            @Override
            public int defaultValue() {
                return defaultValue;
            }

            @Override
            public int end() {
                return end;
            }

            @Override
            public int next(int[] target, int offset) {
                if (this.currentIndex < this.firstIndex - this.tileSize) {
                    return this.many(target, offset, this.firstIndex - this.currentIndex, defaultValue);
                }
                if (this.currentIndex >= this.firstIndex && this.currentIndex <= this.lastIndex - this.tileSize) {
                    int count = this.many(target, offset, this.lastIndex - this.currentIndex + 1, this.value);
                    if (this.currentIndex > this.lastIndex) {
                        this.nextRange();
                    }
                    return count;
                }
                int size = 0;
                while (true) {
                    if (this.firstIndex < 0) {
                        if (size != 0) {
                            Arrays.fill(target, offset + size, offset + this.tileSize, defaultValue);
                            this.currentIndex += this.tileSize - size;
                            return 1;
                        }
                        return this.many(target, offset, this.numberOfTiles * this.tileSize - this.currentIndex, defaultValue);
                    }
                    while (this.currentIndex < this.firstIndex) {
                        ++this.currentIndex;
                        target[offset + size] = defaultValue;
                        if (++size != this.tileSize) continue;
                        return 1;
                    }
                    while (this.currentIndex <= this.lastIndex) {
                        ++this.currentIndex;
                        target[offset + size] = this.value;
                        if (++size != this.tileSize) continue;
                        if (this.currentIndex > this.lastIndex) {
                            this.nextRange();
                        }
                        return 1;
                    }
                    this.nextRange();
                }
            }

            private void nextRange() {
                if (!this.it.hasNext()) {
                    this.firstIndex = -1;
                    this.lastIndex = -1;
                } else {
                    Map.Entry<Range, Integer> entry = this.it.next();
                    this.currentRange = entry.getKey();
                    this.firstIndex = this.currentRange.getFirstCodepoint();
                    if (this.firstIndex >= end) {
                        this.firstIndex = -1;
                        this.lastIndex = -1;
                    } else {
                        this.value = entry.getValue();
                        this.lastIndex = this.currentRange.getLastCodepoint();
                        if (this.lastIndex >= end) {
                            this.lastIndex = end - 1;
                        }
                    }
                }
            }

            private int many(int[] target, int offset, int n, int value) {
                Arrays.fill(target, offset, offset + this.tileSize, value);
                int nt = n / this.tileSize;
                this.currentIndex += nt * this.tileSize;
                return nt;
            }
        };
    }

    public static TileIterator of(final int[] array, final int end, final int tileIndexBits, final int defaultValue) {
        return new TileIterator(){
            int tileSize;
            int numberOfTiles;
            int nextOffset;
            {
                this.tileSize = 1 << tileIndexBits;
                this.numberOfTiles = (end - 1 + this.tileSize) / this.tileSize;
                this.nextOffset = 0;
            }

            @Override
            public int numberOfTiles() {
                return this.numberOfTiles;
            }

            @Override
            public int tileSize() {
                return this.tileSize;
            }

            @Override
            public int tileIndexBits() {
                return tileIndexBits;
            }

            @Override
            public int defaultValue() {
                return defaultValue;
            }

            @Override
            public int end() {
                return end;
            }

            @Override
            public int next(int[] target, int targetOffset) {
                int remainingSize = end - this.nextOffset;
                if (remainingSize <= 0) {
                    return 0;
                }
                if (remainingSize < this.tileSize) {
                    System.arraycopy(array, this.nextOffset, target, targetOffset, remainingSize);
                    Arrays.fill(target, targetOffset + remainingSize, targetOffset + this.tileSize, defaultValue);
                    this.nextOffset += remainingSize;
                    return 1;
                }
                System.arraycopy(array, this.nextOffset, target, targetOffset, this.tileSize);
                int count = 1;
                this.nextOffset += this.tileSize;
                while (end - this.nextOffset >= this.tileSize && 0 == Arrays.compare(target, targetOffset, targetOffset + this.tileSize, array, this.nextOffset, this.nextOffset + this.tileSize)) {
                    ++count;
                    this.nextOffset += this.tileSize;
                }
                return count;
            }
        };
    }

    public static TileIterator of(final Map2D map, final int tileIndexBits, final int defaultValue) {
        return new TileIterator(){
            int tileSize;
            int end;
            int numberOfTiles;
            int currentIndex;
            Iterator<Map.Entry<Map2D.Index, Integer>> it;
            int index;
            int value;
            {
                this.tileSize = 1 << tileIndexBits;
                this.end = map.getEndX() * map.getEndY();
                this.numberOfTiles = (this.end - 1 + this.tileSize) / this.tileSize;
                this.currentIndex = 0;
                this.index = -1;
                if (!map.isEmpty()) {
                    this.it = map.entrySet().iterator();
                    this.nextEntry();
                }
            }

            @Override
            public int numberOfTiles() {
                return this.numberOfTiles;
            }

            @Override
            public int tileSize() {
                return this.tileSize;
            }

            @Override
            public int tileIndexBits() {
                return tileIndexBits;
            }

            @Override
            public int defaultValue() {
                return defaultValue;
            }

            @Override
            public int end() {
                return this.end;
            }

            @Override
            public int next(int[] target, int offset) {
                if (this.currentIndex < this.index - this.tileSize) {
                    return this.many(target, offset, this.index - this.currentIndex);
                }
                int size = 0;
                while (true) {
                    if (this.index < 0) {
                        if (size != 0) {
                            Arrays.fill(target, offset + size, offset + this.tileSize, defaultValue);
                            this.currentIndex += this.tileSize - size;
                            return 1;
                        }
                        return this.many(target, offset, this.numberOfTiles * this.tileSize - this.currentIndex);
                    }
                    while (this.currentIndex < this.index) {
                        ++this.currentIndex;
                        target[offset + size] = defaultValue;
                        if (++size != this.tileSize) continue;
                        return 1;
                    }
                    if (this.currentIndex == this.index) {
                        ++this.currentIndex;
                        target[offset + size] = this.value;
                        if (++size == this.tileSize) {
                            this.nextEntry();
                            return 1;
                        }
                    }
                    this.nextEntry();
                }
            }

            private void nextEntry() {
                if (!this.it.hasNext()) {
                    this.index = -1;
                } else {
                    Map.Entry<Map2D.Index, Integer> entry = this.it.next();
                    this.index = entry.getKey().getX() * map.getEndY() + entry.getKey().getY();
                    this.value = entry.getValue();
                }
            }

            private int many(int[] target, int offset, int n) {
                Arrays.fill(target, offset, offset + this.tileSize, defaultValue);
                int nt = n / this.tileSize;
                this.currentIndex += nt * this.tileSize;
                return nt;
            }
        };
    }
}

