/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.XMLToken;

public class InputParser {
    private static final String FOUND = ", found '%'";
    public final int[] input;
    public final int length;
    public String path;
    public int pos;
    public int mark;

    public InputParser(String input) {
        this.input = input.replaceAll("\r\n?", "\n").codePoints().toArray();
        this.length = this.input.length;
    }

    public final boolean more() {
        return this.pos < this.length;
    }

    public final int current() {
        int i = this.pos;
        return i < this.length ? this.input[i] : 0;
    }

    public final boolean current(int cp) {
        int i = this.pos;
        return i < this.length && cp == this.input[i];
    }

    protected final void mark() {
        this.mark = this.pos;
    }

    protected final int next() {
        int i = this.pos + 1;
        return i < this.length ? this.input[i] : 0;
    }

    public final int consume() {
        return this.pos < this.length ? this.input[this.pos++] : 0;
    }

    public final boolean consume(int cp) {
        int i;
        return (i = this.pos++) < this.length && cp == this.input[i];
    }

    protected static boolean quote(int cp) {
        return cp == 34 || cp == 39;
    }

    public final boolean consume(String string) {
        int i = this.pos;
        int l = string.length();
        if (i + l > this.length) {
            return false;
        }
        for (int s = 0; s < l; ++s) {
            if (this.input[i++] == string.charAt(s)) continue;
            return false;
        }
        this.pos = i;
        return true;
    }

    protected final byte[] found() {
        return this.current() == 0 ? Token.EMPTY : Util.inf(FOUND, this.currentAsString());
    }

    protected final String remaining() {
        int cp;
        TokenBuilder tb = new TokenBuilder();
        int pl = Math.min(this.length, this.pos + 15);
        for (int p = this.pos; p < pl && (cp = this.input[p]) != 10; ++p) {
            tb.add(cp);
        }
        return String.valueOf(tb) + (pl == this.length ? "" : "...");
    }

    public final TokenBuilder substring(int s, int e) {
        TokenBuilder tb = new TokenBuilder();
        for (int i = s; i < e; ++i) {
            tb.add(this.input[i]);
        }
        return tb;
    }

    protected final String currentAsString() {
        int cp = this.current();
        return cp == 0 ? "END OF INPUT" : (!XMLToken.valid(cp) || Character.isSpaceChar(cp) ? Character.getName(cp) : Character.toString(cp));
    }

    public InputInfo info() {
        return new InputInfo(this);
    }
}

