/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.io.IOException;
import java.math.BigDecimal;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.query.QueryContext;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dec;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.Token;

public final class DecSeq
extends NativeSeq {
    private final BigDecimal[] values;

    private DecSeq(BigDecimal[] values) {
        super(values.length, (Type)AtomType.DECIMAL);
        this.values = values;
    }

    public static Value read(DataInput in, Type type, QueryContext qc) throws IOException {
        int size = in.readNum();
        BigDecimal[] values = new BigDecimal[size];
        for (int s = 0; s < size; ++s) {
            values[s] = new BigDecimal(Token.string(in.readToken()));
        }
        return DecSeq.get(values);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeNum((int)this.size);
        for (BigDecimal v : this.values) {
            out.writeToken(Token.chopNumber(Token.token(v.toPlainString())));
        }
    }

    @Override
    public Dec itemAt(long index) {
        return Dec.get(this.values[(int)index]);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        BigDecimal[] tmp = new BigDecimal[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return DecSeq.get(tmp);
    }

    public BigDecimal[] toJava() {
        return this.values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj instanceof DecSeq) {
            DecSeq seq = (DecSeq)obj;
            if (!Array.equals(this.values, seq.values)) return false;
            return true;
        } else if (!super.equals(obj)) return false;
        return true;
    }

    private static Value get(BigDecimal[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Dec.get(values[0]) : new DecSeq(values));
    }
}

