/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.util.DeepEqual;
import org.basex.query.util.DeepEqualOptions;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.ADateDur;
import org.basex.query.value.item.DTDur;
import org.basex.query.value.item.Dec;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.YMDur;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public abstract class ADate
extends ADateDur {
    static final long MAX_YEAR = 25252734927766554L;
    static final long MIN_YEAR = -25252734927766554L;
    private static final long ADD_NEG = 25252734927766800L;
    static final String DD = "(\\d{2})";
    static final String YEAR = "(-?(000[1-9]|00[1-9]\\d|0[1-9]\\d{2}|[1-9]\\d{3,}))";
    static final String ZONE = "(([-+])(\\d{2}):(\\d{2})|Z)?";
    static final byte[] DAYS = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final Pattern DATE = Pattern.compile("(-?(000[1-9]|00[1-9]\\d|0[1-9]\\d{2}|[1-9]\\d{3,}))-(\\d{2})-(\\d{2})(([-+])(\\d{2}):(\\d{2})|Z)?");
    public static final Pattern TIME = Pattern.compile("(\\d{2}):(\\d{2}):(\\d{2}(\\.\\d+)?)(([-+])(\\d{2}):(\\d{2})|Z)?");
    long year = Long.MAX_VALUE;
    byte month = (byte)-1;
    byte day = (byte)-1;
    byte hour = (byte)-1;
    byte minute = (byte)-1;
    BigDecimal seconds;
    short tz = Short.MAX_VALUE;
    static final DatatypeFactory DF;

    ADate(Type type, ADate date) {
        super(type);
        this.year = date.year;
        this.month = date.month;
        this.day = date.day;
        this.hour = date.hour;
        this.minute = date.minute;
        this.seconds = date.seconds;
        this.tz = date.tz;
    }

    ADate(Type type) {
        super(type);
    }

    final void date(byte[] date, String exp, InputInfo info) throws QueryException {
        Matcher mt = DATE.matcher(Token.string(date).trim());
        if (!mt.matches()) {
            throw this.dateError(date, exp, info);
        }
        this.year = this.toLong(mt.group(1), false, info);
        if (this.year < 0L) {
            ++this.year;
        }
        this.month = (byte)(Strings.toInt(mt.group(3)) - 1);
        this.day = (byte)(Strings.toInt(mt.group(4)) - 1);
        if (this.month < 0 || this.month >= 12 || this.day < 0 || this.day >= ADate.daysOfMonth(this.year, this.month)) {
            throw this.dateError(date, exp, info);
        }
        if (this.year <= -25252734927766554L || this.year > 25252734927766554L) {
            throw QueryError.DATERANGE_X_X.get(info, this.type, date);
        }
        this.zone(mt, 5, date, info);
    }

    final void time(byte[] time, String exp, InputInfo info) throws QueryException {
        Matcher mt = TIME.matcher(Token.string(time).trim());
        if (!mt.matches()) {
            throw this.dateError(time, exp, info);
        }
        this.hour = (byte)Strings.toInt(mt.group(1));
        this.minute = (byte)Strings.toInt(mt.group(2));
        this.seconds = this.toDecimal(mt.group(3), false, info);
        if (this.minute >= 60 || this.seconds.compareTo(Dec.BD_60) >= 0 || this.hour > 24 || this.hour == 24 && (this.minute > 0 || this.seconds.compareTo(BigDecimal.ZERO) > 0)) {
            throw this.dateError(time, exp, info);
        }
        this.zone(mt, 5, time, info);
        if (this.hour == 24) {
            this.hour = 0;
            this.add(Dec.BD_864000);
        }
    }

    final void zone(Matcher matcher, int pos, byte[] value, InputInfo info) throws QueryException {
        String z = matcher.group(pos);
        if (z == null) {
            return;
        }
        if ("Z".equals(z)) {
            this.tz = 0;
        } else {
            int th = Strings.toInt(matcher.group(pos + 2));
            int tm = Strings.toInt(matcher.group(pos + 3));
            if (th > 14 || tm > 59 || th == 14 && tm != 0) {
                throw QueryError.INVALIDZONE_X.get(info, new Object[]{value});
            }
            int mn = th * 60 + tm;
            this.tz = (short)("-".equals(matcher.group(pos + 1)) ? -mn : mn);
        }
    }

    final void calc(DTDur dur, boolean plus) {
        this.add(plus ? dur.seconds : dur.seconds.negate());
    }

    final void calc(YMDur dur, boolean plus, InputInfo info) throws QueryException {
        long m = plus ? dur.months : -dur.months;
        long mn = (long)this.month + m;
        this.month = (byte)ADate.mod(mn, 12);
        this.year += ADate.div(mn, 12);
        this.day = (byte)Math.min(ADate.daysOfMonth(this.year, this.month) - 1, this.day);
        if (this.year <= -25252734927766554L || this.year > 25252734927766554L) {
            throw QueryError.YEARRANGE_X.get(info, this.year);
        }
    }

    private void add(BigDecimal add) {
        BigDecimal sc = this.seconds().add(add);
        this.seconds = sc.signum() >= 0 ? sc.remainder(Dec.BD_60) : sc.negate().add(sc.remainder(Dec.BD_60)).add(Dec.BD_60).add(sc).remainder(Dec.BD_60);
        long mn = Math.max(this.minute(), 0L) + ADate.div(sc.setScale(0, RoundingMode.FLOOR).longValue(), 60);
        this.minute = (byte)ADate.mod(mn, 60);
        long ho = (long)Math.max(this.hour, 0) + ADate.div(mn, 60);
        this.hour = (byte)ADate.mod(ho, 24);
        long da = ADate.div(ho, 24);
        long[] ymd = ADate.ymd(this.days().add(BigDecimal.valueOf(da)));
        this.year = ymd[0];
        this.month = (byte)ymd[1];
        this.day = (byte)ymd[2];
    }

    private static long mod(long value, int mod) {
        return (value > 0L ? value : Long.MAX_VALUE / (long)mod * (long)mod + value) % (long)mod;
    }

    private static long div(long value, int div) {
        return value < 0L ? (value + 1L) / (long)div - 1L : value / (long)div;
    }

    public abstract ADate timeZone(DTDur var1, boolean var2, InputInfo var3) throws QueryException;

    protected void tz(DTDur dur, boolean undefined, InputInfo info) throws QueryException {
        int t;
        if (undefined) {
            t = Short.MAX_VALUE;
        } else {
            if (dur == null) {
                Calendar c = Calendar.getInstance();
                t = (short)((c.get(15) + c.get(16)) / 60000);
            } else {
                t = (short)(dur.minute() + dur.hour() * 60L);
                if (dur.seconds().signum() != 0) {
                    throw QueryError.ZONESEC_X.get(info, dur);
                }
                if (Math.abs(t) > 840 || dur.day() != 0L) {
                    throw QueryError.INVALZONE_X.get(info, dur);
                }
            }
            if (this.tz != Short.MAX_VALUE) {
                this.add(BigDecimal.valueOf(60L * (long)(t - this.tz)));
            }
        }
        this.tz = (short)t;
    }

    @Override
    public final long yea() {
        return this.year > 0L ? this.year : this.year - 1L;
    }

    @Override
    public final long mon() {
        return this.month + 1;
    }

    @Override
    public final long day() {
        return this.day + 1;
    }

    @Override
    public final long hour() {
        return this.hour;
    }

    @Override
    public final long minute() {
        return this.minute;
    }

    @Override
    public final BigDecimal seconds() {
        return this.seconds == null ? BigDecimal.ZERO : this.seconds;
    }

    public final BigDecimal sec() {
        return this.seconds;
    }

    public final int tz() {
        return this.tz;
    }

    public final boolean hasTz() {
        return this.tz != Short.MAX_VALUE;
    }

    @Override
    public byte[] string(InputInfo ii) {
        boolean ymd;
        TokenBuilder tb = new TokenBuilder();
        boolean bl = ymd = this.year != Long.MAX_VALUE;
        if (ymd) {
            if (this.year <= 0L) {
                tb.add(45);
            }
            ADate.prefix(tb, Math.abs(this.yea()), 4);
            tb.add(45);
            ADate.prefix(tb, this.mon(), 2);
            tb.add(45);
            ADate.prefix(tb, this.day(), 2);
        }
        if (this.hour >= 0) {
            if (ymd) {
                tb.add(84);
            }
            ADate.prefix(tb, this.hour(), 2);
            tb.add(58);
            ADate.prefix(tb, this.minute(), 2);
            tb.add(58);
            if (this.seconds.intValue() < 10) {
                tb.add(48);
            }
            tb.add(Token.chopNumber(Token.token(this.seconds().abs().toPlainString())));
        }
        this.zone(tb);
        return tb.finish();
    }

    void zone(TokenBuilder tb) {
        if (this.tz == Short.MAX_VALUE) {
            return;
        }
        if (this.tz == 0) {
            tb.add(90);
        } else {
            tb.add(this.tz > 0 ? 43 : 45);
            ADate.prefix(tb, Math.abs(this.tz) / 60, 2);
            tb.add(58);
            ADate.prefix(tb, Math.abs(this.tz) % 60, 2);
        }
    }

    static void prefix(TokenBuilder tb, long number, int zero) {
        byte[] t = Token.token(number);
        for (int i = t.length; i < zero; ++i) {
            tb.add(48);
        }
        tb.add(t);
    }

    @Override
    public final boolean equal(Item item, Collation coll, InputInfo ii) throws QueryException {
        return this.compare(item, ii) == 0;
    }

    @Override
    public final boolean deepEqual(Item item, DeepEqual deep) throws QueryException {
        return this.type == item.type && this.compare(item, deep.info) == 0 && (deep.options.get(DeepEqualOptions.TIMEZONES) == false || this.tz == ((ADate)item).tz);
    }

    @Override
    public final boolean atomicEqual(Item item) throws QueryException {
        return this == item || this.type == item.type && this.compare(item, null) == 0 && this.hasTz() == ((ADate)item).hasTz();
    }

    public final int hashCode() {
        return this.toSeconds().intValue();
    }

    @Override
    public int compare(Item item, Collation coll, boolean transitive, InputInfo ii) throws QueryException {
        return this.compare(item, ii);
    }

    private int compare(Item item, InputInfo info) throws QueryException {
        ADate dat = (ADate)(item instanceof ADate ? item : this.type.cast(item, null, info));
        return this.toSeconds().compareTo(dat.toSeconds());
    }

    @Override
    public final XMLGregorianCalendar toJava() {
        return DF.newXMLGregorianCalendar(this.year == Long.MAX_VALUE ? null : BigInteger.valueOf(this.year > 0L ? this.year : this.year - 1L), this.month >= 0 ? this.month + 1 : Integer.MIN_VALUE, this.day >= 0 ? this.day + 1 : Integer.MIN_VALUE, this.hour >= 0 ? (int)this.hour : Integer.MIN_VALUE, this.minute >= 0 ? (int)this.minute : Integer.MIN_VALUE, this.seconds != null ? this.seconds.intValue() : Integer.MIN_VALUE, this.seconds != null ? this.seconds.remainder(BigDecimal.ONE) : null, this.tz == Short.MAX_VALUE ? Integer.MIN_VALUE : (int)this.tz);
    }

    final BigDecimal toSeconds() {
        return this.daySeconds().add(this.days().multiply(Dec.BD_864000));
    }

    public final BigDecimal daySeconds() {
        int z = this.tz;
        if (z == Short.MAX_VALUE) {
            long n = System.currentTimeMillis();
            z = Calendar.getInstance().getTimeZone().getOffset(n) / 60000;
        }
        return (this.seconds == null ? BigDecimal.ZERO : this.seconds).add(BigDecimal.valueOf((long)Math.max(0, this.hour) * 3600L + (long)Math.max(0, this.minute) * 60L - (long)z * 60L));
    }

    final BigDecimal days() {
        long y = this.year == Long.MAX_VALUE ? 1L : this.year;
        return ADate.days(y + 25252734927766800L, Math.max(this.month, 0), Math.max(this.day, 0));
    }

    private static BigDecimal days(long year, int month, int day) {
        long y = year - (long)(month < 2 ? 1 : 0);
        long m = month + (month < 2 ? 13 : 1);
        long d = day + 1;
        return Dec.BD_365.multiply(BigDecimal.valueOf(y)).add(BigDecimal.valueOf(y / 4L - y / 100L + y / 400L - 92L + d + (153L * m - 2L) / 5L));
    }

    private static long[] ymd(BigDecimal days) {
        BigDecimal d = days;
        BigDecimal t = d.add(Dec.BD_36525).multiply(Dec.BD_4).divideToIntegralValue(Dec.BD_146097).subtract(BigDecimal.ONE);
        BigDecimal y = Dec.BD_100.multiply(t);
        d = d.subtract(Dec.BD_36524.multiply(t).add(t.divideToIntegralValue(Dec.BD_4)));
        t = d.add(Dec.BD_366).multiply(Dec.BD_4).divideToIntegralValue(Dec.BD_1461).subtract(BigDecimal.ONE);
        y = y.add(t);
        d = d.subtract(Dec.BD_365.multiply(t).add(t.divideToIntegralValue(Dec.BD_4)));
        BigDecimal m = Dec.BD_5.multiply(d).add(Dec.BD_2).divideToIntegralValue(Dec.BD_153);
        d = d.subtract(Dec.BD_153.multiply(m).add(Dec.BD_2).divideToIntegralValue(Dec.BD_5));
        long mm = m.longValue();
        if (mm > 9L) {
            mm -= 12L;
            y = y.add(BigDecimal.ONE);
        }
        return new long[]{y.subtract(BigDecimal.valueOf(25252734927766800L)).longValue(), mm + 2L, d.longValue()};
    }

    public static int daysOfMonth(long year, int month) {
        int days = DAYS[month];
        return month == 1 && year % 4L == 0L && (year % 100L != 0L || year % 400L == 0L) ? days + 1 : days;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ADate)) return false;
        ADate dat = (ADate)obj;
        if (!this.type.eq(dat.type)) return false;
        if (this.year != dat.year) return false;
        if (this.month != dat.month) return false;
        if (this.day != dat.day) return false;
        if (this.hour != dat.hour) return false;
        if (this.minute != dat.minute) return false;
        if (this.tz != dat.tz) return false;
        if (!Objects.equals(this.seconds, dat.seconds)) return false;
        return true;
    }

    @Override
    public final void toString(QueryString qs) {
        qs.quoted(this.string(null));
    }

    static {
        try {
            DF = DatatypeFactory.newInstance();
        }
        catch (Exception ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
    }
}

