/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.map;

import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.RecordField;
import org.basex.query.value.type.RecordType;
import org.basex.query.value.type.Type;
import org.basex.util.hash.TokenObjectMap;

public final class MapCompilation {
    public static final byte[] EXTENDED = new byte[0];
    public MapType mapType;
    public RecordType record;
    public byte[] key;
    public RecordField field;
    public Integer index;
    public boolean keyMismatch;

    public static MapCompilation get(Expr map) {
        MapCompilation mi = new MapCompilation();
        Type type = map.seqType().type;
        if (type instanceof MapType) {
            MapType mt;
            mi.mapType = mt = (MapType)type;
            if (mt instanceof RecordType) {
                RecordType rt;
                mi.record = rt = (RecordType)mt;
            }
        }
        return mi;
    }

    public MapCompilation key(Expr expr) throws QueryException {
        if (this.record != null) {
            Type kt = expr.seqType().type;
            if (expr instanceof Item) {
                Item item = (Item)expr;
                if (kt.isStringOrUntyped()) {
                    TokenObjectMap<RecordField> fields = this.record.fields();
                    byte[] k = item.string(null);
                    this.index = fields.index(k);
                    this.field = fields.get(k);
                    if (this.field != null) {
                        this.key = k;
                    }
                }
                if (this.key == null && kt.instanceOf(AtomType.ANY_ATOMIC_TYPE)) {
                    this.key = EXTENDED;
                }
            }
        }
        if (this.mapType != null) {
            AtomType et = expr.seqType().type.atomic();
            Type kt = this.mapType.keyType();
            this.keyMismatch = et != null && (kt.isStringOrUntyped() && et.isNumber() || kt.isNumber() && et.isStringOrUntyped());
        }
        return this;
    }

    public MapCompilation index(Expr expr) {
        if (this.record != null && expr instanceof Itr) {
            Itr itr = (Itr)expr;
            this.index = (int)itr.itr();
            TokenObjectMap<RecordField> fields = this.record.fields();
            if (this.index > 0 && this.index <= fields.size()) {
                this.field = fields.value(this.index);
            }
        }
        return this;
    }
}

