/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.parse.json;

import org.basex.build.json.JsonParserOptions;
import org.basex.io.parse.json.JsonConstants;
import org.basex.io.parse.json.JsonXmlConverter;
import org.basex.query.QueryException;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FBuilder;
import org.basex.query.value.node.FElem;

public final class JsonAttsConverter
extends JsonXmlConverter {
    JsonAttsConverter(JsonParserOptions opts) throws QueryException {
        super(opts);
    }

    @Override
    protected void openObject() {
        this.openOuter(JsonConstants.OBJECT);
    }

    @Override
    protected void closeObject() {
        this.closeOuter();
    }

    @Override
    protected void openPair(byte[] key, boolean add) {
        this.addValues.add(add);
        if (add) {
            this.openInner(Q_PAIR);
            this.name = this.shared.token(key);
            this.curr.add(Q_NAME, this.name);
        }
    }

    @Override
    protected void closePair(boolean add) {
        if (add) {
            this.closeInner();
            this.name = null;
        }
        this.addValues.pop();
    }

    @Override
    protected void openArray() {
        this.openOuter(JsonConstants.ARRAY);
    }

    @Override
    protected void closeArray() {
        this.closeOuter();
    }

    @Override
    protected void openItem() {
        this.openInner(Q_ITEM);
    }

    @Override
    protected void closeItem() {
        this.closeInner();
    }

    @Override
    void addValue(byte[] type, byte[] value) {
        if (this.addValues.peek()) {
            this.element(type).add(value != null ? this.shared.token(value) : null);
        }
    }

    private void openOuter(byte[] type) {
        this.stack.push(this.element(type));
    }

    private void closeOuter() {
        this.stack.pop();
    }

    private void openInner(QNm type) {
        this.curr = FElem.build(type);
        this.stack.push(this.curr);
    }

    private void closeInner() {
        this.curr = (FBuilder)this.stack.pop();
        if (!this.stack.isEmpty()) {
            this.curr = ((FBuilder)this.stack.peek()).add(this.curr);
        }
    }

    private FBuilder element(byte[] type) {
        if (this.curr == null) {
            this.curr = FElem.build(Q_JSON);
        }
        this.processType(this.curr, type);
        return this.curr;
    }
}

