/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.folder;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import org.basex.data.Data;
import org.basex.gui.GUIConstants;
import org.basex.gui.GUIOptions;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLayout;
import org.basex.gui.layout.BaseXPopup;
import org.basex.gui.layout.BaseXScrollBar;
import org.basex.gui.view.View;
import org.basex.gui.view.ViewData;
import org.basex.gui.view.ViewNotifier;
import org.basex.gui.view.folder.FolderIterator;
import org.basex.query.value.seq.DBNodes;

public final class FolderView
extends View {
    private static final int OFFX = 8;
    boolean[] opened;
    int lineH;
    int focusedPos;
    private BufferedImage closedMarker;
    private BufferedImage openedMarker;
    private final BaseXScrollBar scroll;
    private int totalW;
    private int startY;
    private int treeH;
    private int boxW;
    private int boxMargin;

    public FolderView(ViewNotifier notifier) {
        super("folder", notifier);
        this.createBoxes();
        this.layout(new BorderLayout());
        this.scroll = new BaseXScrollBar(this);
        this.add((Component)this.scroll, "East");
        new BaseXPopup(this, GUIConstants.POPUP);
    }

    @Override
    public void refreshInit() {
        this.scroll.pos(0);
        if (this.gui.context.data() == null) {
            this.opened = null;
        } else if (this.visible()) {
            this.refreshOpenedNodes();
            this.refreshHeight();
            this.repaint();
        }
    }

    private void refreshOpenedNodes() {
        Data data = this.gui.context.data();
        this.opened = new boolean[data.meta.size];
        int is = data.meta.size;
        for (int pre = 0; pre < is; ++pre) {
            this.opened[pre] = data.parent(pre, data.kind(pre)) <= 0;
        }
    }

    @Override
    public void refreshFocus() {
        this.repaint();
    }

    @Override
    public void refreshMark() {
        int pre = this.gui.context.focused;
        if (pre == -1) {
            return;
        }
        Data data = this.gui.context.data();
        int par = data.parent(pre, data.kind(pre));
        this.jumpTo(pre, par != -1 && !this.opened[par]);
        this.repaint();
    }

    @Override
    public void refreshContext(boolean more, boolean quick) {
        this.startY = 0;
        this.scroll.pos(0);
        DBNodes curr = this.gui.context.current();
        if (more && !curr.isEmpty()) {
            this.jumpTo(curr.pre(0), true);
        }
        this.refreshHeight();
        this.repaint();
    }

    @Override
    public void refreshLayout() {
        this.scroll.refreshLayout();
        this.createBoxes();
        if (this.opened == null) {
            return;
        }
        this.refreshOpenedNodes();
        this.refreshHeight();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void refreshUpdate() {
        if (this.opened == null) {
            return;
        }
        Data data = this.gui.context.data();
        if (this.opened.length < data.meta.size) {
            this.opened = Arrays.copyOf(this.opened, data.meta.size);
        }
        this.startY = 0;
        this.scroll.pos(0);
        DBNodes marked = this.gui.context.marked;
        if (!marked.isEmpty()) {
            this.jumpTo(marked.pre(0), true);
        }
        this.refreshHeight();
        this.repaint();
    }

    @Override
    public boolean visible() {
        return this.gui.gopts.get(GUIOptions.SHOWFOLDER);
    }

    @Override
    public void visible(boolean v) {
        this.gui.gopts.set(GUIOptions.SHOWFOLDER, v);
    }

    @Override
    protected boolean db() {
        return true;
    }

    private void refreshHeight() {
        if (this.opened == null) {
            return;
        }
        this.treeH = new FolderIterator(this).height();
        this.scroll.height(this.treeH + 5);
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.opened == null) {
            this.refreshInit();
            return;
        }
        super.paintComponent(g);
        if (this.opened == null) {
            return;
        }
        this.gui.painting = true;
        this.startY = -this.scroll.pos();
        this.totalW = this.getWidth() - (this.treeH > this.getHeight() ? this.scroll.getWidth() : 0);
        FolderIterator iter = new FolderIterator(this, this.startY + 5, this.getHeight());
        Data data = this.gui.context.data();
        while (iter.more()) {
            int kind = data.kind(iter.pre);
            boolean elem = kind == 1 || kind == 0;
            int x = 8 + iter.level * (this.lineH >> 1) + (elem ? this.lineH : this.boxW);
            this.drawEntry(g, iter.pre, x, iter.y + this.boxW);
        }
        this.gui.painting = false;
    }

    private void drawEntry(Graphics g, int pre, int x, int y) {
        Data data = this.gui.context.data();
        DBNodes marked = this.gui.context.marked;
        int kind = data.kind(pre);
        boolean elem = kind == 1 || kind == 0;
        Color col = GUIConstants.TEXT;
        Font fnt = GUIConstants.font;
        if (marked.find(pre) >= 0) {
            col = GUIConstants.colormark3;
            fnt = GUIConstants.bfont;
        }
        if (y < -this.lineH) {
            return;
        }
        g.setColor(GUIConstants.color1);
        g.drawLine(2, y + this.boxMargin - 1, this.totalW - 5, y + this.boxMargin - 1);
        byte[] name = ViewData.text(data, pre);
        int p = this.gui.context.focused;
        while (p > pre) {
            p = ViewData.parent(data, p);
        }
        if (pre == p) {
            g.setColor(GUIConstants.color2);
            g.fillRect(0, y - this.boxW - this.boxMargin, this.totalW, this.lineH + 1);
        }
        if (elem) {
            int yy = y - this.boxW;
            BufferedImage marker = this.opened[pre] ? this.openedMarker : this.closedMarker;
            g.drawImage(marker, x - this.lineH, yy, this);
        }
        g.setFont(fnt);
        g.setColor(col);
        BaseXLayout.chopString(g, name, x, y - GUIConstants.fontSize, this.totalW + 6 - x - 10, GUIConstants.fontSize);
        if (this.gui.context.focused == pre) {
            g.setColor(GUIConstants.color4);
            g.drawRect(1, y - this.boxW - this.boxMargin, this.totalW - 3, this.lineH + 1);
            g.drawRect(2, y - this.boxW - this.boxMargin + 1, this.totalW - 5, this.lineH - 1);
        }
    }

    private boolean focus(int x, int y) {
        if (this.opened == null) {
            return false;
        }
        int fsz = GUIConstants.fontSize;
        FolderIterator iter = new FolderIterator(this, this.startY + 3, this.getHeight());
        Data data = this.gui.context.data();
        while (iter.more()) {
            int xx;
            if (y <= iter.y || y > iter.y + this.lineH) continue;
            Cursor c = GUIConstants.CURSORARROW;
            int kind = data.kind(iter.pre);
            if ((kind == 1 || kind == 0) && x > (xx = 8 + iter.level * (this.lineH >> 1) + this.lineH - 6) - fsz && x < xx) {
                c = GUIConstants.CURSORHAND;
            }
            this.gui.cursor(c);
            this.gui.notify.focus(iter.pre, this);
            this.repaint();
            return true;
        }
        return false;
    }

    private void jumpTo(int pre, boolean open) {
        if (this.getWidth() == 0 || !this.visible()) {
            return;
        }
        if (open) {
            int p = pre;
            while (p > 0) {
                this.opened[p] = true;
                p = ViewData.parent(this.gui.context.data(), p);
            }
            this.refreshHeight();
        }
        FolderIterator iter = new FolderIterator(this);
        while (iter.more() && pre != iter.pre) {
        }
        int y = -iter.y;
        int h = this.getHeight();
        if (y > this.startY || y + h < this.startY + this.lineH) {
            this.startY = Math.min(0, Math.max(-this.treeH + h - 5, y + this.lineH));
            this.scroll.pos(-this.startY);
        }
    }

    private void createBoxes() {
        int s = GUIConstants.fontSize;
        this.boxMargin = s >> 2;
        this.lineH = s + this.boxMargin;
        this.boxW = s - this.boxMargin;
        int sp = Math.max(1, s >> 4);
        BufferedImage emptyBox = new BufferedImage(this.boxW + 1, this.boxW + 1, 2);
        Graphics2D g = emptyBox.createGraphics();
        BaseXLayout.antiAlias(g);
        g.setColor(GUIConstants.color4);
        g.fillOval((this.boxW >> 2) - 1, (this.boxW >> 2) + 1, this.boxW >> 1, this.boxW >> 1);
        g.setColor(GUIConstants.color3);
        g.fillOval((this.boxW >> 2) - 2, this.boxW >> 2, this.boxW >> 1, this.boxW >> 1);
        this.openedMarker = new BufferedImage(this.boxW + 1, this.boxW + 1, 2);
        g = this.openedMarker.createGraphics();
        BaseXLayout.antiAlias(g);
        Polygon p = new Polygon(new int[]{0, this.boxW, this.boxW >> 1}, new int[]{this.boxW - sp >> 1, this.boxW - sp >> 1, this.boxW}, 3);
        p.translate(0, -1);
        g.setColor(GUIConstants.color4);
        g.fillPolygon(p);
        p.translate(-1, -1);
        g.setColor(GUIConstants.color3);
        g.fillPolygon(p);
        this.closedMarker = new BufferedImage(this.boxW + 1, this.boxW + 1, 2);
        g = this.closedMarker.createGraphics();
        BaseXLayout.antiAlias(g);
        p = new Polygon(new int[]{this.boxW - sp >> 1, this.boxW, this.boxW - sp >> 1}, new int[]{0, this.boxW >> 1, this.boxW}, 3);
        p.translate(-1, 1);
        g.setColor(GUIConstants.color4);
        g.fillPolygon(p);
        p.translate(-1, -1);
        g.setColor(GUIConstants.color3);
        g.fillPolygon(p);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.gui.updating) {
            return;
        }
        super.mouseMoved(e);
        this.focus(e.getX(), e.getY());
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.gui.updating || this.opened == null) {
            return;
        }
        super.mousePressed(e);
        if (!this.focus(e.getX(), e.getY())) {
            return;
        }
        DBNodes marked = this.gui.context.marked;
        if (e.getClickCount() == 2) {
            this.gui.notify.context(marked, false, null);
        } else if (e.isShiftDown()) {
            this.gui.notify.mark(1, null);
        } else if (BaseXKeys.sc(e) && SwingUtilities.isLeftMouseButton(e)) {
            this.gui.notify.mark(2, null);
        } else if (this.getCursor() != GUIConstants.CURSORHAND) {
            if (!marked.contains(this.gui.context.focused)) {
                this.gui.notify.mark(0, null);
            }
        } else {
            int n = this.gui.context.focused;
            this.opened[n] = this.opened[n] ^ true;
            this.refreshHeight();
            this.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        boolean left = SwingUtilities.isLeftMouseButton(e);
        if (!left || this.gui.updating || this.opened == null) {
            return;
        }
        super.mouseDragged(e);
        if (this.focus(e.getX(), e.getY())) {
            this.gui.notify.mark(1, null);
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.gui.updating) {
            return;
        }
        this.scroll.pos(this.scroll.pos() + e.getUnitsToScroll() * 20);
        this.repaint();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int focus;
        if (this.gui.updating || this.opened == null) {
            return;
        }
        super.keyPressed(e);
        int n = focus = this.focusedPos == -1 ? 0 : this.focusedPos;
        if (this.gui.context.focused == -1) {
            this.gui.context.focused = 0;
        }
        int focusPre = this.gui.context.focused;
        Data data = this.gui.context.data();
        int kind = data.kind(focusPre);
        boolean right = BaseXKeys.NEXTCHAR.is(e);
        boolean down = BaseXKeys.NEXTLINE.is(e);
        boolean up = BaseXKeys.PREVLINE.is(e);
        if (right || BaseXKeys.PREVCHAR.is(e)) {
            if (e.isShiftDown()) {
                this.opened[focusPre] = right;
                int s = data.meta.size;
                for (int pre = focusPre + 1; pre != s && data.parent(pre, data.kind(pre)) >= focusPre; ++pre) {
                    this.opened[pre] = right;
                }
                this.refreshHeight();
                this.repaint();
                return;
            }
            if (right ^ this.opened[focusPre] && (!ViewData.leaf(this.gui.gopts, data, focusPre) || data.attSize(focusPre, kind) > 1)) {
                this.opened[focusPre] = right;
                this.refreshHeight();
                this.repaint();
            } else if (right) {
                down = true;
            } else {
                up = true;
            }
        }
        if (down) {
            focus = Math.min(data.meta.size - 1, focus + 1);
        } else if (up) {
            focus = Math.max(0, focus - 1);
        } else if (BaseXKeys.NEXTPAGE.is(e)) {
            focus = Math.min(data.meta.size - 1, focus + this.getHeight() / this.lineH);
        } else if (BaseXKeys.PREVPAGE.is(e)) {
            focus = Math.max(0, focus - this.getHeight() / this.lineH);
        } else if (BaseXKeys.TEXTSTART.is(e)) {
            focus = 0;
        } else if (BaseXKeys.TEXTEND.is(e)) {
            focus = data.meta.size - 1;
        }
        if (focus == this.focusedPos) {
            return;
        }
        this.gui.context.focused = -1;
        DBNodes curr = this.gui.context.current();
        int pre = curr.pre(0);
        FolderIterator iter = new FolderIterator(this);
        while (iter.more() && focus-- != 0) {
            pre = iter.pre;
        }
        if (pre == curr.pre(0) && down) {
            ++pre;
        }
        this.gui.notify.focus(pre, this);
        this.jumpTo(pre, false);
        this.repaint();
    }
}

