/*
 * Decompiled with CFR 0.152.
 */
package org.basex.data;

import java.util.ArrayList;
import org.basex.data.Data;
import org.basex.data.NSNode;
import org.basex.data.Namespaces;
import org.basex.util.Atts;
import org.basex.util.list.IntList;

final class NSScope {
    private final Data data;
    private final Namespaces nspaces;
    private final IntList preStack = new IntList();
    private final NSNode root;
    private final ArrayList<NSNode> cache;

    NSScope(int pre, Data data) {
        this.data = data;
        this.nspaces = data.nspaces;
        this.root = this.nspaces.cursor();
        this.cache = this.nspaces.cache(pre);
    }

    void loop(int nsPre, int c) {
        if (c == 0) {
            this.nspaces.root(nsPre, this.data);
        }
        while (!this.preStack.isEmpty() && this.preStack.peek() > nsPre) {
            this.nspaces.close(this.preStack.pop());
        }
    }

    void open(int pre) {
        this.nspaces.open();
        this.preStack.push(pre);
    }

    boolean open(int pre, Atts nsp) {
        Atts ns = new Atts();
        int as = nsp.size();
        for (int a = 0; a < as; ++a) {
            byte[] prefix = nsp.name(a);
            byte[] uri = nsp.value(a);
            int uriId = this.nspaces.uriIdForPrefix(prefix, true);
            if (uriId != 0 && uriId == this.nspaces.uriId(uri)) continue;
            ns.add(prefix, uri);
        }
        this.nspaces.open(pre, ns);
        this.preStack.push(pre);
        return !ns.isEmpty();
    }

    void shift(int diff) {
        for (NSNode node : this.cache) {
            node.incrementPre(diff);
        }
    }

    void close() {
        while (!this.preStack.isEmpty()) {
            this.nspaces.close(this.preStack.pop());
        }
        this.nspaces.cursor(this.root);
    }
}

