# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman, Enno Cramer
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.006;
use strict;
use warnings;

package ArchWay::MainWindow::Conflict;

use base 'ArchWay::MainWindow::Base';

use Glib qw(TRUE FALSE);
use Gtk2;

use Arch::Util qw(run_cmd);

sub init ($) {
	my $self = shift;

	$self->SUPER::init;

	# init ui
	$self->set_default_size(500, 500);
	$self->main_widget->set_position(250);
	$self->refresh;
}

sub confl_list ($) {
	my $self = shift;

	if (! exists $self->{confl_list}) {
		my $cl = Gtk2::TreeView->new;
		$cl->set_model(Gtk2::ListStore->new(qw(Glib::String)));

		$cl->insert_column_with_attributes(
			-1, "Conflict files", Gtk2::CellRendererText->new,
			text => 0,
		);

		$self->{confl_list} = $cl;
	}

	return $self->{confl_list};
}

sub main_widget ($) {
	my $self = shift;

	if (! exists $self->{main_widget}) {
		my $scwin = Gtk2::ScrolledWindow->new();
		$scwin->set_policy('automatic', 'automatic');
		$scwin->add($self->confl_list());

		my $lbl = Gtk2::Label->new;
		$lbl->set_markup('<b>*** not implemented yet ***</b>');

		my $vpaned = Gtk2::VPaned->new();
		$vpaned->pack1($scwin, TRUE, TRUE);
		$vpaned->pack2($lbl, TRUE, TRUE);
		
		$self->{main_widget} = $vpaned;
	}

	return $self->{main_widget};
}

sub tree ($) {
	my $self = shift;

	return $self->{tree};
}

sub refresh ($) {
	my $self = shift;

	my $model = $self->confl_list->get_model;
	$model->clear;

	my $root = $self->tree->root;

	my @files = run_cmd('find', $root, '-name', '*.rej');
	foreach (@files) {
		s,^\Q$root/,,;
		my $iter = $model->append;
		$model->set($iter,
			0 => $_,
		);
	}
}

1;

__END__
