/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.schema;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.schema.PgColumnUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PgColumn {
    private static final Pattern PATTERN_NULL = Pattern.compile("^(.+)[\\s]+NULL$", 2);
    private static final Pattern PATTERN_NOT_NULL = Pattern.compile("^(.+)[\\s]+NOT[\\s]+NULL$", 2);
    private static final Pattern PATTERN_DEFAULT = Pattern.compile("^(.+)[\\s]+DEFAULT[\\s]+(.+)$", 2);
    private Integer statistics;
    private String defaultValue;
    private String name;
    private String type;
    private boolean nullValue = true;
    private String storage;
    private String comment;

    public PgColumn(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getFullDefinition(boolean addDefaults) {
        String defaultColValue;
        StringBuilder sbDefinition = new StringBuilder(100);
        sbDefinition.append(PgDiffUtils.getQuotedName(this.name));
        sbDefinition.append(' ');
        sbDefinition.append(this.type);
        if (this.defaultValue != null && !this.defaultValue.isEmpty()) {
            sbDefinition.append(" DEFAULT ");
            sbDefinition.append(this.defaultValue);
        } else if (!this.nullValue && addDefaults && (defaultColValue = PgColumnUtils.getDefaultValue(this.type)) != null) {
            sbDefinition.append(" DEFAULT ");
            sbDefinition.append(defaultColValue);
        }
        if (!this.nullValue) {
            sbDefinition.append(" NOT NULL");
        }
        return sbDefinition.toString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setNullValue(boolean nullValue) {
        this.nullValue = nullValue;
    }

    public boolean getNullValue() {
        return this.nullValue;
    }

    public void setStatistics(Integer statistics) {
        this.statistics = statistics;
    }

    public Integer getStatistics() {
        return this.statistics;
    }

    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void parseDefinition(String definition) {
        String string = definition;
        Matcher matcher = PATTERN_NOT_NULL.matcher(string);
        if (matcher.matches()) {
            string = matcher.group(1).trim();
            this.setNullValue(false);
        } else {
            matcher = PATTERN_NULL.matcher(string);
            if (matcher.matches()) {
                string = matcher.group(1).trim();
                this.setNullValue(true);
            }
        }
        matcher = PATTERN_DEFAULT.matcher(string);
        if (matcher.matches()) {
            string = matcher.group(1).trim();
            this.setDefaultValue(matcher.group(2).trim());
        }
        this.setType(string);
    }
}

