/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffArguments;
import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.Resources;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgColumn;
import cz.startnet.utils.pgdiff.schema.PgColumnUtils;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTable;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PgDiffTables {
    public static void dropClusters(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        for (PgTable newTable : newSchema.getTables()) {
            PgTable oldTable = oldSchema == null ? null : oldSchema.getTable(newTable.getName());
            String oldCluster = oldTable == null ? null : oldTable.getClusterIndexName();
            String newCluster = newTable.getClusterIndexName();
            if (oldCluster == null || newCluster != null || !newTable.containsIndex(oldCluster)) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.print("ALTER TABLE ");
            writer.print(PgDiffUtils.getQuotedName(newTable.getName()));
            writer.println(" SET WITHOUT CLUSTER;");
        }
    }

    public static void createClusters(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        for (PgTable newTable : newSchema.getTables()) {
            PgTable oldTable = oldSchema == null ? null : oldSchema.getTable(newTable.getName());
            String oldCluster = oldTable == null ? null : oldTable.getClusterIndexName();
            String newCluster = newTable.getClusterIndexName();
            if ((oldCluster != null || newCluster == null) && (oldCluster == null || newCluster == null || newCluster.compareTo(oldCluster) == 0)) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.print("ALTER TABLE ");
            writer.print(PgDiffUtils.getQuotedName(newTable.getName()));
            writer.print(" CLUSTER ON ");
            writer.print(PgDiffUtils.getQuotedName(newCluster));
            writer.println(';');
        }
    }

    public static void alterTables(PrintWriter writer, PgDiffArguments arguments, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        for (PgTable newTable : newSchema.getTables()) {
            if (oldSchema == null || !oldSchema.containsTable(newTable.getName())) continue;
            PgTable oldTable = oldSchema.getTable(newTable.getName());
            PgDiffTables.updateTableColumns(writer, arguments, oldTable, newTable, searchPathHelper);
            PgDiffTables.checkWithOIDS(writer, oldTable, newTable, searchPathHelper);
            PgDiffTables.checkInherits(writer, oldTable, newTable, searchPathHelper);
            PgDiffTables.checkTablespace(writer, oldTable, newTable, searchPathHelper);
            PgDiffTables.addAlterStatistics(writer, oldTable, newTable, searchPathHelper);
            PgDiffTables.addAlterStorage(writer, oldTable, newTable, searchPathHelper);
            PgDiffTables.alterComments(writer, oldTable, newTable, searchPathHelper);
        }
    }

    private static void addAlterStatistics(PrintWriter writer, PgTable oldTable, PgTable newTable, SearchPathHelper searchPathHelper) {
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        for (PgColumn pgColumn : newTable.getColumns()) {
            PgColumn oldColumn = oldTable.getColumn(pgColumn.getName());
            if (oldColumn == null) continue;
            Integer oldStat = oldColumn.getStatistics();
            Integer newStat = pgColumn.getStatistics();
            Integer newStatValue = null;
            if (!(newStat == null || oldStat != null && newStat.equals(oldStat))) {
                newStatValue = newStat;
            } else if (oldStat != null && newStat == null) {
                newStatValue = -1;
            }
            if (newStatValue == null) continue;
            stats.put(pgColumn.getName(), newStatValue);
        }
        for (Map.Entry entry : stats.entrySet()) {
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.print("ALTER TABLE ONLY ");
            writer.print(PgDiffUtils.getQuotedName(newTable.getName()));
            writer.print(" ALTER COLUMN ");
            writer.print(PgDiffUtils.getQuotedName((String)entry.getKey()));
            writer.print(" SET STATISTICS ");
            writer.print(entry.getValue());
            writer.println(';');
        }
    }

    private static void addAlterStorage(PrintWriter writer, PgTable oldTable, PgTable newTable, SearchPathHelper searchPathHelper) {
        for (PgColumn newColumn : newTable.getColumns()) {
            String newStorage;
            PgColumn oldColumn = oldTable.getColumn(newColumn.getName());
            String oldStorage = oldColumn == null || oldColumn.getStorage() == null || oldColumn.getStorage().isEmpty() ? null : oldColumn.getStorage();
            String string = newStorage = newColumn.getStorage() == null || newColumn.getStorage().isEmpty() ? null : newColumn.getStorage();
            if (newStorage == null && oldStorage != null) {
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.println(MessageFormat.format(Resources.getString("WarningUnableToDetermineStorageType"), newTable.getName() + '.' + newColumn.getName()));
                continue;
            }
            if (newStorage == null || newStorage.equalsIgnoreCase(oldStorage)) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.print("ALTER TABLE ONLY ");
            writer.print(PgDiffUtils.getQuotedName(newTable.getName()));
            writer.print(" ALTER COLUMN ");
            writer.print(PgDiffUtils.getQuotedName(newColumn.getName()));
            writer.print(" SET STORAGE ");
            writer.print(newStorage);
            writer.print(';');
        }
    }

    private static void addCreateTableColumns(List<String> statements, PgDiffArguments arguments, PgTable oldTable, PgTable newTable, List<PgColumn> dropDefaultsColumns) {
        for (PgColumn column : newTable.getColumns()) {
            if (oldTable.containsColumn(column.getName())) continue;
            statements.add("\tADD COLUMN " + column.getFullDefinition(arguments.isAddDefaults()));
            if (!arguments.isAddDefaults() || column.getNullValue() || column.getDefaultValue() != null && !column.getDefaultValue().isEmpty()) continue;
            dropDefaultsColumns.add(column);
        }
    }

    private static void addDropTableColumns(List<String> statements, PgTable oldTable, PgTable newTable) {
        for (PgColumn column : oldTable.getColumns()) {
            if (newTable.containsColumn(column.getName())) continue;
            statements.add("\tDROP COLUMN " + PgDiffUtils.getQuotedName(column.getName()));
        }
    }

    private static void addModifyTableColumns(List<String> statements, PgDiffArguments arguments, PgTable oldTable, PgTable newTable, List<PgColumn> dropDefaultsColumns) {
        for (PgColumn newColumn : newTable.getColumns()) {
            String defaultValue;
            String newDefault;
            if (!oldTable.containsColumn(newColumn.getName())) continue;
            PgColumn oldColumn = oldTable.getColumn(newColumn.getName());
            String newColumnName = PgDiffUtils.getQuotedName(newColumn.getName());
            if (!oldColumn.getType().equals(newColumn.getType())) {
                statements.add("\tALTER COLUMN " + newColumnName + " TYPE " + newColumn.getType() + " /* " + MessageFormat.format(Resources.getString("TypeParameterChange"), newTable.getName(), oldColumn.getType(), newColumn.getType()) + " */");
            }
            String oldDefault = oldColumn.getDefaultValue() == null ? "" : oldColumn.getDefaultValue();
            String string = newDefault = newColumn.getDefaultValue() == null ? "" : newColumn.getDefaultValue();
            if (!oldDefault.equals(newDefault)) {
                if (newDefault.length() == 0) {
                    statements.add("\tALTER COLUMN " + newColumnName + " DROP DEFAULT");
                } else {
                    statements.add("\tALTER COLUMN " + newColumnName + " SET DEFAULT " + newDefault);
                }
            }
            if (oldColumn.getNullValue() == newColumn.getNullValue()) continue;
            if (newColumn.getNullValue()) {
                statements.add("\tALTER COLUMN " + newColumnName + " DROP NOT NULL");
                continue;
            }
            if (arguments.isAddDefaults() && (defaultValue = PgColumnUtils.getDefaultValue(newColumn.getType())) != null) {
                statements.add("\tALTER COLUMN " + newColumnName + " SET DEFAULT " + defaultValue);
                dropDefaultsColumns.add(newColumn);
            }
            statements.add("\tALTER COLUMN " + newColumnName + " SET NOT NULL");
        }
    }

    private static void checkInherits(PrintWriter writer, PgTable oldTable, PgTable newTable, SearchPathHelper searchPathHelper) {
        for (String tableName : oldTable.getInherits()) {
            if (newTable.getInherits().contains(tableName)) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.println("ALTER TABLE " + PgDiffUtils.getQuotedName(newTable.getName()));
            writer.println("\tNO INHERIT " + PgDiffUtils.getQuotedName(tableName) + ';');
        }
        for (String tableName : newTable.getInherits()) {
            if (oldTable.getInherits().contains(tableName)) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.println("ALTER TABLE " + PgDiffUtils.getQuotedName(newTable.getName()));
            writer.println("\tINHERIT " + PgDiffUtils.getQuotedName(tableName) + ';');
        }
    }

    private static void checkWithOIDS(PrintWriter writer, PgTable oldTable, PgTable newTable, SearchPathHelper searchPathHelper) {
        if (oldTable.getWith() == null && newTable.getWith() == null || oldTable.getWith() != null && oldTable.getWith().equals(newTable.getWith())) {
            return;
        }
        searchPathHelper.outputSearchPath(writer);
        writer.println();
        writer.println("ALTER TABLE " + PgDiffUtils.getQuotedName(newTable.getName()));
        if (newTable.getWith() == null || "OIDS=false".equalsIgnoreCase(newTable.getWith())) {
            writer.println("\tSET WITHOUT OIDS;");
        } else if ("OIDS".equalsIgnoreCase(newTable.getWith()) || "OIDS=true".equalsIgnoreCase(newTable.getWith())) {
            writer.println("\tSET WITH OIDS;");
        } else {
            writer.println("\tSET " + newTable.getWith() + ";");
        }
    }

    private static void checkTablespace(PrintWriter writer, PgTable oldTable, PgTable newTable, SearchPathHelper searchPathHelper) {
        if (oldTable.getTablespace() == null && newTable.getTablespace() == null || oldTable.getTablespace() != null && oldTable.getTablespace().equals(newTable.getTablespace())) {
            return;
        }
        searchPathHelper.outputSearchPath(writer);
        writer.println();
        writer.println("ALTER TABLE " + PgDiffUtils.getQuotedName(newTable.getName()));
        writer.println("\tTABLESPACE " + newTable.getTablespace() + ';');
    }

    public static void createTables(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        for (PgTable table : newSchema.getTables()) {
            if (oldSchema != null && oldSchema.containsTable(table.getName())) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.println(table.getCreationSQL());
        }
    }

    public static void dropTables(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        if (oldSchema == null) {
            return;
        }
        for (PgTable table : oldSchema.getTables()) {
            if (newSchema.containsTable(table.getName())) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.println(table.getDropSQL());
        }
    }

    private static void updateTableColumns(PrintWriter writer, PgDiffArguments arguments, PgTable oldTable, PgTable newTable, SearchPathHelper searchPathHelper) {
        ArrayList<String> statements = new ArrayList<String>();
        ArrayList<PgColumn> dropDefaultsColumns = new ArrayList<PgColumn>();
        PgDiffTables.addDropTableColumns(statements, oldTable, newTable);
        PgDiffTables.addCreateTableColumns(statements, arguments, oldTable, newTable, dropDefaultsColumns);
        PgDiffTables.addModifyTableColumns(statements, arguments, oldTable, newTable, dropDefaultsColumns);
        if (!statements.isEmpty()) {
            int i;
            String quotedTableName = PgDiffUtils.getQuotedName(newTable.getName());
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.println("ALTER TABLE " + quotedTableName);
            for (i = 0; i < statements.size(); ++i) {
                writer.print((String)statements.get(i));
                writer.println(i + 1 < statements.size() ? "," : ";");
            }
            if (!dropDefaultsColumns.isEmpty()) {
                writer.println();
                writer.println("ALTER TABLE " + quotedTableName);
                for (i = 0; i < dropDefaultsColumns.size(); ++i) {
                    writer.print("\tALTER COLUMN ");
                    writer.print(PgDiffUtils.getQuotedName(((PgColumn)dropDefaultsColumns.get(i)).getName()));
                    writer.print(" DROP DEFAULT");
                    writer.println(i + 1 < dropDefaultsColumns.size() ? "," : ";");
                }
            }
        }
    }

    private static void alterComments(PrintWriter writer, PgTable oldTable, PgTable newTable, SearchPathHelper searchPathHelper) {
        if (oldTable.getComment() == null && newTable.getComment() != null || oldTable.getComment() != null && newTable.getComment() != null && !oldTable.getComment().equals(newTable.getComment())) {
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.print("COMMENT ON TABLE ");
            writer.print(PgDiffUtils.getQuotedName(newTable.getName()));
            writer.print(" IS ");
            writer.print(newTable.getComment());
            writer.println(';');
        } else if (oldTable.getComment() != null && newTable.getComment() == null) {
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.print("COMMENT ON TABLE ");
            writer.print(PgDiffUtils.getQuotedName(newTable.getName()));
            writer.println(" IS NULL;");
        }
        for (PgColumn newColumn : newTable.getColumns()) {
            PgColumn oldColumn = oldTable.getColumn(newColumn.getName());
            String oldComment = oldColumn == null ? null : oldColumn.getComment();
            String newComment = newColumn.getComment();
            if (newComment != null && (oldComment == null ? newComment != null : !oldComment.equals(newComment))) {
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.print("COMMENT ON COLUMN ");
                writer.print(PgDiffUtils.getQuotedName(newTable.getName()));
                writer.print('.');
                writer.print(PgDiffUtils.getQuotedName(newColumn.getName()));
                writer.print(" IS ");
                writer.print(newColumn.getComment());
                writer.println(';');
                continue;
            }
            if (oldComment == null || newComment != null) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.print("COMMENT ON COLUMN ");
            writer.print(PgDiffUtils.getQuotedName(newTable.getName()));
            writer.print('.');
            writer.print(PgDiffUtils.getQuotedName(newColumn.getName()));
            writer.println(" IS NULL;");
        }
    }

    private PgDiffTables() {
    }
}

