/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff;

import cz.startnet.utils.pgdiff.PgDiffUtils;
import cz.startnet.utils.pgdiff.SearchPathHelper;
import cz.startnet.utils.pgdiff.schema.PgIndex;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PgDiffIndexes {
    public static void createIndexes(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        for (PgTable newTable : newSchema.getTables()) {
            String newTableName = newTable.getName();
            if (oldSchema == null) {
                for (PgIndex index : newTable.getIndexes()) {
                    searchPathHelper.outputSearchPath(writer);
                    writer.println();
                    writer.println(index.getCreationSQL());
                }
                continue;
            }
            for (PgIndex index : PgDiffIndexes.getNewIndexes(oldSchema.getTable(newTableName), newTable)) {
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.println(index.getCreationSQL());
            }
        }
    }

    public static void dropIndexes(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        for (PgTable newTable : newSchema.getTables()) {
            String newTableName = newTable.getName();
            PgTable oldTable = oldSchema == null ? null : oldSchema.getTable(newTableName);
            for (PgIndex index : PgDiffIndexes.getDropIndexes(oldTable, newTable)) {
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.println(index.getDropSQL());
            }
        }
    }

    private static List<PgIndex> getDropIndexes(PgTable oldTable, PgTable newTable) {
        ArrayList<PgIndex> list = new ArrayList<PgIndex>();
        if (newTable != null && oldTable != null) {
            for (PgIndex index : oldTable.getIndexes()) {
                if (newTable.containsIndex(index.getName()) && newTable.getIndex(index.getName()).equals(index)) continue;
                list.add(index);
            }
        }
        return list;
    }

    private static List<PgIndex> getNewIndexes(PgTable oldTable, PgTable newTable) {
        ArrayList<PgIndex> list;
        block4: {
            list = new ArrayList<PgIndex>();
            if (newTable == null) break block4;
            if (oldTable == null) {
                for (PgIndex index : newTable.getIndexes()) {
                    list.add(index);
                }
            } else {
                for (PgIndex index : newTable.getIndexes()) {
                    if (oldTable.containsIndex(index.getName()) && oldTable.getIndex(index.getName()).equals(index)) continue;
                    list.add(index);
                }
            }
        }
        return list;
    }

    public static void alterComments(PrintWriter writer, PgSchema oldSchema, PgSchema newSchema, SearchPathHelper searchPathHelper) {
        if (oldSchema == null) {
            return;
        }
        for (PgIndex oldIndex : oldSchema.getIndexes()) {
            PgIndex newIndex = newSchema.getIndex(oldIndex.getName());
            if (newIndex == null) continue;
            if (oldIndex.getComment() == null && newIndex.getComment() != null || oldIndex.getComment() != null && newIndex.getComment() != null && !oldIndex.getComment().equals(newIndex.getComment())) {
                searchPathHelper.outputSearchPath(writer);
                writer.println();
                writer.print("COMMENT ON INDEX ");
                writer.print(PgDiffUtils.getQuotedName(newIndex.getName()));
                writer.print(" IS ");
                writer.print(newIndex.getComment());
                writer.println(';');
                continue;
            }
            if (oldIndex.getComment() == null || newIndex.getComment() != null) continue;
            searchPathHelper.outputSearchPath(writer);
            writer.println();
            writer.print("COMMENT ON INDEX ");
            writer.print(PgDiffUtils.getQuotedName(newIndex.getName()));
            writer.println(" IS NULL;");
        }
    }

    private PgDiffIndexes() {
    }
}

