/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent;

import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Ascii;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Preconditions;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.base.Strings;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$AtomicHelper;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$Cancellation;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$Failure;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$Listener;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$SafeAtomicHelper;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$SetFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$SynchronizedHelper;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$TrustedFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$UnsafeAtomicHelper;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.AbstractFuture$Waiter;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.FluentFuture;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.Futures;
import com.carrotsearch.ant.tasks.junit4.dependencies.com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class AbstractFuture
extends FluentFuture {
    private static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final Logger log;
    private static final AbstractFuture$AtomicHelper ATOMIC_HELPER;
    private static final Object NULL;
    private volatile @Nullable Object value;
    private volatile @Nullable AbstractFuture$Listener listeners;
    private volatile @Nullable AbstractFuture$Waiter waiters;

    /*
     * Unable to fully structure code
     */
    private void removeWaiter(AbstractFuture$Waiter var1_1) {
        var1_1.thread = null;
        block0: while (true) {
            var2_2 = null;
            var3_3 = this.waiters;
            if (var3_3 == AbstractFuture$Waiter.TOMBSTONE) {
                return;
            }
            while (var3_3 != null) {
                var4_4 = var3_3.next;
                if (var3_3.thread != null) {
                    var2_2 = var3_3;
                } else if (var2_2 != null) {
                    var2_2.next = var4_4;
                    if (var2_2.thread == null) {
                        continue block0;
                    }
                } else {
                    if (AbstractFuture.ATOMIC_HELPER.casWaiters(this, var3_3, var4_4)) ** break;
                    continue block0;
                }
                var3_3 = var4_4;
            }
            break;
        }
    }

    protected AbstractFuture() {
    }

    @CanIgnoreReturnValue
    public Object get(long l, TimeUnit timeUnit) {
        Object object;
        long l2;
        Object object2;
        long l3;
        block11: {
            l3 = timeUnit.toNanos(l);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            object2 = this.value;
            if (object2 != null & !(object2 instanceof AbstractFuture$SetFuture)) {
                return this.getDoneValue(object2);
            }
            long l4 = l2 = l3 > 0L ? System.nanoTime() + l3 : 0L;
            if (l3 >= 1000L) {
                object = this.waiters;
                if (object != AbstractFuture$Waiter.TOMBSTONE) {
                    AbstractFuture$Waiter abstractFuture$Waiter = new AbstractFuture$Waiter();
                    do {
                        abstractFuture$Waiter.setNext((AbstractFuture$Waiter)object);
                        if (!ATOMIC_HELPER.casWaiters(this, (AbstractFuture$Waiter)object, abstractFuture$Waiter)) continue;
                        do {
                            LockSupport.parkNanos(this, l3);
                            if (Thread.interrupted()) {
                                this.removeWaiter(abstractFuture$Waiter);
                                throw new InterruptedException();
                            }
                            object2 = this.value;
                            if (!(object2 != null & !(object2 instanceof AbstractFuture$SetFuture))) continue;
                            return this.getDoneValue(object2);
                        } while ((l3 = l2 - System.nanoTime()) >= 1000L);
                        this.removeWaiter(abstractFuture$Waiter);
                        break block11;
                    } while ((object = this.waiters) != AbstractFuture$Waiter.TOMBSTONE);
                }
                return this.getDoneValue(this.value);
            }
        }
        while (l3 > 0L) {
            object2 = this.value;
            if (object2 != null & !(object2 instanceof AbstractFuture$SetFuture)) {
                return this.getDoneValue(object2);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            l3 = l2 - System.nanoTime();
        }
        object = this.toString();
        if (this.isDone()) {
            throw new TimeoutException("Waited " + l + " " + Ascii.toLowerCase(timeUnit.toString()) + " but future completed as timeout expired");
        }
        throw new TimeoutException("Waited " + l + " " + Ascii.toLowerCase(timeUnit.toString()) + " for " + (String)object);
    }

    @CanIgnoreReturnValue
    public Object get() {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.value;
        if (object != null & !(object instanceof AbstractFuture$SetFuture)) {
            return this.getDoneValue(object);
        }
        AbstractFuture$Waiter abstractFuture$Waiter = this.waiters;
        if (abstractFuture$Waiter != AbstractFuture$Waiter.TOMBSTONE) {
            AbstractFuture$Waiter abstractFuture$Waiter2 = new AbstractFuture$Waiter();
            do {
                abstractFuture$Waiter2.setNext(abstractFuture$Waiter);
                if (!ATOMIC_HELPER.casWaiters(this, abstractFuture$Waiter, abstractFuture$Waiter2)) continue;
                do {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    this.removeWaiter(abstractFuture$Waiter2);
                    throw new InterruptedException();
                } while (!((object = this.value) != null & !(object instanceof AbstractFuture$SetFuture)));
                return this.getDoneValue(object);
            } while ((abstractFuture$Waiter = this.waiters) != AbstractFuture$Waiter.TOMBSTONE);
        }
        return this.getDoneValue(this.value);
    }

    private Object getDoneValue(Object object) {
        if (object instanceof AbstractFuture$Cancellation) {
            throw AbstractFuture.cancellationExceptionWithCause("Task was cancelled.", ((AbstractFuture$Cancellation)object).cause);
        }
        if (object instanceof AbstractFuture$Failure) {
            throw new ExecutionException(((AbstractFuture$Failure)object).exception);
        }
        if (object == NULL) {
            return null;
        }
        Object object2 = object;
        return object2;
    }

    @Override
    public boolean isDone() {
        Object object = this.value;
        return object != null & !(object instanceof AbstractFuture$SetFuture);
    }

    @Override
    public boolean isCancelled() {
        Object object = this.value;
        return object instanceof AbstractFuture$Cancellation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @CanIgnoreReturnValue
    public boolean cancel(boolean bl) {
        Object object = this.value;
        boolean bl2 = false;
        if (!(object == null | object instanceof AbstractFuture$SetFuture)) return bl2;
        AbstractFuture$Cancellation abstractFuture$Cancellation = GENERATE_CANCELLATION_CAUSES ? new AbstractFuture$Cancellation(bl, new CancellationException("Future.cancel() was called.")) : (bl ? AbstractFuture$Cancellation.CAUSELESS_INTERRUPTED : AbstractFuture$Cancellation.CAUSELESS_CANCELLED);
        AbstractFuture abstractFuture = this;
        while (true) {
            if (ATOMIC_HELPER.casValue(abstractFuture, object, abstractFuture$Cancellation)) {
                bl2 = true;
                if (bl) {
                    abstractFuture.interruptTask();
                }
                AbstractFuture.complete(abstractFuture);
                if (!(object instanceof AbstractFuture$SetFuture)) return bl2;
                ListenableFuture listenableFuture = ((AbstractFuture$SetFuture)object).future;
                if (listenableFuture instanceof AbstractFuture$TrustedFuture) {
                    AbstractFuture abstractFuture2 = (AbstractFuture)listenableFuture;
                    object = abstractFuture2.value;
                    if (!(object == null | object instanceof AbstractFuture$SetFuture)) return bl2;
                    abstractFuture = abstractFuture2;
                    continue;
                }
                listenableFuture.cancel(bl);
                return bl2;
            }
            object = abstractFuture.value;
            if (!(object instanceof AbstractFuture$SetFuture)) return bl2;
        }
    }

    protected void interruptTask() {
    }

    protected final boolean wasInterrupted() {
        Object object = this.value;
        return object instanceof AbstractFuture$Cancellation && ((AbstractFuture$Cancellation)object).wasInterrupted;
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        Preconditions.checkNotNull(runnable, "Runnable was null.");
        Preconditions.checkNotNull(executor, "Executor was null.");
        AbstractFuture$Listener abstractFuture$Listener = this.listeners;
        if (abstractFuture$Listener != AbstractFuture$Listener.TOMBSTONE) {
            AbstractFuture$Listener abstractFuture$Listener2 = new AbstractFuture$Listener(runnable, executor);
            do {
                abstractFuture$Listener2.next = abstractFuture$Listener;
                if (!ATOMIC_HELPER.casListeners(this, abstractFuture$Listener, abstractFuture$Listener2)) continue;
                return;
            } while ((abstractFuture$Listener = this.listeners) != AbstractFuture$Listener.TOMBSTONE);
        }
        AbstractFuture.executeListener(runnable, executor);
    }

    @CanIgnoreReturnValue
    protected boolean set(@Nullable Object object) {
        Object object2;
        Object object3 = object2 = object == null ? NULL : object;
        if (ATOMIC_HELPER.casValue(this, null, object2)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    @CanIgnoreReturnValue
    protected boolean setException(Throwable throwable) {
        AbstractFuture$Failure abstractFuture$Failure = new AbstractFuture$Failure((Throwable)Preconditions.checkNotNull(throwable));
        if (ATOMIC_HELPER.casValue(this, null, abstractFuture$Failure)) {
            AbstractFuture.complete(this);
            return true;
        }
        return false;
    }

    private static Object getFutureValue(ListenableFuture listenableFuture) {
        Object object;
        if (listenableFuture instanceof AbstractFuture$TrustedFuture) {
            Object object2 = ((AbstractFuture)listenableFuture).value;
            if (object2 instanceof AbstractFuture$Cancellation) {
                AbstractFuture$Cancellation abstractFuture$Cancellation = (AbstractFuture$Cancellation)object2;
                if (abstractFuture$Cancellation.wasInterrupted) {
                    object2 = abstractFuture$Cancellation.cause != null ? new AbstractFuture$Cancellation(false, abstractFuture$Cancellation.cause) : AbstractFuture$Cancellation.CAUSELESS_CANCELLED;
                }
            }
            return object2;
        }
        try {
            Object object3 = Futures.getDone(listenableFuture);
            object = object3 == null ? NULL : object3;
        }
        catch (ExecutionException executionException) {
            object = new AbstractFuture$Failure(executionException.getCause());
        }
        catch (CancellationException cancellationException) {
            object = new AbstractFuture$Cancellation(false, cancellationException);
        }
        catch (Throwable throwable) {
            object = new AbstractFuture$Failure(throwable);
        }
        return object;
    }

    private static void complete(AbstractFuture abstractFuture) {
        AbstractFuture$Listener abstractFuture$Listener = null;
        block0: while (true) {
            abstractFuture.releaseWaiters();
            abstractFuture.afterDone();
            abstractFuture$Listener = abstractFuture.clearListeners(abstractFuture$Listener);
            abstractFuture = null;
            while (abstractFuture$Listener != null) {
                AbstractFuture$Listener abstractFuture$Listener2 = abstractFuture$Listener;
                abstractFuture$Listener = abstractFuture$Listener.next;
                Runnable runnable = abstractFuture$Listener2.task;
                if (runnable instanceof AbstractFuture$SetFuture) {
                    Object object;
                    AbstractFuture$SetFuture abstractFuture$SetFuture = (AbstractFuture$SetFuture)runnable;
                    abstractFuture = abstractFuture$SetFuture.owner;
                    if (abstractFuture.value != abstractFuture$SetFuture || !ATOMIC_HELPER.casValue(abstractFuture, abstractFuture$SetFuture, object = AbstractFuture.getFutureValue(abstractFuture$SetFuture.future))) continue;
                    continue block0;
                }
                AbstractFuture.executeListener(runnable, abstractFuture$Listener2.executor);
            }
            break;
        }
    }

    @ForOverride
    protected void afterDone() {
    }

    final Throwable trustedGetException() {
        return ((AbstractFuture$Failure)this.value).exception;
    }

    final void maybePropagateCancellationTo(@Nullable Future future) {
        if (future != null & this.isCancelled()) {
            future.cancel(this.wasInterrupted());
        }
    }

    private void releaseWaiters() {
        AbstractFuture$Waiter abstractFuture$Waiter;
        while (!ATOMIC_HELPER.casWaiters(this, abstractFuture$Waiter = this.waiters, AbstractFuture$Waiter.TOMBSTONE)) {
        }
        AbstractFuture$Waiter abstractFuture$Waiter2 = abstractFuture$Waiter;
        while (abstractFuture$Waiter2 != null) {
            abstractFuture$Waiter2.unpark();
            abstractFuture$Waiter2 = abstractFuture$Waiter2.next;
        }
    }

    private AbstractFuture$Listener clearListeners(AbstractFuture$Listener abstractFuture$Listener) {
        AbstractFuture$Listener abstractFuture$Listener2;
        while (!ATOMIC_HELPER.casListeners(this, abstractFuture$Listener2 = this.listeners, AbstractFuture$Listener.TOMBSTONE)) {
        }
        AbstractFuture$Listener abstractFuture$Listener3 = abstractFuture$Listener;
        while (abstractFuture$Listener2 != null) {
            AbstractFuture$Listener abstractFuture$Listener4 = abstractFuture$Listener2;
            abstractFuture$Listener2 = abstractFuture$Listener2.next;
            abstractFuture$Listener4.next = abstractFuture$Listener3;
            abstractFuture$Listener3 = abstractFuture$Listener4;
        }
        return abstractFuture$Listener3;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(super.toString()).append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
        } else if (this.isDone()) {
            this.addDoneString(stringBuilder);
        } else {
            String string;
            try {
                string = this.pendingToString();
            }
            catch (RuntimeException runtimeException) {
                string = "Exception thrown from implementation: " + runtimeException.getClass();
            }
            if (!Strings.isNullOrEmpty(string)) {
                stringBuilder.append("PENDING, info=[").append(string).append("]");
            } else if (this.isDone()) {
                this.addDoneString(stringBuilder);
            } else {
                stringBuilder.append("PENDING");
            }
        }
        return stringBuilder.append("]").toString();
    }

    protected @Nullable String pendingToString() {
        Object object = this.value;
        if (object instanceof AbstractFuture$SetFuture) {
            return "setFuture=[" + this.userObjectToString(((AbstractFuture$SetFuture)object).future) + "]";
        }
        if (this instanceof ScheduledFuture) {
            return "remaining delay=[" + ((ScheduledFuture)((Object)this)).getDelay(TimeUnit.MILLISECONDS) + " ms]";
        }
        return null;
    }

    private void addDoneString(StringBuilder stringBuilder) {
        try {
            Object object = Futures.getDone(this);
            stringBuilder.append("SUCCESS, result=[").append(this.userObjectToString(object)).append("]");
        }
        catch (ExecutionException executionException) {
            stringBuilder.append("FAILURE, cause=[").append(executionException.getCause()).append("]");
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("UNKNOWN, cause=[").append(runtimeException.getClass()).append(" thrown from get()]");
        }
    }

    private String userObjectToString(Object object) {
        if (object == this) {
            return "this future";
        }
        return String.valueOf(object);
    }

    private static void executeListener(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
        }
        catch (RuntimeException runtimeException) {
            log.log(Level.SEVERE, "RuntimeException while executing runnable " + runnable + " with executor " + executor, runtimeException);
        }
    }

    private static CancellationException cancellationExceptionWithCause(@Nullable String string, @Nullable Throwable throwable) {
        CancellationException cancellationException = new CancellationException(string);
        cancellationException.initCause(throwable);
        return cancellationException;
    }

    static /* synthetic */ AbstractFuture$AtomicHelper access$200() {
        return ATOMIC_HELPER;
    }

    static /* synthetic */ boolean access$300() {
        return GENERATE_CANCELLATION_CAUSES;
    }

    static /* synthetic */ Object access$400(AbstractFuture abstractFuture) {
        return abstractFuture.value;
    }

    static /* synthetic */ Object access$500(ListenableFuture listenableFuture) {
        return AbstractFuture.getFutureValue(listenableFuture);
    }

    static /* synthetic */ void access$600(AbstractFuture abstractFuture) {
        AbstractFuture.complete(abstractFuture);
    }

    static /* synthetic */ AbstractFuture$Waiter access$800(AbstractFuture abstractFuture) {
        return abstractFuture.waiters;
    }

    static /* synthetic */ AbstractFuture$Waiter access$802(AbstractFuture abstractFuture, AbstractFuture$Waiter abstractFuture$Waiter) {
        abstractFuture.waiters = abstractFuture$Waiter;
        return abstractFuture.waiters;
    }

    static /* synthetic */ AbstractFuture$Listener access$900(AbstractFuture abstractFuture) {
        return abstractFuture.listeners;
    }

    static /* synthetic */ AbstractFuture$Listener access$902(AbstractFuture abstractFuture, AbstractFuture$Listener abstractFuture$Listener) {
        abstractFuture.listeners = abstractFuture$Listener;
        return abstractFuture.listeners;
    }

    static /* synthetic */ Object access$402(AbstractFuture abstractFuture, Object object) {
        abstractFuture.value = object;
        return abstractFuture.value;
    }

    static {
        AbstractFuture$AtomicHelper abstractFuture$AtomicHelper;
        GENERATE_CANCELLATION_CAUSES = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        log = Logger.getLogger(AbstractFuture.class.getName());
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            abstractFuture$AtomicHelper = new AbstractFuture$UnsafeAtomicHelper(null);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            try {
                abstractFuture$AtomicHelper = new AbstractFuture$SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(AbstractFuture$Waiter.class, Thread.class, "thread"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture$Waiter.class, AbstractFuture$Waiter.class, "next"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, AbstractFuture$Waiter.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, AbstractFuture$Listener.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(AbstractFuture.class, Object.class, "value"));
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                abstractFuture$AtomicHelper = new AbstractFuture$SynchronizedHelper(null);
            }
        }
        ATOMIC_HELPER = abstractFuture$AtomicHelper;
        Class<LockSupport> clazz = LockSupport.class;
        if (throwable2 != null) {
            log.log(Level.SEVERE, "UnsafeAtomicHelper is broken!", throwable);
            log.log(Level.SEVERE, "SafeAtomicHelper is broken!", throwable2);
        }
        NULL = new Object();
    }
}

