/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.utilities;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.ui.ac;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import org.adtpro.gui.Gui;
import org.adtpro.utilities.Log;

public class VDiskPersister {
    private Gui _parent;
    Disk _disk1 = null;
    Disk _disk2 = null;
    Path _disk1_filePath;
    Path _disk2_filePath;
    FileTime _disk1_modifiedTime;
    FileTime _disk2_modifiedTime;
    private static VDiskPersister _theSingleton = null;

    private VDiskPersister(Gui gui) {
        this._parent = gui;
        this.refreshDisks(0);
    }

    private void refreshDisks(int n) {
        BasicFileAttributes basicFileAttributes;
        BasicFileAttributes basicFileAttributes2;
        String string = this._parent.getWorkingDirectory();
        if (n == 0 || n == 1) {
            try {
                this._disk1 = new Disk(string + "Virtual.po");
                this._disk1_filePath = Paths.get(string + "Virtual.po", new String[0]);
                basicFileAttributes2 = Files.readAttributes(this._disk1_filePath, BasicFileAttributes.class, new LinkOption[0]);
                this._disk1_modifiedTime = basicFileAttributes2.lastModifiedTime();
            }
            catch (IOException iOException) {
                Log.println(false, "Unable to find Virtual.po in current working directory; creating a new one.");
                try {
                    ac.createProDisk((String)(string + "Virtual.po"), (String)"Hosted.VDrive1", (int)819200);
                    this._disk1 = new Disk(string + "Virtual.po");
                    this._disk1_filePath = Paths.get(string + "Virtual.po", new String[0]);
                    basicFileAttributes = Files.readAttributes(this._disk1_filePath, BasicFileAttributes.class, new LinkOption[0]);
                    this._disk1_modifiedTime = basicFileAttributes.lastModifiedTime();
                }
                catch (IOException iOException2) {
                    iOException2.printStackTrace();
                }
            }
        }
        if (n == 0 || n == 2) {
            try {
                this._disk2 = new Disk(string + "Virtual2.po");
                this._disk2_filePath = Paths.get(string + "Virtual2.po", new String[0]);
                basicFileAttributes2 = Files.readAttributes(this._disk2_filePath, BasicFileAttributes.class, new LinkOption[0]);
                this._disk2_modifiedTime = basicFileAttributes2.lastModifiedTime();
            }
            catch (IOException iOException) {
                Log.println(false, "Unable to find Virtual2.po in current working directory; creating a new one.");
                try {
                    ac.createProDisk((String)(string + "Virtual2.po"), (String)"Hosted.VDrive2", (int)819200);
                    this._disk2 = new Disk(string + "Virtual2.po");
                    this._disk2_filePath = Paths.get(string + "Virtual2.po", new String[0]);
                    basicFileAttributes = Files.readAttributes(this._disk2_filePath, BasicFileAttributes.class, new LinkOption[0]);
                    this._disk2_modifiedTime = basicFileAttributes.lastModifiedTime();
                }
                catch (IOException iOException3) {
                    iOException3.printStackTrace();
                }
            }
        }
    }

    public byte[] readBlock(int n, int n2) throws IOException {
        if (n == 1) {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(this._disk1_filePath, BasicFileAttributes.class, new LinkOption[0]);
            FileTime fileTime = basicFileAttributes.lastModifiedTime();
            if (this._disk1_modifiedTime != fileTime) {
                Log.println(false, "New VDisk 1 data found - refreshing");
                this.refreshDisks(n);
            }
            return this._disk1.readBlock(n2);
        }
        BasicFileAttributes basicFileAttributes = Files.readAttributes(this._disk2_filePath, BasicFileAttributes.class, new LinkOption[0]);
        FileTime fileTime = basicFileAttributes.lastModifiedTime();
        if (this._disk2_modifiedTime != fileTime) {
            Log.println(false, "New VDisk 2 data found - refreshing");
            this.refreshDisks(n);
        }
        return this._disk2.readBlock(n2);
    }

    public void writeBlock(int n, int n2, byte[] byArray) throws IOException {
        if (n == 1) {
            this._disk1.writeBlock(n2, byArray);
            this._disk1.save();
            BasicFileAttributes basicFileAttributes = Files.readAttributes(this._disk1_filePath, BasicFileAttributes.class, new LinkOption[0]);
            this._disk1_modifiedTime = basicFileAttributes.lastModifiedTime();
        } else {
            this._disk2.writeBlock(n2, byArray);
            this._disk2.save();
            BasicFileAttributes basicFileAttributes = Files.readAttributes(this._disk2_filePath, BasicFileAttributes.class, new LinkOption[0]);
            this._disk2_modifiedTime = basicFileAttributes.lastModifiedTime();
        }
    }

    public static VDiskPersister getSingleton(Gui gui) {
        if (null == _theSingleton) {
            VDiskPersister.allocateSingleton(gui);
        }
        return _theSingleton;
    }

    private static synchronized void allocateSingleton(Gui gui) {
        if (null == _theSingleton) {
            _theSingleton = new VDiskPersister(gui);
        }
    }
}

