/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.utilities;

public class UnsignedByte {
    private UnsignedByte() {
    }

    public static int intValue(byte by) {
        if (by >= 0) {
            return by;
        }
        return 256 + by;
    }

    public static int intValue(byte by, byte by2) {
        return UnsignedByte.intValue(by2) * 256 + UnsignedByte.intValue(by);
    }

    public static byte loByte(int n) {
        return (byte)(n & 0xFF);
    }

    public static byte hiByte(int n) {
        return (byte)((n & 0xFF00) >> 8);
    }

    public static byte loByte(long l) {
        return UnsignedByte.loByte((int)l);
    }

    public static byte hiByte(long l) {
        return UnsignedByte.hiByte((int)l);
    }

    public static String toString(byte by) {
        int n = UnsignedByte.intValue(by);
        char c = n / 16 < 10 ? (char)(n / 16 + 48) : (char)(n / 16 + 55);
        char c2 = n % 16 < 10 ? (char)(n % 16 + 48) : (char)(n % 16 + 55);
        return "" + c + "" + c2;
    }

    public static String toShortString(byte by) {
        int n = UnsignedByte.intValue(by);
        if (n < 16) {
            char c = n % 16 < 10 ? (char)(n % 16 + 48) : (char)(n % 16 + 55);
            return "" + c;
        }
        return UnsignedByte.toString(by);
    }
}

