/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.transport.audio;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.adtpro.utilities.Log;

public class BytesToWav {
    public static final int SAMPLE_FREQ = 44100;

    public static byte[] encode(byte[] byArray, int n) {
        return BytesToWav.encode(byArray, n, 300);
    }

    public static byte[] encode(byte[] byArray, int n, int n2) {
        byte by = -1;
        Log.println(false, "BytesToWav.encode() entry, encoding " + n + " bytes.");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0x100000);
        BytesToWav.leaderTone(byteArrayOutputStream, 44100, n2, 100);
        BytesToWav.onePeriod(byteArrayOutputStream, 2200, 44100, 100, 0.0);
        by = BytesToWav.encodeData(byteArrayOutputStream, byArray, n, by, 44100, 100);
        BytesToWav.encodeByte(byteArrayOutputStream, by, 44100, 100, 0.0);
        BytesToWav.onePeriod(byteArrayOutputStream, 200, 44100, 100, 0.0);
        BytesToWav.silence(byteArrayOutputStream, 100);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(44 + byteArrayOutputStream.size());
        try {
            byteArrayOutputStream2.write(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            Log.printStackTrace(iOException);
        }
        return byteArrayOutputStream2.toByteArray();
    }

    static void leaderTone(ByteArrayOutputStream byteArrayOutputStream, int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            BytesToWav.onePeriod(byteArrayOutputStream, 770, n, n3, 0.0);
        }
    }

    static void silence(ByteArrayOutputStream byteArrayOutputStream, int n) {
        for (int i = 0; i < 15000; ++i) {
            byteArrayOutputStream.write(0);
        }
    }

    static double onePeriod(ByteArrayOutputStream byteArrayOutputStream, int n, int n2, int n3, double d) {
        int n4;
        int n5 = n2 / (2 * n);
        double d2 = d + ((double)n2 / (double)(2 * n) - (double)n5) / 20.0;
        int n6 = 1;
        for (n4 = 0; n4 < n5; ++n4) {
            byteArrayOutputStream.write(n6);
        }
        if (d2 > 1.0) {
            byteArrayOutputStream.write(n6);
        }
        n6 = -1;
        for (n4 = 0; n4 < n5; ++n4) {
            byteArrayOutputStream.write(n6);
        }
        if (d2 > 1.0) {
            byteArrayOutputStream.write(n6);
            d2 -= 1.0;
        }
        return d2;
    }

    public static byte encodeData(ByteArrayOutputStream byteArrayOutputStream, byte[] byArray, int n, byte by, int n2, int n3) {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            by = (byte)(byArray[i] ^ by);
            d = BytesToWav.encodeByte(byteArrayOutputStream, byArray[i], n2, n3, d);
        }
        return by;
    }

    static double encodeByte(ByteArrayOutputStream byteArrayOutputStream, byte by, int n, int n2, double d) {
        double d2 = d;
        for (int i = 0; i < 8; ++i) {
            d2 = ((long)by & 0x80L) == 128L ? BytesToWav.onePeriod(byteArrayOutputStream, 1000, n, n2, d2) : BytesToWav.onePeriod(byteArrayOutputStream, 2000, n, n2, d2);
            by = (byte)((long)(by << 1) & 0xFFL);
        }
        return d2;
    }
}

