/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.adtpro.ADTProperties;
import org.adtpro.gui.FrameUtils;
import org.adtpro.gui.GridBagUtil;
import org.adtpro.gui.Gui;
import org.adtpro.resources.Messages;
import org.adtpro.transport.SerialTransport;
import org.adtpro.utilities.Log;

public class SerialConfig
extends JDialog
implements ActionListener {
    private static SerialConfig _theSingleton = null;
    JTabbedPane _tabbedPane = new JTabbedPane();
    private static final long serialVersionUID = 1L;
    private JLabel labelComPort;
    private JComboBox comboComPort;
    private JLabel labelSpeed;
    private JComboBox comboSpeed;
    private JLabel labelBootstrapPacing;
    private JComboBox comboBootstrapPacing;
    private JLabel labelBootstrapSpeed;
    private JComboBox comboBootstrapSpeed;
    private JCheckBox iicCheckBox;
    private ADTProperties _properties = null;
    private int exitStatus = 0;
    public JButton okButton = new JButton(Messages.getString("Gui.Ok"));
    public JButton cancelButton = new JButton(Messages.getString("Gui.Cancel"));
    public static Gui _parent;
    private KeyAdapter myKeyListener = new MyKeyAdapter();
    public static final int CANCEL = 0;
    public static final int OK = 1;

    private SerialConfig() {
        this.setTitle(Messages.getString("Gui.SerialConfig"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        GridBagUtil.constrain(jPanel, this.okButton, 1, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        GridBagUtil.constrain(jPanel, this.cancelButton, 2, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel3.setLayout(new GridBagLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this._tabbedPane, "Center");
        this.getContentPane().add((Component)jPanel, "South");
        Log.getSingleton();
        this.comboComPort = new JComboBox();
        this.enumeratePorts();
        this.comboSpeed = new JComboBox();
        this.comboSpeed.addItem("19200");
        this.comboSpeed.addItem("115200");
        this.comboBootstrapSpeed = new JComboBox();
        this.comboBootstrapSpeed.addItem("2400");
        this.comboBootstrapSpeed.addItem("9600");
        this.comboBootstrapPacing = new JComboBox();
        this.comboBootstrapPacing.addItem("15");
        this.comboBootstrapPacing.addItem("25");
        this.comboBootstrapPacing.addItem("50");
        this.comboBootstrapPacing.addItem("75");
        this.comboBootstrapPacing.addItem("100");
        this.comboBootstrapPacing.addItem("150");
        this.comboBootstrapPacing.addItem("250");
        this.comboBootstrapPacing.addItem("500");
        this.comboBootstrapPacing.addItem("1000");
        this.iicCheckBox = new JCheckBox(Messages.getString("Gui.IIc"));
        this.labelComPort = new JLabel(Messages.getString("Gui.Port"), 2);
        this.labelSpeed = new JLabel(Messages.getString("Gui.Speed"), 2);
        this.labelBootstrapSpeed = new JLabel(Messages.getString("Gui.BootstrapSpeed"), 2);
        this.labelBootstrapPacing = new JLabel(Messages.getString("Gui.BootstrapPacing"), 2);
        GridBagUtil.constrain(jPanel2, this.labelComPort, 1, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 0);
        GridBagUtil.constrain(jPanel2, this.comboComPort, 1, 2, 1, 1, 2, 17, 0.0, 0.0, 0, 5, 5, 5);
        GridBagUtil.constrain(jPanel2, this.labelSpeed, 2, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 0);
        GridBagUtil.constrain(jPanel2, this.comboSpeed, 2, 2, 1, 1, 2, 17, 1.0, 0.0, 0, 5, 5, 5);
        GridBagUtil.constrain(jPanel2, this.iicCheckBox, 1, 3, 2, 1, 2, 17, 1.0, 0.0, 0, 0, 5, 5);
        GridBagUtil.constrain(jPanel3, this.labelBootstrapPacing, 1, 4, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 0, 5);
        GridBagUtil.constrain(jPanel3, this.comboBootstrapPacing, 1, 5, 1, 1, 2, 17, 1.0, 0.0, 0, 5, 5, 5);
        GridBagUtil.constrain(jPanel3, this.labelBootstrapSpeed, 2, 4, 1, 1, 0, 17, 0.0, 0.0, 0, 5, 0, 5);
        GridBagUtil.constrain(jPanel3, this.comboBootstrapSpeed, 2, 5, 1, 1, 2, 17, 1.0, 0.0, 0, 5, 5, 5);
        this._tabbedPane.addTab(Messages.getString("Gui.ConfigSerialTab"), null, jPanel2, Messages.getString("Gui.ConfigSerialTab.Help"));
        this._tabbedPane.addTab(Messages.getString("Gui.ConfigBootstrapTab"), null, jPanel3, Messages.getString("Gui.ConfigBootstrapTab.Help"));
        this._tabbedPane.addKeyListener(this.myKeyListener);
        this.comboSpeed.addKeyListener(this.myKeyListener);
        this.comboComPort.addKeyListener(this.myKeyListener);
        this.comboBootstrapPacing.addKeyListener(this.myKeyListener);
        this.comboBootstrapSpeed.addKeyListener(this.myKeyListener);
        this.cancelButton.addKeyListener(this.myKeyListener);
        this.okButton.addKeyListener(this.myKeyListener);
        this.iicCheckBox.addKeyListener(this.myKeyListener);
        this.pack();
        this.setBounds(FrameUtils.center(this.getSize()));
        this.okButton.requestFocus();
        this.getRootPane().setDefaultButton(this.okButton);
        Log.println(false, "SerialConfig Constructor exit.");
    }

    public static SerialConfig getSingleton(Gui gui) {
        _parent = gui;
        if (null == _theSingleton) {
            SerialConfig.allocateSingleton(gui);
        }
        return _theSingleton;
    }

    private static synchronized void allocateSingleton(Gui gui) {
        if (null == _theSingleton) {
            _theSingleton = new SerialConfig();
        }
    }

    public static void setProperties(ADTProperties aDTProperties) {
        SerialConfig._theSingleton._properties = aDTProperties;
        SerialConfig._theSingleton.comboSpeed.setSelectedItem(aDTProperties.getProperty("CommPortSpeed", "115200"));
        SerialConfig._theSingleton.iicCheckBox.setSelected(aDTProperties.getProperty("HardwareHandshaking", "false").compareTo("true") == 0);
        SerialConfig._theSingleton.comboComPort.setSelectedItem(aDTProperties.getProperty("CommPort", "COM1"));
        SerialConfig._theSingleton.comboBootstrapSpeed.setSelectedItem(aDTProperties.getProperty("CommPortBootstrapSpeed", "9600"));
        SerialConfig._theSingleton.comboBootstrapPacing.setSelectedItem(aDTProperties.getProperty("CommPortBootstrapPacing", "250"));
    }

    public static String getPort() {
        return (String)SerialConfig._theSingleton.comboComPort.getSelectedItem();
    }

    public static String getSpeed() {
        return (String)SerialConfig._theSingleton.comboSpeed.getSelectedItem();
    }

    public static boolean getHardware() {
        return SerialConfig._theSingleton.iicCheckBox.isSelected();
    }

    public static void showSingleton(Gui gui, int n) {
        Log.println(false, "SerialConfig.showSingleton() showing tab " + n + ".");
        _theSingleton.enumeratePorts();
        _theSingleton.setModal(true);
        _theSingleton.setBounds(FrameUtils.center(_theSingleton.getSize(), gui.getBounds()));
        SerialConfig._theSingleton._tabbedPane.setSelectedIndex(n);
        _theSingleton.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Log.println(false, "SerialConfig.actionPerformed() entry, responding to " + actionEvent.getActionCommand());
        if (actionEvent.getSource() == this.okButton) {
            String string = (String)this.comboComPort.getSelectedItem();
            if (string != null) {
                this._properties.setProperty("CommPort", string);
            } else {
                JOptionPane.showMessageDialog(this, Messages.getString("Gui.NoRXTXDialogText"), Messages.getString("Gui.NoRXTXDialogTitle"), 0);
                _parent.setSerialAvailable(false);
            }
            this._properties.setProperty("CommPortSpeed", (String)this.comboSpeed.getSelectedItem());
            this._properties.setProperty("CommPortBootstrapPacing", (String)this.comboBootstrapPacing.getSelectedItem());
            this._properties.setProperty("CommPortBootstrapSpeed", (String)this.comboBootstrapSpeed.getSelectedItem());
            if (this.iicCheckBox.isSelected()) {
                this._properties.setProperty("HardwareHandshaking", "true");
            } else {
                this._properties.setProperty("HardwareHandshaking", "false");
            }
            this._properties.save();
            SerialConfig._theSingleton.exitStatus = 1;
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton) {
            SerialConfig._theSingleton.comboSpeed.setSelectedItem(this._properties.getProperty("CommPortSpeed", "115200"));
            SerialConfig._theSingleton.iicCheckBox.setSelected(this._properties.getProperty("HardwareHandshaking", "false").compareTo("true") == 0);
            SerialConfig._theSingleton.comboComPort.setSelectedItem(this._properties.getProperty("CommPort", "COM1"));
            SerialConfig._theSingleton.exitStatus = 0;
            this.setVisible(false);
        }
        Log.println(false, "SerialConfig.actionPerformed() exit.");
    }

    public void enumeratePorts() {
        Log.println(false, "SerialConfig.enumeratePorts() entry.");
        String string = (String)this.comboComPort.getSelectedItem();
        this.comboComPort.removeAllItems();
        Log.println(false, "SerialConfig.enumeratePorts() about to attempt to instantiate serial ports.");
        String[] stringArray = SerialTransport.getPortNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2 == null || string2.startsWith("LPT")) continue;
            this.comboComPort.addItem(string2);
        }
        _parent.setSerialAvailable(true);
        if (string != null) {
            this.comboComPort.setSelectedItem(string);
        }
        Log.println(false, "SerialConfig.enumeratePorts() completed instantiating serial ports.");
        Log.println(false, "SerialConfig.enumeratePorts() exit.");
    }

    public int getExitStatus() {
        return SerialConfig._theSingleton.exitStatus;
    }

    class MyKeyAdapter
    extends KeyAdapter {
        MyKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                SerialConfig.this.cancelButton.doClick();
            }
        }
    }
}

