/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import org.adtpro.ADTProperties;
import org.adtpro.CommsThread;
import org.adtpro.gui.AudioConfig;
import org.adtpro.gui.FrameUtils;
import org.adtpro.gui.GridBagUtil;
import org.adtpro.gui.SerialConfig;
import org.adtpro.resources.Messages;
import org.adtpro.transport.ATransport;
import org.adtpro.transport.AudioTransport;
import org.adtpro.transport.SerialIPTransport;
import org.adtpro.transport.SerialTransport;
import org.adtpro.transport.UDPTransport;
import org.adtpro.utilities.BareBonesBrowserLaunch;
import org.adtpro.utilities.Log;
import org.adtpro.utilities.StringUtilities;

public final class Gui
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    Gui _parent;
    private CommsThread _commsThread;
    private String _workingDirectory = this.getWorkingDirectory();
    private JProgressBar progressBar;
    private JLabel labelMainProgress;
    private JLabel labelSubProgress;
    public ADTProperties _properties = new ADTProperties(Messages.getString("PropertiesFileName"));
    boolean _isSerialAvailable = false;
    JMenu menuBootstrap;
    JMenuItem _dosAction2 = null;
    JMenuItem _sosAction = null;
    JMenuItem _speedibootAction = null;
    JMenuItem _vsdrivebootAction = null;
    JMenuItem _serialConfigBootstrapAction = null;
    JCheckBoxMenuItem _protoCompatMenuItem = null;
    JCheckBoxMenuItem _traceMenuItem = null;
    JRadioButton _serialButton = null;
    JRadioButton _ethernetButton = null;
    JRadioButton _audioButton = null;
    JRadioButton _disconnectButton = null;
    JRadioButton _previousButton = null;

    public Gui(String[] stringArray) {
        Object object;
        Log.getSingleton().setTrace(this._properties.getProperty("TraceEnabled", "false").compareTo("true") == 0);
        Log.println(false, "Gui Constructor entry.");
        this.addWindowListener(new WindowCloseMonitor());
        this.setTitle(Messages.getString("Gui.Title") + " " + Messages.getString("Version.Number"));
        try {
            this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/org/adtpro/resources/ADTPro.png")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string = this._properties.getProperty("WorkingDirectory", "disks");
        if (string != null) {
            this.setWorkingDirectory(string);
        }
        JMenuBar jMenuBar = new JMenuBar();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        JMenu jMenu = new JMenu(Messages.getString("Gui.File"));
        MenuAction menuAction = new MenuAction(Messages.getString("Gui.SerialConfig"));
        jMenu.add(menuAction);
        MenuAction menuAction2 = new MenuAction(Messages.getString("Gui.CD"));
        jMenu.add(menuAction2);
        this._traceMenuItem = new JCheckBoxMenuItem(Messages.getString("Gui.Trace"));
        jMenu.add(this._traceMenuItem);
        this._traceMenuItem.addActionListener(this);
        MenuAction menuAction3 = new MenuAction(Messages.getString("Gui.Quit"));
        jMenu.add(menuAction3);
        jMenuBar.add(jMenu);
        this.menuBootstrap = new JMenu(Messages.getString("Gui.Bootstrap"));
        JMenu jMenu2 = new JMenu(Messages.getString("Gui.BootstrapProDOS"));
        JMenu jMenu3 = new JMenu(Messages.getString("Gui.BootstrapDOS"));
        MenuAction menuAction4 = new MenuAction(Messages.getString("Gui.BS.ProDOSFast"));
        this._speedibootAction = jMenu2.add(menuAction4);
        this._speedibootAction.setEnabled(true);
        MenuAction menuAction5 = new MenuAction(Messages.getString("Gui.BS.ProDOSVSDrive"));
        this._vsdrivebootAction = jMenu2.add(menuAction5);
        this._vsdrivebootAction.setEnabled(true);
        jMenu2.addSeparator();
        MenuAction menuAction6 = new MenuAction(Messages.getString("Gui.BS.ProDOS"));
        jMenu2.add(menuAction6);
        MenuAction menuAction7 = new MenuAction(Messages.getString("Gui.BS.DOS"));
        jMenu3.add(menuAction7);
        MenuAction menuAction8 = new MenuAction(Messages.getString("Gui.BS.DOS2"));
        this._dosAction2 = jMenu3.add(menuAction8);
        this._dosAction2.setEnabled(true);
        MenuAction menuAction9 = new MenuAction(Messages.getString("Gui.BS.ADT"));
        jMenu3.add(menuAction9);
        MenuAction menuAction10 = new MenuAction(Messages.getString("Gui.BS.ADTPro"));
        jMenu2.add(menuAction10);
        MenuAction menuAction11 = new MenuAction(Messages.getString("Gui.BS.ADTProAudio"));
        jMenu2.add(menuAction11);
        MenuAction menuAction12 = new MenuAction(Messages.getString("Gui.BS.ADTProEthernet"));
        jMenu2.add(menuAction12);
        jMenuBar.add(this.menuBootstrap);
        this.menuBootstrap.add(jMenu2);
        this.menuBootstrap.add(jMenu3);
        MenuAction menuAction13 = new MenuAction(Messages.getString("Gui.BS.SOS"));
        this._sosAction = this.menuBootstrap.add(menuAction13);
        MenuAction menuAction14 = new MenuAction(Messages.getString("Gui.SerialConfigBootstrap"));
        this._serialConfigBootstrapAction = jMenu2.add(menuAction14);
        this._serialConfigBootstrapAction.setEnabled(true);
        this.menuBootstrap.add(this._serialConfigBootstrapAction);
        this.menuBootstrap.setEnabled(false);
        JMenu jMenu4 = new JMenu(Messages.getString("Gui.Help"));
        MenuAction menuAction15 = new MenuAction(Messages.getString("Gui.Website"));
        jMenu4.add(menuAction15);
        MenuAction menuAction16 = new MenuAction(Messages.getString("Gui.About"));
        jMenu4.add(menuAction16);
        jMenuBar.add(jMenu4);
        this.setJMenuBar(jMenuBar);
        this._traceMenuItem.setSelected(this._properties.getProperty("TraceEnabled", "false").compareTo("true") == 0);
        this.labelMainProgress = new JLabel(Messages.getString("Gui.Quiesced"));
        this.labelSubProgress = new JLabel(Messages.getString("Gui.Disconnected"));
        this.progressBar = new JProgressBar();
        this.progressBar.setString("");
        this.progressBar.setMaximum(280);
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this._serialButton = new JRadioButton(Messages.getString("Gui.SerialButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/org/adtpro/resources/serialDeselected.png"))));
        this._serialButton.setHorizontalTextPosition(0);
        this._serialButton.setVerticalTextPosition(3);
        this._serialButton.setMargin(new Insets(0, 0, 0, 0));
        this._serialButton.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/org/adtpro/resources/serialSelected.png"))));
        this._serialButton.addActionListener(this);
        this._ethernetButton = new JRadioButton(Messages.getString("Gui.EthernetButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/org/adtpro/resources/ethernetDeselected.png"))));
        this._ethernetButton.setHorizontalTextPosition(0);
        this._ethernetButton.setVerticalTextPosition(3);
        this._ethernetButton.setMargin(new Insets(0, 0, 0, 0));
        this._ethernetButton.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/org/adtpro/resources/ethernetSelected.png"))));
        this._ethernetButton.addActionListener(this);
        this._audioButton = new JRadioButton(Messages.getString("Gui.AudioButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/org/adtpro/resources/audioDeselected.png"))));
        this._audioButton.setHorizontalTextPosition(0);
        this._audioButton.setVerticalTextPosition(3);
        this._audioButton.setMargin(new Insets(0, 0, 0, 0));
        this._audioButton.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/org/adtpro/resources/audioSelected.png"))));
        this._audioButton.addActionListener(this);
        this._disconnectButton = new JRadioButton(Messages.getString("Gui.DisconnectButton"), new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/org/adtpro/resources/disconnectDeselected.png"))));
        this._disconnectButton.setHorizontalTextPosition(0);
        this._disconnectButton.setVerticalTextPosition(3);
        this._disconnectButton.setMargin(new Insets(0, 0, 0, 0));
        this._disconnectButton.setSelectedIcon(new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/org/adtpro/resources/disconnectSelected.png"))));
        this._disconnectButton.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._serialButton);
        buttonGroup.add(this._ethernetButton);
        buttonGroup.add(this._audioButton);
        buttonGroup.add(this._disconnectButton);
        GridBagUtil.constrain(jPanel, this._serialButton, 1, 1, 1, 1, 2, 17, 0.0, 0.0, 5, 5, 5, 0);
        GridBagUtil.constrain(jPanel, this._ethernetButton, 2, 1, 1, 1, 2, 17, 0.0, 0.0, 5, 10, 5, 0);
        GridBagUtil.constrain(jPanel, this._audioButton, 3, 1, 1, 1, 2, 17, 0.0, 0.0, 5, 10, 5, 0);
        GridBagUtil.constrain(jPanel, this._disconnectButton, 4, 1, 1, 1, 0, 13, 0.0, 0.0, 5, 10, 5, 5);
        GridBagUtil.constrain(jPanel, this.labelMainProgress, 1, 3, 4, 1, 2, 17, 1.0, 0.0, 0, 5, 5, 5);
        GridBagUtil.constrain(jPanel, this.progressBar, 1, 4, 4, 1, 2, 17, 1.0, 0.0, 0, 5, 5, 5);
        GridBagUtil.constrain(jPanel, this.labelSubProgress, 1, 5, 4, 1, 2, 17, 1.0, 0.0, 0, 5, 5, 5);
        this._parent = this;
        this.pack();
        this._previousButton = this._disconnectButton;
        this._disconnectButton.requestFocus();
        this._disconnectButton.doClick();
        int n = Integer.parseInt(this._properties.getProperty("CoordH", "0"));
        if (n > 0) {
            object = new Rectangle(Integer.parseInt(this._properties.getProperty("CoordX", "0")), Integer.parseInt(this._properties.getProperty("CoordY", "0")), Integer.parseInt(this._properties.getProperty("CoordW", "0")), Integer.parseInt(this._properties.getProperty("CoordH", "0")));
            if (((Rectangle)object).height == 0 || ((Rectangle)object).width == 0 || !FrameUtils.fits((Rectangle)object)) {
                Log.println(false, "Gui setting screen coordinates to defaults; properties file coords weren't good.");
                this.setBounds(FrameUtils.center(this.getSize()));
            } else {
                Log.println(false, "Gui setting screen coordinates from properties file values.");
                this.setBounds((Rectangle)object);
            }
        } else {
            Log.println(false, "Gui setting screen coordinates to defaults; properties file height was zero.");
            this.setBounds(FrameUtils.center(this.getSize()));
        }
        this.setVisible(true);
        SerialConfig.getSingleton(this);
        AudioConfig.getSingleton(this, this._properties);
        Log.println(true, "OS: " + System.getProperty("os.name"));
        Log.println(true, "Java VM: " + System.getProperty("java.vm.info"));
        Log.println(true, "Java bit width: " + System.getProperty("sun.arch.data.model"));
        Log.println(true, "Invocation args.length: " + stringArray.length);
        if (stringArray.length > 0) {
            object = stringArray[0];
            Log.println(true, "args [0] = " + (String)object);
            if (((String)object).equalsIgnoreCase(Messages.getString("Gui.EthernetButton")) || ((String)object).equalsIgnoreCase("ethernet")) {
                this._ethernetButton.doClick();
            } else if (((String)object).equalsIgnoreCase(Messages.getString("Gui.SerialButton")) || ((String)object).equalsIgnoreCase("serial")) {
                this._serialButton.doClick();
            } else if (((String)object).equalsIgnoreCase(Messages.getString("Gui.AudioButton")) || ((String)object).equalsIgnoreCase("audio")) {
                this._audioButton.doClick();
            } else if (((String)object).equalsIgnoreCase(Messages.getString("Gui.SerialIPButton")) || ((String)object).equalsIgnoreCase("localhost")) {
                Log.println(false, "Gui constructor starting the Serial-IP client.");
                try {
                    boolean bl = this.startComms(new SerialIPTransport(this._properties.getProperty("SerialIPHost", "localhost"), this._properties.getProperty("SerialIPPort", "1977")));
                    if (bl) {
                        String string2 = Messages.getString("Gui.ServingSerialIPTitle");
                        string2 = StringUtilities.replaceSubstring(string2, "%1", this._properties.getProperty("SerialIPPort", "1977"));
                        string2 = StringUtilities.replaceSubstring(string2, "%2", this._properties.getProperty("SerialIPHost", "localhost"));
                        this.setTitle(string2);
                        this._properties.setProperty("SerialIPPort", this._properties.getProperty("SerialIPPort", "1977"));
                        this._properties.setProperty("SerialIPHost", this._properties.getProperty("SerialIPHost", "localhost"));
                        Log.println(false, "Gui constructor started Serial-IP client.");
                    }
                }
                catch (Exception exception) {
                    Log.printStackTrace(exception);
                    this.setTitle(Messages.getString("Gui.Title") + " " + Messages.getString("Version.Number"));
                    Log.println(false, "Gui constructor can't start the localhost client.");
                }
            }
        }
        Log.println(false, "Gui Constructor exit.");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block28: {
            Log.println(false, "Gui.actionPerformed() entry, responding to " + actionEvent.getActionCommand() + "; previous button is " + this._previousButton.getText());
            if (actionEvent.getSource() == this._serialButton && this._previousButton != this._serialButton) {
                if (this._isSerialAvailable) {
                    if (this.startComms(null)) {
                        if (this._properties.getProperty("CommPortSpeed") == null || this._properties.getProperty("CommPort") == null) {
                            this.serialConfigGui(0);
                            if (SerialConfig.getSingleton(this).getExitStatus() == 1) {
                                this._serialButton.doClick();
                            } else {
                                this._disconnectButton.doClick();
                            }
                        } else {
                            try {
                                this.setSerialTitle();
                                Log.println(false, "Gui.actionPerformed setting previous button to _serialButton.");
                                JRadioButton jRadioButton = this._previousButton;
                                this._previousButton = this._serialButton;
                                boolean bl = this.startComms(new SerialTransport(this, this._properties.getProperty("CommPort"), this._properties.getProperty("CommPortSpeed"), this._properties.getProperty("HardwareHandshaking", "false").compareTo("true") == 0));
                                if (!bl) {
                                    jRadioButton.doClick();
                                }
                            }
                            catch (Exception exception) {
                                Log.printStackTrace(exception);
                                this._disconnectButton.doClick();
                            }
                        }
                    } else {
                        this._previousButton.doClick();
                    }
                } else {
                    JOptionPane.showMessageDialog(this, Messages.getString("Gui.NoRXTXDialogText"), Messages.getString("Gui.NoRXTXDialogTitle"), 0);
                    this._disconnectButton.doClick();
                }
            } else if (actionEvent.getSource() == this._ethernetButton && this._previousButton != this._ethernetButton) {
                Log.println(false, "Gui.actionPerformed acting on the ethernet button.");
                try {
                    boolean bl = this.startComms(new UDPTransport(this._properties.getProperty("UDPServerPort", "6502")));
                    if (bl) {
                        String string = Messages.getString("Gui.ServingEthernetTitle");
                        string = StringUtilities.replaceSubstring(string, "%1", InetAddress.getLocalHost().getHostAddress());
                        this.setTitle(string);
                        Log.println(false, "Gui.actionPerformed ethernet button connected.");
                        this._previousButton = this._ethernetButton;
                        break block28;
                    }
                    this._previousButton.doClick();
                }
                catch (Exception exception) {
                    Log.printStackTrace(exception);
                    this.setTitle(Messages.getString("Gui.Title") + " " + Messages.getString("Version.Number"));
                    this._disconnectButton.doClick();
                    Log.println(false, "Gui.actionPerformed ethernet button can't connect.");
                }
            } else if (actionEvent.getSource() == this._audioButton && this._previousButton != this._audioButton) {
                boolean bl = this.startComms(new AudioTransport(this._properties));
                if (bl) {
                    this.setTitle(Messages.getString("Gui.Title") + " " + Messages.getString("Version.Number"));
                    this.setTitle(Messages.getString("Gui.ServingAudioTitle"));
                    this._previousButton = this._audioButton;
                } else {
                    this._previousButton.doClick();
                }
            } else if (actionEvent.getSource() == this._disconnectButton) {
                if (this._previousButton != this._disconnectButton) {
                    boolean bl = this.startComms(null);
                    if (bl) {
                        this.setTitle(Messages.getString("Gui.Title") + " " + Messages.getString("Version.Number"));
                        this._previousButton = this._disconnectButton;
                        Log.println(false, "Gui.actionPerformed setting previous button to _disconnectButton.");
                    } else {
                        this._previousButton.doClick();
                    }
                }
            } else if (actionEvent.getActionCommand().equals(Messages.getString("Gui.Trace"))) {
                Log.getSingleton().setTrace(this._traceMenuItem.isSelected());
                this.saveProperties();
            }
        }
        Log.println(false, "Gui.actionPerformed() exit.");
    }

    public String getWorkingDirectory() {
        if (this._workingDirectory == null) {
            File file = new File(".");
            this._workingDirectory = file.getAbsolutePath();
            this._workingDirectory = this._workingDirectory.substring(0, this._workingDirectory.length() - 2);
        }
        if (!this._workingDirectory.endsWith(File.separator)) {
            this._workingDirectory = this._workingDirectory + File.separator;
        }
        Log.println(false, "Gui.getWorkingDirectory(): " + this._workingDirectory);
        return this._workingDirectory;
    }

    public void setSerialTitle() {
        String string = Messages.getString("Gui.ServingSerialTitle");
        string = StringUtilities.replaceSubstring(string, "%1", this._properties.getProperty("CommPort"));
        string = StringUtilities.replaceSubstring(string, "%2", this._properties.getProperty("CommPortSpeed"));
        this.setTitle(string);
    }

    public void setSerialSpeed(int n) {
        if (n == 0) {
            n = Integer.parseInt(this._properties.getProperty("CommPortSpeed", "115200"));
        }
        this._commsThread.setSpeed(n);
        String string = this._properties.getProperty("CommPortSpeed", "115200");
        this._properties.setProperty("CommPortSpeed", new String("" + n));
        this.setSerialTitle();
        this._properties.setProperty("CommPortSpeed", string);
    }

    public void serialConfigGui(int n) {
        SerialConfig.getSingleton(this);
        SerialConfig.setProperties(this._properties);
        SerialConfig.showSingleton(this, n);
    }

    public void audioConfigGui() {
        AudioConfig.getSingleton(this, this._properties);
        AudioConfig.showSingleton(this);
    }

    public byte setWorkingDirectory(String string) {
        byte by = 6;
        string = string.trim();
        File file = new File(string);
        Log.println(false, "Gui.setWorkingDirectory() incoming: " + string);
        File file2 = file.isAbsolute() ? null : new File(this._workingDirectory);
        Log.println(false, "Gui.setWorkingDirectory() parentDir: " + file2);
        File file3 = new File(file2, string);
        String string2 = null;
        try {
            string2 = file3.getCanonicalPath();
            file3 = new File(string2);
            if (!file3.isDirectory()) {
                string2 = null;
            }
        }
        catch (IOException iOException) {
            string2 = null;
            file3 = new File(string);
            try {
                string2 = file3.getCanonicalPath();
                if (!file3.isDirectory()) {
                    string2 = null;
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
        }
        if (string2 != null) {
            if (!this._workingDirectory.endsWith(File.separator)) {
                this._workingDirectory = this._workingDirectory + File.separator;
            }
            this._workingDirectory = string2;
            Log.println(false, "Gui.setWorkingDirectory() saving: " + this._workingDirectory);
            this.saveProperties();
            by = 0;
        } else {
            Log.println(false, "Gui.setWorkingDirectory() unable to make that change.");
        }
        return by;
    }

    public String[] getFiles(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(string.charAt(i));
        }
        String string2 = stringBuffer.toString();
        final String string3 = string2.replaceAll("\\*", ".*").replaceAll("\\?", ".");
        File file = new File(this.getWorkingDirectory());
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.toUpperCase().matches(string3.toUpperCase());
            }
        };
        String[] stringArray = file.list(filenameFilter);
        return stringArray;
    }

    public String[] getFiles() {
        File file = new File(this.getWorkingDirectory());
        File[] fileArray = file.listFiles();
        Object[] objectArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            objectArray[i] = fileArray[i].getName();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void setSerialAvailable(boolean bl) {
        this._isSerialAvailable = bl;
    }

    public void setProgressMaximum(int n) {
        this.clearProgress();
        this.progressBar.setMaximum(n);
        this.progressBar.setString("");
    }

    public void clearProgress() {
        this.setProgressValue(0);
        this.progressBar.setString("");
    }

    public void setProgressValue(int n) {
        this.progressBar.setValue(n);
    }

    public void setMainText(String string) {
        this.labelMainProgress.setText(string);
    }

    public void setSecondaryText(String string) {
        if (!string.equals("")) {
            this.labelSubProgress.setText(string);
            this.labelSubProgress.setForeground(this.labelMainProgress.getForeground());
        } else {
            this.labelSubProgress.setText("I");
            this.labelSubProgress.setForeground(this.labelSubProgress.getBackground());
        }
    }

    public void requestSendFinished(String string) {
        JOptionPane.showMessageDialog(this._parent, string, Messages.getString("Gui.BS.DoneTitle"), 1);
    }

    public boolean startComms(ATransport aTransport) {
        boolean bl = true;
        Log.println(false, "Gui.startComms() entry.");
        if (this._commsThread != null) {
            if (this._commsThread.isBusy()) {
                Object[] objectArray = new Object[]{Messages.getString("Gui.Yes"), Messages.getString("Gui.No")};
                int n = JOptionPane.showOptionDialog(null, Messages.getString("Gui.Busy"), Messages.getString("Gui.BusyTitle"), -1, 2, null, objectArray, objectArray[0]);
                if (n != 0) {
                    bl = false;
                }
            }
            if (bl) {
                try {
                    Log.println(false, "Gui.startComms() about clean up window...");
                    this.cleanupWindow();
                    Log.println(false, "Gui.startComms() about to interrupt existing comms thread...");
                    this._commsThread.interrupt();
                    Log.println(false, "Gui.startComms() about to request stop of comms thread...");
                    this._commsThread.requestStop();
                }
                catch (Throwable throwable) {
                    Log.printStackTrace(throwable);
                }
                this.menuBootstrap.setEnabled(false);
                this._commsThread = null;
                Log.println(false, "Gui.startComms() done with old thread.");
            }
        } else {
            Log.println(false, "Gui.startComms() didn't have an old thread to stop.");
        }
        if (aTransport != null && bl) {
            this.setMainText(Messages.getString("Gui.Quiesced"));
            this.setSecondaryText(Messages.getString("Gui.Connected"));
            this.clearProgress();
            this._commsThread = new CommsThread(this, aTransport);
            this._commsThread.start();
            this.saveProperties();
            if (this._commsThread.supportsBootstrap()) {
                this.menuBootstrap.setEnabled(true);
                this._dosAction2.setEnabled(this._commsThread.transportType() == 3);
                this._sosAction.setEnabled(this._commsThread.transportType() != 3);
                this._speedibootAction.setEnabled(this._commsThread.transportType() != 3);
                this._vsdrivebootAction.setEnabled(this._commsThread.transportType() != 3);
                this._serialConfigBootstrapAction.setEnabled(this._commsThread.transportType() != 3);
            }
        }
        Log.println(false, "Gui.startComms() exit; returning " + bl + ".");
        return bl;
    }

    public void cancelCommsThread(String string) {
        this._disconnectButton.doClick();
        Log.println(false, "Gui.cancelCommsThread() About to show dialog...");
        JOptionPane.showMessageDialog(this, Messages.getString(string));
        Log.println(false, "Gui.cancelCommsThread() Done showing dialog.");
        this.cleanupWindow();
        if (string == "Gui.PortDoesNotExist" || string == "Gui.PortInUse") {
            this.serialConfigGui(0);
        }
    }

    public void cleanupWindow() {
        this.setMainText(Messages.getString("Gui.Quiesced"));
        this.setSecondaryText(Messages.getString("Gui.Disconnected"));
        this.menuBootstrap.setEnabled(false);
        this.clearProgress();
    }

    public void saveProperties() {
        if (this._traceMenuItem != null) {
            if (this._traceMenuItem.isSelected()) {
                this._properties.setProperty("TraceEnabled", "true");
            } else {
                this._properties.setProperty("TraceEnabled", "false");
            }
        }
        this._properties.setProperty("WorkingDirectory", this.getWorkingDirectory());
        Rectangle rectangle = this.getBounds();
        if (rectangle.height > 0) {
            this._properties.setProperty("CoordX", "" + rectangle.x);
            this._properties.setProperty("CoordY", "" + rectangle.y);
            this._properties.setProperty("CoordH", "" + rectangle.height);
            this._properties.setProperty("CoordW", "" + rectangle.width);
        }
        this._properties.save();
    }

    public static class WindowCloseMonitor
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            Window window = windowEvent.getWindow();
            Gui gui = (Gui)windowEvent.getSource();
            gui.saveProperties();
            window.setVisible(false);
            window.dispose();
            System.exit(0);
        }
    }

    class MenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 5031778497008160371L;

        public MenuAction(String string) {
            super(string, null);
        }

        public MenuAction(String string, Icon icon) {
            super(string, icon);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = new Object[]{Messages.getString("Gui.Ok"), Messages.getString("Gui.Cancel")};
            Log.println(false, "Gui.MenuAction.actionPerformed() responding to " + actionEvent.getActionCommand());
            if (actionEvent.getActionCommand().equals(Messages.getString("Gui.Quit"))) {
                Gui.this.saveProperties();
                Gui.this.setVisible(false);
                Gui.this.dispose();
                System.exit(0);
            } else if (actionEvent.getActionCommand().equals(Messages.getString("Gui.About"))) {
                String string = Messages.getString("Gui.AboutText");
                string = StringUtilities.replaceSubstring(string, "%1", Messages.getString("Version.Number"));
                JOptionPane.showMessageDialog(null, string, Messages.getString("Gui.About"), 1);
            } else if (actionEvent.getActionCommand().equals(Messages.getString("Gui.Website"))) {
                BareBonesBrowserLaunch.openURL("http://adtpro.com");
            } else if (actionEvent.getActionCommand().equals(Messages.getString("Gui.CD"))) {
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(1);
                jFileChooser.setCurrentDirectory(new File(Gui.this.getWorkingDirectory()));
                int n = jFileChooser.showDialog(Gui.this._parent, Messages.getString("Gui.CDSet"));
                if (n == 0) {
                    if (jFileChooser.getSelectedFile().isDirectory()) {
                        Gui.this.setWorkingDirectory(jFileChooser.getSelectedFile().toString());
                        Gui.this.setSecondaryText(jFileChooser.getSelectedFile().toString());
                        Gui.this.saveProperties();
                    } else {
                        String string = jFileChooser.getSelectedFile().getParent();
                        Gui.this.setWorkingDirectory(string);
                        Gui.this.setSecondaryText(string);
                        Gui.this.saveProperties();
                    }
                }
            } else if (actionEvent.getActionCommand().equals(Messages.getString("Gui.BS.DOS")) || actionEvent.getActionCommand().equals(Messages.getString("Gui.BS.DOS2")) || actionEvent.getActionCommand().equals(Messages.getString("Gui.BS.ProDOS")) || actionEvent.getActionCommand().equals(Messages.getString("Gui.BS.ProDOSFast")) || actionEvent.getActionCommand().equals(Messages.getString("Gui.BS.ProDOSVSDrive")) || actionEvent.getActionCommand().equals(Messages.getString("Gui.BS.ADT")) || actionEvent.getActionCommand().equals(Messages.getString("Gui.BS.ADTPro")) || actionEvent.getActionCommand().equals(Messages.getString("Gui.BS.ADTProAudio")) || actionEvent.getActionCommand().equals(Messages.getString("Gui.BS.ADTProEthernet"))) {
                int n = Gui.this._commsThread.requestSend(actionEvent.getActionCommand());
                int n2 = 2400;
                int n3 = 250;
                try {
                    n2 = Integer.parseInt(Gui.this._properties.getProperty("CommPortBootstrapSpeed"));
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = 2400;
                }
                try {
                    n3 = Integer.parseInt(Gui.this._properties.getProperty("CommPortBootstrapPacing"));
                }
                catch (NumberFormatException numberFormatException) {
                    n3 = 250;
                }
                Log.println(false, "Gui.actionPerformed getting instructions with speed = " + n2 + " pacing = " + n3);
                String string = Gui.this._commsThread.getInstructions(actionEvent.getActionCommand(), n, n2);
                int n4 = JOptionPane.showOptionDialog(Gui.this._parent, string, Messages.getString("Gui.Name"), 0, 2, null, objectArray, objectArray[0]);
                if (n4 == 0) {
                    Gui.this._commsThread.requestSend(actionEvent.getActionCommand(), true, n3, n2);
                }
            } else if (actionEvent.getActionCommand().equals(Messages.getString("Gui.BS.SOS"))) {
                int n = Gui.this._commsThread.requestSend(actionEvent.getActionCommand());
                int n5 = 115200;
                int n6 = 100;
                Log.println(false, "Gui.actionPerformed getting instructions with speed = " + n5 + " pacing = " + n6);
                String string = Gui.this._commsThread.getInstructions(actionEvent.getActionCommand(), n, n5);
                int n7 = JOptionPane.showOptionDialog(Gui.this._parent, string, Messages.getString("Gui.Name"), 0, 2, null, objectArray, objectArray[0]);
                if (n7 == 0) {
                    Gui.this._commsThread.requestSend(actionEvent.getActionCommand(), true, n6, n5);
                }
            } else if (actionEvent.getActionCommand().equals(Messages.getString("Gui.AudioConfig"))) {
                Gui.this.audioConfigGui();
                if (AudioConfig.getSingleton(Gui.this._parent, Gui.this._properties).getExitStatus() == 1 && Gui.this._commsThread != null && Gui.this._commsThread.transportType() == 3) {
                    Gui.this._commsThread.setAudioParms();
                }
            } else if (actionEvent.getActionCommand().equals(Messages.getString("Gui.SerialConfig")) || actionEvent.getActionCommand().equals(Messages.getString("Gui.SerialConfigBootstrap"))) {
                if (actionEvent.getActionCommand().equals(Messages.getString("Gui.SerialConfigBootstrap"))) {
                    Gui.this.serialConfigGui(1);
                } else {
                    Gui.this.serialConfigGui(0);
                }
                if (SerialConfig.getSingleton(Gui.this._parent).getExitStatus() == 1 && Gui.this._commsThread != null && Gui.this._commsThread.transportType() == 1) {
                    Gui.this._commsThread.setParms(Gui.this._properties.getProperty("CommPort"), Integer.parseInt(Gui.this._properties.getProperty("CommPortSpeed")), Gui.this._properties.getProperty("HardwareHandshaking", "false").compareTo("true") == 0);
                    String string = Messages.getString("Gui.ServingSerialTitle");
                    string = StringUtilities.replaceSubstring(string, "%1", Gui.this._properties.getProperty("CommPort"));
                    string = StringUtilities.replaceSubstring(string, "%2", Gui.this._properties.getProperty("CommPortSpeed"));
                    Gui.this.setTitle(string);
                }
            }
            Log.println(false, "Gui.MenuAction.actionPerformed() exit.");
        }
    }
}

