/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.adtpro.ADTProperties;
import org.adtpro.gui.FrameUtils;
import org.adtpro.gui.GridBagUtil;
import org.adtpro.gui.Gui;
import org.adtpro.resources.Messages;
import org.adtpro.utilities.Log;

public class AudioConfig
extends JDialog
implements ActionListener {
    private static AudioConfig _theSingleton = null;
    private static final long serialVersionUID = 1L;
    private JLabel labelAudioDevice;
    private JComboBox comboAudioDevice;
    private int exitStatus = 0;
    int[] _audioDeviceIndices;
    public JButton okButton = new JButton(Messages.getString("Gui.Ok"));
    public JButton cancelButton = new JButton(Messages.getString("Gui.Cancel"));
    private static ADTProperties _properties = null;
    public static Gui _parent;
    public static final int CANCEL = 0;
    public static final int OK = 1;

    private AudioConfig(ADTProperties aDTProperties) {
        int n;
        _properties = aDTProperties;
        this.setTitle(Messages.getString("Gui.AudioConfig"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        GridBagUtil.constrain(jPanel, this.okButton, 1, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        GridBagUtil.constrain(jPanel, this.cancelButton, 2, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 5, 5);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel2, "North");
        this.getContentPane().add((Component)jPanel, "South");
        Log.getSingleton();
        this.comboAudioDevice = new JComboBox();
        this.comboAudioDevice.addItem(Messages.getString("Gui.DefaultAudioMixer"));
        Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
        String string = null;
        this._audioDeviceIndices = new int[infoArray.length + 1];
        this._audioDeviceIndices[0] = 0;
        int n2 = 1;
        for (n = 0; n < infoArray.length; ++n) {
            string = null;
            try {
                string = infoArray[n].getName();
                if (string.equals("")) continue;
                this.comboAudioDevice.addItem(string);
                this._audioDeviceIndices[n2] = n;
                Log.println(false, "AudioConfig().ctor Added device " + string + " at index " + n + ", mixer index " + n2 + ".");
                ++n2;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.labelAudioDevice = new JLabel(Messages.getString("Gui.AudioConfigMixer"), 2);
        GridBagUtil.constrain(jPanel2, this.labelAudioDevice, 1, 1, 1, 1, 0, 17, 0.0, 0.0, 5, 5, 0, 0);
        GridBagUtil.constrain(jPanel2, this.comboAudioDevice, 1, 2, 1, 1, 2, 17, 0.0, 0.0, 0, 5, 5, 5);
        this.pack();
        this.setBounds(FrameUtils.center(this.getSize()));
        this.okButton.requestFocus();
        this.getRootPane().setDefaultButton(this.okButton);
        n = 0;
        try {
            n = Integer.parseInt(_properties.getProperty("AudioPortIndex", "0"));
            Log.println(false, "AudioConfig.ctor() Found a GUI mixer index of: " + n);
            Log.println(false, "  which is a hardware index of: " + this._audioDeviceIndices[n]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.comboAudioDevice.setSelectedIndex(n);
        Log.println(false, "AudioConfig Constructor exit.");
    }

    public static AudioConfig getSingleton(Gui gui, ADTProperties aDTProperties) {
        _parent = gui;
        _properties = aDTProperties;
        if (null == _theSingleton) {
            AudioConfig.allocateSingleton(gui, aDTProperties);
        }
        return _theSingleton;
    }

    private static synchronized void allocateSingleton(Gui gui, ADTProperties aDTProperties) {
        if (null == _theSingleton) {
            _theSingleton = new AudioConfig(aDTProperties);
        }
    }

    public static String getPort() {
        return (String)AudioConfig._theSingleton.comboAudioDevice.getSelectedItem();
    }

    public static void showSingleton(Gui gui) {
        _theSingleton.setModal(true);
        _theSingleton.setBounds(FrameUtils.center(_theSingleton.getSize(), gui.getBounds()));
        _theSingleton.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Log.println(false, "AudioConfig.actionPerformed() entry, responding to " + actionEvent.getActionCommand());
        if (actionEvent.getSource() == this.okButton) {
            Log.println(false, "  Selected index: " + this.comboAudioDevice.getSelectedIndex());
            if (this.comboAudioDevice.getSelectedIndex() > -1) {
                _properties.setProperty("AudioPortIndex", Integer.toString(this.comboAudioDevice.getSelectedIndex()));
                _properties.setProperty("AudioHardwareIndex", Integer.toString(this._audioDeviceIndices[this.comboAudioDevice.getSelectedIndex()]));
                Log.println(false, "  Set property to: " + Integer.toString(this.comboAudioDevice.getSelectedIndex()));
            } else {
                _properties.setProperty("AudioPortIndex", "0");
                Log.println(false, "  Oops, set property to 0.");
            }
            _properties.save();
            AudioConfig._theSingleton.exitStatus = 1;
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cancelButton) {
            int n = Integer.parseInt(_properties.getProperty("AudioPortIndex", "0"));
            AudioConfig._theSingleton.comboAudioDevice.setSelectedIndex(n);
            AudioConfig._theSingleton.exitStatus = 0;
            this.setVisible(false);
        }
        Log.println(false, "AudioConfig.actionPerformed() exit.");
    }

    public int getExitStatus() {
        return AudioConfig._theSingleton.exitStatus;
    }
}

