/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro;

import java.util.Vector;
import org.adtpro.NibbleBufferEntry;
import org.adtpro.utilities.Log;
import org.adtpro.utilities.UnsignedByte;

public class NibbleBufferMap {
    Vector mapEntries;
    public double accuracy = 0.0;
    byte[] buffer;
    int currentGapSequence = -1;
    int currentByteMode = 0;
    public static final int MAP_FIELD_ENTRY_MODE = 0;
    public static final int MAP_TENTATIVE_GAP_MODE = 1;
    public static final int MAP_GAP_MODE = 2;
    public static final int BITSLIP_LENGTH = 4;
    public static final int NIBBLE_TRACK_LENGTH = 6656;
    public static final int MIN_TRACK_LENGTH = 4500;

    NibbleBufferMap(byte[] byArray) {
        this.buffer = byArray;
        this.mapEntries = new Vector();
        this.buildMap();
    }

    void buildMap() {
        Log.println(false, "NibbleBufferMap.buildMap() inBuffer size: " + this.buffer.length);
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        block5: for (int i = 0; i < this.buffer.length; ++i) {
            switch (this.currentByteMode) {
                case 0: {
                    if (!this.isFirstGapByte(this.buffer[i])) continue block5;
                    this.currentByteMode = 1;
                    n3 = i;
                    n2 = 1;
                    continue block5;
                }
                case 1: {
                    int n4;
                    if (UnsignedByte.loByte(this.buffer[i]) == UnsignedByte.loByte(NibbleBufferEntry.cGapSequence[this.currentGapSequence][n2])) {
                        NibbleBufferEntry nibbleBufferEntry;
                        if (++n2 != NibbleBufferEntry.cGapSequence[this.currentGapSequence].length) continue block5;
                        int n5 = i - n - n2 - 4 + 1;
                        if (n5 > 0) {
                            nibbleBufferEntry = new NibbleBufferEntry(this.buffer, 1, n, n5);
                            this.mapEntries.add(nibbleBufferEntry);
                            n4 = n + n5;
                        } else {
                            n4 = n;
                        }
                        n5 = i - n4 - n2 + 1;
                        if (n5 > 0) {
                            nibbleBufferEntry = new NibbleBufferEntry(this.buffer, 2, n4, n5);
                            this.mapEntries.add(nibbleBufferEntry);
                        }
                        this.currentByteMode = 2;
                        n = i - n2 + 1;
                        continue block5;
                    }
                    i = n3;
                    this.currentByteMode = 0;
                    this.currentGapSequence = -1;
                    n2 = 0;
                    continue block5;
                }
                case 2: {
                    if (this.buffer[i] == -1) continue block5;
                    int n4 = i - n;
                    if (n4 > 0) {
                        NibbleBufferEntry nibbleBufferEntry = new NibbleBufferEntry(this.buffer, 0, n, n4);
                        this.mapEntries.add(nibbleBufferEntry);
                    }
                    this.currentByteMode = 0;
                    n = i;
                    continue block5;
                }
                default: {
                    Log.println(true, "NibbleBufferMap internal error: look, this really shouldn't happen...");
                }
            }
        }
        Log.println(false, "NibbleBufferMap.buildMap() exit; found " + this.mapEntries.size() + " map entries.");
    }

    boolean isFirstGapByte(byte by) {
        byte by2;
        boolean bl = false;
        int n = 0;
        n = 0;
        while ((by2 = UnsignedByte.loByte(NibbleBufferEntry.cGapSequence[n][0])) != 0) {
            if (UnsignedByte.loByte(by) == by2) {
                this.currentGapSequence = n;
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    int findFirstRepeatCandidate() {
        int n = 0;
        for (NibbleBufferEntry nibbleBufferEntry : this.mapEntries) {
            if (nibbleBufferEntry.type == 1 && nibbleBufferEntry.startIndex >= 4500) {
                Log.println(false, "NibbleBufferMap.findFirstRepeatCandidate() found a candidate at " + n + ".");
                return n;
            }
            ++n;
        }
        Log.println(false, "NibbleBufferMap.findFirstRepeatCandidate() returning -1.");
        return -1;
    }

    int findNextRepeatCandidate(int n) {
        int n2 = -1;
        for (int i = n + 1; i < this.mapEntries.size(); ++i) {
            NibbleBufferEntry nibbleBufferEntry = (NibbleBufferEntry)this.mapEntries.elementAt(i);
            if (nibbleBufferEntry.startIndex > 6656) {
                n2 = -1;
                break;
            }
            if (nibbleBufferEntry.type != 1) continue;
            n2 = i;
            break;
        }
        return n2;
    }

    double assessRepeatStartingAt(int n) {
        int n2;
        double d = 0.5;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n && (n2 = i + n) < this.mapEntries.size(); ++i) {
            NibbleBufferEntry nibbleBufferEntry = (NibbleBufferEntry)this.mapEntries.elementAt(i);
            NibbleBufferEntry nibbleBufferEntry2 = (NibbleBufferEntry)this.mapEntries.elementAt(n2);
            if (nibbleBufferEntry2.length == 0) {
                Log.println(false, "NibbleBufferMap.assessRepeatStartingAt() found zero length second.");
            }
            NibbleBufferEntry.SameContentsReturn sameContentsReturn = nibbleBufferEntry.sameContents(nibbleBufferEntry2);
            double d4 = sameContentsReturn.liklihood;
            d3 += sameContentsReturn.weight;
            d2 += sameContentsReturn.weight * d4;
        }
        if (d3 > 0.0) {
            d = d2 / d3;
        }
        return d;
    }

    int determineTrackLength() {
        int n = -1;
        double d = 0.0;
        int n2 = 0;
        int n3 = this.findFirstRepeatCandidate();
        while (n3 > 0) {
            double d2 = this.assessRepeatStartingAt(n3);
            if (d2 > d) {
                d = d2;
                n2 = n3;
            }
            n3 = this.findNextRepeatCandidate(n3);
        }
        if (d > 0.0) {
            NibbleBufferEntry nibbleBufferEntry = (NibbleBufferEntry)this.mapEntries.elementAt(n2);
            n = nibbleBufferEntry.startIndex;
        }
        this.accuracy = d;
        Log.println(false, "NibbleBufferMap.determineTrackLength() returning " + n + " for track length.");
        return n;
    }

    int findLongestGapBefore(int n) {
        int n2 = 0;
        int n3 = 0;
        for (NibbleBufferEntry nibbleBufferEntry : this.mapEntries) {
            if (nibbleBufferEntry.startIndex + nibbleBufferEntry.length > n || nibbleBufferEntry.type != 0 || nibbleBufferEntry.length <= n3) continue;
            n3 = nibbleBufferEntry.length;
            n2 = nibbleBufferEntry.startIndex;
        }
        return n2;
    }
}

