/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro;

import org.adtpro.utilities.Log;

public class NibbleBufferEntry {
    static int[] validDiskBytes = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1};
    static int[][] cGapSequence = new int[][]{{255, 255, 255, 255}, {254, 255, 255, 255, 255}, {252, 255, 255, 255, 255}, {249, 254, 255, 255, 255}, {243, 252, 255, 255, 255}, {231, 249, 254, 255, 255}, {207, 243, 252, 255, 255}, {159, 231, 249, 254, 255}, {0}};
    int type = 0;
    int startIndex = 0;
    int length = 0;
    byte[] buffer;
    public static final int NIBBLE_GAP = 0;
    public static final int NIBBLE_FIELD = 1;
    public static final int NIBBLE_BITSLIP = 2;

    public NibbleBufferEntry(byte[] byArray) {
        this(byArray, 0, 0, 0);
    }

    public NibbleBufferEntry(byte[] byArray, int n, int n2, int n3) {
        this.buffer = byArray;
        this.type = n;
        this.startIndex = n2;
        this.length = n3;
    }

    public double weightedCompareWith(NibbleBufferEntry nibbleBufferEntry) {
        int n = this.length < nibbleBufferEntry.length ? this.length : nibbleBufferEntry.length;
        int n2 = this.length > nibbleBufferEntry.length ? this.length : nibbleBufferEntry.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (this.buffer[i] == nibbleBufferEntry.buffer[i]) {
                d += 1.0;
                continue;
            }
            if (validDiskBytes[this.buffer[i]] != 0 && validDiskBytes[nibbleBufferEntry.buffer[i]] != 0) continue;
            d += 0.5;
        }
        return (d += (double)(n2 - n) * 0.5) / (double)n2;
    }

    public SameContentsReturn sameContents(NibbleBufferEntry nibbleBufferEntry) {
        SameContentsReturn sameContentsReturn = new SameContentsReturn();
        if (nibbleBufferEntry.length == 0) {
            Log.println(true, "NibbleBufferEntry.sameContents() problem: another.length = 0!");
        }
        if (this.type != nibbleBufferEntry.type) {
            sameContentsReturn.liklihood = 0.0;
            sameContentsReturn.weight = 1.0;
        }
        switch (this.type) {
            case 0: {
                sameContentsReturn.liklihood = this.length / nibbleBufferEntry.length;
                if (sameContentsReturn.liklihood > 1.0) {
                    sameContentsReturn.liklihood = 1.0 / sameContentsReturn.liklihood;
                }
                sameContentsReturn.weight = 0.2;
                break;
            }
            case 1: {
                sameContentsReturn.liklihood = this.weightedCompareWith(nibbleBufferEntry);
                sameContentsReturn.weight = 1.0;
                break;
            }
            case 2: {
                sameContentsReturn.liklihood = 1.0;
                sameContentsReturn.weight = 0.0;
            }
        }
        return sameContentsReturn;
    }

    public class SameContentsReturn {
        double liklihood;
        double weight;
    }
}

