/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro;

import org.adtpro.NibbleBufferMap;
import org.adtpro.NibbleTrack;
import org.adtpro.utilities.Log;

public class NibbleAnalysis {
    static final int MIN_TRACK_LENGTH = 4500;
    static final int NIBBLE_TRACK_LENGTH = 6656;

    public static NibbleTrack analyzeNibbleBuffer(byte[] byArray) {
        Log.println(false, "NibbleAnalysis.analyzeNibbleBuffer() rawNibbleBuffer length: " + byArray.length);
        NibbleTrack nibbleTrack = new NibbleTrack();
        NibbleBufferMap nibbleBufferMap = new NibbleBufferMap(byArray);
        int n = nibbleBufferMap.determineTrackLength();
        Log.println(false, "NibbleAnalysis.analyzeNibbleBuffer() length: " + n);
        if (n >= 4500 && n <= 6656) {
            nibbleTrack.accuracy = nibbleBufferMap.accuracy;
            nibbleTrack.foundLength = n;
            Log.println(false, "NibbleAnalysis.analyzeNibbleBuffer() Accuracy: " + nibbleTrack.accuracy + " Length: " + nibbleTrack.foundLength);
            NibbleAnalysis.composeNibbleTrack(nibbleTrack, nibbleBufferMap);
        } else {
            Log.println(false, "NibbleAnalysis.analyzeNibbleBuffer() thought the length was unacceptable?");
        }
        return nibbleTrack;
    }

    static void composeNibbleTrack(NibbleTrack nibbleTrack, NibbleBufferMap nibbleBufferMap) {
        int n;
        int n2 = 0;
        int n3 = nibbleBufferMap.findLongestGapBefore(nibbleTrack.foundLength);
        int n4 = 6656 - nibbleTrack.foundLength;
        if (n3 > 0) {
            Log.println(false, "Copying first part for " + n3 + " bytes.");
            for (n = 0; n < n3; ++n) {
                nibbleTrack.trackBuffer[n] = nibbleBufferMap.buffer[n];
            }
        }
        n2 = n3;
        if (n4 > 0) {
            Log.println(false, "Inserting " + n4 + " bytes of gap.");
            for (n = 0; n < n4; ++n) {
                nibbleTrack.trackBuffer[n2 + n] = -1;
            }
            n2 += n4;
        }
        for (n = 0; n < nibbleTrack.foundLength - n3; ++n) {
            nibbleTrack.trackBuffer[n + n2] = nibbleBufferMap.buffer[n + n3];
        }
        Log.println(false, "Copying final buffer from " + n2 + " to " + (n2 + nibbleTrack.foundLength - n3) + ".");
    }
}

