/*
 * Decompiled with CFR 0.152.
 */
package org.adtpro;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.physical.NibbleOrder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.BindException;
import java.util.Calendar;
import jssc.SerialPortException;
import org.adtpro.ADTPro;
import org.adtpro.NibbleAnalysis;
import org.adtpro.NibbleTrack;
import org.adtpro.gui.Gui;
import org.adtpro.resources.Messages;
import org.adtpro.transport.ATransport;
import org.adtpro.transport.AudioTransport;
import org.adtpro.transport.GoHomeException;
import org.adtpro.transport.ProtocolVersionException;
import org.adtpro.transport.SerialTransport;
import org.adtpro.transport.TransportTimeoutException;
import org.adtpro.utilities.ByteStream;
import org.adtpro.utilities.Log;
import org.adtpro.utilities.StringUtilities;
import org.adtpro.utilities.UnsignedByte;
import org.adtpro.utilities.VDiskPersister;

public class CommsThread
extends Thread {
    private boolean _shouldRun = true;
    private boolean _busy = false;
    protected boolean _client01xCompatibleProtocol = false;
    protected int _protocolVersion = 257;
    private ATransport _transport;
    private Gui _parent;
    public static final byte CHR_ACK = 6;
    public static final byte CHR_NAK = 21;
    public static final byte CHR_ENQ = 5;
    public static final byte CHR_CAN = 24;
    public static final byte CHR_TIMEOUT = 8;
    private int[] CRCTABLE = new int[256];
    private int _maxRetries = 3;
    long _startTime;
    long _endTime;
    private long _diffMillis;
    private Worker _worker = null;
    private boolean _isBinary = false;
    private String[] files = null;
    VDiskPersister _vdisks;
    public static int lastFileNumber = 1;
    public static String lastFileName = "";
    public static int lastNibNumber = 1;
    public static String lastNibName = "";
    public static int _lastAudioPacket = 0;

    public CommsThread(Gui gui, ATransport aTransport) {
        this._transport = aTransport;
        Log.getSingleton();
        Log.println(false, "CommsThread constructor entry.");
        this._vdisks = VDiskPersister.getSingleton(gui);
        this._parent = gui;
        try {
            this._transport.open();
        }
        catch (BindException bindException) {
            Log.printStackTrace(bindException);
            this._parent.cancelCommsThread("Gui.PortInUse");
            this.requestStop();
        }
        catch (SerialPortException serialPortException) {
            Log.printStackTrace(serialPortException);
            this._parent.cancelCommsThread("Gui.PortInUse");
            this.requestStop();
        }
        catch (Exception exception) {
            Log.printStackTrace(exception);
            this._shouldRun = false;
        }
        Log.println(false, "CommsThread constructor exit; _shouldRun=" + this._shouldRun);
    }

    @Override
    public void run() {
        Log.println(false, "CommsThread.run() entry; _shouldRun=" + this._shouldRun);
        if (this._shouldRun) {
            this.makeCrcTable();
            this.commandLoop();
        } else if (this._transport != null) {
            try {
                this._transport.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        Log.println(false, "CommsThread.run() exit.");
    }

    public void commandLoop() {
        Log.println(false, "CommsThread.commandLoop() starting.");
        byte by = 0;
        boolean bl = false;
        block18: while (this._shouldRun) {
            Log.println(false, "CommsThread.commandLoop() Waiting for command from Apple.");
            bl = false;
            this._busy = false;
            while (this._shouldRun && !bl) {
                try {
                    by = this.waitForData(1);
                    bl = true;
                    Log.println(false, "CommsThread.commandLoop() Received data.");
                }
                catch (TransportTimeoutException transportTimeoutException) {}
            }
            if (!this._shouldRun) continue;
            Log.println(false, "CommsThread.commandLoop() Received a byte: " + UnsignedByte.toString(by));
            this._parent.setProgressMaximum(0);
            switch (by) {
                case -61: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.2"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received CD command.");
                    this.changeDirectory();
                    this._parent.setSecondaryText(this._parent.getWorkingDirectory());
                    this._busy = false;
                    continue block18;
                }
                case -60: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.1"));
                    this._parent.setSecondaryText(this._parent.getWorkingDirectory());
                    Log.println(false, "CommsThread.commandLoop() Received DIR command.");
                    this.sendDirectory();
                    this._parent.setSecondaryText(this._parent.getWorkingDirectory());
                    this._busy = false;
                    continue block18;
                }
                case -63: {
                    this._busy = true;
                    Log.println(false, "CommsThread.commandLoop() Received wide protocol request.");
                    this.dispatchCommand(this.pullEnvelopeWide(false));
                    this._busy = false;
                    continue block18;
                }
                case -59: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.24"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received virtual drive command.");
                    this.pullEnvelope();
                    this._busy = false;
                    continue block18;
                }
                case -48: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.16"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received Put/Send command.");
                    this.receiveDisk(false);
                    this._busy = false;
                    continue block18;
                }
                case -57: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.3"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received Get/Receive command.");
                    this.sendDisk();
                    this._busy = false;
                    continue block18;
                }
                case -62: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.3"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received Batch command.");
                    this.receiveDisk(true);
                    this._busy = false;
                    continue block18;
                }
                case -51: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.3"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received Multiple nibble command.");
                    this.receiveNibbleDisk(true, 35);
                    this._busy = false;
                    continue block18;
                }
                case -39: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.23"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received Ping command.");
                    this._transport.pushBuffer();
                    this._transport.flushReceiveBuffer();
                    this._busy = false;
                    continue block18;
                }
                case -38: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.14"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received Query File Size command.");
                    this.queryFileSize();
                    this._busy = false;
                    continue block18;
                }
                case -46: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.11"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received ADT Receive command.");
                    this.send140kDisk();
                    this._busy = false;
                    continue block18;
                }
                case -45: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.15"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received ADT Send command.");
                    this.receive140kDisk();
                    this._busy = false;
                    continue block18;
                }
                case -50: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.12"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received Nibble Put command.");
                    this.receiveNibbleDisk(false, 35);
                    this._busy = false;
                    continue block18;
                }
                case -42: {
                    this._busy = true;
                    this._parent.setMainText(Messages.getString("CommsThread.5"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.commandLoop() Received Half Track Put command.");
                    this.receiveNibbleDisk(false, 70);
                    this._busy = false;
                    continue block18;
                }
            }
            Log.println(false, "CommsThread.commandLoop() Received unknown command: " + UnsignedByte.toString(by));
        }
        Log.println(false, "CommsThread.commandLoop() ending.");
    }

    public void dispatchCommand(byte[] byArray) {
        Log.println(false, "CommsThread.dispatchCommand() entry.");
        switch (byArray[2]) {
            case -62: {
                this._busy = true;
                this._parent.setMainText(Messages.getString("CommsThread.3"));
                this._parent.setSecondaryText("");
                Log.println(false, "CommsThread.dispatchCommand() Received Batch command.");
                this.receiveDiskWide(true, byArray);
                this._busy = false;
                break;
            }
            case -61: {
                this._busy = true;
                this._parent.setMainText(Messages.getString("CommsThread.2"));
                this._parent.setSecondaryText("");
                Log.println(false, "CommsThread.dispatchCommand() Received CD command.");
                this.changeDirectoryWide(byArray);
                this._parent.setSecondaryText(this._parent.getWorkingDirectory());
                this._busy = false;
                break;
            }
            case -60: {
                this._busy = true;
                this._parent.setMainText(Messages.getString("CommsThread.1"));
                this._parent.setSecondaryText(this._parent.getWorkingDirectory());
                Log.println(false, "CommsThread.dispatchCommand() Received DIR command.");
                this.sendDirectoryWide(byArray);
                this._parent.setSecondaryText(this._parent.getWorkingDirectory());
                this._busy = false;
                break;
            }
            case -48: {
                this._busy = true;
                this._parent.setMainText(Messages.getString("CommsThread.16"));
                this._parent.setSecondaryText("");
                Log.println(false, "CommsThread.dispatchCommand() Received Put/Send command.");
                this.receiveDiskWide(false, byArray);
                this._busy = false;
                break;
            }
            case -51: {
                this._busy = true;
                this._parent.setMainText(Messages.getString("CommsThread.3"));
                this._parent.setSecondaryText("");
                Log.println(false, "CommsThread.dispatchCommand() Received Multiple nibble command.");
                this.receiveNibbleDiskWide(true, byArray);
                this._busy = false;
                break;
            }
            case -50: {
                this._busy = true;
                this._parent.setMainText(Messages.getString("CommsThread.12"));
                this._parent.setSecondaryText("");
                Log.println(false, "CommsThread.dispatchCommand() Received Nibble Put command.");
                this.receiveNibbleDiskWide(false, byArray);
                this._busy = false;
                break;
            }
            case -57: {
                this._busy = true;
                this._parent.setMainText(Messages.getString("CommsThread.3"));
                this._parent.setSecondaryText("");
                Log.println(false, "CommsThread.dispatchCommand() Received Get/Receive command.");
                this.sendDiskWide(byArray);
                this._busy = false;
                break;
            }
            case -38: {
                this._busy = true;
                this._parent.setMainText(Messages.getString("CommsThread.14"));
                this._parent.setSecondaryText("");
                Log.println(false, "CommsThread.dispatchCommand() Received Query File Size command.");
                this.queryFileSizeWide(byArray);
                this._busy = false;
                break;
            }
            case -58: {
                this._busy = true;
                Log.println(false, "CommsThread.dispatchCommand() Received Send Bootstrap File.");
                this.sendBootstrapFileWide(byArray);
                this._busy = false;
                break;
            }
            case -40: {
                Log.println(false, "CommsThread.dispatchCommand() Received Home command.  How charming.");
                if (this._transport.transportType() != 3) break;
                this._parent.setSecondaryText("Heard audio signal #" + _lastAudioPacket++);
                break;
            }
            case -53: {
                Log.println(false, "CommsThread.dispatchCommand() Received stray acknowledgement packet.  Sending Home in response.");
                this.pullPayloadWide(byArray);
                this.sendHome();
                break;
            }
            default: {
                Log.println(false, "CommsThread.dispatchCommand() Received unknown command: " + UnsignedByte.toString(byArray[2]));
                this.pullPayloadWide(byArray);
            }
        }
        Log.println(false, "CommsThread.dispatchCommand() exit.");
    }

    public void sendBootstrapFileWide(byte[] byArray) {
        byte[] byArray2 = this.pullPayloadWide(byArray);
        if (byArray2 != null) {
            Log.println(false, "CommsThread.sendBootstrapFileWide() payload length: " + byArray2.length);
            switch (byArray2[0]) {
                case -78: {
                    this._parent.setMainText(Messages.getString("CommsThread.5"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.dispatchCommand() Received Apple II PD dump command.");
                    this.requestSend(Messages.getString("Gui.BS.ProDOSRaw"), true, 0, 115200);
                    break;
                }
                case -77: {
                    this._parent.setMainText(Messages.getString("CommsThread.5"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.sendBootstrapFileWide() Received Apple /// SOS.KERNEL dump command.");
                    this.requestSend(Messages.getString("Gui.BS.SOSKERNEL"), true, 0, 115200);
                    break;
                }
                case -76: {
                    this._parent.setMainText(Messages.getString("CommsThread.5"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.sendBootstrapFileWide() Received Apple /// SOS.INTERP dump command.");
                    this.requestSend(Messages.getString("Gui.BS.SOSINTERP"), true, 0, 115200);
                    break;
                }
                case -75: {
                    this._parent.setMainText(Messages.getString("CommsThread.5"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.sendBootstrapFileWide() Received Apple /// SOS.DRIVER dump command.");
                    this.requestSend(Messages.getString("Gui.BS.SOSDRIVER"), true, 0, 115200);
                    break;
                }
                case -74: {
                    this._parent.setMainText(Messages.getString("CommsThread.5"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.sendBootstrapFileWide() Received ADTPro serial dump command.");
                    this.requestSend(Messages.getString("Gui.BS.ADTProRaw"), true, 0, 115200);
                    break;
                }
                case -73: {
                    this._parent.setMainText(Messages.getString("CommsThread.5"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.sendBootstrapFileWide() Received VSDRIVE driver dump command.");
                    this.requestSend(Messages.getString("Gui.BS.VSDriveRaw"), true, 0, 115200);
                    break;
                }
                case -72: {
                    this._parent.setMainText(Messages.getString("CommsThread.5"));
                    this._parent.setSecondaryText("");
                    Log.println(false, "CommsThread.sendBootstrapFileWide() Received BASIC dump command.");
                    this.requestSend(Messages.getString("Gui.BS.BSpeed"), true, 0, 115200);
                    break;
                }
                default: {
                    Log.println(false, "CommsThread.sendBootstrapFileWide() Received an unknown bootstrap file request.");
                }
            }
        }
    }

    public void sendDirectory() {
        Log.println(false, "CommsThread.sendDirectory() Seeking directory of: " + this._parent.getWorkingDirectory());
        try {
            this._transport.writeBytes("DIRECTORY OF ");
            this._transport.writeBytes(this._parent.getWorkingDirectory());
            if ((this._parent.getWorkingDirectory().length() + 13) % 40 != 0) {
                this._transport.writeByte('\r');
            }
            this._transport.writeBytes("----------------------------------------");
            if (this.files != null) {
                this.files = null;
            }
            this.files = this._parent.getFiles();
            if (this.files.length > 0) {
                int n = 0;
                int n2 = 0;
                int n3 = (this._parent.getWorkingDirectory().length() + 13) / 40 + 2;
                block2: while (this._shouldRun) {
                    if (n > 0 && n + this.files[n2].length() > 40) {
                        while (n++ < 40) {
                            this._transport.writeByte(' ');
                        }
                        n = 0;
                        ++n3;
                    }
                    if (n3 > 20) {
                        n3 = 0;
                        this._transport.writeByte('\u0000');
                        this._transport.writeByte('\u0001');
                        this._transport.pushBuffer();
                        if (this.waitForData(15) == 0) break;
                    }
                    n3 += this.files[n2].length() / 40;
                    n += this.files[n2].length() % 40;
                    this._transport.writeBytes(this.files[n2]);
                    if (++n2 + 1 <= this.files.length) {
                        do {
                            if (n == 40) {
                                n = 0;
                                ++n3;
                                continue block2;
                            }
                            this._transport.writeByte(' ');
                        } while (++n % 14 > 0);
                        continue;
                    }
                    break;
                }
            } else {
                this._transport.writeBytes("NO FILES");
            }
            this._transport.writeByte('\u0000');
            this._transport.writeByte('\u0000');
            this._transport.pushBuffer();
        }
        catch (Throwable throwable) {
            Log.println(true, "sendDirectory exception:");
            Log.printStackTrace(throwable);
            this._transport.writeBytes("NO FILES");
            this._transport.writeByte('\u0000');
            this._transport.writeByte('\u0000');
            this._transport.pushBuffer();
        }
    }

    public void sendDirectoryWide(byte[] byArray) {
        block19: {
            int n = 18;
            byte[] byArray2 = new byte[1024];
            ByteStream byteStream = new ByteStream(byArray2);
            Log.println(false, "CommsThread.sendDirectoryWide() entry.");
            byte by = 0;
            byte[] byArray3 = this.pullPayloadWide(byArray);
            StringBuffer stringBuffer = new StringBuffer();
            if (byArray3 != null) {
                int n2;
                for (n2 = 0; n2 < byArray3.length - 2; ++n2) {
                    Log.println(false, "CommsThread.sendDirectoryWide() payload[" + n2 + "] " + UnsignedByte.toString(byArray3[n2]));
                    stringBuffer.append((char)(UnsignedByte.intValue(byArray3[n2]) & 0x7F));
                }
                int n3 = UnsignedByte.intValue(byArray3[byArray3.length - 1]);
                Log.println(false, "CommsThread.sendDirectoryWide() value: " + stringBuffer.toString().trim());
                String string = stringBuffer.toString().trim();
                Log.println(false, "CommsThread.sendDirectoryWide() Seeking directory of: " + this._parent.getWorkingDirectory());
                String string2 = this._parent.getWorkingDirectory();
                if (this.files != null) {
                    this.files = null;
                }
                this.files = this._parent.getFiles();
                this.files = string.length() > 0 ? this._parent.getFiles(string) : this._parent.getFiles();
                if (this.files != null) {
                    if (string2.length() <= 66) {
                        string2 = "DIRECTORY OF: " + string2;
                    }
                    if (string2.length() > 80) {
                        string2 = string2.substring(string2.length() - 80, string2.length());
                    } else if (string2.length() < 80) {
                        string2 = string2.concat("\r");
                    }
                    if (string2.length() < 40) {
                        string2 = string2.concat("\r");
                    } else if (string2.length() == 40) {
                        string2 = string2.concat("\r");
                    }
                    for (n2 = 0; n2 < 1024; ++n2) {
                        byArray2[n2] = 0;
                    }
                    try {
                        byteStream.writeBytes(string2);
                        byteStream.writeBytes("----------------------------------------");
                        if (this.files.length > 0) {
                            int n4 = n3 * n;
                            int n5 = n4 + n;
                            by = 1;
                            if (n5 >= this.files.length) {
                                by = 0;
                                n5 = this.files.length;
                            }
                            for (n2 = n4; n2 < n5; ++n2) {
                                String string3 = this.files[n2];
                                if (string3.length() > 40) {
                                    string3 = string3.substring(0, 38).concat("..");
                                }
                                Log.println(false, "CommsThread.sendDirectoryWide() sending name[" + n2 + "]: " + string3);
                                byteStream.writeBytes(string3);
                                if (string3.length() >= 40) continue;
                                byteStream.writeByte('\r');
                            }
                            byteStream.writeByte('\u0000');
                            byteStream.writeByte(by);
                            this.sendPacketWide(byteStream.getBuffer(), n3, 2, 1);
                            break block19;
                        }
                        byteStream.writeBytes("NO FILES");
                        byteStream.writeByte('\u0000');
                        byteStream.writeByte('\u0000');
                        this.sendPacketWide(byteStream.getBuffer(), n3, 2, 1);
                    }
                    catch (Throwable throwable) {
                        Log.println(true, "sendDirectory exception:");
                        Log.printStackTrace(throwable);
                        this._transport.writeByte('\u0000');
                        this._transport.writeByte('\u0000');
                        this._transport.pushBuffer();
                    }
                } else {
                    this._transport.writeByte('\u0000');
                    this._transport.writeByte('\u0000');
                    this._transport.pushBuffer();
                }
            }
        }
    }

    public void queryFileSize() {
        long l = 0L;
        byte by = 0;
        byte by2 = 0;
        byte by3 = -1;
        try {
            String string = this.receiveName();
            Disk disk = null;
            try {
                Log.println(false, "CommsThread.queryFileSize() seeking file " + this._parent.getWorkingDirectory() + string);
                disk = new Disk(this._parent.getWorkingDirectory() + string);
            }
            catch (IOException iOException) {
                try {
                    Log.println(false, "CommsThread.queryFileSize() failed to find that file.");
                    Log.println(false, "CommsThread.queryFileSize() seeking file " + string);
                    disk = new Disk(string);
                    Log.println(false, "CommsThread.queryFileSize() found file " + string);
                }
                catch (IOException iOException2) {
                    Log.println(false, "CommsThread.queryFileSize() can't read file: " + string + ".");
                    by3 = 2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                by3 = 4;
            }
            if (disk == null) {
                if (by3 == -1) {
                    by3 = 2;
                }
            } else if (disk.getImageOrder() == null) {
                by3 = 4;
            } else {
                l = disk.getImageOrder().getClass() == NibbleOrder.class ? 455L : (long)disk.getImageOrder().getBlocksOnDevice();
                by = UnsignedByte.loByte(l);
                by2 = UnsignedByte.hiByte(l);
                by3 = 0;
            }
            if (disk != null) {
                this._parent.setSecondaryText(disk.getFilename());
            } else {
                this._parent.setSecondaryText(string);
            }
            Log.println(false, "CommsThread.queryFileSize() lo:" + UnsignedByte.toString(by) + " hi:" + UnsignedByte.toString(by2));
            this._transport.writeByte(by);
            this._transport.writeByte(by2);
            this._transport.writeByte(by3);
            this._transport.pushBuffer();
        }
        catch (TransportTimeoutException transportTimeoutException) {
            Log.println(false, "CommsThread.queryFileSize() aborting due to timeout.");
        }
        catch (ProtocolVersionException protocolVersionException) {
            Log.println(false, "CommsThread.queryFileSize() aborting due to protocol version exception.");
        }
    }

    public void queryFileSizeWide(byte[] byArray) {
        long l = 0L;
        byte by = 0;
        byte by2 = 0;
        byte by3 = -1;
        StringBuffer stringBuffer = new StringBuffer();
        Log.println(false, "CommsThread.queryFileSizeWide() entry.");
        byte[] byArray2 = this.pullPayloadWide(byArray);
        if (byArray2 != null) {
            String string;
            Log.println(false, "CommsThread.queryFileSizeWide() payload length: " + byArray2.length);
            for (int i = 0; i < byArray2.length && byArray2[i] != 0; ++i) {
                stringBuffer.append((char)(UnsignedByte.intValue(byArray2[i]) & 0x7F));
            }
            if (stringBuffer.charAt(0) == '\u0001') {
                string = this.files[18 * (byArray2[1] - 1) + (byArray2[2] - 3)].trim();
                Log.println(false, "CommsThread.queryFileSizeWide() value: " + string);
            } else {
                Log.println(false, "CommsThread.queryFileSizeWide() value: " + stringBuffer.toString().trim());
                string = stringBuffer.toString().trim();
            }
            Disk disk = null;
            try {
                Log.println(false, "CommsThread.queryFileSizeWide() seeking file " + this._parent.getWorkingDirectory() + string);
                disk = new Disk(this._parent.getWorkingDirectory() + string);
            }
            catch (IOException iOException) {
                try {
                    Log.println(false, "CommsThread.queryFileSizeWide() failed to find that file.");
                    Log.println(false, "CommsThread.queryFileSizeWide() seeking file [" + string + "]");
                    disk = new Disk(string);
                    Log.println(false, "CommsThread.queryFileSizeWide() found file " + string);
                }
                catch (IOException iOException2) {
                    Log.println(false, "CommsThread.queryFileSizeWide() can't read file: " + string + ".");
                    by3 = 2;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                by3 = 4;
            }
            if (disk == null) {
                if (by3 == -1) {
                    by3 = 2;
                }
            } else if (disk.getImageOrder() == null) {
                by3 = 4;
            } else {
                l = disk.getImageOrder().getClass() == NibbleOrder.class ? 455L : (long)disk.getImageOrder().getBlocksOnDevice();
                by = UnsignedByte.loByte(l);
                by2 = UnsignedByte.hiByte(l);
                by3 = 0;
            }
            if (disk != null) {
                this._parent.setSecondaryText(disk.getFilename());
            } else {
                this._parent.setSecondaryText(string);
            }
            Log.println(false, "CommsThread.queryFileSize() lo:" + UnsignedByte.toString(by) + " hi:" + UnsignedByte.toString(by2));
            this._transport.writeByte(by);
            this._transport.writeByte(by2);
            this._transport.writeByte(by3);
            this._transport.pushBuffer();
        }
        Log.println(false, "CommsThread.queryFileSizeWide() exit.");
    }

    public void pullEnvelope() {
        byte[] byArray = new byte[512];
        try {
            Log.println(false, "Waiting for command...");
            byte by = this.waitForData(5);
            Log.println(false, " received command: " + UnsignedByte.toString(by));
            Log.println(false, "Waiting for blocklo...");
            byte by2 = this.waitForData(5);
            Log.println(false, " received blocklo: " + UnsignedByte.toString(by2));
            Log.println(false, "Waiting for blockhi...");
            byte by3 = this.waitForData(5);
            Log.println(false, " received blockhi: " + UnsignedByte.toString(by3));
            Log.println(false, "Waiting for checksum...");
            byte by4 = this.waitForData(5);
            byte by5 = -59;
            by5 = (byte)(by5 ^ by);
            by5 = (byte)(by5 ^ by2);
            by5 = (byte)(by5 ^ by3);
            Log.println(false, " received checksum: " + UnsignedByte.toString(by4) + " calculated checksum: " + UnsignedByte.toString(by5));
            if (by4 == by5) {
                int n;
                String string;
                if (by == 1 || by == 3 || by == 5) {
                    byte by6;
                    string = Messages.getString("CommsThread.25");
                    n = UnsignedByte.intValue(by2, by3);
                    string = StringUtilities.replaceSubstring(string, "%1", "" + n);
                    this._parent.setSecondaryText(string);
                    Log.println(false, "Reading block " + n);
                    this._transport.writeByte(197);
                    this._transport.writeByte(by);
                    this._transport.writeByte(by2);
                    this._transport.writeByte(by3);
                    if (by == 3 || by == 5) {
                        byte[] byArray2 = this.getProDOSDateTime();
                        this._transport.writeByte(byArray2[0]);
                        this._transport.writeByte(byArray2[1]);
                        this._transport.writeByte(byArray2[2]);
                        this._transport.writeByte(byArray2[3]);
                        by6 = -59;
                        by6 = (byte)(by6 ^ by);
                        by6 = (byte)(by6 ^ by2);
                        by6 = (byte)(by6 ^ by3);
                        by6 = (byte)(by6 ^ byArray2[0]);
                        by6 = (byte)(by6 ^ byArray2[1]);
                        by6 = (byte)(by6 ^ byArray2[2]);
                        by6 = (byte)(by6 ^ byArray2[3]);
                        this._transport.writeByte(by6);
                    } else {
                        this._transport.writeByte(by4);
                    }
                    byArray = by == 5 ? this._vdisks.readBlock(2, n) : this._vdisks.readBlock(1, n);
                    this._transport.writeBytes(byArray);
                    by6 = this.checksum(byArray, 512);
                    Log.println(false, "Sending checksum byte " + UnsignedByte.toString(by6));
                    this._transport.writeByte(by6);
                    this._transport.pushBuffer();
                }
                if (by == 2 || by == 4) {
                    int n2;
                    Log.println(false, "Waiting for block data...");
                    for (n2 = 0; n2 < 512; ++n2) {
                        byArray[n2] = this.waitForData(5);
                    }
                    by4 = this.waitForData(5);
                    Log.println(false, "Received buffer:");
                    for (n2 = 0; n2 < 512; ++n2) {
                        if (n2 % 32 == 0 && n2 != 0) {
                            Log.println(false, "");
                        }
                        Log.print(false, UnsignedByte.toString(byArray[n2]) + " ");
                    }
                    Log.println(false, "");
                    if (by4 == this.checksum(byArray, 512)) {
                        string = Messages.getString("CommsThread.26");
                        n = UnsignedByte.intValue(by2, by3);
                        string = StringUtilities.replaceSubstring(string, "%1", "" + n);
                        this._parent.setSecondaryText(string);
                        Log.println(false, "Block checksums matched at " + UnsignedByte.toString(by4));
                        Log.println(false, "Writing block " + UnsignedByte.intValue(by2, by3));
                        n = UnsignedByte.intValue(by2, by3);
                        if (by == 4) {
                            this._vdisks.writeBlock(2, n, byArray);
                        } else {
                            this._vdisks.writeBlock(1, n, byArray);
                        }
                    } else {
                        Log.println(false, "Block checksums did not match.  Received: " + UnsignedByte.toString(by4) + " calculated: " + UnsignedByte.toString(this.checksum(byArray, 512)));
                    }
                    this._transport.writeByte(197);
                    this._transport.writeByte(by);
                    this._transport.writeByte(by2);
                    this._transport.writeByte(by3);
                    this._transport.writeByte(by4);
                    this._transport.pushBuffer();
                }
            } else {
                Log.println(false, "Envelope checksums did not match.");
            }
        }
        catch (TransportTimeoutException transportTimeoutException) {
            Log.println(false, "CommsThread.pullEnvelope() aborting due to timeout.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
        catch (IOException iOException) {
            Log.println(false, "I/O exception occurred.  Can't find Virtual.po?");
            iOException.printStackTrace();
        }
    }

    private byte[] getProDOSDateTime() {
        byte[] byArray = new byte[]{0, 0, 0, 0};
        Calendar calendar = Calendar.getInstance();
        int n = calendar.get(1) - 2000;
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = n5 + n4 * 256;
        int n7 = n3 + n2 * 32 + n * 512;
        byArray[0] = UnsignedByte.loByte(n6);
        byArray[1] = UnsignedByte.hiByte(n6);
        byArray[2] = UnsignedByte.loByte(n7);
        byArray[3] = UnsignedByte.hiByte(n7);
        return byArray;
    }

    public byte checksum(byte[] byArray, int n) {
        int n2 = n;
        byte by = 0;
        if (byArray.length < n) {
            n2 = byArray.length;
        }
        for (int i = 0; i < n2; ++i) {
            by = (byte)(by ^ byArray[i]);
        }
        return by;
    }

    public byte[] pullEnvelopeWide(boolean bl) {
        return this.pullEnvelopeWide(bl, 15);
    }

    public byte[] pullEnvelopeWide(boolean bl, int n) {
        byte by = 0;
        byte by2 = -63;
        byte[] byArray = new byte[]{0, 0, 0};
        Log.println(false, "CommsThread.pullEnvelopeWide() entry.");
        try {
            if (bl) {
                while ((by = this.waitForData(n)) != -63) {
                }
            }
            Log.println(false, "Waiting for byteslo...");
            byte by3 = this.waitForData(5);
            by2 = (byte)(by2 ^ by3);
            Log.println(false, " received byteslo: " + UnsignedByte.toString(by3));
            Log.println(false, "Waiting for byteshi...");
            byte by4 = this.waitForData(5);
            by2 = (byte)(by2 ^ by4);
            Log.println(false, " received byteshi: " + UnsignedByte.toString(by4));
            Log.println(false, "Waiting for command...");
            byte by5 = this.waitForData(5);
            by2 = (byte)(by2 ^ by5);
            Log.println(false, " received envelope command: " + UnsignedByte.toString(by5));
            Log.println(false, "Waiting for check byte...");
            byte by6 = this.waitForData(5);
            Log.println(false, " received checkbyte: " + UnsignedByte.toString(by6));
            Log.println(false, " calculated checkbyte: " + UnsignedByte.toString(by2));
            if (by6 == by2) {
                byArray[0] = by3;
                byArray[1] = by4;
                byArray[2] = by5;
            } else {
                Log.println(false, "CommsThread.pullEnvelopeWide() received ill-formed envelope.");
                this._transport.flushReceiveBuffer();
            }
        }
        catch (TransportTimeoutException transportTimeoutException) {
            Log.println(false, "CommsThread.pullEnvelopeWide() aborting due to timeout.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
        Log.println(false, "CommsThread.pullEnvelopeWide() exit.");
        return byArray;
    }

    public byte[] pullPayloadWide(byte[] byArray) {
        byte[] byArray2 = null;
        byte by = 0;
        int n = byArray[0] + byArray[1] * 256;
        Log.println(false, "CommsThread.pullPayloadWide() entry.");
        if (n > 0) {
            byArray2 = new byte[n];
            try {
                byte by2;
                for (int i = 0; i < n; ++i) {
                    byArray2[i] = by2 = this.waitForData(1);
                    Log.println(false, "CommsThread.pullPayloadWide() payload byte [" + i + "]: " + UnsignedByte.toString(by2));
                    by = (byte)(by ^ by2);
                }
                by2 = this.waitForData(1);
                Log.println(false, "CommsThread.pullPayloadWide() received   checkbyte: " + UnsignedByte.toString(by2));
                Log.println(false, "CommsThread.pullPayloadWide() calculated checkbyte: " + UnsignedByte.toString(by));
                if (by != by2) {
                    Log.println(false, "CommsThread.pullPayloadWide() Got erroneous checkbyte on length.");
                    byArray2 = null;
                } else {
                    Log.println(false, "CommsThread.pullPayloadWide() checkbyte on payload matched.");
                }
            }
            catch (TransportTimeoutException transportTimeoutException) {
                Log.println(false, "CommsThread.pullPayloadWide() Timeout waiting for payload.");
                byArray2 = null;
            }
        }
        return byArray2;
    }

    public void sendHome() {
        Log.println(false, "CommsThread.sendHome() entry.");
        this._transport.writeByte(UnsignedByte.loByte(193));
        this._transport.writeByte(0);
        this._transport.writeByte(0);
        this._transport.writeByte(UnsignedByte.loByte(216));
        this._transport.writeByte(19);
        this._transport.pushBuffer();
        Log.println(false, "CommsThread.sendHome() exit.");
    }

    public void changeDirectory() {
        byte by = 6;
        try {
            String string = this.receiveName();
            if (this._shouldRun) {
                by = this._parent.setWorkingDirectory(string);
                this._transport.writeByte(by);
                this._transport.pushBuffer();
            }
        }
        catch (TransportTimeoutException transportTimeoutException) {
            Log.println(false, "CommsThread.changeDirectory() aborting due to timeout.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
        catch (ProtocolVersionException protocolVersionException) {
            Log.println(false, "CommsThread.changeDirectory() aborting due to protocol mismatch.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
    }

    public void changeDirectoryWide(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        Log.println(false, "CommsThread.changeDirectoryWide() entry.");
        byte[] byArray2 = this.pullPayloadWide(byArray);
        if (byArray2 != null) {
            Log.println(false, "CommsThread.changeDirectoryWide() payload length: " + byArray2.length);
            for (int i = 0; i < byArray2.length; ++i) {
                Log.println(false, "CommsThread.changeDirectoryWide() payload[" + i + "] " + UnsignedByte.toString(byArray2[i]));
                stringBuffer.append((char)(UnsignedByte.intValue(byArray2[i]) & 0x7F));
            }
            Log.println(false, "CommsThread.changeDirectoryWide() value: " + stringBuffer.toString().trim());
            byte by = this._parent.setWorkingDirectory(stringBuffer.toString().trim());
            this._transport.writeByte((int)by);
            this._transport.pushBuffer();
        }
        Log.println(false, "CommsThread.changeDirectoryWide() exit.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveDisk(boolean bl) {
        Log.println(false, "CommsThread.receiveDisk() entry.");
        this._startTime = System.currentTimeMillis();
        try {
            Log.print(false, "Waiting for name...");
            String string = this._parent.getWorkingDirectory() + this.receiveName();
            Log.println(false, " received name: " + string);
            if (!string.equals(lastFileName)) {
                lastFileNumber = 1;
                lastFileName = string;
            }
            File file = null;
            FileOutputStream fileOutputStream = null;
            byte[] byArray = new byte[20480];
            int n = 0;
            int n2 = 0;
            Log.println(false, "Waiting for sizeLo...");
            byte by = this.waitForData(15);
            Log.println(false, " received sizeLo: " + UnsignedByte.toString(by));
            Log.println(false, "Waiting for sizeHi...");
            byte by2 = this.waitForData(15);
            Log.println(false, " received sizeHi: " + UnsignedByte.toString(by2));
            int n3 = UnsignedByte.intValue(by, by2);
            this._parent.setProgressMaximum(n3);
            if (bl) {
                String string2;
                do {
                    String string3 = lastFileNumber < 10 ? "000" : (lastFileNumber < 100 ? "00" : (lastFileNumber < 1000 ? "0" : ""));
                    string2 = string3 + lastFileNumber;
                    file = n3 * 512 == 143360 ? new File(string + string2 + ".dsk") : new File(string + string2 + ".po");
                    ++lastFileNumber;
                } while (file.exists());
                string = n3 * 512 == 143360 ? string + string2 + ".dsk" : string + string2 + ".po";
            } else {
                String string4 = string.toUpperCase();
                if (n3 * 512 == 143360) {
                    if (!string4.endsWith(".DSK") && !string4.endsWith(".DO")) {
                        string = string + ".dsk";
                    }
                } else if (!string4.endsWith(".PO") && !string4.endsWith(".HDV")) {
                    string = string + ".po";
                }
                file = new File(string);
            }
            try {
                fileOutputStream = new FileOutputStream(file);
                this._transport.writeByte(0);
                this._transport.pushBuffer();
                Log.println(false, "CommsThread.receiveDisk() about to wait for ACK from apple...");
                if (this.waitForData(15) == 6) {
                    int n4;
                    int n5;
                    Log.println(false, "receiveDisk() received ACK from apple.");
                    this._parent.setProgressMaximum(n3 * 2);
                    this._parent.setSecondaryText(file.getName());
                    int n6 = n3 / 40;
                    int n7 = n3 % 40;
                    for (n5 = 0; n5 < n6; ++n5) {
                        Log.println(false, "receiveDisk() Receiving part " + (n5 + 1) + " of " + n6 + "; ");
                        for (n4 = 0; n4 < 80 && (n = this.receivePacket(byArray, n4 * 256, n5 * 80 + n4, 1)) == 0; ++n4) {
                            this._parent.setProgressValue(++n2);
                        }
                        if (n != 0) break;
                        Log.println(false, "Writing part " + (n5 + 1) + " of " + n6 + ".");
                        fileOutputStream.write(byArray);
                    }
                    Log.println(false, "CommsThread.receiveDisk() Bottom of for loop... packetResult: " + n);
                    if (n == 0 && n7 > 0) {
                        Log.println(false, "Receiving remainder part.");
                        for (n4 = 0; n4 < n7 * 2 && (n = this.receivePacket(byArray, n4 * 256, n5 * 80 + n4, 1)) == 0; ++n4) {
                            this._parent.setProgressValue(++n2);
                        }
                        if (n == 0) {
                            Log.println(false, "Writing remainder " + n7 + " blocks.");
                            fileOutputStream.write(byArray, 0, n7 * 512);
                        }
                    }
                    fileOutputStream.close();
                    if (n == 0) {
                        Log.println(false, "CommsThread.receiveDisk() length: " + n3 * 512 + " Disk.APPLE_140KB_DISK: " + 143360);
                        if (n3 * 512 == 143360) {
                            Disk disk = new Disk(string, true);
                            disk.makeDosOrder();
                            disk.save();
                            Log.println(false, "CommsThread.receiveDisk() found a 140k disk; saved as DOS order format.");
                        } else {
                            Log.println(false, "CommsThread.receiveDisk() found a disk of length " + n3 * 512 + "; left it alone (didn't change to DOS order), because it expected length " + 143360 + " in order to change to DOS order.");
                        }
                    }
                } else {
                    n = -1;
                }
                if (n == 0) {
                    byte by3 = this.waitForData(60);
                    this._endTime = System.currentTimeMillis();
                    this._diffMillis = (this._endTime - this._startTime) / 1000L;
                    if (by3 == 0) {
                        String string5 = Messages.getString("CommsThread.19");
                        string5 = StringUtilities.replaceSubstring(string5, "%1", file.getName());
                        string5 = StringUtilities.replaceSubstring(string5, "%2", "" + this._diffMillis);
                        this._parent.setSecondaryText(string5);
                        Log.println(true, "Apple sent disk image " + string + " successfully in " + (this._endTime - this._startTime) / 1000L + " seconds.");
                    } else {
                        String string6 = Messages.getString("CommsThread.20");
                        string6 = StringUtilities.replaceSubstring(string6, "%1", file.getName());
                        string6 = StringUtilities.replaceSubstring(string6, "%2", "" + this._diffMillis);
                        this._parent.setSecondaryText(string6);
                        Log.println(true, "Apple sent disk image " + string + " with errors.");
                    }
                } else {
                    Log.println(true, Messages.getString("CommsThread.21"));
                    this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                    this._parent.clearProgress();
                    this._transport.flushReceiveBuffer();
                    this._transport.flushSendBuffer();
                    file.delete();
                    if (bl) {
                        --lastFileNumber;
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this._transport.writeByte(2);
                this._transport.pushBuffer();
            }
            catch (IOException iOException) {
                this._transport.writeByte(2);
                this._transport.pushBuffer();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (TransportTimeoutException transportTimeoutException) {
            Log.println(false, "CommsThread.receiveDisk() aborting due to timeout.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
        catch (ProtocolVersionException protocolVersionException) {
            Log.println(false, "CommsThread.receiveDisk() aborting due to protocol mismatch.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
        Log.println(false, "CommsThread.receiveDisk() exit.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveDiskWide(boolean bl, byte[] byArray) {
        boolean bl2 = true;
        Log.println(false, "CommsThread.receiveDiskWide() entry.");
        this._startTime = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = this.pullPayloadWide(byArray);
        if (byArray2 != null) {
            Log.println(false, "CommsThread.receiveDiskWide() payload length: " + byArray2.length);
            for (int i = 0; i < byArray2.length; ++i) {
                Log.println(false, "CommsThread.receiveDiskWide() payload[" + i + "] " + UnsignedByte.toString(byArray2[i]));
                if (byArray2[i] == 0) break;
                stringBuffer.append((char)(UnsignedByte.intValue(byArray2[i]) & 0x7F));
            }
            Log.println(false, "CommsThread.receiveDiskWide() name: " + stringBuffer.toString().trim());
            String string = stringBuffer.toString().trim();
            String string2 = this._parent.getWorkingDirectory() + string;
            Log.println(false, " received name: " + string2);
            if (!string2.equals(lastFileName)) {
                lastFileNumber = 1;
                lastFileName = string2;
            }
            File file = null;
            FileOutputStream fileOutputStream = null;
            byte[] byArray3 = new byte[65536];
            boolean bl3 = false;
            byte by = 0;
            byte by2 = 0;
            int n = 0;
            int n2 = 0;
            by = byArray2[byArray2.length - 2];
            by2 = byArray2[byArray2.length - 1];
            n = UnsignedByte.intValue(by, by2);
            Log.println(false, " blocks to receive: " + n);
            this._parent.setProgressMaximum(n);
            if (bl) {
                String string3;
                do {
                    String string4 = lastFileNumber < 10 ? "000" : (lastFileNumber < 100 ? "00" : (lastFileNumber < 1000 ? "0" : ""));
                    string3 = string4 + lastFileNumber;
                    file = n * 512 == 143360 ? new File(string2 + string3 + ".dsk") : new File(string2 + string3 + ".po");
                    ++lastFileNumber;
                } while (file.exists());
                string2 = n * 512 == 143360 ? string2 + string3 + ".dsk" : string2 + string3 + ".po";
            } else {
                String string5 = string2.toUpperCase();
                if (n * 512 == 143360) {
                    if (!string5.endsWith(".DSK") && !string5.endsWith(".DO")) {
                        string2 = string2 + ".dsk";
                    }
                } else if (!string5.endsWith(".PO") && !string5.endsWith(".HDV")) {
                    string2 = string2 + ".po";
                }
                file = new File(string2);
            }
            try {
                Object object;
                fileOutputStream = new FileOutputStream(file);
                this._transport.writeByte(0);
                this._transport.pushBuffer();
                this._parent.setProgressMaximum(n);
                this._parent.setSecondaryText(file.getName());
                int n3 = 0;
                do {
                    Log.println(false, "receiveDiskWide() about to wait for a packet.");
                    try {
                        n3 = this.receivePacketWide(byArray3, 0, n2);
                        if (n3 == 0) break;
                        if (n3 == -1) {
                            Log.println(false, "Acknowledged earlier packet at block " + n2 + ".");
                            continue;
                        }
                        this._parent.setProgressValue(n2 += n3 / 512);
                        Log.println(false, "Writing up to block " + n2 + ".");
                        object = new byte[n3];
                        System.arraycopy(byArray3, 0, object, 0, n3);
                        fileOutputStream.write((byte[])object);
                        object = null;
                    }
                    catch (GoHomeException goHomeException) {
                        bl2 = false;
                        bl3 = true;
                    }
                } while (n2 < n && bl2);
                Log.println(false, "CommsThread.receiveDiskWide() finished writing file.");
                fileOutputStream.close();
                if (!bl3) {
                    Log.println(false, "CommsThread.receiveDiskWide() length: " + n * 512 + " Disk.APPLE_140KB_DISK: " + 143360);
                    if (n * 512 == 143360) {
                        object = new Disk(string2, true);
                        object.makeDosOrder();
                        object.save();
                        Log.println(false, "CommsThread.receiveDiskWide() found a 140k disk; saved as DOS order format.");
                    } else {
                        Log.println(false, "CommsThread.receiveDiskWide() found a disk of length " + n * 512 + "; left it alone (didn't change to DOS order), because it expected length " + 143360 + " in order to change to DOS order.");
                    }
                }
                if (!bl3) {
                    byte[] byArray4 = this.pullPayloadWide(this.pullEnvelopeWide(true));
                    int n4 = byArray4 != null && byArray4.length == 1 ? byArray4[0] : 21;
                    this._endTime = System.currentTimeMillis();
                    this._diffMillis = (this._endTime - this._startTime) / 1000L;
                    if (n4 == 0) {
                        object = Messages.getString("CommsThread.19");
                        object = StringUtilities.replaceSubstring((String)object, "%1", file.getName());
                        object = StringUtilities.replaceSubstring((String)object, "%2", "" + this._diffMillis);
                        this._parent.setSecondaryText((String)object);
                        Log.println(true, "Apple sent disk image " + string2 + " successfully in " + (this._endTime - this._startTime) / 1000L + " seconds.");
                    } else {
                        object = Messages.getString("CommsThread.20");
                        object = StringUtilities.replaceSubstring((String)object, "%1", file.getName());
                        object = StringUtilities.replaceSubstring((String)object, "%2", "" + this._diffMillis);
                        this._parent.setSecondaryText((String)object);
                        Log.println(true, "Apple sent disk image " + string2 + " with errors.");
                    }
                } else {
                    Log.println(true, Messages.getString("CommsThread.21"));
                    this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                    this._parent.clearProgress();
                    this._transport.flushReceiveBuffer();
                    this._transport.flushSendBuffer();
                    file.delete();
                    if (bl) {
                        --lastFileNumber;
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this._transport.writeByte(2);
                this._transport.pushBuffer();
            }
            catch (IOException iOException) {
                this._transport.writeByte(2);
                this._transport.pushBuffer();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Log.println(false, "CommsThread.receiveDiskWide() exit.");
    }

    public void sendDisk() {
        Log.println(false, "CommsThread.sendDisk() entry.");
        Log.println(false, "Current working directory: " + this._parent.getWorkingDirectory());
        byte[] byArray = new byte[512];
        int n = 0;
        boolean bl = false;
        this._startTime = System.currentTimeMillis();
        try {
            String string = this.receiveName();
            Disk disk = null;
            try {
                Log.println(false, "CommsThread.sendDisk() looking for file: " + this._parent.getWorkingDirectory() + string);
                disk = new Disk(this._parent.getWorkingDirectory() + string);
            }
            catch (IOException iOException) {
                try {
                    Log.println(false, "CommsThread.sendDisk() Failed to find that file.  Now looking for: " + string);
                    disk = new Disk(string);
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            if (disk != null) {
                if (disk.getImageOrder() != null) {
                    this._transport.writeByte(0);
                    this._transport.pushBuffer();
                    Log.println(false, "CommsThread.sendDisk() about to wait for initial ack.");
                    byte by = this.waitForData(15);
                    Log.println(false, "CommsThread.sendDisk() received initial reply from Apple: " + UnsignedByte.toString(by));
                    if (by == 6) {
                        if (!this._client01xCompatibleProtocol) {
                            this.waitForData(15);
                            this.waitForData(1);
                            this.waitForData(1);
                        }
                        int n2 = disk.getImageOrder().getBlocksOnDevice();
                        this._parent.setProgressMaximum(n2 * 2);
                        this._parent.setSecondaryText(disk.getFilename());
                        Log.println(false, "CommsThread.sendDisk() disk length is " + n2 + " blocks.");
                        for (int i = 0; i < n2; ++i) {
                            byArray = disk.readBlock(i);
                            for (int j = 0; j < 2; ++j) {
                                Log.println(false, "CommsThread.sendDisk() sending packet for block: " + i + " halfBlock: " + (2 - j));
                                bl = this.sendPacket(byArray, i, j * 256, 1);
                                if (!bl) break;
                                this._parent.setProgressValue(++n);
                            }
                            if (!bl) break;
                        }
                        if (bl) {
                            byte by2 = this.waitForData(15);
                            this._endTime = System.currentTimeMillis();
                            this._diffMillis = (this._endTime - this._startTime) / 1000L;
                            if (by2 == 0) {
                                String string2 = Messages.getString("CommsThread.17");
                                string2 = StringUtilities.replaceSubstring(string2, "%1", string);
                                string2 = StringUtilities.replaceSubstring(string2, "%2", "" + this._diffMillis);
                                this._parent.setSecondaryText(string2);
                                Log.println(true, "Apple received disk image " + string + " successfully in " + (float)(this._endTime - this._startTime) / 1000.0f + " seconds.");
                            } else {
                                String string3 = Messages.getString("CommsThread.18");
                                string3 = StringUtilities.replaceSubstring(string3, "%1", string);
                                string3 = StringUtilities.replaceSubstring(string3, "%2", "" + this._diffMillis);
                                this._parent.setSecondaryText(string3);
                                Log.println(true, "Apple received disk image " + string + " with " + by2 + " errors.");
                            }
                        } else {
                            Log.println(true, Messages.getString("CommsThread.21"));
                            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                            this._parent.clearProgress();
                            this._transport.flushReceiveBuffer();
                            this._transport.flushSendBuffer();
                        }
                    } else {
                        this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                        this._parent.clearProgress();
                        this._transport.flushReceiveBuffer();
                        this._transport.flushSendBuffer();
                    }
                } else {
                    this._transport.writeByte(2);
                    this._transport.pushBuffer();
                }
            } else {
                this._transport.writeByte(2);
                this._transport.pushBuffer();
            }
        }
        catch (TransportTimeoutException transportTimeoutException) {
            Log.println(false, "CommsThread.sendDisk() aborting due to timeout.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
        catch (ProtocolVersionException protocolVersionException) {
            Log.println(false, "CommsThread.sendDisk() aborting due to protocol mismatch.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
        Log.println(false, "CommsThread.sendDisk() exit.");
    }

    public void sendDiskWide(byte[] byArray) {
        Log.println(false, "CommsThread.sendDiskWide() entry.");
        Log.println(false, "Current working directory: " + this._parent.getWorkingDirectory());
        byte[] byArray2 = this.pullPayloadWide(byArray);
        boolean bl = false;
        this._startTime = System.currentTimeMillis();
        if (byArray2 != null) {
            String string;
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            Log.println(false, "CommsThread.sendDiskWide() payload length: " + byArray2.length);
            for (n = 0; n < byArray2.length - 1 && byArray2[n] != 0; ++n) {
                stringBuffer.append((char)(UnsignedByte.intValue(byArray2[n]) & 0x7F));
            }
            if (stringBuffer.charAt(0) == '\u0001') {
                string = this.files[18 * (byArray2[1] - 1) + (byArray2[2] - 3)].trim();
                Log.println(false, "CommsThread.sendDiskWide() value: " + string);
            } else {
                Log.println(false, "CommsThread.sendDiskWide() value: " + stringBuffer.toString().trim());
                string = stringBuffer.toString().trim();
            }
            int n2 = byArray2[n + 1];
            Log.println(false, "CommsThread.sendDiskWide() number of blocks to send at once (BAOCNT): " + n2);
            Disk disk = null;
            try {
                Log.println(false, "CommsThread.sendDiskWide() looking for file: " + this._parent.getWorkingDirectory() + string);
                disk = new Disk(this._parent.getWorkingDirectory() + string);
            }
            catch (IOException iOException) {
                try {
                    Log.println(false, "CommsThread.sendDiskWide() Failed to find that file.  Now looking for: " + string);
                    disk = new Disk(string);
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            if (disk != null) {
                if (disk.getImageOrder() != null) {
                    byte by;
                    this._transport.writeByte(0);
                    this._transport.pushBuffer();
                    Log.println(false, "CommsThread.sendDiskWide() about to wait for initial ack.");
                    byte[] byArray3 = this.pullEnvelopeWide(true);
                    byte[] byArray4 = null;
                    if (UnsignedByte.intValue(byArray3[2]) == 203) {
                        byArray4 = this.pullPayloadWide(byArray3);
                        by = byArray4 != null ? byArray4[0] : (byte)24;
                    } else {
                        Log.println(false, "CommsThread.sendDiskWide() Well, adding up the envelope bytes got us zero: " + UnsignedByte.toString(byArray3[2]));
                        by = 24;
                    }
                    Log.println(false, "CommsThread.sendDiskWide() received initial reply from client: " + UnsignedByte.toString(by));
                    if (by == 6) {
                        int n3 = disk.getImageOrder().getBlocksOnDevice();
                        this._parent.setProgressMaximum(n3);
                        this._parent.setSecondaryText(disk.getFilename());
                        Log.println(false, "CommsThread.sendDiskWide() disk length is " + n3 + " blocks.");
                        byte[] byArray5 = new byte[n2 * 512];
                        byte[] byArray6 = new byte[512];
                        int n4 = 0;
                        int n5 = 0;
                        int n6 = 0;
                        while (n6 < n3) {
                            n4 = n6 + n2 > n3 ? n3 - n6 : n2;
                            if (n5 + n2 > 40) {
                                n4 = 40 - n5;
                            }
                            for (int i = 0; i < n4; ++i) {
                                byArray6 = disk.readBlock(n6 + i);
                                System.arraycopy(byArray6, 0, byArray5, i * 512, 512);
                            }
                            Log.println(false, "CommsThread.sendDiskWide() sending packet starting at block: " + n6 + " with a block count (BAOCNT) of: " + n4);
                            bl = this.sendPacketWide(byArray5, n6, n4);
                            if (!bl) break;
                            if ((n5 += n4) == 40) {
                                n5 = 0;
                            }
                            this._parent.setProgressValue(n6 += n4);
                        }
                        if (bl) {
                            this._endTime = System.currentTimeMillis();
                            this._diffMillis = (this._endTime - this._startTime) / 1000L;
                            String string2 = Messages.getString("CommsThread.17");
                            string2 = StringUtilities.replaceSubstring(string2, "%1", string);
                            string2 = StringUtilities.replaceSubstring(string2, "%2", "" + this._diffMillis);
                            this._parent.setSecondaryText(string2);
                            Log.println(true, "Apple received disk image " + string + " successfully in " + (float)(this._endTime - this._startTime) / 1000.0f + " seconds.");
                        } else {
                            Log.println(true, Messages.getString("CommsThread.21"));
                            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                            this._parent.clearProgress();
                            this._transport.flushReceiveBuffer();
                            this._transport.flushSendBuffer();
                        }
                    } else {
                        this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                        this._parent.clearProgress();
                        this._transport.flushReceiveBuffer();
                        this._transport.flushSendBuffer();
                    }
                } else {
                    this._transport.writeByte(2);
                    this._transport.pushBuffer();
                }
            } else {
                this._transport.writeByte(2);
                this._transport.pushBuffer();
            }
        }
        Log.println(false, "CommsThread.sendDiskWide() exit.");
    }

    public void send140kDisk() {
        block18: {
            this._startTime = System.currentTimeMillis();
            try {
                String string = this.receiveName();
                int n = 28672;
                byte[] byArray = new byte[n];
                File file = new File(string);
                int n2 = 0;
                int n3 = 0;
                FileInputStream fileInputStream = null;
                boolean bl = false;
                if (!file.isFile() && !(file = new File(this._parent.getWorkingDirectory() + string)).isFile()) {
                    this._transport.writeByte(26);
                    this._transport.pushBuffer();
                    n2 = -1;
                }
                if (n2 != 0) break block18;
                long l = file.length();
                if (l != 143360L) {
                    Log.println(false, "Not a 140k image for legacy ADT.");
                    this._transport.writeByte(30);
                    this._transport.pushBuffer();
                    n2 = -1;
                    break block18;
                }
                this._parent.setSecondaryText(string);
                this._transport.writeByte(0);
                this._transport.pushBuffer();
                try {
                    byte by = this.waitForData(15);
                    if (by == 6) {
                        int n4;
                        this._parent.setProgressMaximum(560);
                        fileInputStream = new FileInputStream(file);
                        for (n4 = 0; n4 < 5; ++n4) {
                            int n5 = fileInputStream.read(byArray);
                            Log.println(false, " ... read " + n5 + " chars.");
                            for (int i = 0; i < 7; ++i) {
                                Log.print(false, "Reading track " + i);
                                for (int j = 15; j >= 0; --j) {
                                    Log.println(false, "Sending track " + (i + n4 * 7) + " sector " + j + ".");
                                    bl = this.sendPacket(byArray, 0, i * 4096 + j * 256, 0);
                                    if (!bl) break;
                                    this._parent.setProgressValue(++n3);
                                }
                                if (!bl) break;
                            }
                            if (!bl) break;
                        }
                        fileInputStream.close();
                        if (bl) {
                            n4 = this.waitForData(15);
                            this._endTime = System.currentTimeMillis();
                            this._diffMillis = (this._endTime - this._startTime) / 1000L;
                            if (n4 == 0) {
                                String string2 = Messages.getString("CommsThread.19");
                                string2 = StringUtilities.replaceSubstring(string2, "%1", file.getName());
                                string2 = StringUtilities.replaceSubstring(string2, "%2", "" + this._diffMillis);
                                this._parent.setSecondaryText(string2);
                                Log.println(true, "Apple sent disk image " + string + " successfully in " + (float)(this._endTime - this._startTime) / 1000.0f + " seconds.");
                            } else {
                                this._parent.setSecondaryText(Messages.getString("CommsThread.20") + " in " + this._diffMillis + " seconds.");
                                Log.println(true, "Apple sent disk image " + string + " with errors.");
                            }
                        } else {
                            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                            this._transport.flushReceiveBuffer();
                            this._transport.flushSendBuffer();
                        }
                    }
                }
                catch (IOException iOException) {
                    this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                    this._transport.flushReceiveBuffer();
                    this._transport.flushSendBuffer();
                }
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (TransportTimeoutException transportTimeoutException) {
            }
            catch (ProtocolVersionException protocolVersionException) {
                Log.println(false, "CommsThread.send140kDisk() aborting due to protocol mismatch.");
                this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
            }
        }
        Log.println(false, "send140kDisk() exit.");
    }

    public boolean sendPacket(byte[] byArray, int n, int n2, int n3) {
        boolean bl = false;
        int n4 = 0;
        int n5 = 21;
        int n6 = 0;
        Log.println(false, "CommsThread.sendPacket() entry; block to send: " + UnsignedByte.toString(UnsignedByte.hiByte(n)) + "" + UnsignedByte.toString(UnsignedByte.loByte(n)) + " half " + UnsignedByte.loByte(2 - n2 / 256));
        do {
            Log.println(false, "CommsThread.sendPacket() looping until successful to send block: " + UnsignedByte.toString(UnsignedByte.hiByte(n)) + "" + UnsignedByte.toString(UnsignedByte.loByte(n)) + " half " + UnsignedByte.loByte(2 - n2 / 256));
            byte by = 0;
            if (n3 == 1 && !this._client01xCompatibleProtocol) {
                this._transport.writeByte(UnsignedByte.loByte(n));
                this._transport.writeByte(UnsignedByte.hiByte(n));
                this._transport.writeByte(UnsignedByte.loByte(2 - n2 / 256));
            } else if (n3 == 2) {
                this._transport.writeByte(UnsignedByte.loByte(n));
                this._transport.writeByte(UnsignedByte.hiByte(n));
                this._transport.writeByte(2);
            }
            n4 = 0;
            while (n4 < 256) {
                byte by2 = byArray[n2 + n4];
                byte by3 = (byte)(UnsignedByte.intValue(by2) - UnsignedByte.intValue(by));
                by = by2;
                this._transport.writeByte(by3);
                if (UnsignedByte.intValue(by3) > 0) {
                    ++n4;
                } else {
                    while (this._shouldRun && n4 < 256 && byArray[n2 + n4] == by2) {
                        ++n4;
                    }
                    this._transport.writeByte((byte)(n4 & 0xFF));
                }
                if (this._shouldRun) continue;
                bl = false;
                break;
            }
            if (!this._shouldRun) continue;
            int n7 = this.doCrc(byArray, n2, 256);
            this._transport.writeByte((byte)(n7 & 0xFF));
            this._transport.writeByte((byte)((n7 & 0xFF00) >> 8 & 0xFF));
            this._transport.pushBuffer();
            Log.println(false, "CommsThread.sendPacket() calculated CRC: " + (n7 & 0xFFFF));
            try {
                int n8;
                n5 = this.waitForData(15, (byte)6, (byte)21);
                if (n3 == 1 && !this._client01xCompatibleProtocol) {
                    int n9 = 0;
                    n9 = UnsignedByte.intValue(this.waitForData(1));
                    byte by4 = this.waitForData(1);
                    n8 = UnsignedByte.loByte(2 - n2 / 256);
                    Log.println(false, "Apple requested block: " + UnsignedByte.toString(UnsignedByte.hiByte(n9 += UnsignedByte.intValue(this.waitForData(1)) * 256)) + "" + UnsignedByte.toString(UnsignedByte.loByte(n9)) + " half " + by4);
                    if (n5 == 21 && (n == n9 && Math.abs(by4 - n8) == 1 || n + 1 == n9 && Math.abs(by4 - n8) == 1)) {
                        n5 = 6;
                        Log.println(false, "CommsThread.sendPacket() found an old packet; advancing (location 1).");
                    }
                } else if (n3 == 2) {
                    n8 = UnsignedByte.intValue(this.waitForData(15));
                    Log.println(false, "CommsThread.sendPacket() Incoming (send next) Chunk: " + n8);
                    int n10 = UnsignedByte.intValue(this.waitForData(15));
                    Log.println(false, "CommsThread.sendPacket() Incoming (send next) Track: " + n10);
                    byte by5 = this.waitForData(15);
                    Log.println(false, "CommsThread.sendPacket() Check byte received: " + by5);
                    int n11 = n / 256;
                    int n12 = n & 0xFF;
                    Log.println(false, "CommsThread.sendPacket() host (sent) chunk: " + n12 + " host (sent) Track: " + n11);
                    if (n5 == 21) {
                        n5 = 6;
                        Log.println(false, "CommsThread.sendPacket() found an old packet; advancing (location 2).");
                    }
                }
            }
            catch (TransportTimeoutException transportTimeoutException) {
                Log.println(false, "CommsThread.sendPacket() timeout.");
                n5 = 21;
            }
            Log.println(false, "CommsThread.sendPacket() ACK from Apple: " + UnsignedByte.toString(UnsignedByte.loByte(n5)));
            if (n5 == 6) {
                bl = true;
                continue;
            }
            Log.println(false, "CommsThread.sendPacket() didn't work; will retry #" + ++n6 + ".");
            int n13 = 250;
            if (this._transport.transportType() == 3) {
                n13 = 2000;
            }
            try {
                Log.println(true, "CommsThread.sendPacket() block: " + n + " offset: " + n2 + ".");
                Log.println(true, "CommsThread.sendPacket() backoff sleeping for " + n6 * n13 / 1000 + " seconds (or 1 second, whichever is shorter).");
                CommsThread.sleep(Math.min(1000, n6 * n13));
            }
            catch (InterruptedException interruptedException) {
                Log.printStackTrace(interruptedException);
                Log.println(false, "CommsThread.sendPacket() backoff sleep was interrupted.");
            }
            this._transport.flushReceiveBuffer();
        } while (n5 != 6 && this._shouldRun && n6 < this._maxRetries);
        Log.println(false, "CommsThread.sendPacket() exit, rc = " + bl);
        return bl;
    }

    public boolean sendPacketWide(byte[] byArray, int n, int n2) {
        return this.sendPacketWide(byArray, n, n2, 15);
    }

    public boolean sendPacketWide(byte[] byArray, int n, int n2, int n3) {
        boolean bl = false;
        int n4 = 0;
        int n5 = 21;
        int n6 = 0;
        byte by = 0;
        Log.println(false, "CommsThread.sendPacketWide() entry; block to send: " + UnsignedByte.toString(UnsignedByte.hiByte(n)) + "" + UnsignedByte.toString(UnsignedByte.loByte(n)));
        do {
            int n7;
            Log.println(false, "CommsThread.sendPacketWide() looping until successful to send block: " + UnsignedByte.toString(UnsignedByte.hiByte(n)) + "" + UnsignedByte.toString(UnsignedByte.loByte(n)));
            byte by2 = 0;
            this._transport.writeByte(UnsignedByte.loByte(193));
            by = UnsignedByte.loByte(193);
            this._transport.writeByte(UnsignedByte.loByte(n2 * 512));
            by = (byte)(by ^ UnsignedByte.loByte(n2 * 512));
            this._transport.writeByte(UnsignedByte.hiByte(n2 * 512));
            by = (byte)(by ^ UnsignedByte.hiByte(n2 * 512));
            this._transport.writeByte(UnsignedByte.loByte(211));
            by = (byte)(by ^ UnsignedByte.loByte(211));
            this._transport.writeByte(UnsignedByte.loByte(by));
            this._transport.writeByte(UnsignedByte.loByte(n));
            this._transport.writeByte(UnsignedByte.hiByte(n));
            int n8 = 0;
            for (n7 = 0; n7 < n2 * 2; ++n7) {
                n4 = 0;
                while (n4 < 256) {
                    byte by3 = byArray[n8 + n4];
                    byte by4 = (byte)(UnsignedByte.intValue(by3) - UnsignedByte.intValue(by2));
                    by2 = by3;
                    this._transport.writeByte(by4);
                    if (UnsignedByte.intValue(by4) > 0) {
                        ++n4;
                    } else {
                        while (this._shouldRun && n4 < 256 && byArray[n8 + n4] == by3) {
                            ++n4;
                        }
                        this._transport.writeByte((byte)(n4 & 0xFF));
                    }
                    if (this._shouldRun) continue;
                    bl = false;
                    break;
                }
                n8 += n4;
            }
            if (this._shouldRun) {
                int n9 = this.doCrc(byArray, 0, n2 * 512);
                this._transport.writeByte((byte)(n9 & 0xFF));
                this._transport.writeByte((byte)((n9 & 0xFF00) >> 8 & 0xFF));
                this._transport.pushBuffer();
                Log.println(false, "CommsThread.sendPacketWide() calculated CRC: " + (n9 & 0xFFFF));
                byte[] byArray2 = this.pullEnvelopeWide(true, n3);
                byte[] byArray3 = null;
                if (UnsignedByte.intValue(byArray2[2]) == 203) {
                    byArray3 = this.pullPayloadWide(byArray2);
                    if (byArray3 != null) {
                        n5 = byArray3[0];
                        if (n + n2 != UnsignedByte.intValue(byArray3[1], byArray3[2])) {
                            Log.println(false, "CommsThread.sendPacketWide() Ack received for block " + UnsignedByte.intValue(byArray3[1], byArray3[2]) + ", but we were expecting an ack for block " + (n + n2) + ".");
                            n5 = 21;
                        } else {
                            Log.println(false, "CommsThread.sendPacketWide() Ack received; next block should be " + (n + n2) + ".");
                        }
                    } else {
                        n5 = 24;
                    }
                } else if (UnsignedByte.intValue(byArray2[2]) == 216) {
                    Log.println(false, "CommsThread.sendPacketWide() received home request; client is aborting.");
                    n5 = 24;
                } else {
                    Log.println(false, "CommsThread.sendPacketWide() Well, ack envelope was unexpected: " + UnsignedByte.toString(byArray2[2]));
                    n5 = 21;
                }
            }
            Log.println(false, "CommsThread.sendPacketWide() ACK from client: " + UnsignedByte.toString(UnsignedByte.loByte(n5)));
            if (n5 == 6) {
                bl = true;
                continue;
            }
            if (n5 == 24) {
                n6 = this._maxRetries + 1;
                bl = false;
                continue;
            }
            Log.println(false, "CommsThread.sendPacketWide() didn't work; will retry #" + ++n6 + ".");
            n7 = 250;
            if (this._transport.transportType() == 3) {
                n7 = 2000;
            }
            try {
                Log.println(true, "CommsThread.sendPacketWide() block: " + n + ".");
                Log.println(true, "CommsThread.sendPacketWide() backoff sleeping for " + n6 * n7 / 1000 + " seconds (or 1 second, whichever is shorter).");
                CommsThread.sleep(Math.min(1000, n6 * n7));
            }
            catch (InterruptedException interruptedException) {
                Log.printStackTrace(interruptedException);
                Log.println(false, "CommsThread.sendPacketWide() backoff sleep was interrupted.");
            }
            this._transport.flushReceiveBuffer();
        } while (n5 != 6 && this._shouldRun && n6 < this._maxRetries);
        Log.println(false, "CommsThread.sendPacketWide() exit, rc = " + bl);
        return bl;
    }

    public void sendNibbleDisk(boolean bl) {
        Log.println(false, "CommsThread.sendNibbleDisk() entry.");
        Log.println(false, "Current working directory: " + this._parent.getWorkingDirectory());
        int n = 0;
        boolean bl2 = false;
        this._startTime = System.currentTimeMillis();
        try {
            String string = this.receiveName();
            Disk disk = null;
            try {
                Log.println(false, "CommsThread.sendNibbleDisk() looking for file: " + this._parent.getWorkingDirectory() + string);
                disk = new Disk(this._parent.getWorkingDirectory() + string);
            }
            catch (IOException iOException) {
                try {
                    Log.println(false, "CommsThread.sendNibbleDisk() Failed to find that file.  Now looking for: " + string);
                    disk = new Disk(string);
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            if (disk != null) {
                if (disk.getImageOrder() != null && disk.getImageOrder().getClass() == NibbleOrder.class) {
                    int n2;
                    int n3;
                    this._transport.writeByte(0);
                    this._transport.pushBuffer();
                    boolean bl3 = false;
                    byte[] byArray = disk.getDiskImageManager().getDiskImage();
                    for (n3 = 0; n3 < byArray.length; ++n3) {
                        if (bl3) {
                            if ((byArray[n3] == UnsignedByte.loByte(213) || byArray[n3] == UnsignedByte.loByte(222)) && n3 + 1 < byArray.length && byArray[n3 + 1] == UnsignedByte.loByte(170)) {
                                bl3 = false;
                            } else {
                                byArray[n3] = 127;
                            }
                        }
                        if (n3 + 3 < byArray.length && byArray[n3] == UnsignedByte.loByte(127) && byArray[n3 + 1] == UnsignedByte.loByte(127) && byArray[n3 + 2] == UnsignedByte.loByte(127) && byArray[n3 + 3] == UnsignedByte.loByte(127)) {
                            n3 += 3;
                            bl3 = true;
                            continue;
                        }
                        if (!(n3 + 4 < byArray.length && byArray[n3] == UnsignedByte.loByte(126) && byArray[n3 + 1] == UnsignedByte.loByte(127) && byArray[n3 + 2] == UnsignedByte.loByte(127) && byArray[n3 + 3] == UnsignedByte.loByte(127) && byArray[n3 + 4] == UnsignedByte.loByte(127) || byArray[n3] == UnsignedByte.loByte(124) && byArray[n3 + 1] == UnsignedByte.loByte(127) && byArray[n3 + 2] == UnsignedByte.loByte(127) && byArray[n3 + 3] == UnsignedByte.loByte(127) && byArray[n3 + 4] == UnsignedByte.loByte(127) || byArray[n3] == UnsignedByte.loByte(121) && byArray[n3 + 1] == UnsignedByte.loByte(126) && byArray[n3 + 2] == UnsignedByte.loByte(127) && byArray[n3 + 3] == UnsignedByte.loByte(127) && byArray[n3 + 4] == UnsignedByte.loByte(127) || byArray[n3] == UnsignedByte.loByte(115) && byArray[n3 + 1] == UnsignedByte.loByte(124) && byArray[n3 + 2] == UnsignedByte.loByte(127) && byArray[n3 + 3] == UnsignedByte.loByte(127) && byArray[n3 + 4] == UnsignedByte.loByte(127) || byArray[n3] == UnsignedByte.loByte(103) && byArray[n3 + 1] == UnsignedByte.loByte(121) && byArray[n3 + 2] == UnsignedByte.loByte(126) && byArray[n3 + 3] == UnsignedByte.loByte(127) && byArray[n3 + 4] == UnsignedByte.loByte(127) || byArray[n3] == UnsignedByte.loByte(79) && byArray[n3 + 1] == UnsignedByte.loByte(115) && byArray[n3 + 2] == UnsignedByte.loByte(124) && byArray[n3 + 3] == UnsignedByte.loByte(127) && byArray[n3 + 4] == UnsignedByte.loByte(127)) && (byArray[n3] != UnsignedByte.loByte(31) || byArray[n3 + 1] != UnsignedByte.loByte(103) || byArray[n3 + 2] != UnsignedByte.loByte(121) || byArray[n3 + 3] != UnsignedByte.loByte(126) || byArray[n3 + 4] != UnsignedByte.loByte(127))) continue;
                        n3 += 4;
                        bl3 = true;
                    }
                    Log.println(true, "Rearranging disk image");
                    boolean bl4 = false;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    byte[] byArray2 = new byte[232960];
                    for (n2 = 0; n2 < 35; ++n2) {
                        n4 = 0;
                        n5 = 0;
                        n6 = 0;
                        n7 = 0;
                        int n8 = n2 * 6656;
                        bl4 = false;
                        for (n3 = 0; n3 < 6656; ++n3) {
                            if (byArray[n8 + n3] == UnsignedByte.loByte(127)) {
                                if (bl4) {
                                    ++n4;
                                    continue;
                                }
                                n4 = 1;
                                bl4 = true;
                                n5 = n8 + n3;
                                continue;
                            }
                            if (bl4 && n4 > n6) {
                                n6 = n4;
                                n7 = n5;
                            }
                            bl4 = false;
                        }
                        if (n4 > n6) {
                            n6 = n4;
                            n7 = n5;
                        }
                        int n9 = n8;
                        if (n6 > 26) {
                            n9 = n7 + 17;
                            n7 += 17;
                        }
                        for (n3 = 0; n3 < 6656; ++n3) {
                            if (n9 + n3 >= 6656 + n8) {
                                n9 -= 6656;
                            }
                            try {
                                byArray2[n8 + n3] = byArray[n9 + n3];
                                continue;
                            }
                            catch (Throwable throwable) {
                                Log.println(true, "Oops! trackbuf[" + (n8 + n3) + "]= buffer[" + (n9 + n3) + "]");
                            }
                        }
                    }
                    for (n2 = 0; n2 < 35; ++n2) {
                        Log.println(false, "Dumping out track " + n2 + ": (zero-based)");
                        for (n3 = 0; n3 < 6656; ++n3) {
                            Log.print(false, UnsignedByte.toString(byArray2[n2 * 6656 + n3]));
                        }
                        Log.println(false, "");
                    }
                    Log.println(false, "CommsThread.sendNibbleDisk() disk length is: " + byArray2.length);
                    Log.println(false, "CommsThread.sendNibbleDisk() about to wait for initial ack.");
                    byte by = this.waitForData(15);
                    Log.println(false, "CommsThread.sendNibbleDisk() received initial reply from Apple: " + UnsignedByte.toString(by));
                    if (by == 6) {
                        this.waitForData(15);
                        this.waitForData(15);
                        this.waitForData(15);
                        this._parent.setProgressMaximum(910);
                        this._parent.setSecondaryText(disk.getFilename());
                        for (n2 = 0; n2 < 35; ++n2) {
                            for (int i = 0; i < 26; ++i) {
                                Log.println(false, "CommsThread.sendNibbleDisk() sending packet for chunk: " + i);
                                bl2 = this.sendPacket(byArray2, n2 * 256 + i, n2 * 6656 + i * 256, 2);
                                if (!bl2) break;
                                this._parent.setProgressValue(++n);
                            }
                            if (!bl2) break;
                        }
                        if (bl2) {
                            byte by2 = this.waitForData(15);
                            this._endTime = System.currentTimeMillis();
                            this._diffMillis = (this._endTime - this._startTime) / 1000L;
                            if (by2 == 0) {
                                String string2 = Messages.getString("CommsThread.17");
                                string2 = StringUtilities.replaceSubstring(string2, "%1", string);
                                string2 = StringUtilities.replaceSubstring(string2, "%2", "" + this._diffMillis);
                                this._parent.setSecondaryText(string2);
                                Log.println(true, "Apple received disk image " + string + " successfully in " + (float)(this._endTime - this._startTime) / 1000.0f + " seconds.");
                            } else {
                                String string3 = Messages.getString("CommsThread.18");
                                string3 = StringUtilities.replaceSubstring(string3, "%1", string);
                                string3 = StringUtilities.replaceSubstring(string3, "%2", "" + this._diffMillis);
                                this._parent.setSecondaryText(string3);
                                Log.println(true, "Apple received disk image " + string + " with " + by2 + " errors.");
                            }
                        } else {
                            Log.println(true, Messages.getString("CommsThread.21"));
                            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                            this._parent.clearProgress();
                            this._transport.flushReceiveBuffer();
                            this._transport.flushSendBuffer();
                        }
                    } else {
                        this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                        this._parent.clearProgress();
                        this._transport.flushReceiveBuffer();
                        this._transport.flushSendBuffer();
                    }
                } else {
                    this._transport.writeByte(2);
                    this._transport.pushBuffer();
                }
            } else {
                this._transport.writeByte(2);
                this._transport.pushBuffer();
            }
        }
        catch (TransportTimeoutException transportTimeoutException) {
            Log.println(false, "CommsThread.sendNibbleDisk() aborting due to timeout.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
        catch (ProtocolVersionException protocolVersionException) {
            Log.println(false, "CommsThread.sendNibbleDisk() aborting due to protocol mismatch.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
        Log.println(false, "CommsThread.sendNibbleDisk() exit.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveNibbleDisk(boolean bl, int n) {
        boolean bl2 = true;
        Log.println(false, "CommsThread.receiveNibbleDisk() entry.");
        this._startTime = System.currentTimeMillis();
        try {
            Log.print(false, "Waiting for name...");
            String string = this._parent.getWorkingDirectory() + this.receiveName();
            Log.println(false, " received name: " + string);
            if (!string.equals(lastNibName)) {
                lastNibNumber = 1;
                lastNibName = string;
            }
            File file = null;
            FileOutputStream fileOutputStream = null;
            NibbleTrack nibbleTrack = null;
            int n2 = 0;
            byte[] byArray = new byte[13312];
            if (bl) {
                do {
                    String string2 = lastNibNumber < 10 ? "000" : (lastNibNumber < 100 ? "00" : (lastNibNumber < 1000 ? "0" : ""));
                    String string3 = string2 + lastNibNumber;
                    file = new File(string + string3 + ".nib");
                    ++lastNibNumber;
                } while (file.exists());
            } else {
                String string4 = string.toUpperCase();
                if (n == 35) {
                    if (!string4.endsWith(".NIB")) {
                        string = string + ".nib";
                    }
                } else if (!string4.endsWith(".V2D")) {
                    string = string + ".v2d";
                }
                file = new File(string);
            }
            try {
                byte by;
                fileOutputStream = new FileOutputStream(file);
                this._transport.writeByte(0);
                this._transport.pushBuffer();
                Log.println(false, "CommsThread.receiveNibbleDisk() about to wait for ACK from apple...");
                if (bl) {
                    byte by2 = this.waitForData(1);
                    by2 = this.waitForData(1);
                }
                if ((by = this.waitForData(15)) == 6) {
                    Log.println(false, "receiveNibbleDisk() received ACK from apple.");
                    this._parent.setProgressMaximum(n * 52);
                    this._parent.setSecondaryText(string);
                    int n3 = 52;
                    for (int i = 0; i < n; ++i) {
                        int n4;
                        for (n4 = 0; n4 < n3; ++n4) {
                            Log.println(false, "receiveNibbleDisk() Receiving part " + (n4 + 1) + " of " + n3 + "; ");
                            n2 = this.receivePacket(byArray, n4 * 256, -1, 2);
                            if (n2 != 0) break;
                            this._parent.setProgressValue(i * 52 + n4 + 1);
                        }
                        Log.println(false, "Dumping out raw track " + i + ": (zero-based; first try)");
                        for (int j = 0; j < 6656; ++j) {
                            Log.print(false, UnsignedByte.toString(byArray[j]));
                        }
                        Log.println(false, "");
                        NibbleTrack nibbleTrack2 = NibbleAnalysis.analyzeNibbleBuffer(byArray);
                        if (nibbleTrack2 != null) {
                            if (nibbleTrack2.accuracy < 0.9) {
                                Log.println(false, "CommsThread.receiveNibbleDisk() asking to re-send track; accuracy was low.");
                                this._transport.writeByte((byte)5);
                                this._transport.pushBuffer();
                                if (bl2) {
                                    for (n4 = 0; n4 < n3; ++n4) {
                                        Log.println(false, "receiveNibbleDisk() Re-receiving part " + (n4 + 1) + " of " + n3 + "; ");
                                        n2 = this.receivePacket(byArray, n4 * 256, -1, 2);
                                        if (n2 != 0) {
                                            bl2 = false;
                                            break;
                                        }
                                        this._parent.setProgressValue(i * 52 + n4 + 1);
                                    }
                                    nibbleTrack = NibbleAnalysis.analyzeNibbleBuffer(byArray);
                                    Log.println(false, "receiveNibbleDisk() accuracies: realTrack1: " + nibbleTrack2.accuracy + " realTrack2: " + nibbleTrack.accuracy);
                                    if (nibbleTrack.accuracy > nibbleTrack2.accuracy) {
                                        Log.println(false, "receiveNibbleDisk() swapping due to better accuracy in second run.");
                                        nibbleTrack2 = nibbleTrack;
                                    }
                                }
                            } else {
                                Log.println(false, "CommsThread.receiveNibbleDisk() successfully received track.");
                            }
                        } else {
                            Log.println(true, "Unable to analyze track number " + i + " (decimal; zero-based).");
                        }
                        if (!bl2) break;
                        Log.println(false, "Acknowledging track number " + i + " (decimal; zero-based).");
                        this._transport.writeByte((byte)6);
                        this._transport.pushBuffer();
                        Log.println(false, "Writing track " + (i + 1) + " of 35.");
                        fileOutputStream.write(nibbleTrack2.trackBuffer);
                        Log.println(false, "CommsThread.receiveNibbleDisk() Bottom of for loop... packetResult: " + n2);
                    }
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    Log.println(false, "CommsThread.receiveNibbleDisk() closing.");
                    Log.println(false, "CommsThread.receiveNibbleDisk() saved as NIB order format.");
                } else {
                    Log.println(false, "CommsThread.receiveNibbleDisk() received " + by + " when expecting " + 6 + ".");
                    n2 = -1;
                }
                if (n2 == 0) {
                    byte by3 = this.waitForData(15);
                    this._endTime = System.currentTimeMillis();
                    this._diffMillis = (this._endTime - this._startTime) / 1000L;
                    if (by3 == 0) {
                        String string5 = Messages.getString("CommsThread.19");
                        string5 = StringUtilities.replaceSubstring(string5, "%1", file.getName());
                        string5 = StringUtilities.replaceSubstring(string5, "%2", "" + this._diffMillis);
                        this._parent.setSecondaryText(string5);
                        Log.println(true, "Apple sent disk image " + string + " successfully in " + (this._endTime - this._startTime) / 1000L + " seconds.");
                    } else {
                        this._parent.setSecondaryText(Messages.getString("CommsThread.20") + " in " + this._diffMillis + " seconds.");
                        Log.println(true, "Apple sent disk image " + string + " with errors.");
                    }
                } else {
                    Log.println(true, Messages.getString("CommsThread.21"));
                    this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                    this._parent.clearProgress();
                    this._transport.flushReceiveBuffer();
                    this._transport.flushSendBuffer();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this._transport.writeByte(2);
                this._transport.pushBuffer();
            }
            catch (IOException iOException) {
                this._transport.writeByte(2);
                this._transport.pushBuffer();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (TransportTimeoutException transportTimeoutException) {
            Log.println(false, "CommsThread.receiveNibbleDisk() aborting due to timeout.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
        catch (ProtocolVersionException protocolVersionException) {
            Log.println(false, "CommsThread.receiveNibbleDisk() aborting due to protocol mismatch.");
            this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
        }
        Log.println(false, "CommsThread.receiveNibbleDisk() exit.");
    }

    boolean getTrackAck(int n) {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = 0;
        while (!bl2) {
            if (n3 == 5) {
                bl2 = true;
                continue;
            }
            try {
                n2 = this.waitForData(15);
                if (n2 == n) {
                    bl = true;
                    Log.println(false, "CommsThread.getTrackAck() expected and received track " + n2);
                } else {
                    Log.println(false, "CommsThread.getTrackAck() was expecting track " + n + "but got track " + n2);
                }
                bl2 = true;
            }
            catch (TransportTimeoutException transportTimeoutException) {
                this._transport.writeByte((byte)8);
                this._transport.pushBuffer();
                ++n3;
            }
        }
        if (n3 == 5) {
            Log.println(false, "CommsThread.getTrackAck() timed out.");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveNibbleDiskWide(boolean bl, byte[] byArray) {
        boolean bl2 = true;
        Log.println(false, "CommsThread.receiveNibbleDiskWide() entry.");
        this._startTime = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray2 = this.pullPayloadWide(byArray);
        if (byArray2 != null) {
            Log.println(false, "CommsThread.receiveNibbleDiskWide() payload length: " + byArray2.length);
            for (int i = 0; i < byArray2.length; ++i) {
                Log.println(false, "CommsThread.receiveNibbleDiskWide() payload[" + i + "] " + UnsignedByte.toString(byArray2[i]));
                if (byArray2[i] == 0) break;
                stringBuffer.append((char)(UnsignedByte.intValue(byArray2[i]) & 0x7F));
            }
            Log.println(false, "CommsThread.receiveNibbleDiskWide() name: " + stringBuffer.toString().trim());
            String string = stringBuffer.toString().trim();
            String string2 = this._parent.getWorkingDirectory() + string;
            Log.println(false, " received name: " + string2);
            if (!string2.equals(lastFileName)) {
                lastFileNumber = 1;
                lastFileName = string2;
            }
            File file = null;
            FileOutputStream fileOutputStream = null;
            byte[] byArray3 = new byte[13312];
            byte by = 0;
            byte by2 = 0;
            int n = 0;
            by = byArray2[byArray2.length - 2];
            by2 = byArray2[byArray2.length - 1];
            n = UnsignedByte.intValue(by, by2);
            Log.println(false, " blocks to receive: " + n);
            this._parent.setProgressMaximum(35);
            NibbleTrack[] nibbleTrackArray = new NibbleTrack[2];
            if (bl) {
                do {
                    String string3 = lastNibNumber < 10 ? "000" : (lastNibNumber < 100 ? "00" : (lastNibNumber < 1000 ? "0" : ""));
                    String string4 = string3 + lastNibNumber;
                    file = new File(string2 + string4 + ".nib");
                    ++lastNibNumber;
                } while (file.exists());
            } else {
                String string5 = string2.toUpperCase();
                if (!string5.endsWith(".NIB")) {
                    string2 = string2 + ".nib";
                }
                file = new File(string2);
            }
            this._parent.setSecondaryText(file.getName());
            try {
                fileOutputStream = new FileOutputStream(file);
                this._transport.writeByte(0);
                this._transport.pushBuffer();
                for (int i = 0; i < 35; ++i) {
                    int n2 = 0;
                    double d = 0.0;
                    try {
                        boolean bl3 = this.receiveNibbleTrackWide(byArray3, i);
                        if (bl3) {
                            nibbleTrackArray[n2] = NibbleAnalysis.analyzeNibbleBuffer(byArray3);
                            d = nibbleTrackArray[n2].accuracy;
                            ++n2;
                            if (d < 0.9) {
                                this._transport.writeByte((byte)5);
                                this._transport.pushBuffer();
                                bl3 = this.receiveNibbleTrackWide(byArray3, i);
                                if (bl3) {
                                    nibbleTrackArray[n2] = NibbleAnalysis.analyzeNibbleBuffer(byArray3);
                                    d = nibbleTrackArray[n2].accuracy;
                                    ++n2;
                                    this._transport.writeByte((byte)6);
                                    this._transport.pushBuffer();
                                }
                            } else {
                                this._transport.writeByte((byte)6);
                                this._transport.pushBuffer();
                            }
                        } else {
                            bl2 = false;
                        }
                        if (!bl2) break;
                        if (nibbleTrackArray[1] != null) {
                            if (nibbleTrackArray[1].accuracy > nibbleTrackArray[0].accuracy) {
                                fileOutputStream.write(nibbleTrackArray[1].trackBuffer);
                            } else {
                                fileOutputStream.write(nibbleTrackArray[0].trackBuffer);
                            }
                        } else {
                            fileOutputStream.write(nibbleTrackArray[0].trackBuffer);
                        }
                        this._parent.setProgressValue(i + 1);
                        continue;
                    }
                    catch (GoHomeException goHomeException) {
                        bl2 = false;
                        break;
                    }
                }
                fileOutputStream.flush();
                fileOutputStream.close();
                Log.println(false, "CommsThread.receiveNibbleDiskWide() closing.");
                Log.println(false, "CommsThread.receiveNibbleDiskWide() saved as NIB order format.");
                if (bl2) {
                    this.pullPayloadWide(this.pullEnvelopeWide(true));
                    boolean bl4 = false;
                    this._endTime = System.currentTimeMillis();
                    this._diffMillis = (this._endTime - this._startTime) / 1000L;
                    if (!bl4) {
                        String string6 = Messages.getString("CommsThread.19");
                        string6 = StringUtilities.replaceSubstring(string6, "%1", file.getName());
                        string6 = StringUtilities.replaceSubstring(string6, "%2", "" + this._diffMillis);
                        this._parent.setSecondaryText(string6);
                        Log.println(true, "Apple sent disk image " + string2 + " successfully in " + (this._endTime - this._startTime) / 1000L + " seconds.");
                    } else {
                        this._parent.setSecondaryText(Messages.getString("CommsThread.20") + " in " + this._diffMillis + " seconds.");
                        Log.println(true, "Apple sent disk image " + string2 + " with errors.");
                    }
                } else {
                    Log.println(true, Messages.getString("CommsThread.21"));
                    this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                    this._parent.clearProgress();
                    this._transport.flushReceiveBuffer();
                    this._transport.flushSendBuffer();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                this._transport.writeByte(2);
                this._transport.pushBuffer();
            }
            catch (IOException iOException) {
                this._transport.writeByte(2);
                this._transport.pushBuffer();
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        Log.println(false, "CommsThread.receiveNibbleDiskWide() exit.");
    }

    public boolean receiveNibbleTrackWide(byte[] byArray, int n) throws GoHomeException {
        boolean bl = true;
        byte[] byArray2 = new byte[65536];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Log.println(false, "receiveNibbleTrackWide() entry.");
        do {
            if ((n3 = this.receivePacketWide(byArray2, 0, n4)) == 0) {
                bl = false;
                continue;
            }
            if (n3 == -1) {
                Log.println(false, "receiveNibbleTrackWide() skipping 512 bytes due to duplicate acknowledgement.");
                continue;
            }
            Log.println(false, "receiveNibbleTrackWide() adding " + n3 + " bytes to the track buffer, now at length " + (n3 + n2) + " bytes.");
            System.arraycopy(byArray2, 0, byArray, n2, n3);
            n2 += n3;
            n4 += n3 / 512;
        } while (bl && n2 < 13312);
        Log.println(false, "receiveNibbleTrackWide() exit; rc=" + bl);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive140kDisk() {
        block29: {
            this._startTime = System.currentTimeMillis();
            try {
                int n;
                String string = this._parent.getWorkingDirectory() + this.receiveName();
                String string2 = string.toUpperCase();
                if (!string2.endsWith(".DSK") && !string2.endsWith(".DO")) {
                    string = string + ".dsk";
                }
                File file = new File(string);
                FileOutputStream fileOutputStream = null;
                byte[] byArray = new byte[28672];
                int n2 = -1;
                int n3 = 0;
                if (file.exists()) {
                    this._transport.writeByte(28);
                    this._transport.pushBuffer();
                    break block29;
                }
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                if (fileOutputStream == null) break block29;
                this._parent.setSecondaryText(string);
                for (n = 0; n < byArray.length; ++n) {
                    byArray[n] = 0;
                }
                try {
                    for (n = 0; n < 7; ++n) {
                        fileOutputStream.write(byArray);
                    }
                    fileOutputStream.close();
                    this._transport.writeByte(0);
                    this._transport.pushBuffer();
                    fileOutputStream = new FileOutputStream(file);
                    while (this.waitForData(15) != 6) {
                        Log.println(true, "hrm, not getting an ACK from the Apple...");
                    }
                    this._parent.setProgressMaximum(560);
                    for (int i = 0; i < 5; ++i) {
                        for (int j = 0; j < 7; ++j) {
                            for (int k = 15; k >= 0 && (n2 = this.receivePacket(byArray, j * 4096 + k * 256, -1, 0)) == 0; --k) {
                                this._parent.setProgressValue(++n3);
                            }
                            if (n2 != 0) break;
                        }
                        fileOutputStream.write(byArray);
                        if (n2 != 0) break;
                    }
                    fileOutputStream.close();
                    Disk disk = new Disk(string);
                    disk.save();
                    Log.println(false, "CommsThread.receive140kDisk() saved as DOS order format.");
                    if (n2 == 0) {
                        byte by = this.waitForData(15);
                        this._endTime = System.currentTimeMillis();
                        this._diffMillis = (this._endTime - this._startTime) / 1000L;
                        if (by == 0) {
                            String string3 = Messages.getString("CommsThread.19");
                            string3 = StringUtilities.replaceSubstring(string3, "%1", file.getName());
                            string3 = StringUtilities.replaceSubstring(string3, "%2", "" + this._diffMillis);
                            this._parent.setSecondaryText(string3);
                            Log.println(true, "Apple sent disk image " + string + " successfully in " + (float)(this._endTime - this._startTime) / 1000.0f + " seconds.");
                        } else {
                            this._parent.setSecondaryText(Messages.getString("CommsThread.20") + " in " + this._diffMillis + " seconds.");
                            Log.println(true, "Received disk image " + string + " with errors.");
                        }
                    } else {
                        this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
                        this._transport.flushReceiveBuffer();
                        this._transport.flushSendBuffer();
                    }
                }
                catch (IOException iOException) {
                    this._transport.writeByte(26);
                    this._transport.pushBuffer();
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            catch (TransportTimeoutException transportTimeoutException) {
                Log.println(true, "receive140kDisk() aborting due to timeout.");
                this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
            }
            catch (ProtocolVersionException protocolVersionException) {
                Log.println(false, "CommsThread.receive140kDisk() aborting due to protocol mismatch.");
                this._parent.setSecondaryText(Messages.getString("CommsThread.21"));
            }
        }
        Log.println(false, "receive140kDisk() exit.");
    }

    public int receivePacket(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        int n9 = 0;
        boolean bl = false;
        Log.println(false, "CommsThread.receivePacket() entry; offset " + n + ", buffNum = " + n2 + ", preamble style = " + n3 + ".");
        do {
            Log.println(false, "CommsThread.receivePacket() top of receivePacket loop.");
            n9 = 0;
            int n10 = 0;
            bl = false;
            if (n3 == 2 || n3 == 1 && !this._client01xCompatibleProtocol || this._transport.transportType() == 2 || this._transport.transportType() == 3) {
                try {
                    int n11 = n2 / 2;
                    int n12 = n2 % 2;
                    n7 = UnsignedByte.intValue(this.waitForData(15, UnsignedByte.loByte(n11)));
                    n7 += UnsignedByte.intValue(this.waitForData(1, UnsignedByte.hiByte(n11))) * 256;
                    by = this.waitForData(1);
                    n8 = Math.abs(2 - by);
                    if (n3 == 1) {
                        Log.println(false, "ProDOS-style preamble checking in force.");
                        Log.println(false, "CommsThread.receivePacket() BlockNum: " + n11 + " local lsb: " + UnsignedByte.toString(UnsignedByte.loByte(n11)) + " Incoming lsb: " + UnsignedByte.toString(UnsignedByte.loByte(n7)) + " halfNum: " + n12 + " Incoming halfNum: " + n8);
                        if (n7 != n11 || n8 != n12) {
                            if (n7 == n11 - 1 && n8 == 1 - n12) {
                                n9 = -2;
                                Log.println(false, "Block numbers were close (full); acknowledging.");
                                this._transport.pauseIncorrectCRC();
                            } else if (n7 == n11 && n8 == 1 - n12) {
                                n9 = -2;
                                Log.println(false, "Block numbers were close (half); acknowledging.");
                                this._transport.pauseIncorrectCRC();
                            } else {
                                n9 = -1;
                                Log.println(false, "Block numbers didn't match.");
                                this._transport.pauseIncorrectCRC();
                            }
                        }
                    } else if (n3 == 2) {
                        Log.println(false, "Nibble-style preamble checking in force.");
                        Log.println(false, "CommsThread.receivePacket() Track: " + UnsignedByte.toString(UnsignedByte.hiByte(n7)) + " Sector: " + UnsignedByte.toString(UnsignedByte.loByte(n7)) + " Check: " + UnsignedByte.toString(UnsignedByte.loByte(by)));
                        if (by != 2) {
                            n9 = -1;
                            this._transport.pauseIncorrectCRC();
                        }
                        n11 = n2 / 2;
                        if (n2 == UnsignedByte.loByte(n7) + 1) {
                            n9 = -1;
                            Log.println(false, "Chunk numbers were close; acknowledging.");
                            this._transport.pauseIncorrectCRC();
                        }
                    } else {
                        n9 = 0;
                    }
                }
                catch (TransportTimeoutException transportTimeoutException) {
                    n9 = -1;
                    Log.println(true, "CommsThread.receivePacket() TransportTimeoutException! (location 1)");
                }
            }
            if (n9 == 0) {
                int n13 = 0;
                while (n13 < 256) {
                    try {
                        by = this.waitForData(15);
                        if (UnsignedByte.intValue(by) > 0) {
                            n10 = (byte)(n10 + UnsignedByte.intValue(by));
                            byArray[n + n13++] = n10;
                        } else {
                            by = this.waitForData(1);
                            do {
                                byArray[n + n13++] = n10;
                            } while (this._shouldRun && n13 < 256 && n13 != UnsignedByte.intValue(by));
                        }
                        if (this._shouldRun) continue;
                        n9 = -1;
                        break;
                    }
                    catch (TransportTimeoutException transportTimeoutException) {
                        n9 = -1;
                        Log.println(true, "CommsThread.receivePacket() TransportTimeoutException! (location 2)");
                        break;
                    }
                }
                if (this._shouldRun && !bl && n9 == 0) {
                    Log.println(false, "Receiving CRC bytes...");
                    try {
                        by2 = this.waitForData(1);
                        by3 = this.waitForData(1);
                        n5 = UnsignedByte.intValue(by2, by3);
                        n6 = this.doCrc(byArray, n, 256);
                        if (n5 != n6) {
                            n9 = -1;
                            Log.println(true, "Incorrect CRC. Computed: " + n6 + " Received: " + n5);
                            this._transport.pauseIncorrectCRC();
                        } else {
                            Log.println(false, "Correct CRC. Computed: " + n6 + " Received: " + n5);
                            n9 = 0;
                        }
                    }
                    catch (TransportTimeoutException transportTimeoutException) {
                        Log.println(true, "CommsThread.receivePacket() TransportTimeoutException! (location 3)");
                        n9 = -1;
                    }
                }
            }
            if (n9 == 0) {
                this._transport.writeByte((byte)6);
                this._transport.pushBuffer();
                this._transport.flushReceiveBuffer();
                this._transport.flushSendBuffer();
                continue;
            }
            if (n9 == -2) {
                this._transport.writeByte((byte)6);
                this._transport.pushBuffer();
                this._transport.flushReceiveBuffer();
                this._transport.flushSendBuffer();
                ++n4;
                Log.println(false, "CommsThread.receivePacket() didn't work - out-of-sync packet received.");
                continue;
            }
            Log.println(false, "CommsThread.receivePacket() didn't work; will retry #" + ++n4 + ".");
            int n14 = 500;
            if (this._transport.transportType() == 3) {
                n14 = 2000;
            }
            try {
                Log.println(true, "CommsThread.receivePacket() block: " + n2 / 2 + " offset: " + n + ".");
                Log.println(true, "CommsThread.receivePacket() backoff sleeping for " + n4 * n14 / 1000 + " seconds.");
                CommsThread.sleep(n4 * n14);
            }
            catch (InterruptedException interruptedException) {
                Log.printStackTrace(interruptedException);
                Log.println(false, "CommsThread.receivePacket() audio backoff sleep was interrupted.");
            }
            this._transport.writeByte((byte)21);
            this._transport.pushBuffer();
            this._transport.flushReceiveBuffer();
            this._transport.flushSendBuffer();
        } while (n9 != 0 && this._shouldRun && n4 < this._maxRetries);
        Log.println(false, "CommsThread.receivePacket() exit.");
        return n9;
    }

    public int receivePacketWide(byte[] byArray, int n) throws GoHomeException {
        return this.receivePacketWide(byArray, n, -1);
    }

    public int receivePacketWide(byte[] byArray, int n, int n2) throws GoHomeException {
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        int n7 = 0;
        int n8 = 0;
        Log.println(false, "CommsThread.receivePacketWide() entry; expected start block: " + n2 + " buffer offset: " + n + ".");
        do {
            int n9;
            block22: {
                Log.println(false, "CommsThread.receivePacketWide() top of receivePacketWide loop.");
                n7 = 0;
                int n10 = 0;
                byte[] byArray2 = this.pullEnvelopeWide(true);
                if ((byArray2[0] | byArray2[1] | byArray2[2]) != 0 && UnsignedByte.intValue(byArray2[2]) != 216) {
                    n9 = byArray2[0] + byArray2[1] * 256;
                    Log.println(false, "CommsThread.receivePacketWide() expecting to read " + n9 + " bytes after RLE decompression.");
                    try {
                        n8 = 0;
                        n8 += UnsignedByte.intValue(this.waitForData(1));
                        Log.println(false, "CommsThread.receivePacketWide() incoming block is " + (n8 += UnsignedByte.intValue(this.waitForData(1)) * 256) + ".");
                        block5: for (n3 = 0; n3 < byArray2[1]; ++n3) {
                            int n11 = 0;
                            while (n11 < 256) {
                                by = this.waitForData(1);
                                if (UnsignedByte.intValue(by) > 0) {
                                    n10 = (byte)(n10 + UnsignedByte.intValue(by));
                                    if (n2 < 0 || n2 == n8) {
                                        byArray[n + n3 * 256 + n11++] = n10;
                                    } else {
                                        ++n11;
                                    }
                                } else {
                                    by = this.waitForData(1);
                                    do {
                                        if (n2 < 0 || n2 == n8) {
                                            byArray[n + n3 * 256 + n11++] = n10;
                                            continue;
                                        }
                                        ++n11;
                                    } while (this._shouldRun && n11 < 256 && n11 != UnsignedByte.intValue(by));
                                }
                                if (this._shouldRun) continue;
                                n7 = 0;
                                continue block5;
                            }
                        }
                        by2 = this.waitForData(1);
                        by3 = this.waitForData(1);
                        n5 = UnsignedByte.intValue(by2, by3);
                        if (n2 < 0 || n2 == n8) {
                            n6 = this.doCrc(byArray, n, n9);
                            if (n5 != n6) {
                                n7 = 0;
                                Log.println(true, "Incorrect CRC. Computed: " + n6 + " Received: " + n5);
                                this._transport.pauseIncorrectCRC();
                            } else {
                                Log.println(false, "Correct CRC. Computed: " + n6 + " Received: " + n5);
                                n7 = n9;
                            }
                        } else {
                            n7 = n9;
                        }
                        break block22;
                    }
                    catch (TransportTimeoutException transportTimeoutException) {
                        n7 = 0;
                        Log.println(true, "CommsThread.receivePacket() TransportTimeoutException! (location 2)");
                        break;
                    }
                }
                if (UnsignedByte.intValue(byArray2[2]) == 216) {
                    Log.println(false, "CommsThread.receivePacketWide() told to go home.");
                    throw new GoHomeException();
                }
            }
            if (n7 == 0) {
                Log.println(false, "CommsThread.receivePacketWide() didn't work; will retry #" + ++n4 + ".");
                n9 = 500;
                if (this._transport.transportType() == 3) {
                    n9 = 2000;
                }
                try {
                    Log.println(true, "CommsThread.receivePacketWide() offset: " + n + ".");
                    Log.println(true, "CommsThread.receivePacketWide() backoff sleeping for " + n4 * n9 / 1000 + " seconds.");
                    CommsThread.sleep(n4 * n9);
                }
                catch (InterruptedException interruptedException) {
                    Log.printStackTrace(interruptedException);
                    Log.println(false, "CommsThread.receivePacketWide() audio backoff sleep was interrupted.");
                }
                this._transport.flushReceiveBuffer();
                this._transport.writeByte((byte)21);
                this._transport.pushBuffer();
                this._transport.flushSendBuffer();
                continue;
            }
            this._transport.writeByte((byte)6);
            this._transport.pushBuffer();
            this._transport.flushReceiveBuffer();
            this._transport.flushSendBuffer();
        } while (n7 == 0 && this._shouldRun && n4 < this._maxRetries);
        if (n2 > -1 && n8 < n2) {
            n7 = -1;
        }
        Log.println(false, "CommsThread.receivePacketWide() exit, bytesReceived = " + n7);
        return n7;
    }

    public byte waitForData(int n, byte by, byte by2) throws TransportTimeoutException {
        byte by3;
        Log.println(false, "CommsThread.waitForData(two bytes) entry, expecting " + by + " or " + by2);
        if (this._transport.transportType() == 3) {
            by3 = this.waitForData(n);
            Log.println(false, "CommsThread.waitForData(two bytes) received byte " + by3);
            for (int i = 0; by3 != by && by3 != by2 && i < 6; ++i) {
                by3 = this.waitForData(n);
            }
        } else {
            by3 = this.waitForData(n);
        }
        return by3;
    }

    public byte waitForData(int n, byte by) throws TransportTimeoutException {
        byte by2;
        Log.println(false, "CommsThread.waitForData(one byte) entry, expecting " + by);
        if (this._transport.transportType() == 3) {
            by2 = this.waitForData(n);
            for (int i = 0; by2 != by && i < 6; ++i) {
                by2 = this.waitForData(n);
            }
        } else {
            by2 = this.waitForData(n);
        }
        return by2;
    }

    public byte waitForData(int n) throws TransportTimeoutException {
        byte by = 0;
        boolean bl = false;
        while (!bl && this._shouldRun) {
            try {
                if (this._transport != null) {
                    by = this._transport.readByte(n);
                    bl = true;
                    continue;
                }
                this._shouldRun = false;
            }
            catch (TransportTimeoutException transportTimeoutException) {
                throw transportTimeoutException;
            }
            catch (Exception exception) {
                Log.printStackTrace(exception);
            }
        }
        return by;
    }

    public String receiveName() throws TransportTimeoutException, ProtocolVersionException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 256 && this._shouldRun; ++i) {
            byte by = this.waitForData(15);
            int n = UnsignedByte.intValue(by);
            if (n <= 127 && i == 0) {
                Log.println(false, "CommsThread.receiveName() found the protocol MSB - value: " + n);
                n = by;
                by = this.waitForData(15);
                int n2 = UnsignedByte.intValue(by);
                Log.println(false, "CommsThread.receiveName() found the protocol LSB - value: " + n2);
                by = this.waitForData(15);
                if (by == 0) {
                    Log.println(false, "CommsThread.receiveName() found the zero byte.  Sending ACK...");
                    this._transport.writeByte((byte)6);
                    this._transport.pushBuffer();
                    this._protocolVersion = n * 256 + n2;
                    Log.println(false, "CommsThread.receiveName() back to receiving the first name byte...");
                    by = this.waitForData(15);
                } else {
                    throw new ProtocolVersionException("CommsThread.receiveName() found an incompatible protocol version.");
                }
            }
            if (by == 0) break;
            stringBuffer.append((char)(UnsignedByte.intValue(by) & 0x7F));
        }
        Log.println(false, "CommsThread.receiveName() received name: [" + stringBuffer.toString() + "]");
        return new String(stringBuffer);
    }

    public int doCrc(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = n3 << 8 & 0xFF00 ^ this.CRCTABLE[((n3 & 0xFF00) >> 8 ^ byArray[n + i]) & 0xFF] & 0xFFFF;
        }
        return n3;
    }

    void makeCrcTable() {
        for (int i = 0; i < 256; ++i) {
            int n = i << 8;
            for (int j = 0; j < 8; ++j) {
                n = (n & 0x8000) != 0 ? n << 1 ^ 0x1021 : n << 1;
            }
            this.CRCTABLE[i] = n;
        }
    }

    public int requestSend(String string) {
        return this.requestSend(string, false, 0, 0);
    }

    public int requestSend(String string, boolean bl, int n, int n2) {
        String string2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl2 = false;
        Log.println(false, "CommsThread.requestSend() request: " + string + ", reallySend = " + bl);
        InputStream inputStream = null;
        if (this._transport.transportType() == 3) {
            string2 = string.equals(Messages.getString("Gui.BS.ProDOS")) ? "org/adtpro/resources/PD.raw" : (string.equals(Messages.getString("Gui.BS.DOS")) ? "org/adtpro/resources/EsDOS1.raw" : (string.equals(Messages.getString("Gui.BS.DOS2")) ? "org/adtpro/resources/EsDOS2.raw" : (string.equals(Messages.getString("Gui.BS.ADT")) ? "org/adtpro/resources/adt.raw" : (string.equals(Messages.getString("Gui.BS.ADTPro")) ? "org/adtpro/resources/adtpro.raw" : (string.equals(Messages.getString("Gui.BS.ADTProAudio")) ? "org/adtpro/resources/adtproaud.raw" : (string.equals(Messages.getString("Gui.BS.ADTProEthernet")) ? "org/adtpro/resources/adtproeth.raw" : "'CommsThread.requestSend() - not set! (AudioTransport)'"))))));
        } else if (string.equals(Messages.getString("Gui.BS.ProDOSVSDrive"))) {
            string2 = "org/adtpro/resources/grub_vsdrive.dmp";
            n4 = 4;
            n5 = 0;
        } else if (string.equals(Messages.getString("Gui.BS.VSDriveRaw"))) {
            string2 = "org/adtpro/resources/vsdrive_speed.raw";
            n4 = 0;
            n5 = 0;
            bl2 = true;
        } else if (string.equals(Messages.getString("Gui.BS.BSpeed"))) {
            string2 = "org/adtpro/resources/BSpeed.raw";
            n4 = 0;
            n5 = 0;
            bl2 = true;
        } else if (string.equals(Messages.getString("Gui.BS.ProDOSFast"))) {
            string2 = "org/adtpro/resources/grub2.dmp";
            n4 = 4;
            n5 = 0;
        } else if (string.equals(Messages.getString("Gui.BS.ProDOS"))) {
            string2 = "org/adtpro/resources/PD.dmp";
            n4 = 4;
            n5 = 0;
        } else if (string.equals(Messages.getString("Gui.BS.DOS"))) {
            string2 = "org/adtpro/resources/EsDOS.dmp";
            n4 = 3;
            n5 = 0;
        } else if (string.equals(Messages.getString("Gui.BS.ProDOSRaw"))) {
            string2 = "org/adtpro/resources/PDSpeed.raw";
            n4 = 0;
            n5 = 0;
            bl2 = true;
        } else if (string.equals(Messages.getString("Gui.BS.SOS"))) {
            string2 = "org/adtpro/resources/SOSLoader.raw";
            n4 = 0;
            n5 = 0;
            bl2 = true;
        } else if (string.equals(Messages.getString("Gui.BS.SOSKERNEL"))) {
            string2 = "org/adtpro/resources/SK.raw";
            n4 = 0;
            n5 = 0;
            bl2 = true;
        } else if (string.equals(Messages.getString("Gui.BS.SOSINTERP"))) {
            string2 = "org/adtpro/resources/adtsos.raw";
            n4 = 0;
            n5 = 0;
            bl2 = true;
        } else if (string.equals(Messages.getString("Gui.BS.SOSDRIVER"))) {
            string2 = "org/adtpro/resources/SD.raw";
            n4 = 0;
            n5 = 0;
            bl2 = true;
        } else if (string.equals(Messages.getString("Gui.BS.ADT"))) {
            string2 = "org/adtpro/resources/adt.dmp";
            n4 = 5;
            n5 = 4;
        } else if (string.equals(Messages.getString("Gui.BS.ADTPro"))) {
            string2 = "org/adtpro/resources/adtpro.dmp";
            n4 = 5;
            n5 = 4;
        } else if (string.equals(Messages.getString("Gui.BS.ADTProRaw"))) {
            string2 = "org/adtpro/resources/adtpro.raw";
            n4 = 0;
            n5 = 0;
            bl2 = true;
        } else if (string.equals(Messages.getString("Gui.BS.ADTProAudio"))) {
            string2 = "org/adtpro/resources/adtproaud.dmp";
            n4 = 5;
            n5 = 4;
        } else if (string.equals(Messages.getString("Gui.BS.ADTProEthernet"))) {
            string2 = "org/adtpro/resources/adtproeth.dmp";
            n4 = 5;
            n5 = 4;
        } else {
            string2 = "'CommsThread.requestSend() - not set! (non-AudioTransport)'";
        }
        Log.println(false, "CommsThread.requestSend() seeking resource named " + string2);
        inputStream = ADTPro.class.getClassLoader().getResourceAsStream(string2);
        if (inputStream != null) {
            try {
                n3 = inputStream.available();
            }
            catch (IOException iOException) {
                Log.printStackTrace(iOException);
            }
            if (bl) {
                if (this._worker != null) {
                    this._worker.interrupt();
                }
                Log.println(false, "CommsThread.requestSend() Reading " + string2);
                this._parent.setMainText(Messages.getString("CommsThread.4"));
                this._parent.setSecondaryText(string2);
                this._worker = new Worker(this._parent, string, inputStream, n, n2, n4, n5, bl2);
                this._worker.start();
            } else {
                Log.println(false, "CommsThread.requestSend() found file sized " + n3 + " bytes.");
            }
        } else {
            Log.println(true, "Unable to find resource named " + string2 + " to send.");
        }
        return n3;
    }

    public void requestStop() {
        Log.println(false, "CommsThread.requestStop() entry.");
        this._shouldRun = false;
        if (this._worker != null) {
            this._worker.interrupt();
        }
        try {
            Log.println(false, "CommsThread.requestStop() about to close transport.");
            this._transport.close();
        }
        catch (Exception exception) {
            Log.printStackTrace(exception);
        }
        Log.println(false, "CommsThread.requestStop() exit.");
    }

    public boolean isBusy() {
        return this._busy;
    }

    public int transportType() {
        return this._transport.transportType();
    }

    public boolean supportsBootstrap() {
        return this._transport.supportsBootstrap();
    }

    public void setHardwareHandshaking(boolean bl) {
        if (this._transport.transportType() == 1) {
            try {
                ((SerialTransport)this._transport).setHardwareHandshaking(bl);
            }
            catch (SerialPortException serialPortException) {
                Log.println(true, "Unable to set hardware handshaking.");
                serialPortException.printStackTrace();
            }
        }
    }

    public void setSpeed(int n) {
        if (this._transport.transportType() == 1) {
            try {
                Log.println(false, "CommsThread.setSpeed() Attempting to set the serial port's speed to " + n);
                ((SerialTransport)this._transport).setSpeed(n);
                Log.println(false, "CommsThread.setSpeed() successful.");
            }
            catch (Exception exception) {
                Log.printStackTrace(exception);
                Log.println(true, "CommsThread.setSpeed() failed to set the port speed to " + n + ".");
            }
        }
    }

    public void setParms(String string, int n, boolean bl) {
        if (this._transport.transportType() == 1) {
            try {
                ((SerialTransport)this._transport).setParms(string, n, bl);
            }
            catch (Exception exception) {
                Log.printStackTrace(exception);
                Log.println(true, "CommsThread.setParms() failed to set the port parameters.");
            }
        }
    }

    public void setAudioParms() {
        if (this._transport.transportType() == 3) {
            try {
                ((AudioTransport)this._transport).setAudioParms();
            }
            catch (Exception exception) {
                Log.printStackTrace(exception);
                Log.println(true, "CommsThread.setParms() failed to set audio parameters.");
            }
        }
    }

    public String getInstructions(String string, int n, int n2) {
        return this._transport.getInstructions(string, n, n2);
    }

    public class Worker
    extends Thread {
        InputStream _is;
        int _speed;
        int _pacing;
        int _slowFirst = 0;
        int _slowLast = 0;
        String _resource = null;

        public Worker(Gui gui, String string, InputStream inputStream, int n, int n2, int n3, int n4, boolean bl) {
            Log.println(false, "CommsThread Worker inner class instantiation.");
            Log.println(false, "CommsThread Worker Pacing = " + n + ", speed = " + n2);
            CommsThread.this._parent = gui;
            this._is = inputStream;
            this._pacing = n;
            this._speed = n2;
            this._slowFirst = n3;
            this._slowLast = n4;
            this._resource = string;
            CommsThread.this._isBinary = bl;
        }

        @Override
        public void run() {
            Log.println(false, "CommsThread.Worker.run() entry.");
            CommsThread.this._startTime = System.currentTimeMillis();
            CommsThread.this._busy = true;
            if (CommsThread.this._transport.transportType() == 3) {
                try {
                    int n;
                    int n2 = this._is.available();
                    CommsThread.this._parent.setProgressMaximum(n2);
                    byte[] byArray = new byte[n2];
                    Log.println(false, "CommsThread.Worker.run() read " + n + " bytes from the stream.");
                    for (n = this._is.read(byArray); n < n2; n += this._is.read(byArray, n, n2 - n)) {
                        Log.println(false, "CommsThread.Worker.run() read " + n + " bytes from the stream.");
                    }
                    ((AudioTransport)CommsThread.this._transport).writeBigBytes(byArray);
                    ((AudioTransport)CommsThread.this._transport).pushBigBuffer(CommsThread.this._parent);
                    String string = CommsThread.this._transport.getInstructionsDone(this._resource);
                    if (!string.equals("")) {
                        CommsThread.this._parent.requestSendFinished(string);
                    }
                }
                catch (Exception exception) {
                    Log.printStackTrace(exception);
                }
            } else {
                try {
                    Object object;
                    int n = this._is.available();
                    CommsThread.this._transport.setSlowSpeed(this._speed);
                    CommsThread.this._parent.setProgressMaximum(n);
                    if (CommsThread.this._isBinary) {
                        int n3;
                        int n4;
                        object = new byte[n];
                        Log.println(false, "CommsThread.Worker.run() read " + n4 + " bytes from the stream.");
                        for (n4 = this._is.read((byte[])object); n4 < n; n4 += this._is.read((byte[])object, n4, n - n4)) {
                            Log.println(false, "CommsThread.Worker.run() read " + n4 + " more bytes from the stream.");
                        }
                        if (this._resource.equals(Messages.getString("Gui.BS.SOSINTERP")) || this._resource.equals(Messages.getString("Gui.BS.ProDOSRaw")) || this._resource.equals(Messages.getString("Gui.BS.BSpeed")) || this._resource.equals(Messages.getString("Gui.BS.ADTProRaw")) || this._resource.equals(Messages.getString("Gui.BS.VSDriveRaw")) || this._resource.equals(Messages.getString("Gui.BS.SOSDRIVER"))) {
                            n3 = ((byte[])object).length;
                            Log.println(false, "CommsThread.Worker.run() writing length header of 0x" + Integer.toHexString(n3) + ".");
                            if (this._resource.equals(Messages.getString("Gui.BS.SOSINTERP")) || this._resource.equals(Messages.getString("Gui.BS.SOSDRIVER"))) {
                                CommsThread.this._transport.writeByte(83);
                                CommsThread.this._transport.pushBuffer();
                                Worker.sleep(20L);
                            } else if (this._resource.equals(Messages.getString("Gui.BS.ProDOSRaw"))) {
                                CommsThread.this._transport.writeByte(80);
                            } else if (this._resource.equals(Messages.getString("Gui.BS.ADTProRaw"))) {
                                CommsThread.this._transport.writeByte(65);
                            } else if (this._resource.equals(Messages.getString("Gui.BS.VSDriveRaw"))) {
                                CommsThread.this._transport.writeByte(86);
                            } else if (this._resource.equals(Messages.getString("Gui.BS.BSpeed"))) {
                                CommsThread.this._transport.writeByte(66);
                            }
                            CommsThread.this._transport.writeByte(UnsignedByte.loByte(n3));
                            CommsThread.this._transport.writeByte(UnsignedByte.hiByte(n3));
                        }
                        for (n3 = 0; n3 < ((byte[])object).length; ++n3) {
                            if (!CommsThread.this._shouldRun) {
                                Log.println(false, "CommsThread.Worker.run() told to stop.");
                                break;
                            }
                            CommsThread.this._transport.writeByte(object[n3]);
                            if ((this._resource.equals(Messages.getString("Gui.BS.SOSKERNEL")) || this._resource.equals(Messages.getString("Gui.BS.SOSINTERP")) || this._resource.equals(Messages.getString("Gui.BS.SOSDRIVER"))) && n3 < 2) {
                                Worker.sleep(1L);
                            }
                            CommsThread.this._transport.pushBuffer();
                            if (!CommsThread.this._shouldRun) continue;
                            CommsThread.this._parent.setProgressValue(n3 + 1);
                        }
                    } else {
                        int n5;
                        int n6;
                        object = new char[n];
                        InputStreamReader inputStreamReader = new InputStreamReader(this._is);
                        Log.println(false, "CommsThread.Worker.run() read " + n6 + " bytes from the stream.");
                        for (n6 = inputStreamReader.read((char[])object); n6 < n; n6 += inputStreamReader.read((char[])object, n6, n - n6)) {
                            Log.println(false, "CommsThread.Worker.run() read " + n6 + " more bytes from the stream.");
                        }
                        Log.println(false, "commsThread.Worker.run() speed = " + this._speed + " pacing = " + this._pacing);
                        int n7 = 0;
                        for (n5 = 0; n5 < ((byte[])object).length; ++n5) {
                            if (object[n5] != 13) continue;
                            ++n7;
                        }
                        n5 = 0;
                        int n8 = 500;
                        if (n8 < this._pacing) {
                            n8 = this._pacing;
                        }
                        for (int i = 0; i < ((byte[])object).length; ++i) {
                            if (!CommsThread.this._shouldRun) {
                                Log.println(false, "CommsThread.Worker.run() told to stop.");
                                break;
                            }
                            if (object[i] == 13) {
                                block41: {
                                    CommsThread.this._transport.writeByte(141);
                                    CommsThread.this._transport.pushBuffer();
                                    try {
                                        if (this._slowFirst > n5 || n5 > n7 - this._slowLast) {
                                            Worker.sleep(n8);
                                        } else {
                                            Worker.sleep(Integer.parseInt(((CommsThread)CommsThread.this)._parent._properties.getProperty("CommPortBootstrapPacing", "250")));
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        Log.printStackTrace(interruptedException);
                                        Log.println(false, "CommsThread.Worker.run() interrupted.");
                                        if (CommsThread.this._shouldRun) break block41;
                                        Log.println(false, "CommsThread.Worker.run() told to stop, again...");
                                        break;
                                    }
                                }
                                ++n5;
                            } else if (object[i] != 10) {
                                CommsThread.this._transport.writeByte((char)object[i]);
                            }
                            if (!CommsThread.this._shouldRun) continue;
                            CommsThread.this._parent.setProgressValue(i + 1);
                        }
                    }
                    if (CommsThread.this._shouldRun) {
                        CommsThread.this._transport.pushBuffer();
                        CommsThread.this._endTime = System.currentTimeMillis();
                        CommsThread.this._diffMillis = (CommsThread.this._endTime - CommsThread.this._startTime) / 1000L;
                        CommsThread.this._parent.setSecondaryText(Messages.getString("CommsThread.22") + " in " + CommsThread.this._diffMillis + " seconds.");
                        Log.println(true, "Text file sent in " + (CommsThread.this._endTime - CommsThread.this._startTime) / 1000L + " seconds.");
                        object = CommsThread.this._transport.getInstructionsDone(this._resource);
                        if (!((String)object).equals("")) {
                            CommsThread.this._parent.requestSendFinished((String)object);
                        }
                    }
                }
                catch (Exception exception) {
                    Log.printStackTrace(exception);
                }
            }
            if (CommsThread.this._shouldRun) {
                CommsThread.this._transport.flushReceiveBuffer();
            }
            CommsThread.this._transport.setFullSpeed();
            CommsThread.this._busy = false;
            Log.println(false, "CommsThread.Worker.run() exit.");
        }

        public void requestStop() {
            CommsThread.this._shouldRun = false;
            CommsThread.this._busy = false;
        }

        public void setPacing(int n) {
            this._pacing = n;
        }
    }
}

