/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit.io;

import com.webcodepro.shrinkit.CRC16;
import com.webcodepro.shrinkit.io.ByteConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;

public class LittleEndianByteInputStream
extends InputStream
implements ByteConstants {
    private InputStream inputStream;
    private long bytesRead = 0L;
    private CRC16 crc = new CRC16();

    public LittleEndianByteInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public LittleEndianByteInputStream(byte[] byArray) {
        this.inputStream = new ByteArrayInputStream(byArray);
    }

    public int read() throws IOException {
        int n = this.inputStream.read();
        if (n != -1) {
            this.crc.update(n);
            ++this.bytesRead;
        }
        return n;
    }

    public int readByte() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new IOException("Expecting a byte but at EOF");
        }
        return n;
    }

    public byte[] readBytes(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = this.inputStream.read(byArray);
        this.bytesRead += (long)n2;
        if (n == 0 && n2 == -1) {
            n2 = 0;
        }
        if (n2 < n) {
            throw new IOException("Requested " + n + " bytes, but " + n2 + " read");
        }
        this.crc.update(byArray);
        return byArray;
    }

    public int seekFileType() throws IOException {
        return this.seekFileType(6);
    }

    public int seekFileType(int n) throws IOException {
        int n2;
        byte[] byArray = new byte[2048];
        byte[] byArray2 = new byte[6];
        byte[] byArray3 = new byte[4];
        byte[] byArray4 = new byte[3];
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < byArray.length; ++n2) {
            byArray[n2] = 0;
        }
        for (n2 = 0; n2 < n; ++n2) {
            byArray[n2] = (byte)this.readByte();
        }
        while (n4 < byArray.length - n) {
            if (n == 6) {
                System.arraycopy(byArray, n4, byArray2, 0, NUFILE_ID.length);
                if (Arrays.equals(byArray2, NUFILE_ID)) {
                    n3 = 1;
                    break;
                }
            }
            System.arraycopy(byArray, n4, byArray3, 0, NUFX_ID.length);
            System.arraycopy(byArray, n4, byArray4, 0, BXY_ID.length);
            if (Arrays.equals(byArray3, NUFX_ID)) {
                n3 = 2;
                break;
            }
            if (Arrays.equals(byArray4, BXY_ID)) {
                n3 = 3;
                break;
            }
            byArray[n4 + n] = (byte)this.readByte();
            ++n4;
        }
        return n3;
    }

    public int readWord() throws IOException {
        return (this.readByte() | this.readByte() << 8) & 0xFFFF;
    }

    public long readLong() throws IOException {
        long l = this.readByte();
        long l2 = this.readByte();
        long l3 = this.readByte();
        long l4 = this.readByte();
        return l | l2 << 8 | l3 << 16 | l4 << 24;
    }

    public Date readDate() throws IOException {
        byte[] byArray = this.readBytes(8);
        if (Arrays.equals(TIMEREC_NULL, byArray)) {
            return null;
        }
        int n = byArray[3] + 1900;
        if (n < 1940) {
            n += 100;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, byArray[5] - 1, byArray[4], byArray[2], byArray[1], byArray[0]);
        return gregorianCalendar.getTime();
    }

    public void resetCrc() {
        this.crc.reset();
    }

    public long getCrcValue() {
        return this.crc.getValue();
    }

    public long getTotalBytesRead() {
        return this.bytesRead;
    }
}

