/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFileEntry;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.ui.ac;
import com.webcodepro.applecommander.util.TextBundle;
import com.webcodepro.shrinkit.HeaderBlock;
import com.webcodepro.shrinkit.NuFileArchive;
import com.webcodepro.shrinkit.ThreadRecord;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class Utilities {
    public static byte[] unpackSHKFile(String string) throws IOException {
        return Utilities.unpackSHKFile(string, 0);
    }

    public static byte[] unpackSHKFile(String string, int n) throws IOException {
        TextBundle textBundle = StorageBundle.getInstance();
        byte[] byArray = null;
        File file = new File(string);
        if (file.isDirectory() || !file.canRead()) {
            throw new IOException(textBundle.format("NotAFile", string, 1));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        NuFileArchive nuFileArchive = new NuFileArchive(fileInputStream);
        int n2 = Disk.sizeToFit(nuFileArchive.getArchiveSize());
        if (n > 0) {
            n2 = n * 512;
        }
        ByteArrayImageLayout byteArrayImageLayout = new ByteArrayImageLayout(n2);
        ProdosOrder prodosOrder = new ProdosOrder(byteArrayImageLayout);
        ProdosFormatDisk[] prodosFormatDiskArray = ProdosFormatDisk.create(string, "APPLECOMMANDER", prodosOrder);
        ProdosFormatDisk prodosFormatDisk = prodosFormatDiskArray[0];
        for (HeaderBlock headerBlock : nuFileArchive.getHeaderBlocks()) {
            ProdosFileEntry prodosFileEntry = null;
            ThreadRecord threadRecord = null;
            ThreadRecord threadRecord2 = null;
            Object object = headerBlock.getThreadRecords().iterator();
            while (object.hasNext()) {
                ThreadRecord threadRecord3 = object.next();
                try {
                    switch (threadRecord3.getThreadKind()) {
                        case ASCII_TEXT: {
                            break;
                        }
                        case ALLOCATED_SPACE: {
                            break;
                        }
                        case APPLE_IIGS_ICON: {
                            break;
                        }
                        case CREATE_DIRECTORY: {
                            break;
                        }
                        case DATA_FORK: {
                            threadRecord = threadRecord3;
                            break;
                        }
                        case DISK_IMAGE: {
                            byArray = Utilities.readThread(threadRecord3);
                            break;
                        }
                        case RESOURCE_FORK: {
                            threadRecord2 = threadRecord3;
                            break;
                        }
                        case FILENAME: {
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    throw new IOException(exception.getMessage());
                }
            }
            try {
                if (threadRecord == null || (prodosFileEntry = (ProdosFileEntry)((ac.Name)(object = new ac.Name(headerBlock.getFilename()))).createEntry(prodosFormatDisk)) == null) continue;
                if (threadRecord2 != null) {
                    prodosFileEntry.setFileData(Utilities.readThread(threadRecord), Utilities.readThread(threadRecord2));
                    prodosFileEntry.setStorageType(5);
                } else {
                    prodosFileEntry.setFileData(Utilities.readThread(threadRecord));
                }
                prodosFileEntry.setFilename(headerBlock.getFinalFilename());
                prodosFileEntry.setFiletype(headerBlock.getFileType());
                prodosFileEntry.setAuxiliaryType((int)headerBlock.getExtraType());
                prodosFileEntry.setCreationDate(headerBlock.getCreateWhen());
                prodosFileEntry.setLastModificationDate(headerBlock.getModWhen());
                prodosFileEntry = null;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
        }
        if (byArray != null) {
            return byArray;
        }
        return prodosOrder.readBytes(0, n2);
    }

    public static byte[] readThread(ThreadRecord threadRecord) throws IOException {
        threadRecord.readThreadData(new LittleEndianByteInputStream(threadRecord.getRawInputStream()));
        InputStream inputStream = threadRecord.getInputStream();
        byte[] byArray = new byte[(int)threadRecord.getThreadEof()];
        inputStream.read(byArray, 0, byArray.length);
        inputStream.close();
        return byArray;
    }
}

