/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.shrinkit;

import com.webcodepro.shrinkit.ThreadKind;
import com.webcodepro.shrinkit.ThreadRecord;
import com.webcodepro.shrinkit.io.LittleEndianByteInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderBlock {
    private int headerCrc;
    private int attribCount;
    private int versionNumber;
    private long totalThreads;
    private int fileSysId;
    private int fileSysInfo;
    private long access;
    private long fileType;
    private long extraType;
    private int storageType;
    private Date createWhen;
    private Date modWhen;
    private Date archiveWhen;
    private int optionSize;
    private byte[] optionListBytes;
    private byte[] attribBytes;
    private String filename;
    private String rawFilename;
    private long headerSize = 0L;
    private List<ThreadRecord> threads = new ArrayList<ThreadRecord>();

    public HeaderBlock(LittleEndianByteInputStream littleEndianByteInputStream) throws IOException {
        int n;
        int n2 = littleEndianByteInputStream.seekFileType(4);
        if (n2 == 0) {
            throw new IOException("Unable to decode this archive.");
        }
        this.headerCrc = littleEndianByteInputStream.readWord();
        this.attribCount = littleEndianByteInputStream.readWord();
        this.versionNumber = littleEndianByteInputStream.readWord();
        this.totalThreads = littleEndianByteInputStream.readLong();
        this.fileSysId = littleEndianByteInputStream.readWord();
        this.fileSysInfo = littleEndianByteInputStream.readWord();
        this.access = littleEndianByteInputStream.readLong();
        this.fileType = littleEndianByteInputStream.readLong();
        this.extraType = littleEndianByteInputStream.readLong();
        this.storageType = littleEndianByteInputStream.readWord();
        this.createWhen = littleEndianByteInputStream.readDate();
        this.modWhen = littleEndianByteInputStream.readDate();
        this.archiveWhen = littleEndianByteInputStream.readDate();
        if (this.versionNumber >= 1) {
            this.optionSize = littleEndianByteInputStream.readWord();
            if (this.optionSize > 0) {
                this.optionListBytes = littleEndianByteInputStream.readBytes(this.optionSize - 2);
            }
        }
        int n3 = this.attribCount - 58;
        if (this.versionNumber >= 1) {
            n3 = this.optionSize == 0 ? (n3 -= 2) : (n3 -= this.optionSize);
        }
        if (n3 > 0) {
            this.attribBytes = littleEndianByteInputStream.readBytes(n3);
        }
        if ((n = littleEndianByteInputStream.readWord()) > 0) {
            this.rawFilename = new String(littleEndianByteInputStream.readBytes(n));
        }
    }

    public void readThreads(LittleEndianByteInputStream littleEndianByteInputStream) throws IOException {
        for (long i = 0L; i < this.totalThreads; ++i) {
            this.threads.add(new ThreadRecord(this, littleEndianByteInputStream));
        }
        for (ThreadRecord threadRecord : this.threads) {
            threadRecord.readThreadData(littleEndianByteInputStream);
            this.headerSize += threadRecord.getThreadEof();
        }
    }

    public String getFilename() {
        if (this.filename == null) {
            ThreadRecord threadRecord = this.findThreadRecord(ThreadKind.FILENAME);
            if (threadRecord != null) {
                this.filename = threadRecord.getText();
            }
            if (this.filename == null) {
                this.filename = this.rawFilename;
            }
            if (this.filename.contains(":")) {
                this.filename = this.filename.replace(":", "/");
            }
        }
        return this.filename;
    }

    public String getFinalFilename() {
        String string = this.getFilename();
        String[] stringArray = string.split("/");
        string = stringArray[stringArray.length - 1];
        return string;
    }

    public ThreadRecord getDataForkInputStream() throws IOException {
        return this.findThreadRecord(ThreadKind.DATA_FORK);
    }

    public ThreadRecord getResourceForkInputStream() throws IOException {
        return this.findThreadRecord(ThreadKind.RESOURCE_FORK);
    }

    protected ThreadRecord findThreadRecord(ThreadKind threadKind) {
        for (ThreadRecord threadRecord : this.threads) {
            if (threadRecord.getThreadKind() != threadKind) continue;
            return threadRecord;
        }
        return null;
    }

    public int getHeaderCrc() {
        return this.headerCrc;
    }

    public void setHeaderCrc(int n) {
        this.headerCrc = n;
    }

    public int getAttribCount() {
        return this.attribCount;
    }

    public void setAttribCount(int n) {
        this.attribCount = n;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(int n) {
        this.versionNumber = n;
    }

    public long getTotalThreads() {
        return this.totalThreads;
    }

    public void setTotalThreads(long l) {
        this.totalThreads = l;
    }

    public int getFileSysId() {
        return this.fileSysId;
    }

    public void setFileSysId(int n) {
        this.fileSysId = n;
    }

    public int getFileSysInfo() {
        return this.fileSysInfo;
    }

    public void setFileSysInfo(int n) {
        this.fileSysInfo = n;
    }

    public long getAccess() {
        return this.access;
    }

    public void setAccess(long l) {
        this.access = l;
    }

    public long getFileType() {
        return this.fileType;
    }

    public void setFileType(long l) {
        this.fileType = l;
    }

    public long getExtraType() {
        return this.extraType;
    }

    public void setExtraType(long l) {
        this.extraType = l;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public void setStorageType(int n) {
        this.storageType = n;
    }

    public Date getCreateWhen() {
        return this.createWhen;
    }

    public void setCreateWhen(Date date) {
        this.createWhen = date;
    }

    public Date getModWhen() {
        return this.modWhen;
    }

    public void setModWhen(Date date) {
        this.modWhen = date;
    }

    public Date getArchiveWhen() {
        return this.archiveWhen;
    }

    public void setArchiveWhen(Date date) {
        this.archiveWhen = date;
    }

    public int getOptionSize() {
        return this.optionSize;
    }

    public void setOptionSize(int n) {
        this.optionSize = n;
    }

    public byte[] getOptionListBytes() {
        return this.optionListBytes;
    }

    public void setOptionListBytes(byte[] byArray) {
        this.optionListBytes = byArray;
    }

    public byte[] getAttribBytes() {
        return this.attribBytes;
    }

    public void setAttribBytes(byte[] byArray) {
        this.attribBytes = byArray;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getRawFilename() {
        return this.rawFilename;
    }

    public List<ThreadRecord> getThreadRecords() {
        return this.threads;
    }

    public void setThreadRecords(List<ThreadRecord> list) {
        this.threads = list;
    }

    public long getHeaderSize() {
        return this.headerSize;
    }
}

