/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui;

import com.webcodepro.applecommander.storage.DirectoryEntry;
import com.webcodepro.applecommander.storage.Disk;
import com.webcodepro.applecommander.storage.DiskFullException;
import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.filters.BinaryFileFilter;
import com.webcodepro.applecommander.storage.filters.HexDumpFileFilter;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.os.pascal.PascalFormatDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.ui.UiBundle;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.List;

public class ac {
    private static TextBundle textBundle = UiBundle.getInstance();

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                ac.help();
            } else if ("-i".equalsIgnoreCase(stringArray[0])) {
                ac.getDiskInfo(stringArray);
            } else if ("-ls".equalsIgnoreCase(stringArray[0])) {
                ac.showDirectory(stringArray, 1);
            } else if ("-l".equalsIgnoreCase(stringArray[0])) {
                ac.showDirectory(stringArray, 2);
            } else if ("-ll".equalsIgnoreCase(stringArray[0])) {
                ac.showDirectory(stringArray, 3);
            } else if ("-e".equalsIgnoreCase(stringArray[0])) {
                ac.getFile(stringArray[1], stringArray[2], true, stringArray.length > 3 ? new PrintStream(new FileOutputStream(stringArray[3])) : System.out);
            } else if ("-x".equalsIgnoreCase(stringArray[0])) {
                ac.getFiles(stringArray[1], stringArray.length > 2 ? stringArray[2] : "");
            } else if ("-g".equalsIgnoreCase(stringArray[0])) {
                ac.getFile(stringArray[1], stringArray[2], false, stringArray.length > 3 ? new PrintStream(new FileOutputStream(stringArray[3])) : System.out);
            } else if ("-p".equalsIgnoreCase(stringArray[0])) {
                ac.putFile(stringArray[1], new Name(stringArray[2]), stringArray[3], stringArray.length > 4 ? stringArray[4] : "0x2000");
            } else if ("-d".equalsIgnoreCase(stringArray[0])) {
                ac.deleteFile(stringArray[1], stringArray[2]);
            } else if ("-k".equalsIgnoreCase(stringArray[0])) {
                ac.setFileLocked(stringArray[1], stringArray[2], true);
            } else if ("-u".equalsIgnoreCase(stringArray[0])) {
                ac.setFileLocked(stringArray[1], stringArray[2], false);
            } else if ("-n".equalsIgnoreCase(stringArray[0])) {
                ac.setDiskName(stringArray[1], stringArray[2]);
            } else if ("-cc65".equalsIgnoreCase(stringArray[0])) {
                ac.putCC65(stringArray[1], new Name(stringArray[2]), stringArray[3]);
            } else if ("-geos".equalsIgnoreCase(stringArray[0])) {
                ac.putGEOS(stringArray[1]);
            } else if ("-dos140".equalsIgnoreCase(stringArray[0])) {
                ac.createDosDisk(stringArray[1], 143360);
            } else if ("-pas140".equalsIgnoreCase(stringArray[0])) {
                ac.createPasDisk(stringArray[1], stringArray[2], 143360);
            } else if ("-pas800".equalsIgnoreCase(stringArray[0])) {
                ac.createPasDisk(stringArray[1], stringArray[2], 819200);
            } else if ("-pro140".equalsIgnoreCase(stringArray[0])) {
                ac.createProDisk(stringArray[1], stringArray[2], 143360);
            } else if ("-pro800".equalsIgnoreCase(stringArray[0])) {
                ac.createProDisk(stringArray[1], stringArray[2], 819200);
            } else if ("-convert".equalsIgnoreCase(stringArray[0])) {
                if (stringArray.length > 3) {
                    ac.convert(stringArray[1], stringArray[2], Integer.parseInt(stringArray[3]));
                } else {
                    ac.convert(stringArray[1], stringArray[2]);
                }
            } else {
                ac.help();
            }
        }
        catch (Exception exception) {
            System.err.println(textBundle.format("CommandLineErrorMessage", exception.getLocalizedMessage()));
            exception.printStackTrace();
            ac.help();
        }
    }

    public static void putFile(String string, String string2, String string3, String string4, String string5) throws IOException, DiskFullException {
        Name name = new Name(string3);
        File file = new File(string);
        if (!file.canRead()) {
            throw new IOException("Unable to read input file named " + string + ".");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        FileInputStream fileInputStream = new FileInputStream(file);
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        Disk disk = new Disk(string2);
        FormattedDisk[] formattedDiskArray = disk.getFormattedDisks();
        FormattedDisk formattedDisk = formattedDiskArray[0];
        FileEntry fileEntry = name.createEntry(formattedDisk);
        if (fileEntry != null) {
            fileEntry.setFiletype(string4);
            fileEntry.setFilename(name.name);
            fileEntry.setFileData(byteArrayOutputStream.toByteArray());
            if (fileEntry.needsAddress()) {
                fileEntry.setAddress(ac.stringToInt(string5));
            }
            formattedDisk.save();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void putFile(String string, Name name, String string2, String string3) throws IOException, DiskFullException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = System.in.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        Disk disk = new Disk(string);
        FormattedDisk[] formattedDiskArray = disk.getFormattedDisks();
        if (formattedDiskArray == null) {
            System.out.println("Dude, formattedDisks is null!");
        }
        FormattedDisk formattedDisk = formattedDiskArray[0];
        if (disk.isSDK() || disk.isDC42()) throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        FileEntry fileEntry = name.createEntry(formattedDisk);
        if (fileEntry == null) throw new IOException("Unable to create entry...");
        fileEntry.setFiletype(string2);
        fileEntry.setFilename(name.name);
        fileEntry.setFileData(byteArrayOutputStream.toByteArray());
        if (fileEntry.needsAddress()) {
            fileEntry.setAddress(ac.stringToInt(string3));
        }
        formattedDisk.save();
    }

    public static void putCC65(String string, String string2, String string3, String string4) throws IOException, DiskFullException {
        byte[] byArray = new byte[4];
        if (System.in.read(byArray, 0, 4) == 4) {
            int n = AppleUtil.getWordValue(byArray, 0);
            ac.putFile(string, string2, string3, string4, Integer.toString(n));
        }
    }

    static void putCC65(String string, Name name, String string2) throws IOException, DiskFullException {
        byte[] byArray = new byte[4];
        if (System.in.read(byArray, 0, 4) == 4) {
            int n = AppleUtil.getWordValue(byArray, 0);
            ac.putFile(string, name, string2, Integer.toString(n));
        }
    }

    static void putGEOS(String string) throws IOException, DiskFullException {
        ac.putFile(string, new Name("GEOS-Should Be ProDOS"), "GEO", "0");
    }

    static void deleteFile(String string, String string2) throws IOException {
        Disk disk = new Disk(string);
        Name name = new Name(string2);
        if (!disk.isSDK() && !disk.isDC42()) {
            FormattedDisk[] formattedDiskArray = disk.getFormattedDisks();
            for (int i = 0; i < formattedDiskArray.length; ++i) {
                FormattedDisk formattedDisk = formattedDiskArray[i];
                FileEntry fileEntry = name.getEntry(formattedDisk);
                if (fileEntry != null) {
                    fileEntry.delete();
                    disk.save();
                    continue;
                }
                System.err.println(textBundle.format("CommandLineNoMatchMessage", name.fullName));
            }
        } else {
            throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        }
    }

    static void getFile(String string, String string2, boolean bl, PrintStream printStream) throws IOException {
        Disk disk = new Disk(string);
        Name name = new Name(string2);
        FormattedDisk[] formattedDiskArray = disk.getFormattedDisks();
        if (printStream == null) {
            printStream = System.out;
        }
        for (int i = 0; i < formattedDiskArray.length; ++i) {
            FormattedDisk formattedDisk = formattedDiskArray[i];
            FileEntry fileEntry = name.getEntry(formattedDisk);
            if (fileEntry != null) {
                Object object;
                if (bl) {
                    object = fileEntry.getSuggestedFilter();
                    if (object instanceof BinaryFileFilter) {
                        object = new HexDumpFileFilter();
                    }
                    byte[] byArray = object.filter(fileEntry);
                    printStream.write(byArray, 0, byArray.length);
                    continue;
                }
                object = fileEntry.getFileData();
                printStream.write((byte[])object, 0, ((Object)object).length);
                continue;
            }
            System.err.println(textBundle.format("CommandLineNoMatchMessage", name.fullName));
        }
    }

    static void getFiles(String string, String string2) throws IOException {
        Disk disk = new Disk(string);
        if (string2 != null && string2.length() > 0) {
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
        } else {
            string2 = "." + File.separator;
        }
        FormattedDisk[] formattedDiskArray = disk.getFormattedDisks();
        for (int i = 0; i < formattedDiskArray.length; ++i) {
            FormattedDisk formattedDisk = formattedDiskArray[i];
            ac.writeFiles(formattedDisk.getFiles(), string2);
        }
    }

    static void writeFiles(List list, String string) throws IOException {
        for (FileEntry fileEntry : list) {
            if (fileEntry != null && !fileEntry.isDeleted() && !fileEntry.isDirectory()) {
                FileFilter fileFilter = fileEntry.getSuggestedFilter();
                if (fileFilter instanceof BinaryFileFilter) {
                    fileFilter = new HexDumpFileFilter();
                }
                byte[] byArray = fileFilter.filter(fileEntry);
                String string2 = fileFilter.getSuggestedFileName(fileEntry);
                File file = new File(string + string2);
                File file2 = new File(string);
                file2.mkdirs();
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                ((OutputStream)fileOutputStream).write(byArray, 0, byArray.length);
                ((OutputStream)fileOutputStream).close();
                continue;
            }
            if (!fileEntry.isDirectory()) continue;
            ac.writeFiles(((DirectoryEntry)((Object)fileEntry)).getFiles(), string + fileEntry.getFilename() + File.separator);
        }
    }

    static FileEntry getEntry(List list, String string) {
        FileEntry fileEntry = null;
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                fileEntry = (FileEntry)list.get(i);
                String string2 = fileEntry.getFilename();
                if (!fileEntry.isDeleted() && string.equalsIgnoreCase(string2)) {
                    return fileEntry;
                }
                if (!fileEntry.isDirectory() || (fileEntry = ac.getEntry(((DirectoryEntry)((Object)fileEntry)).getFiles(), string)) == null) continue;
                return fileEntry;
            }
        }
        return null;
    }

    static void showDirectory(String[] stringArray, int n) throws IOException {
        for (int i = 1; i < stringArray.length; ++i) {
            try {
                Disk disk = new Disk(stringArray[i]);
                FormattedDisk[] formattedDiskArray = disk.getFormattedDisks();
                for (int j = 0; j < formattedDiskArray.length; ++j) {
                    FormattedDisk formattedDisk = formattedDiskArray[j];
                    System.out.print(stringArray[i] + " ");
                    System.out.println(formattedDisk.getDiskName());
                    List list = formattedDisk.getFiles();
                    if (list != null) {
                        ac.showFiles(list, "", n);
                    }
                    System.out.println(textBundle.format("CommandLineStatus", new Object[]{formattedDisk.getFormat(), new Integer(formattedDisk.getFreeSpace()), new Integer(formattedDisk.getUsedSpace())}));
                    System.out.println();
                }
                continue;
            }
            catch (RuntimeException runtimeException) {
                System.out.println(stringArray[i] + ": " + runtimeException.getMessage());
                System.out.println();
            }
        }
    }

    static void showFiles(List list, String string, int n) {
        for (int i = 0; i < list.size(); ++i) {
            FileEntry fileEntry = (FileEntry)list.get(i);
            if (!fileEntry.isDeleted()) {
                List list2 = fileEntry.getFileColumnData(n);
                System.out.print(string);
                for (int j = 0; j < list2.size(); ++j) {
                    System.out.print(list2.get(j));
                    System.out.print(" ");
                }
                System.out.println();
            }
            if (!fileEntry.isDirectory()) continue;
            ac.showFiles(((DirectoryEntry)((Object)fileEntry)).getFiles(), string + "  ", n);
        }
    }

    static void getDiskInfo(String[] stringArray) throws IOException {
        for (int i = 1; i < stringArray.length; ++i) {
            Disk disk = new Disk(stringArray[i]);
            FormattedDisk[] formattedDiskArray = disk.getFormattedDisks();
            for (int j = 0; j < formattedDiskArray.length; ++j) {
                FormattedDisk formattedDisk = formattedDiskArray[j];
                for (FormattedDisk.DiskInformation diskInformation : formattedDisk.getDiskInformation()) {
                    System.out.println(diskInformation.getLabel() + ": " + diskInformation.getValue());
                }
            }
            System.out.println();
        }
    }

    public static void setFileLocked(String string, String string2, boolean bl) throws IOException {
        ac.setFileLocked(string, new Name(string2), bl);
    }

    static void setFileLocked(String string, Name name, boolean bl) throws IOException {
        Disk disk = new Disk(string);
        if (!disk.isSDK() && !disk.isDC42()) {
            FormattedDisk[] formattedDiskArray = disk.getFormattedDisks();
            for (int i = 0; i < formattedDiskArray.length; ++i) {
                FormattedDisk formattedDisk = formattedDiskArray[i];
                FileEntry fileEntry = name.getEntry(formattedDisk);
                if (fileEntry != null) {
                    fileEntry.setLocked(bl);
                    disk.save();
                    continue;
                }
                System.err.println(textBundle.format("CommandLineNoMatchMessage", name.fullName));
            }
        } else {
            throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        }
    }

    public static void setDiskName(String string, String string2) throws IOException {
        Disk disk = new Disk(string);
        if (disk.isSDK() || disk.isDC42()) {
            throw new IOException(textBundle.get("CommandLineSDKReadOnly"));
        }
        FormattedDisk[] formattedDiskArray = disk.getFormattedDisks();
        FormattedDisk formattedDisk = formattedDiskArray[0];
        formattedDisk.setDiskName(string2);
        formattedDiskArray[0].save();
    }

    public static void createDosDisk(String string, int n) throws IOException {
        ByteArrayImageLayout byteArrayImageLayout = new ByteArrayImageLayout(n);
        DosOrder dosOrder = new DosOrder(byteArrayImageLayout);
        DosFormatDisk[] dosFormatDiskArray = DosFormatDisk.create(string, dosOrder);
        dosFormatDiskArray[0].save();
    }

    public static void createPasDisk(String string, String string2, int n) throws IOException {
        ByteArrayImageLayout byteArrayImageLayout = new ByteArrayImageLayout(n);
        ProdosOrder prodosOrder = new ProdosOrder(byteArrayImageLayout);
        PascalFormatDisk[] pascalFormatDiskArray = PascalFormatDisk.create(string, string2, prodosOrder);
        pascalFormatDiskArray[0].save();
    }

    public static void createProDisk(String string, String string2, int n) throws IOException {
        ByteArrayImageLayout byteArrayImageLayout = new ByteArrayImageLayout(n);
        ProdosOrder prodosOrder = new ProdosOrder(byteArrayImageLayout);
        ProdosFormatDisk[] prodosFormatDiskArray = ProdosFormatDisk.create(string, string2, prodosOrder);
        prodosFormatDiskArray[0].save();
    }

    static void convert(String string, String string2) throws IOException {
        ac.convert(string, string2, 0);
    }

    static void convert(String string, String string2, int n) throws IOException {
        Disk disk = new Disk(string, n);
        disk.setFilename(string2);
        disk.save();
    }

    static int stringToInt(String string) {
        int n = 0;
        try {
            string = string.trim().toLowerCase();
            n = string.startsWith("$") ? Integer.parseInt(string.substring(1), 16) : (string.startsWith("0x") ? Integer.parseInt(string.substring(2), 16) : Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            n = 8192;
        }
        return n;
    }

    static void help() {
        System.err.println(textBundle.format("CommandLineHelp", "1.3.5.13"));
    }

    public static class Name {
        private String fullName;
        private String name;
        private String[] path;

        public Name(String string) {
            this.fullName = string;
            if (string.startsWith("/")) {
                this.fullName = string.substring(1, string.length());
            }
            this.path = string.split("/");
            this.name = this.path[this.path.length - 1];
        }

        public FileEntry getEntry(FormattedDisk formattedDisk) {
            String string;
            int n;
            List list = formattedDisk.getFiles();
            FileEntry fileEntry = null;
            for (n = 0; n < this.path.length - 1; ++n) {
                string = this.path[n];
                for (int i = 0; i < list.size(); ++i) {
                    fileEntry = (FileEntry)list.get(i);
                    String string2 = fileEntry.getFilename();
                    if (!fileEntry.isDirectory() || !string.equalsIgnoreCase(string2)) continue;
                    list = ((DirectoryEntry)((Object)fileEntry)).getFiles();
                }
            }
            for (n = 0; n < list.size(); ++n) {
                fileEntry = (FileEntry)list.get(n);
                string = fileEntry.getFilename();
                if (fileEntry.isDeleted() || !this.name.equalsIgnoreCase(string)) continue;
                return fileEntry;
            }
            return null;
        }

        public FileEntry createEntry(FormattedDisk formattedDisk) throws DiskFullException {
            if (this.path.length == 1) {
                return formattedDisk.createFile();
            }
            List list = formattedDisk.getFiles();
            DirectoryEntry directoryEntry = null;
            DirectoryEntry directoryEntry2 = null;
            for (int i = 0; i < this.path.length - 1; ++i) {
                String string = this.path[i];
                directoryEntry = null;
                for (int j = 0; j < list.size(); ++j) {
                    FileEntry fileEntry = (FileEntry)list.get(j);
                    String string2 = fileEntry.getFilename();
                    if (fileEntry.isDeleted() || !fileEntry.isDirectory() || !string.equalsIgnoreCase(string2)) continue;
                    directoryEntry2 = directoryEntry = (DirectoryEntry)((Object)fileEntry);
                    list = directoryEntry.getFiles();
                }
                if (directoryEntry != null) continue;
                directoryEntry2 = directoryEntry2 != null ? (directoryEntry = directoryEntry2.createDirectory(string)) : (directoryEntry = formattedDisk.createDirectory(string));
            }
            if (directoryEntry != null) {
                return directoryEntry.createFile();
            }
            System.err.println(textBundle.format("CommandLineNoMatchMessage", this.fullName));
            return null;
        }
    }
}

