/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.physical;

import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.TextBundle;
import java.util.Arrays;

public class NibbleOrder
extends DosOrder {
    private TextBundle textBundle = StorageBundle.getInstance();
    private static int[] writeTranslateTable = new int[]{150, 151, 154, 155, 157, 158, 159, 166, 167, 171, 172, 173, 174, 175, 178, 179, 180, 181, 182, 183, 185, 186, 187, 188, 189, 190, 191, 203, 205, 206, 207, 211, 214, 215, 217, 218, 219, 220, 221, 222, 223, 229, 230, 231, 233, 234, 235, 236, 237, 238, 239, 242, 243, 244, 245, 246, 247, 249, 250, 251, 252, 253, 254, 255};
    private static int[] sectorInterleave = new int[]{0, 13, 11, 9, 7, 5, 3, 1, 14, 12, 10, 8, 6, 4, 2, 15};
    public int[] readTranslateTable = new int[256];

    public NibbleOrder(ByteArrayImageLayout byteArrayImageLayout) {
        super(byteArrayImageLayout);
        for (int i = 0; i < writeTranslateTable.length; ++i) {
            this.readTranslateTable[NibbleOrder.writeTranslateTable[i]] = i;
        }
    }

    protected byte[] readTrackData(int n) {
        int n2 = this.getPhysicalSize() / this.getTracksPerDisk();
        return this.readBytes(n * n2, n2);
    }

    protected void writeTrackData(int n, byte[] byArray) {
        int n2 = this.getPhysicalSize() / this.getTracksPerDisk();
        this.writeBytes(n * n2, byArray);
    }

    public byte[] readSector(int n, int n2) throws IllegalArgumentException {
        int n3;
        int n4;
        int n5 = sectorInterleave[n2];
        byte[] byArray = this.readTrackData(n);
        int n6 = 0;
        byte[] byArray2 = new byte[14];
        boolean bl = false;
        for (int i = this.getSectorsPerTrack(); !bl && i >= 0; --i) {
            int n7 = this.locateField(213, 170, 150, byArray, byArray2, n6);
            n6 = n7;
            int n8 = this.decodeOddEven(byArray2, 5);
            n4 = this.decodeOddEven(byArray2, 7);
            bl = n8 == n && n4 == n5;
        }
        if (!bl) {
            throw new IllegalArgumentException(this.textBundle.format("NibbleOrder.InvalidPhysicalSectorError", n5, n, 1));
        }
        byte[] byArray3 = new byte[349];
        this.locateField(213, 170, 173, byArray, byArray3, n6);
        byte[] byArray4 = new byte[342];
        n4 = 0;
        for (int i = 0; i < byArray4.length; ++i) {
            n3 = AppleUtil.getUnsignedByte(byArray3[i + 3]);
            n4 ^= this.readTranslateTable[n3];
            if (i < 86) {
                byArray4[byArray4.length - i - 1] = (byte)n4;
                continue;
            }
            byArray4[i - 86] = (byte)n4;
        }
        if ((n4 ^= this.readTranslateTable[AppleUtil.getUnsignedByte(byArray3[345])]) != 0) {
            return null;
        }
        byte[] byArray5 = new byte[256];
        for (n3 = 0; n3 < byArray5.length; ++n3) {
            int n9 = AppleUtil.getUnsignedByte(byArray4[n3]);
            int n10 = byArray4.length - n3 % 86 - 1;
            int n11 = AppleUtil.getUnsignedByte(byArray4[n10]);
            int n12 = n3 / 86 * 2;
            int[] nArray = new int[]{0, 2, 1, 3};
            int n13 = n9 << 2 | nArray[n11 >> n12 & 3];
            byArray5[n3] = (byte)n13;
        }
        return byArray5;
    }

    protected int locateField(int n, int n2, int n3, byte[] byArray, byte[] byArray2, int n4) {
        int n5;
        int n6 = 0;
        for (n5 = n4; n5 < byArray.length + byArray2.length; ++n5) {
            int n7 = n5 % byArray.length;
            int n8 = AppleUtil.getUnsignedByte(byArray[n7]);
            if (n6 == 0 && n8 == n) {
                byArray2[n6++] = (byte)n8;
                continue;
            }
            if (n6 == 1 && n8 == n2) {
                byArray2[n6++] = (byte)n8;
                continue;
            }
            if (n6 == 2 && n8 == n3) {
                byArray2[n6++] = (byte)n8;
                continue;
            }
            if (n6 >= 3 && n6 <= byArray2.length) {
                if (n6 < byArray2.length) {
                    byArray2[n6++] = (byte)n8;
                }
                if (n6 != byArray2.length) continue;
                break;
            }
            n6 = 0;
        }
        return n5 % byArray.length;
    }

    protected int decodeOddEven(byte[] byArray, int n) {
        int n2 = AppleUtil.getUnsignedByte(byArray[n]);
        int n3 = AppleUtil.getUnsignedByte(byArray[n + 1]);
        return (n2 << 1 | 1) & n3;
    }

    protected void encodeOddEven(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >> 1 | 0xAA);
        byArray[n + 1] = (byte)(n2 | 0xAA);
    }

    public void writeSector(int n, int n2, byte[] byArray) throws IllegalArgumentException {
        int n3;
        int n4 = sectorInterleave[n2];
        byte[] byArray2 = this.readTrackData(n);
        int n5 = 0;
        byte[] byArray3 = new byte[14];
        boolean bl = false;
        while (!bl && n5 < byArray2.length) {
            int n6 = this.locateField(213, 170, 150, byArray2, byArray3, n5);
            if (n6 < n5) {
                throw new IllegalArgumentException(this.textBundle.format("NibbleOrder.InvalidPhysicalSectorError", n4, n, 2));
            }
            n5 = n6;
            int n7 = this.decodeOddEven(byArray3, 5);
            n3 = this.decodeOddEven(byArray3, 7);
            bl = n7 == n && n3 == n4;
        }
        if (!bl) {
            throw new IllegalArgumentException(this.textBundle.format("NibbleOrder.InvalidPhysicalSectorError", n4, n, 2));
        }
        int[] nArray = new int[256];
        int[] nArray2 = new int[86];
        n3 = 0;
        int n8 = 2;
        while (true) {
            if (--n8 < 0) {
                n8 += 256;
            }
            int n9 = AppleUtil.getUnsignedByte(byArray[n8]);
            int n10 = n3;
            nArray2[n10] = nArray2[n10] << 1;
            int n11 = n3;
            nArray2[n11] = nArray2[n11] | n9 & 1;
            int n12 = n3;
            nArray2[n12] = nArray2[n12] << 1;
            int n13 = n3++;
            nArray2[n13] = nArray2[n13] | (n9 >>= 1) & 1;
            nArray[n8] = n9 >>= 1;
            if (n3 < 86) continue;
            n3 = 0;
            if (n8 == 0) break;
        }
        n3 = 0;
        while (n3 < 86) {
            int n14 = n3++;
            nArray2[n14] = nArray2[n14] & 0x3F;
        }
        byte[] byArray4 = new byte[343];
        int n15 = 0;
        for (n8 = 86; n8 > 0; --n8) {
            byArray4[n15++] = n8 == 86 ? (byte)writeTranslateTable[nArray2[n8 - 1]] : (byte)writeTranslateTable[nArray2[n8] ^ nArray2[n8 - 1]];
        }
        byArray4[n15++] = (byte)writeTranslateTable[nArray2[0] ^ nArray[n8]];
        for (n8 = 1; n8 < 256; ++n8) {
            byArray4[n15++] = (byte)writeTranslateTable[nArray[n8] ^ nArray[n8 - 1]];
        }
        byArray4[n15++] = (byte)writeTranslateTable[nArray[255]];
        byte[] byArray5 = new byte[3];
        n5 = this.locateField(213, 170, 173, byArray2, byArray5, n5);
        for (int i = 0; i < byArray4.length; ++i) {
            n15 = (n5 + i) % byArray2.length;
            byArray2[n15] = byArray4[i];
        }
        this.writeTrackData(n, byArray2);
    }

    public int getTracksPerDisk() {
        return 35;
    }

    public int getSectorsPerTrack() {
        return 16;
    }

    public int getBlocksOnDevice() {
        return 280;
    }

    public void format() {
        byte[] byArray = new byte[232960];
        Arrays.fill(byArray, (byte)-1);
        this.getDiskImageManager().setDiskImage(byArray);
        byte[] byArray2 = new byte[14];
        byte[] byArray3 = new byte[349];
        Arrays.fill(byArray3, (byte)-106);
        byte[] byArray4 = new byte[]{-43, -86, -106};
        byte[] byArray5 = new byte[]{-43, -86, -83};
        byte[] byArray6 = new byte[]{-34, -86, -21};
        System.arraycopy(byArray4, 0, byArray2, 0, 3);
        System.arraycopy(byArray6, 0, byArray2, 11, 3);
        System.arraycopy(byArray5, 0, byArray3, 0, 3);
        System.arraycopy(byArray6, 0, byArray3, 346, 3);
        int n = 43;
        int n2 = 10;
        int n3 = 254;
        for (int i = 0; i < this.getTracksPerDisk(); ++i) {
            byte[] byArray7 = this.readTrackData(i);
            int n4 = 0;
            for (int j = 0; j < this.getSectorsPerTrack(); ++j) {
                this.encodeOddEven(byArray2, 3, n3);
                this.encodeOddEven(byArray2, 5, i);
                this.encodeOddEven(byArray2, 7, j);
                this.encodeOddEven(byArray2, 9, n3 ^ i ^ j);
                System.arraycopy(byArray2, 0, byArray7, n4 += n, byArray2.length);
                n4 += byArray2.length;
                System.arraycopy(byArray3, 0, byArray7, n4 += n2, byArray3.length);
                n4 += byArray3.length;
            }
            this.writeTrackData(i, byArray7);
        }
    }
}

