/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.os.dos33;

import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.util.TextBundle;

public class UniDosFormatDisk
extends DosFormatDisk {
    private TextBundle textBundle = StorageBundle.getInstance();
    public static final int UNIDOS_DISK_1 = 0;
    public static final int UNIDOS_DISK_2 = 50;
    private int logicalOffset;

    public UniDosFormatDisk(String string, ImageOrder imageOrder, int n) {
        super(string, imageOrder);
        this.logicalOffset = n;
    }

    public static DosFormatDisk[] create(String string, ImageOrder imageOrder) {
        UniDosFormatDisk uniDosFormatDisk = new UniDosFormatDisk(string, imageOrder, 0);
        UniDosFormatDisk uniDosFormatDisk2 = new UniDosFormatDisk(string, imageOrder, 50);
        uniDosFormatDisk.format();
        uniDosFormatDisk2.format();
        return new UniDosFormatDisk[]{uniDosFormatDisk, uniDosFormatDisk2};
    }

    public String getDiskName() {
        if (this.logicalOffset == 0) {
            return this.textBundle.format("DiskNameN", super.getDiskName(), 1);
        }
        if (this.logicalOffset == 50) {
            return this.textBundle.format("DiskNameN", super.getDiskName(), 2);
        }
        return super.getDiskName();
    }

    public int getLogicalDiskNumber() {
        if (this.logicalOffset == 0) {
            return 1;
        }
        if (this.logicalOffset == 50) {
            return 2;
        }
        return 0;
    }

    public void format() {
        this.getImageOrder().format();
        this.format(31, 50, 32);
    }

    public byte[] readSector(int n, int n2) throws IllegalArgumentException {
        return this.getImageOrder().readSector(n + this.logicalOffset, n2);
    }

    public void writeSector(int n, int n2, byte[] byArray) throws IllegalArgumentException {
        this.getImageOrder().writeSector(n + this.logicalOffset, n2, byArray);
    }
}

