/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class PascalTextFileFilter
implements FileFilter {
    private static final char NUL = '\u0000';
    private static final char CR = '\r';
    private static final char DLE = '\u0010';
    private static final int HEADER_SIZE = 1024;
    private static final int INDENT_BASE_VALUE = 32;

    public byte[] filter(FileEntry fileEntry) {
        byte[] byArray = fileEntry.getFileData();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream, true);
        block5: for (int i = 1024; i < byArray.length; ++i) {
            char c = (char)(byArray[i] & 0x7F);
            switch (c) {
                case '\u0000': {
                    continue block5;
                }
                case '\r': {
                    printWriter.println();
                    continue block5;
                }
                case '\u0010': {
                    if (i + 1 >= byArray.length) continue block5;
                    int n = byArray[++i] - 32;
                    while (n-- > 0) {
                        printWriter.print(' ');
                    }
                    continue block5;
                }
                default: {
                    printWriter.print(c);
                }
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public String getSuggestedFileName(FileEntry fileEntry) {
        String string = fileEntry.getFilename().trim();
        if (!string.toLowerCase().endsWith(".txt")) {
            string = string + ".txt";
        }
        return string;
    }
}

