/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage.filters;

import com.webcodepro.applecommander.storage.FileEntry;
import com.webcodepro.applecommander.storage.FileFilter;
import com.webcodepro.applecommander.storage.filters.imagehandlers.AppleImage;
import com.webcodepro.applecommander.util.AppleUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public class GraphicsFileFilter
implements FileFilter {
    public static final int MODE_HGR_BLACK_AND_WHITE = 1;
    public static final int MODE_HGR_COLOR = 2;
    public static final int MODE_DHR_BLACK_AND_WHITE = 3;
    public static final int MODE_DHR_COLOR = 4;
    public static final int MODE_SHR_16 = 5;
    public static final int MODE_SHR_3200 = 6;
    public static final int MODE_QUICKDRAW2_ICON = 7;
    private int mode = 2;
    private static AppleImage referenceImage = AppleImage.create(1, 1);

    public static boolean isCodecAvailable() {
        return referenceImage != null;
    }

    public byte[] filter(FileEntry fileEntry) {
        Object object;
        byte[] byArray = fileEntry.getFileData();
        AppleImage appleImage = null;
        if (this.isHiresColorMode()) {
            appleImage = AppleImage.create(280, 192);
        } else if (this.isDoubleHiresMode()) {
            appleImage = AppleImage.create(560, 384);
        } else if (this.isSuperHiresMode()) {
            appleImage = AppleImage.create(640, 400);
        } else if (!this.isQuickDraw2Icon()) {
            return new byte[0];
        }
        if (this.isQuickDraw2Icon()) {
            int n;
            object = this.buildQuickDraw2Icons(fileEntry);
            int n2 = 0;
            for (n = 0; n < ((AppleImage[])object).length; n += 2) {
                n2 += object[n].getWidth();
            }
            n = object[0].getHeight() + object[1].getHeight();
            appleImage = AppleImage.create(n2, n);
            int n3 = 0;
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (i % 2 == 0) {
                    this.copyImage(appleImage, (AppleImage)object[i], n3, 0);
                    continue;
                }
                this.copyImage(appleImage, (AppleImage)object[i], n3, ((AppleImage)object[i]).getHeight());
                n3 += ((AppleImage)object[i]).getWidth();
            }
        } else if (this.isSuperHiresMode()) {
            if (byArray.length < Short.MAX_VALUE && (byArray = AppleUtil.unpackBytes(byArray)).length == Short.MAX_VALUE) {
                byte[] byArray2 = new byte[32768];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                byArray = byArray2;
            }
            int n = 0;
            int n4 = this.isSuperHires3200Mode() ? 32000 : 32256;
            byte[] byArray3 = new byte[byArray.length - n4];
            System.arraycopy(byArray, n4, byArray3, 0, byArray3.length);
            for (int i = 0; i < 200; ++i) {
                byte[] byArray4 = new byte[160];
                System.arraycopy(byArray, n, byArray4, 0, byArray4.length);
                this.processSuperHiresLine(byArray4, appleImage, i, byArray[32000 + i], byArray3);
                n += byArray4.length;
            }
        } else {
            for (int i = 0; i < 192; ++i) {
                int n = ((i & 7) << 10 | (i & 8) << 4 | (i & 0x30) << 4 | ((i & 0xC0) >> 6) * 40) & 0x1FFF;
                byte[] byArray5 = new byte[40];
                System.arraycopy(byArray, n, byArray5, 0, 40);
                if (this.isHiresBlackAndWhiteMode()) {
                    this.processHiresBlackAndWhiteLine(byArray5, appleImage, i);
                    continue;
                }
                if (this.isHiresColorMode()) {
                    this.processHiresColorLine(byArray5, appleImage, i);
                    continue;
                }
                if (!this.isDoubleHiresMode()) continue;
                byte[] byArray6 = new byte[40];
                System.arraycopy(byArray, n + 8192, byArray6, 0, 40);
                if (this.isDoubleHiresBlackAndWhiteMode()) {
                    this.processDoubleHiresBlackAndWhiteLine(byArray5, byArray6, appleImage, i);
                    continue;
                }
                if (!this.isDoubleHiresColorMode()) continue;
                this.processDoubleHiresColorLine(byArray5, byArray6, appleImage, i);
            }
        }
        try {
            appleImage.setFileExtension(referenceImage.getFileExtension());
            object = new ByteArrayOutputStream();
            appleImage.save((OutputStream)object);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void processHiresBlackAndWhiteLine(byte[] byArray, AppleImage appleImage, int n) {
        for (int i = 0; i < 280; ++i) {
            int n2 = i / 7;
            byte by = byArray[n2];
            int n3 = i % 7;
            if (AppleUtil.isBitSet(by, n3)) {
                appleImage.setPoint(i, n, 0xFFFFFF);
                continue;
            }
            appleImage.setPoint(i, n, 0);
        }
    }

    protected void processHiresColorLine(byte[] byArray, AppleImage appleImage, int n) {
        for (int i = 0; i < 140; ++i) {
            int n2;
            int n3 = i * 2;
            int n4 = n3 + 1;
            int n5 = n3 / 7;
            int n6 = n3 % 7;
            boolean bl = AppleUtil.isBitSet(byArray[n5], n6);
            int n7 = n4 / 7;
            int n8 = n4 % 7;
            boolean bl2 = AppleUtil.isBitSet(byArray[n7], n8);
            if (bl && bl2) {
                n2 = 0xFFFFFF;
            } else if (!bl && !bl2) {
                n2 = 0;
            } else {
                boolean bl3;
                boolean bl4 = bl3 = bl ? AppleUtil.isBitSet(byArray[n5], 7) : AppleUtil.isBitSet(byArray[n7], 7);
                n2 = bl && bl3 ? 255 : (bl && !bl3 ? 0xFF00FF : (bl2 && !bl3 ? 65280 : 0xFF8000));
            }
            if (bl) {
                appleImage.setPoint(n3, n, n2);
            }
            if (!bl2) continue;
            appleImage.setPoint(n4, n, n2);
        }
    }

    protected void processDoubleHiresBlackAndWhiteLine(byte[] byArray, byte[] byArray2, AppleImage appleImage, int n) {
        for (int i = 0; i < 560; ++i) {
            int n2;
            int n3;
            byte[] byArray3 = i % 14 < 7 ? byArray : byArray2;
            byte by = byArray3[n3 = i / 14];
            if (AppleUtil.isBitSet(by, n2 = i % 7)) {
                appleImage.setPoint(i, n * 2, 0xFFFFFF);
                appleImage.setPoint(i, n * 2 + 1, 0xFFFFFF);
                continue;
            }
            appleImage.setPoint(i, n * 2, 0);
            appleImage.setPoint(i, n * 2 + 1, 0);
        }
    }

    protected void processDoubleHiresColorLine(byte[] byArray, byte[] byArray2, AppleImage appleImage, int n) {
        int[] nArray = new int[]{8, 4, 2, 1};
        int[] nArray2 = new int[]{0, 0xFF0000, 0x800000, 0xFF8000, 32768, 0x808080, 65280, 0xFFFF00, 128, 0xFF00FF, 0x808080, 16744640, 160, 255, 49280, 0xFFFFFF};
        for (int i = 0; i < 560; i += 4) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < 4; ++n2) {
                int n4;
                int n5;
                int n6 = i + n2;
                byte[] byArray3 = n6 % 14 < 7 ? byArray : byArray2;
                byte by = byArray3[n5 = n6 / 14];
                if (!AppleUtil.isBitSet(by, n4 = n6 % 7)) continue;
                n3 += nArray[n2];
            }
            for (n2 = 0; n2 < 4; ++n2) {
                appleImage.setPoint(i + n2, n * 2, nArray2[n3]);
                appleImage.setPoint(i + n2, n * 2 + 1, nArray2[n3]);
            }
        }
    }

    protected void processSuperHiresLine(byte[] byArray, AppleImage appleImage, int n, byte by, byte[] byArray2) {
        int n2;
        boolean bl;
        int n3 = by & 0xF;
        boolean bl2 = (by & 0x20) != 0;
        boolean bl3 = bl = (by & 0x80) == 0;
        if (this.isSuperHires3200Mode()) {
            n2 = byArray2.length / 32;
            n3 = n % n2;
            bl2 = false;
            bl = true;
        }
        n2 = bl ? 320 : 640;
        int n4 = n * 2;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            int n6;
            byte by2;
            int n7;
            int n8;
            if (bl) {
                n8 = i / 2;
                n7 = i % 2;
                by2 = byArray[n8];
                n6 = n7 == 1 ? by2 & 0xF : (by2 & 0xF0) >> 4;
                if (this.isSuperHires3200Mode()) {
                    n6 = 15 - n6;
                }
            } else {
                n8 = i / 4;
                n7 = i % 4;
                by2 = byArray[n8];
                switch (n7) {
                    case 0: {
                        n6 = (by2 & 0xC0) >> 6;
                        break;
                    }
                    case 1: {
                        n6 = (by2 & 0x30) >> 4;
                        break;
                    }
                    case 2: {
                        n6 = (by2 & 0xC) >> 2;
                        break;
                    }
                    default: {
                        n6 = by2 & 3;
                    }
                }
                n6 += 12 - n7 * 4;
            }
            if (n6 == 0 && bl2) {
                n8 = n5;
            } else {
                n7 = AppleUtil.getWordValue(byArray2, n3 * 32 + n6 * 2);
                n8 = (n7 & 0xF00) << 12 | (n7 & 0xF0) << 8 | (n7 & 0xF) << 4;
            }
            n7 = bl ? i * 2 : i;
            appleImage.setPoint(n7, n4, n8);
            appleImage.setPoint(n7, n4 + 1, n8);
            if (!bl) continue;
            appleImage.setPoint(n7 + 1, n4, n8);
            appleImage.setPoint(n7 + 1, n4 + 1, n8);
        }
    }

    public AppleImage[] buildQuickDraw2Icons(FileEntry fileEntry) {
        int n;
        ArrayList<AppleImage> arrayList = new ArrayList<AppleImage>();
        byte[] byArray = fileEntry.getFileData();
        for (int i = 26; i < byArray.length && (n = AppleUtil.getWordValue(byArray, i)) != 0; i += n) {
            AppleImage[] appleImageArray = this.buildQuickDraw2IconAndMask(byArray, i + 86);
            arrayList.add(appleImageArray[0]);
            arrayList.add(appleImageArray[1]);
        }
        AppleImage[] appleImageArray = new AppleImage[arrayList.size()];
        arrayList.toArray(appleImageArray);
        return appleImageArray;
    }

    protected AppleImage[] buildQuickDraw2IconAndMask(byte[] byArray, int n) {
        boolean bl = AppleUtil.getWordValue(byArray, n) == 32768;
        int n2 = AppleUtil.getWordValue(byArray, n + 4);
        int n3 = AppleUtil.getWordValue(byArray, n + 6);
        AppleImage[] appleImageArray = new AppleImage[2];
        appleImageArray[0] = this.buildQuickDraw2IconOrMask(byArray, bl, n2, n3, n += 8);
        int n4 = 1 + (n3 - 1) / 2;
        appleImageArray[1] = this.buildQuickDraw2IconOrMask(byArray, false, n2, n3, n += n4 * n2);
        return appleImageArray;
    }

    protected AppleImage buildQuickDraw2IconOrMask(byte[] byArray, boolean bl, int n, int n2, int n3) {
        AppleImage appleImage = AppleImage.create(n2, n);
        int[] nArray = new int[]{0, 0xFF0000, 0x800000, 0xFF8000, 32768, 0x808080, 65280, 0xFFFF00, 128, 0xFF00FF, 0x808080, 16744640, 160, 255, 49280, 0xFFFFFF};
        int[] nArray2 = new int[]{0, 0x111111, 0x222222, 0x333333, 0x444444, 0x555555, 0x666666, 0x777777, 0x888888, 0x999999, 0xAAAAAA, 0xBBBBBB, 0xCCCCCC, 0xDDDDDD, 0xEEEEEE, 0xFFFFFF};
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                if (j > 0 && j % 2 == 0) {
                    ++n3;
                }
                int n4 = AppleUtil.getUnsignedByte(byArray[n3]);
                int n5 = 0;
                n5 = j % 2 == 0 ? n4 & 0xF : n4 & 0xF;
                int n6 = bl ? nArray[n5] : nArray2[n5];
                appleImage.setPoint(j, i, n6);
            }
            ++n3;
        }
        return appleImage;
    }

    public void copyImage(AppleImage appleImage, AppleImage appleImage2, int n, int n2) {
        for (int i = 0; i < appleImage2.getHeight(); ++i) {
            for (int j = 0; j < appleImage2.getWidth(); ++j) {
                appleImage.setPoint(n + j, n2 + i, appleImage2.getPoint(j, i));
            }
        }
    }

    public static String[] getFileExtensions() {
        return referenceImage.getAvailableExtensions();
    }

    public String getSuggestedFileName(FileEntry fileEntry) {
        String string = fileEntry.getFilename().trim();
        if (!string.toLowerCase().endsWith("." + this.getExtension())) {
            string = string + "." + this.getExtension();
        }
        return string;
    }

    public void setExtension(String string) {
        referenceImage.setFileExtension(string);
    }

    public String getExtension() {
        return referenceImage.getFileExtension();
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public boolean isHiresBlackAndWhiteMode() {
        return this.mode == 1;
    }

    public boolean isHiresColorMode() {
        return this.mode == 2;
    }

    public boolean isDoubleHiresBlackAndWhiteMode() {
        return this.mode == 3;
    }

    public boolean isDoubleHiresColorMode() {
        return this.mode == 4;
    }

    public boolean isSuperHires16Mode() {
        return this.mode == 5;
    }

    public boolean isSuperHires3200Mode() {
        return this.mode == 6;
    }

    public boolean isHiresMode() {
        return this.isHiresBlackAndWhiteMode() || this.isHiresColorMode();
    }

    public boolean isDoubleHiresMode() {
        return this.isDoubleHiresBlackAndWhiteMode() || this.isDoubleHiresColorMode();
    }

    public boolean isSuperHiresMode() {
        return this.isSuperHires16Mode() || this.isSuperHires3200Mode();
    }

    public boolean isQuickDraw2Icon() {
        return this.mode == 7;
    }
}

