/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.storage;

import com.webcodepro.applecommander.storage.FormattedDisk;
import com.webcodepro.applecommander.storage.StorageBundle;
import com.webcodepro.applecommander.storage.os.cpm.CpmFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.DosFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.OzDosFormatDisk;
import com.webcodepro.applecommander.storage.os.dos33.UniDosFormatDisk;
import com.webcodepro.applecommander.storage.os.gutenberg.GutenbergFormatDisk;
import com.webcodepro.applecommander.storage.os.nakedos.NakedosFormatDisk;
import com.webcodepro.applecommander.storage.os.pascal.PascalFormatDisk;
import com.webcodepro.applecommander.storage.os.prodos.ProdosFormatDisk;
import com.webcodepro.applecommander.storage.os.rdos.RdosFormatDisk;
import com.webcodepro.applecommander.storage.physical.ByteArrayImageLayout;
import com.webcodepro.applecommander.storage.physical.DosOrder;
import com.webcodepro.applecommander.storage.physical.ImageOrder;
import com.webcodepro.applecommander.storage.physical.NibbleOrder;
import com.webcodepro.applecommander.storage.physical.ProdosOrder;
import com.webcodepro.applecommander.storage.physical.UniversalDiskImageLayout;
import com.webcodepro.applecommander.util.AppleUtil;
import com.webcodepro.applecommander.util.StreamUtil;
import com.webcodepro.applecommander.util.TextBundle;
import com.webcodepro.shrinkit.Utilities;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Disk {
    public static final int BLOCK_SIZE = 512;
    public static final int SECTOR_SIZE = 256;
    public static final int PRODOS_BLOCKS_ON_140KB_DISK = 280;
    public static final int DOS33_SECTORS_ON_140KB_DISK = 560;
    public static final int APPLE_140KB_DISK = 143360;
    public static final int APPLE_140KB_NIBBLE_DISK = 232960;
    public static final int APPLE_800KB_DISK = 819200;
    public static final int APPLE_800KB_2IMG_DISK = 819264;
    public static final int APPLE_5MB_HARDDISK = 0x500000;
    public static final int APPLE_10MB_HARDDISK = 0xA00000;
    public static final int APPLE_20MB_HARDDISK = 0x1400000;
    public static final int APPLE_32MB_HARDDISK = 33553920;
    private static FilenameFilter[] filenameFilters;
    private static String[] allFileExtensions;
    private TextBundle textBundle = StorageBundle.getInstance();
    private String filename;
    private boolean newImage = false;
    private boolean isDC42 = false;
    private ByteArrayImageLayout diskImageManager;
    private ImageOrder imageOrder = null;

    public static FilenameFilter[] getFilenameFilters() {
        if (filenameFilters == null) {
            new Disk();
        }
        return filenameFilters;
    }

    public static String[] getAllExtensions() {
        if (allFileExtensions == null) {
            new Disk();
        }
        return allFileExtensions;
    }

    private Disk() {
        filenameFilters = new FilenameFilter[]{new FilenameFilter(this.textBundle.get("Disk.AllImages"), "*.do; *.dsk; *.po; *.nib; *.2mg; *.2img; *.hdv; *.do.gz; *.dsk.gz; *.po.gz; *.nib.gz; *.2mg.gz; *.2img.gz"), new FilenameFilter(this.textBundle.get("Disk.140kDosImages"), "*.do; *.dsk; *.do.gz; *.dsk.gz"), new FilenameFilter(this.textBundle.get("Disk.140kNibbleImages"), "*.nib; *.nib.gz"), new FilenameFilter(this.textBundle.get("Disk.140kProdosImages"), "*.po; *.po.gz"), new FilenameFilter(this.textBundle.get("Disk.800kProdosImages"), "*.2mg; *.2img; *.2mg.gz, *.2img.gz"), new FilenameFilter(this.textBundle.get("Disk.ApplePcImages"), "*.hdv"), new FilenameFilter(this.textBundle.get("Disk.CompressedImages"), "*.sdk; *.shk; *.do.gz; *.dsk.gz; *.po.gz; *.2mg.gz; *.2img.gz"), new FilenameFilter(this.textBundle.get("Disk.AllFiles"), "*.*")};
        allFileExtensions = new String[]{".do", ".dsk", ".po", ".nib", ".sdk", ".shk", ".2mg", ".2img", ".hdv", ".do.gz", ".dsk.gz", ".po.gz", ".nib.gz", ".2mg.gz", ".2img.gz"};
    }

    protected Disk(String string, ImageOrder imageOrder) {
        this.imageOrder = imageOrder;
        this.filename = string;
        this.newImage = true;
    }

    public Disk(String string) throws IOException {
        this(string, 0, false);
    }

    public Disk(String string, boolean bl) throws IOException {
        this(string, 0, bl);
    }

    public Disk(String string, int n) throws IOException {
        this(string, n, false);
    }

    public Disk(String string, int n, boolean bl) throws IOException {
        Object object;
        this.filename = string;
        int n2 = 0;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (this.isSDK() || this.isSHK() || this.isBXY()) {
            byArray = Utilities.unpackSHKFile(string, n);
            n2 = byArray.length;
            this.filename = this.filename + ".po";
        } else {
            File file = new File(string);
            n2 = (int)file.length();
            InputStream inputStream = new FileInputStream(file);
            if (this.isCompressed()) {
                inputStream = new GZIPInputStream(inputStream);
            }
            object = new ByteArrayOutputStream(n2);
            StreamUtil.copy(inputStream, (OutputStream)object);
            byArray = ((ByteArrayOutputStream)object).toByteArray();
        }
        boolean bl2 = false;
        if (byArray[0] == 50 && byArray[1] == 73 && byArray[2] == 77 && byArray[3] == 71) {
            bl2 = true;
        } else if (Disk.isDC42(byArray)) {
            this.isDC42 = true;
            long l = AppleUtil.getLongValue(byArray, 64);
            if (l < (long)(byArray.length - 83)) {
                byArray2 = new byte[(int)l];
                System.arraycopy(byArray, 84, byArray2, 0, (int)l);
                this.diskImageManager = new ByteArrayImageLayout(byArray2);
                this.filename = this.filename + ".po";
            } else {
                throw new IllegalArgumentException(this.textBundle.get("CommandLineDC42Bad"));
            }
        }
        this.diskImageManager = bl2 || byArray.length == 819264 || byArray.length == 0x500040 || byArray.length == 0xA00040 || byArray.length == 0x1400040 || byArray.length == 33553984 ? new UniversalDiskImageLayout(byArray) : (this.isDC42 ? new ByteArrayImageLayout(byArray2) : new ByteArrayImageLayout(byArray));
        DosOrder dosOrder = new DosOrder(this.diskImageManager);
        object = new ProdosOrder(this.diskImageManager);
        if (this.isSDK()) {
            this.imageOrder = object;
        } else {
            int n3 = -1;
            if (n2 == 143360) {
                this.imageOrder = dosOrder;
                if ((this.isProdosFormat() || this.isDosFormat()) && !bl) {
                    n3 = 0;
                } else {
                    this.imageOrder = object;
                    if (bl || this.isProdosFormat() || this.isDosFormat()) {
                        n3 = 0;
                    }
                }
                if (n3 == -1) {
                    if (this.isProdosOrder() || this.is2ImgOrder()) {
                        this.imageOrder = object;
                        n3 = 0;
                    } else if (this.isDosOrder()) {
                        this.imageOrder = dosOrder;
                        n3 = 0;
                    } else if (this.isNibbleOrder()) {
                        this.imageOrder = new NibbleOrder(this.diskImageManager);
                        n3 = 0;
                    }
                }
                if (n3 == -1) {
                    this.imageOrder = dosOrder;
                    n3 = this.testImageOrder();
                }
            }
            if (n3 == -1) {
                this.imageOrder = object;
                n3 = this.testImageOrder();
                if (n3 == -1) {
                    this.imageOrder = this.isProdosOrder() || this.is2ImgOrder() ? object : (this.isDosOrder() ? dosOrder : (this.isNibbleOrder() ? new NibbleOrder(this.diskImageManager) : object));
                }
            }
        }
    }

    public int testImageOrder() {
        int n = (true == this.isProdosFormat() ? 1 : 0) + (true == this.isDosFormat() ? 2 : 0) + (true == this.isCpmFormat() ? 4 : 0) + (true == this.isUniDosFormat() ? 8 : 0) + (true == this.isPascalFormat() ? 16 : 0) + (true == this.isOzDosFormat() ? 32 : 0);
        if (n == 0) {
            n = -1;
        }
        return n;
    }

    public void save() throws IOException {
        File file = new File(this.getFilename());
        if (!file.exists()) {
            file.createNewFile();
        }
        OutputStream outputStream = new FileOutputStream(file);
        if (this.isCompressed()) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        outputStream.write(this.getDiskImageManager().getDiskImage());
        outputStream.close();
        this.getDiskImageManager().setChanged(false);
        this.newImage = false;
    }

    public void saveAs(String string) throws IOException {
        this.filename = string;
        this.save();
    }

    public FormattedDisk[] getFormattedDisks() {
        if (this.isProdosFormat()) {
            return new FormattedDisk[]{new ProdosFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isUniDosFormat()) {
            return new FormattedDisk[]{new UniDosFormatDisk(this.filename, this.imageOrder, 0), new UniDosFormatDisk(this.filename, this.imageOrder, 50)};
        }
        if (this.isOzDosFormat()) {
            return new FormattedDisk[]{new OzDosFormatDisk(this.filename, this.imageOrder, 0), new OzDosFormatDisk(this.filename, this.imageOrder, 256)};
        }
        if (this.isDosFormat()) {
            return new FormattedDisk[]{new DosFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isNakedosFormat()) {
            return new FormattedDisk[]{new NakedosFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isPascalFormat()) {
            return new FormattedDisk[]{new PascalFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isRdosFormat()) {
            return new FormattedDisk[]{new RdosFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isCpmFormat()) {
            return new FormattedDisk[]{new CpmFormatDisk(this.filename, this.imageOrder)};
        }
        if (this.isWPFormat()) {
            return new FormattedDisk[]{new GutenbergFormatDisk(this.filename, this.imageOrder)};
        }
        return null;
    }

    public ByteArrayImageLayout getDiskImageManager() {
        if (this.imageOrder != null) {
            return this.imageOrder.getDiskImageManager();
        }
        return this.diskImageManager;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getOrderName() {
        return this.imageOrder == null ? this.textBundle.get("FormattedDisk.Unknown") : this.imageOrder.getName();
    }

    public boolean isCompressed() {
        return this.filename.toLowerCase().endsWith(".gz");
    }

    public boolean isSDK() {
        return this.filename.toLowerCase().endsWith(".sdk");
    }

    public boolean isSHK() {
        return this.filename.toLowerCase().endsWith(".shk");
    }

    public boolean isBXY() {
        return this.filename.toLowerCase().endsWith(".bxy");
    }

    public boolean isProdosOrder() {
        return this.filename.toLowerCase().endsWith(".po") || this.filename.toLowerCase().endsWith(".po.gz") || this.is2ImgOrder() || this.filename.toLowerCase().endsWith(".hdv") || this.getPhysicalSize() >= 819264;
    }

    public boolean isDosOrder() {
        return this.filename.toLowerCase().endsWith(".do") || this.filename.toLowerCase().endsWith(".do.gz") || this.filename.toLowerCase().endsWith(".dsk") || this.filename.toLowerCase().endsWith(".dsk.gz");
    }

    public boolean is2ImgOrder() {
        return this.filename.toLowerCase().endsWith(".2img") || this.filename.toLowerCase().endsWith(".2img.gz") || this.filename.toLowerCase().endsWith(".2mg") || this.filename.toLowerCase().endsWith(".2mg.gz");
    }

    public boolean isNibbleOrder() {
        return this.filename.toLowerCase().endsWith(".nib") || this.filename.toLowerCase().endsWith(".nib.gz");
    }

    public int getPhysicalSize() {
        if (this.getDiskImageManager() != null) {
            return this.getDiskImageManager().getPhysicalSize();
        }
        return this.getImageOrder().getPhysicalSize();
    }

    protected void resizeDiskImage(int n) {
        if (n < this.getPhysicalSize()) {
            throw new IllegalArgumentException(this.textBundle.get("Disk.ResizeDiskError"));
        }
        byte[] byArray = new byte[n];
        byte[] byArray2 = this.imageOrder.getDiskImageManager().getDiskImage();
        System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        this.imageOrder.getDiskImageManager().setDiskImage(byArray);
    }

    public byte[] readBlock(int n) {
        return this.imageOrder.readBlock(n);
    }

    public void writeBlock(int n, byte[] byArray) {
        this.imageOrder.writeBlock(n, byArray);
    }

    public byte[] readSector(int n, int n2) throws IllegalArgumentException {
        return this.imageOrder.readSector(n, n2);
    }

    public void writeSector(int n, int n2, byte[] byArray) throws IllegalArgumentException {
        this.imageOrder.writeSector(n, n2, byArray);
    }

    public boolean isProdosFormat() {
        byte[] byArray = this.readBlock(2);
        byte by = byArray[35];
        byte by2 = byArray[36];
        return byArray[0] == 0 && byArray[1] == 0 && (byArray[4] & 0xF0) == 240 && by * by2 <= 512;
    }

    public boolean isDosFormat() {
        boolean bl = false;
        if (!this.is140KbDisk()) {
            return false;
        }
        try {
            byte by;
            byte[] byArray;
            byte by2;
            byte[] byArray2 = this.readSector(17, 0);
            boolean bl2 = bl = !(!this.imageOrder.isSizeApprox(143360) && !this.imageOrder.isSizeApprox(232960) || byArray2[1] != 17 || byArray2[39] != 122 || byArray2[52] != 35 && byArray2[52] != 40 || byArray2[53] != 16);
            if (bl && (by2 = byArray2[1]) == (byArray = this.readSector(by2, by = byArray2[2]))[1] && by == byArray[2] + 1) {
                by2 = byArray[1];
                by = byArray[2];
                bl = by2 == (byArray = this.readSector(by2, by))[1] && by == byArray[2] + 1;
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean isUniDosFormat() {
        if (!this.is800KbDisk()) {
            return false;
        }
        byte[] byArray = this.readSector(17, 0);
        byte[] byArray2 = this.readSector(67, 0);
        return byArray[1] == 17 && byArray[2] == 31 && byArray[39] == 122 && byArray[52] == 50 && byArray[53] == 32 && byArray[54] == 0 && byArray[55] == 1 && byArray2[1] == 17 && byArray2[2] == 31 && byArray2[39] == 122 && byArray2[52] == 50 && byArray2[53] == 32 && byArray2[54] == 0 && byArray2[55] == 1;
    }

    public boolean isOzDosFormat() {
        if (!this.is800KbDisk()) {
            return false;
        }
        byte[] byArray = this.readBlock(544);
        return byArray[1] == 17 && byArray[2] == 31 && byArray[39] == 122 && byArray[52] == 50 && byArray[53] == 32 && byArray[54] == 0 && byArray[55] == 1 && byArray[311] == 1 && byArray[257] == 17 && byArray[258] == 31 && byArray[295] == 122 && byArray[308] == 50 && byArray[309] == 32 && byArray[310] == 0 && byArray[311] == 1;
    }

    public boolean isNakedosFormat() {
        if (!this.is140KbDisk()) {
            return false;
        }
        byte[] byArray = this.readSector(0, 3);
        return (this.imageOrder.isSizeApprox(143360) || this.imageOrder.isSizeApprox(232960)) && byArray[208] == -2 && byArray[209] == -2 && byArray[210] == -2 && byArray[211] == -2 && byArray[212] == -2 && byArray[213] == -2 && byArray[214] == -2 && byArray[215] == -2 && byArray[216] == -2 && byArray[217] == -2 && byArray[218] == -2 && byArray[219] == -2 && byArray[220] != -2;
    }

    public boolean isPascalFormat() {
        if (!this.is140KbDisk() && !this.is800KbDisk()) {
            return false;
        }
        byte[] byArray = this.readBlock(2);
        return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 6 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0;
    }

    public boolean isCpmFormat() {
        int n;
        if (!this.is140KbDisk()) {
            return false;
        }
        byte[] byArray = this.readSector(3, 0);
        int[] nArray = new int[256];
        for (n = 0; n < byArray.length; ++n) {
            nArray[n] = AppleUtil.getUnsignedByte(byArray[n]);
        }
        for (n = 0; n < byArray.length; n += 32) {
            int n2;
            int n3 = 0;
            for (n2 = 0; n2 < 32; ++n2) {
                n3 += nArray[n + n2] == 229 ? 1 : 0;
            }
            if (n3 == 32) continue;
            if (nArray[n] > 15 && nArray[n] != 229) {
                return false;
            }
            for (n2 = 0; n2 < 8; ++n2) {
                if (nArray[n + 1 + n2] <= 127) continue;
                return false;
            }
            if (nArray[n + 12] > 31 || nArray[n + 14] > 0) {
                return false;
            }
            if (nArray[n + 15] <= 128) continue;
            return false;
        }
        return true;
    }

    protected boolean is140KbDisk() {
        return this.getPhysicalSize() >= 143360 && this.getPhysicalSize() <= 232960;
    }

    protected boolean is800KbDisk() {
        return this.getPhysicalSize() >= 819200 && this.getPhysicalSize() <= 819264;
    }

    public boolean isRdosFormat() {
        if (!this.is140KbDisk()) {
            return false;
        }
        byte[] byArray = this.readSector(0, 13);
        String string = AppleUtil.getString(byArray, 224, 4);
        return "RDOS".equals(string);
    }

    public boolean isWPFormat() {
        if (!this.is140KbDisk()) {
            return false;
        }
        byte[] byArray = this.readSector(17, 7);
        return (this.imageOrder.isSizeApprox(143360) || this.imageOrder.isSizeApprox(232960)) && byArray[0] == 17 && byArray[1] == 7 && byArray[15] == -115;
    }

    private static boolean isDC42(byte[] byArray) {
        boolean bl = byArray[82] == 1 && byArray[83] == 0 && (byArray[81] == 2 || byArray[81] == 34 || byArray[81] == 36);
        return byArray[82] == 1 && byArray[83] == 0 && (byArray[81] == 2 || byArray[81] == 34 || byArray[81] == 36);
    }

    public boolean isDC42() {
        return this.isDC42;
    }

    public boolean hasChanged() {
        return this.getDiskImageManager().hasChanged();
    }

    public boolean isNewImage() {
        return this.newImage;
    }

    public ImageOrder getImageOrder() {
        return this.imageOrder;
    }

    protected void setImageOrder(ImageOrder imageOrder) {
        this.imageOrder = imageOrder;
    }

    public void makeDosOrder() {
        DosOrder dosOrder = new DosOrder(new ByteArrayImageLayout(143360));
        this.changeImageOrderByTrackAndSector(this.getImageOrder(), dosOrder);
        this.setImageOrder(dosOrder);
    }

    public void makeProdosOrder() {
        ProdosOrder prodosOrder = new ProdosOrder(new ByteArrayImageLayout(143360));
        this.changeImageOrderByBlock(this.getImageOrder(), prodosOrder);
        this.setImageOrder(prodosOrder);
    }

    public static int sizeToFit(long l) {
        if (l < 143360L) {
            return 143360;
        }
        if (l < 819200L) {
            return 819200;
        }
        if (l < 0x500000L) {
            return 0x500000;
        }
        if (l < 0xA00000L) {
            return 0xA00000;
        }
        if (l < 0x1400000L) {
            return 0x1400000;
        }
        if (l < 33553920L) {
            return 0x1400000;
        }
        if (l < 33553920L) {
            return 33553920;
        }
        return -1;
    }

    private void changeImageOrderByTrackAndSector(ImageOrder imageOrder, ImageOrder imageOrder2) {
        if (!Disk.sameSectorsPerDisk(imageOrder, imageOrder2)) {
            throw new IllegalArgumentException(this.textBundle.get("Disk.ResizeDiskError"));
        }
        for (int i = 0; i < imageOrder.getTracksPerDisk(); ++i) {
            for (int j = 0; j < imageOrder.getSectorsPerTrack(); ++j) {
                byte[] byArray = imageOrder.readSector(i, j);
                imageOrder2.writeSector(i, j, byArray);
            }
        }
    }

    private void changeImageOrderByBlock(ImageOrder imageOrder, ImageOrder imageOrder2) {
        if (!Disk.sameBlocksPerDisk(imageOrder, imageOrder2)) {
            throw new IllegalArgumentException(this.textBundle.get("Disk.ResizeDiskError"));
        }
        for (int i = 0; i < imageOrder.getBlocksOnDevice(); ++i) {
            byte[] byArray = imageOrder.readBlock(i);
            imageOrder2.writeBlock(i, byArray);
        }
    }

    private static boolean sameBlocksPerDisk(ImageOrder imageOrder, ImageOrder imageOrder2) {
        return imageOrder.getBlocksOnDevice() == imageOrder2.getBlocksOnDevice();
    }

    private static boolean sameSectorsPerDisk(ImageOrder imageOrder, ImageOrder imageOrder2) {
        return imageOrder.getSectorsPerDisk() == imageOrder2.getSectorsPerDisk();
    }

    static {
        allFileExtensions = null;
    }

    public class FilenameFilter {
        private String names;
        private String extensions;

        public FilenameFilter(String string, String string2) {
            this.names = string;
            this.extensions = string2;
        }

        public String getExtensions() {
            return this.extensions;
        }

        public String getNames() {
            return this.names;
        }
    }
}

