context("Reading image data from different PNG subformats")

test_that("we can read from PNG images in different subformats", {
    path <- system.file("extdata", "pngsuite", package="loder")
    
    expect_output(print(readPng(file.path(path,"basn0g01.png"))), "PNG image array: 32 x 32 pixels, grey")
    expect_equal(readPng(file.path(path,"basn0g01.png"))[16,16,], 255L)
    expect_equal(readPng(file.path(path,"basn0g02.png"))[16,16,], 170L)
    expect_equal(readPng(file.path(path,"basn0g04.png"))[16,16,], 102L)
    expect_equal(readPng(file.path(path,"basn0g08.png"))[16,16,], 15L)
    expect_equal(readPng(file.path(path,"basn0g16.png"))[16,16,], 165L)
    expect_equal(readPng(file.path(path,"basn2c08.png"))[16,16,], c(255L,16L,255L))
    expect_equal(readPng(file.path(path,"basn2c16.png"))[16,16,], c(132L,132L,0L))
    expect_equal(readPng(file.path(path,"basn3p01.png"))[16,16,], c(238L,255L,34L,255L))
    expect_equal(readPng(file.path(path,"basn3p02.png"))[16,16,], c(0L,0L,255L,255L))
    expect_equal(readPng(file.path(path,"basn3p04.png"))[16,16,], c(0L,255L,68L,255L))
    expect_equal(readPng(file.path(path,"basn3p08.png"))[16,16,], c(123L,254L,0L,255L))
    expect_equal(readPng(file.path(path,"basn4a08.png"))[16,16,], c(131L,123L))
    expect_equal(readPng(file.path(path,"basn4a16.png"))[16,16,], c(0L,247L))
    expect_equal(readPng(file.path(path,"basn6a08.png"))[16,16,], c(32L,255L,4L,123L))
    expect_equal(readPng(file.path(path,"basn6a16.png"))[16,16,], c(255L,255L,0L,247L))
    expect_equal(readPng(file.path(path,"basi6a08.png"))[16,16,], c(32L,255L,4L,123L))
    expect_equal(readPng(file.path(path,"z00n2c08.png"))[16,16,], c(132L,132L,0L))
    expect_equal(readPng(file.path(path,"z03n2c08.png"))[16,16,], c(132L,132L,0L))
})

test_that("errors are raised for defective files", {
    path <- system.file("extdata", "pngsuite", package="loder")
    
    expect_error(readPng(file.path(path,"nosuchfile.png")))
    expect_error(readPng(file.path(path,"xc1n0g08.png")))
    expect_error(readPng(file.path(path,"xc9n2c08.png")))
    expect_error(readPng(file.path(path,"xcrn0g04.png")))
    # LodePNG does not produce an error in this case (incorrect IDAT checksum)
    # expect_error(readPng(file.path(path,"xcsn0g01.png")))
    expect_error(readPng(file.path(path,"xd0n2c08.png")))
    expect_error(readPng(file.path(path,"xd3n2c08.png")))
    expect_error(readPng(file.path(path,"xd9n2c08.png")))
    expect_error(readPng(file.path(path,"xdtn0g01.png")))
    expect_error(readPng(file.path(path,"xhdn0g08.png")))
    expect_error(readPng(file.path(path,"xlfn0g04.png")))
    expect_error(readPng(file.path(path,"xs1n0g01.png")))
    expect_error(readPng(file.path(path,"xs2n0g01.png")))
    expect_error(readPng(file.path(path,"xs4n0g01.png")))
    expect_error(readPng(file.path(path,"xs7n0g01.png")))
})
