## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library("igraph")
library("dagitty")

## ----setup--------------------------------------------------------------------
library("dosearch")

## ----eval = FALSE-------------------------------------------------------------
#  dosearch(
#    data, query, graph,
#    transportability = NULL, selection_bias = NULL, missing_data = NULL,
#    control = list()
#  )

## -----------------------------------------------------------------------------
data <- "
  P(W)
  P(Y|X)
  P(Z|do(X),W)
"

## -----------------------------------------------------------------------------
data <- list(
  "P(W)",
  "P(Y|X)",
  "P(Z|do(X),W)"
)

## -----------------------------------------------------------------------------
query <- "P(Y|do(X),W)"

## -----------------------------------------------------------------------------
query <- c(Y = 0, X = 1, W = 2)

## -----------------------------------------------------------------------------
data <- list(
  c(W = 0),
  c(Y = 0, X = 2),
  c(Z = 0, X = 1, W = 2)
)

## -----------------------------------------------------------------------------
graph <- "
  X -> Y
  Z -> X
  Z -> Y
  X <-> Y
"

## -----------------------------------------------------------------------------
library("igraph")
graph <- graph.formula(X -+ Y, Z -+ X, Z -+ Y, X -+ Y, Y -+ X)
graph <- set_edge_attr(graph, "description", 4:5, "U")

## -----------------------------------------------------------------------------
library("dagitty")
graph <- dagitty("dag{X -> Y; Z -> X; Z -> Y; X <-> Y}")

