/*
 * Decompiled with CFR 0.152.
 */
package com.vlsolutions.swing.docking;

import com.vlsolutions.swing.docking.DockingConstants;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class AutoHidePolicy {
    public static final int INITIAL_EXPAND_COMPONENT_SIZE = 0;
    public static final int INITIAL_EXPAND_CUSTOM_SIZE = 1;
    public static final String PROPERTY_DEFAULT_HIDE_BORDER = "defaultHideBorder";
    public static final String PROPERTY_DEFAULT_GAP = "defaultGap";
    public static final String PROPERTY_EXPAND_MODE = "expandMode";
    public static final String PROPERTY_ROLLOVER_TRIGGER_DELAY = "rolloverTriggerDelay";
    public static final String PROPERTY_EXPANSION_DURATION = "expansionDuration";
    private static AutoHidePolicy policy = new AutoHidePolicy();
    private DockingConstants.Hide defaultHideBorder = DockingConstants.HIDE_LEFT;
    private int defaultGap = 4;
    private ExpandMode expandMode;
    private int rolloverTriggerDelay = 500;
    private int expansionDuration = 300;
    private int initialExpansionModel = 0;
    private int initialExpansionWidth = 200;
    private int initialExpansionHeight = 200;
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);

    private AutoHidePolicy() {
    }

    public void setDefaultHideBorder(DockingConstants.Hide defaultHideBorder) {
        DockingConstants.Hide old = this.defaultHideBorder;
        this.defaultHideBorder = defaultHideBorder;
        this.propertySupport.firePropertyChange(PROPERTY_DEFAULT_HIDE_BORDER, old, defaultHideBorder);
    }

    public DockingConstants.Hide getDefaultHideBorder() {
        return this.defaultHideBorder;
    }

    public int getDefaultGap() {
        return this.defaultGap;
    }

    public void setDefaultGap(int gap) {
        int old = this.defaultGap;
        this.defaultGap = gap;
        this.propertySupport.firePropertyChange(PROPERTY_DEFAULT_GAP, old, gap);
    }

    public static AutoHidePolicy getPolicy() {
        return policy;
    }

    public ExpandMode getExpandMode() {
        return this.expandMode;
    }

    public void setExpandMode(ExpandMode expandMode) {
        ExpandMode old = this.expandMode;
        this.expandMode = expandMode;
        this.propertySupport.firePropertyChange(PROPERTY_EXPAND_MODE, (Object)old, (Object)expandMode);
    }

    public int getRolloverTriggerDelay() {
        return this.rolloverTriggerDelay;
    }

    public void setRolloverTriggerDelay(int delay) {
        int old = this.rolloverTriggerDelay;
        this.rolloverTriggerDelay = delay;
        this.propertySupport.firePropertyChange(PROPERTY_ROLLOVER_TRIGGER_DELAY, old, delay);
    }

    public int getExpansionDuration() {
        return this.expansionDuration;
    }

    public void setExpansionDuration(int millis) {
        int old = this.expansionDuration;
        this.expansionDuration = millis;
        this.propertySupport.firePropertyChange(PROPERTY_EXPANSION_DURATION, old, millis);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    public int getInitialExpansionModel() {
        return this.initialExpansionModel;
    }

    public void setInitialExpansionModel(int model) {
        this.initialExpansionModel = model;
    }

    public int getInitialExpansionWidth() {
        return this.initialExpansionWidth;
    }

    public void setInitialExpansionWidth(int initialExpansionWidth) {
        this.initialExpansionWidth = initialExpansionWidth;
    }

    public int getInitialExpansionHeight() {
        return this.initialExpansionHeight;
    }

    public void setInitialExpansionHeight(int initialExpansionHeight) {
        this.initialExpansionHeight = initialExpansionHeight;
    }

    public static enum ExpandMode {
        EXPAND_ON_ROLLOVER,
        EXPAND_ON_CLICK;

    }
}

