/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.mark.AbstractMarker;
import org.omegat.gui.editor.mark.BidiPainter;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.Styles;

public class BidiMarkers
extends AbstractMarker {
    private static final List<Mark> EMPTY_LIST = Collections.emptyList();
    static final int LRM = 8206;
    static final int RLM = 8207;
    static final int LRE = 8234;
    static final int RLE = 8235;
    static final int PDF = 8236;
    static final int LRO = 8237;
    static final int RLO = 8238;
    static final Highlighter.HighlightPainter LRE_BIDI_PAINTER = new BidiPainter(8234, Styles.EditorColor.COLOR_BIDIMARKERS.getColor());
    static final Highlighter.HighlightPainter RLE_BIDI_PAINTER = new BidiPainter(8235, Styles.EditorColor.COLOR_BIDIMARKERS.getColor());
    static final Highlighter.HighlightPainter LRM_BIDI_PAINTER = new BidiPainter(8206, Styles.EditorColor.COLOR_BIDIMARKERS.getColor());
    static final Highlighter.HighlightPainter RLM_BIDI_PAINTER = new BidiPainter(8207, Styles.EditorColor.COLOR_BIDIMARKERS.getColor());
    static final Highlighter.HighlightPainter RLO_BIDI_PAINTER = new BidiPainter(8238, Styles.EditorColor.COLOR_BIDIMARKERS.getColor());
    static final Highlighter.HighlightPainter LRO_BIDI_PAINTER = new BidiPainter(8237, Styles.EditorColor.COLOR_BIDIMARKERS.getColor());

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String text, boolean isActive) throws Exception {
        int cp;
        if (!this.isEnabled()) {
            return null;
        }
        if (!isActive || text == null || text.trim().isEmpty()) {
            return EMPTY_LIST;
        }
        text = StringUtil.normalizeUnicode(text);
        ArrayList<Mark> marks = new ArrayList<Mark>();
        int startPos = -1;
        int markCodePoint = -1;
        for (int i = 0; i < text.length(); i += Character.charCount(cp)) {
            Mark mark;
            cp = text.codePointAt(i);
            if (cp != 8234 && cp != 8235 && cp != 8206 && cp != 8207 && cp != 8236 && cp != 8237 && cp != 8238) continue;
            if (cp == 8236 && startPos != -1) {
                mark = new Mark(Mark.ENTRY_PART.TRANSLATION, startPos, i);
                switch (markCodePoint) {
                    case 8234: {
                        mark.painter = LRE_BIDI_PAINTER;
                        break;
                    }
                    case 8235: {
                        mark.painter = RLE_BIDI_PAINTER;
                        break;
                    }
                    case 8237: {
                        mark.painter = LRO_BIDI_PAINTER;
                        break;
                    }
                    case 8238: {
                        mark.painter = RLO_BIDI_PAINTER;
                    }
                }
                marks.add(mark);
                startPos = -1;
                markCodePoint = -1;
                continue;
            }
            if (cp == 8206 || cp == 8207) {
                mark = new Mark(Mark.ENTRY_PART.TRANSLATION, i, i + 1);
                mark.painter = cp == 8206 ? LRM_BIDI_PAINTER : RLM_BIDI_PAINTER;
                marks.add(mark);
                continue;
            }
            markCodePoint = cp;
            startPos = i;
        }
        if (startPos != -1) {
            Mark mark = new Mark(Mark.ENTRY_PART.TRANSLATION, startPos, startPos);
            switch (markCodePoint) {
                case 8234: {
                    mark.painter = LRE_BIDI_PAINTER;
                    break;
                }
                case 8235: {
                    mark.painter = RLE_BIDI_PAINTER;
                    break;
                }
                case 8237: {
                    mark.painter = LRO_BIDI_PAINTER;
                    break;
                }
                case 8238: {
                    mark.painter = RLO_BIDI_PAINTER;
                }
            }
            marks.add(mark);
        }
        return marks;
    }

    @Override
    protected boolean isEnabled() {
        return Core.getEditor().getSettings().isMarkBidi();
    }
}

