/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.xtagqxp;

import org.omegat.filters3.Element;

public class Xtag
implements Element {
    private String tag;
    private String shortcut;
    private int index;

    public Xtag(String tag, int index) {
        this.tag = tag;
        this.shortcut = this.makeShortcut(tag);
        this.index = index;
    }

    private String makeShortcut(String tag) {
        int cp = 0;
        for (int i = 0; i < tag.length(); i += Character.charCount(cp)) {
            cp = tag.codePointAt(i);
            if (!Character.isLetter(cp)) continue;
            cp = Character.toLowerCase(cp);
            return String.valueOf(Character.toChars(cp));
        }
        if (cp == 60) {
            return "<";
        }
        if (cp == 62) {
            return ">";
        }
        return "x";
    }

    public String getTag() {
        return this.tag;
    }

    public String getShortcut() {
        if (this.shortcut != null) {
            return this.shortcut;
        }
        return String.valueOf(Character.toChars(this.getTag().codePointAt(0)));
    }

    @Override
    public String toSafeCalcShortcut() {
        return "\b" + this.getShortcut().replace('<', '_').replace('>', '_') + "\b";
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String toShortcut() {
        StringBuilder buf = new StringBuilder();
        if (this.getShortcut().equals("<")) {
            return "<";
        }
        if (this.getShortcut().equals(">")) {
            return ">";
        }
        buf.append("<");
        buf.append(this.getShortcut());
        buf.append(this.getIndex());
        buf.append("/");
        buf.append(">");
        return buf.toString();
    }

    @Override
    public String toOriginal() {
        return "<" + this.getTag() + ">";
    }

    @Override
    public String toTMX() {
        return "";
    }
}

