/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.cmdline.params.LanguageParams;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.formats.LeipzigDoccatSampleStream;
import opennlp.tools.util.ObjectStream;

public class LeipzigDocumentSampleStreamFactory
extends LanguageSampleStreamFactory<DocumentSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(DocumentSample.class, "leipzig", new LeipzigDocumentSampleStreamFactory(Parameters.class));
    }

    protected <P> LeipzigDocumentSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<DocumentSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        this.language = params.getLang();
        try {
            return new LeipzigDoccatSampleStream(params.getLang(), 20, CmdLineUtil.openInFile(params.getData()));
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while opening sample data: " + e.getMessage(), e);
        }
    }

    static interface Parameters
    extends BasicFormatParams,
    LanguageParams {
    }
}

