/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.TagTableModel;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;

public class TagTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_SELECTED_FOCUS = new Color(-7361793);
    public static final Color BGCOLOR_SELECTED = new Color(-5258497);

    public TagTableCellRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value == null) {
            return this;
        }
        String key = (String)value;
        TagTableModel model = this.getTagTableModel(table);
        String text = "";
        String tooltip = null;
        this.setBorder(null);
        if (model.hasTag(key)) {
            switch (column) {
                case 0: {
                    text = key;
                    break;
                }
                case 1: {
                    text = model.getValue(key);
                    break;
                }
                case 2: {
                    HistoryOsmPrimitive primitive = model.getWhichChangedTag(key);
                    if (primitive == null) break;
                    text = model.getVersionString(primitive);
                    tooltip = I18n.tr("Key ''{0}'' was changed in version {1}", key, primitive.getVersion());
                    this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 2, model.getVersionColor(primitive)));
                    break;
                }
            }
        }
        this.setText(text);
        this.setToolTipText(tooltip != null ? tooltip : text);
        this.setHorizontalAlignment(column == 2 ? 11 : 10);
        TwoColumnDiff.Item.DiffItemType diffItemType = model.getDiffItemType(key, column == 1);
        GuiHelper.setBackgroundReadable(this, diffItemType.getColor(isSelected, table.hasFocus()));
        return this;
    }

    protected TagTableModel getTagTableModel(JTable table) {
        return (TagTableModel)table.getModel();
    }
}

