/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.DateRange;
import ch.poole.openinghoursparser.Element;
import ch.poole.openinghoursparser.Holiday;
import ch.poole.openinghoursparser.RuleModifier;
import ch.poole.openinghoursparser.TimeSpan;
import ch.poole.openinghoursparser.Util;
import ch.poole.openinghoursparser.WeekDayRange;
import ch.poole.openinghoursparser.WeekRange;
import ch.poole.openinghoursparser.YearRange;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Rule
extends Element {
    boolean fallBack = false;
    boolean additive = false;
    boolean twentyfourseven = false;
    boolean colonForClarification = false;
    String comment = null;
    List<YearRange> years = null;
    List<WeekRange> weeks = null;
    List<DateRange> dates = null;
    List<Holiday> holidays = null;
    List<WeekDayRange> days = null;
    List<TimeSpan> times = null;
    RuleModifier modifier = null;

    public Rule() {
    }

    public Rule(@NotNull Rule r) {
        this.fallBack = r.fallBack;
        this.additive = r.additive;
        this.twentyfourseven = r.twentyfourseven;
        this.colonForClarification = r.colonForClarification;
        this.comment = r.comment;
        this.years = Util.copyList(r.years);
        this.weeks = Util.copyList(r.weeks);
        this.dates = Util.copyList(r.dates);
        this.holidays = Util.copyList(r.holidays);
        this.days = Util.copyList(r.days);
        this.times = Util.copyList(r.times);
        this.modifier = r.modifier != null ? r.modifier.copy() : null;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.comment != null) {
            b.append("\"" + this.comment + "\":");
        }
        if (this.twentyfourseven) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append("24/7");
        } else {
            this.printList(false, true, b, "", this.years);
            this.printList(false, true, b, "week ", this.weeks);
            this.printList(false, true, b, "", this.dates);
            if (this.colonForClarification) {
                b.append(":");
            }
            boolean addSpace = true;
            ArrayList<Holiday> holidaysTemp = new ArrayList<Holiday>();
            if (this.holidays != null) {
                for (Holiday h : this.holidays) {
                    if (h.getUseAsWeekDay()) continue;
                    holidaysTemp.add(h);
                }
                if (!holidaysTemp.isEmpty()) {
                    this.printList(false, b.length() > 0, b, "", holidaysTemp);
                    holidaysTemp.clear();
                }
                for (Holiday h : this.holidays) {
                    if (!h.getUseAsWeekDay() || h.getAfterWeekDays()) continue;
                    holidaysTemp.add(h);
                }
                if (!holidaysTemp.isEmpty()) {
                    this.printList(false, b.length() > 0, b, "", holidaysTemp);
                    if (this.days != null && !this.days.isEmpty()) {
                        b.append(",");
                        addSpace = false;
                    }
                    holidaysTemp.clear();
                }
            }
            this.printList(false, addSpace, b, "", this.days);
            if (this.holidays != null) {
                for (Holiday h : this.holidays) {
                    if (!h.getAfterWeekDays()) continue;
                    holidaysTemp.add(h);
                }
                if (!holidaysTemp.isEmpty()) {
                    if (this.days != null && !this.days.isEmpty()) {
                        b.append(",");
                        addSpace = false;
                    }
                    this.printList(false, addSpace, b, "", holidaysTemp);
                }
            }
            this.printList(false, true, b, "", this.times);
        }
        if (this.modifier != null) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(this.modifier.toString());
        }
        return b.toString();
    }

    @Override
    public String toDebugString() {
        StringBuilder b = new StringBuilder();
        if (this.comment != null) {
            b.append("\"" + this.comment + "\":");
        }
        if (this.twentyfourseven) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append("24/7");
        } else {
            this.printList(true, true, b, "", this.years);
            this.printList(true, true, b, "week ", this.weeks);
            this.printList(true, true, b, "", this.dates);
            this.printList(true, true, b, "", this.holidays);
            boolean holidaysAsWeekDays = false;
            if (this.holidays != null && !this.holidays.isEmpty() && this.holidays.get(this.holidays.size() - 1).getUseAsWeekDay() && this.days != null && !this.days.isEmpty()) {
                b.append(",");
                holidaysAsWeekDays = true;
            }
            this.printList(true, !holidaysAsWeekDays, b, "", this.days);
            this.printList(true, true, b, "", this.times);
        }
        if (this.modifier != null) {
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(this.modifier.toDebugString());
        }
        return b.toString();
    }

    <T extends Element> void printList(boolean debug, boolean addSpace, @NotNull StringBuilder b, @NotNull String prefix, @Nullable List<T> list) {
        if (list != null) {
            if (addSpace && b.length() > 0) {
                b.append(" ");
            }
            b.append(prefix);
            Iterator<T> iter = list.iterator();
            while (iter.hasNext()) {
                b.append(debug ? ((Element)iter.next()).toDebugString() : ((Element)iter.next()).toString());
                if (!iter.hasNext()) continue;
                b.append(",");
            }
        }
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Rule) {
            Rule o = (Rule)other;
            return this.fallBack == o.fallBack && this.additive == o.additive && Util.equals(this.comment, o.comment) && this.twentyfourseven == o.twentyfourseven && Util.equals(this.years, o.years) && Util.equals(this.weeks, o.weeks) && Util.equals(this.dates, o.dates) && Util.equals(this.holidays, o.holidays) && Util.equals(this.days, o.days) && Util.equals(this.times, o.times) && Util.equals(this.modifier, o.modifier);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.fallBack ? 0 : 1);
        result = 37 * result + (this.additive ? 0 : 1);
        result = 37 * result + (this.comment == null ? 0 : this.comment.hashCode());
        result = 37 * result + (this.twentyfourseven ? 0 : 1);
        result = 37 * result + (this.years == null ? 0 : this.years.hashCode());
        result = 37 * result + (this.weeks == null ? 0 : this.weeks.hashCode());
        result = 37 * result + (this.dates == null ? 0 : this.dates.hashCode());
        result = 37 * result + (this.holidays == null ? 0 : this.holidays.hashCode());
        result = 37 * result + (this.days == null ? 0 : this.days.hashCode());
        result = 37 * result + (this.times == null ? 0 : this.times.hashCode());
        result = 37 * result + (this.modifier == null ? 0 : this.modifier.hashCode());
        return result;
    }

    public boolean isMergeableWith(Rule r) {
        return this.equals(r) || !this.twentyfourseven && Util.equals(this.comment, r.comment) && Util.equals(this.years, r.years) && Util.equals(this.weeks, r.weeks) && Util.equals(this.dates, r.dates) && Util.equals(this.modifier, r.modifier);
    }

    public boolean isFallBack() {
        return this.fallBack;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isTwentyfourseven() {
        return this.twentyfourseven;
    }

    public void setTwentyfourseven(boolean twentyfourseven) {
        this.twentyfourseven = twentyfourseven;
    }

    @Nullable
    public List<YearRange> getYears() {
        return this.years;
    }

    @Nullable
    public List<WeekRange> getWeeks() {
        return this.weeks;
    }

    @Nullable
    public List<DateRange> getDates() {
        return this.dates;
    }

    @Nullable
    public List<Holiday> getHolidays() {
        return this.holidays;
    }

    @Nullable
    public List<WeekDayRange> getDays() {
        return this.days;
    }

    @Nullable
    public List<TimeSpan> getTimes() {
        return this.times;
    }

    @Nullable
    public RuleModifier getModifier() {
        return this.modifier;
    }

    public void setFallBack(boolean fallBack) {
        this.fallBack = fallBack;
    }

    public void setAdditive(boolean additive) {
        this.additive = additive;
    }

    public void setComment(@Nullable String comment) {
        this.comment = comment;
    }

    public void setYears(@Nullable List<YearRange> years) {
        this.years = years;
    }

    public void setWeeks(@Nullable List<WeekRange> weeks) {
        this.weeks = weeks;
    }

    @Deprecated
    public void setMonthdays(@Nullable List<DateRange> monthdays) {
        this.dates = monthdays;
    }

    public void setDates(@Nullable List<DateRange> dates) {
        this.dates = dates;
    }

    public void setHolidays(@Nullable List<Holiday> holidays) {
        this.holidays = holidays;
    }

    public void setDays(@Nullable List<WeekDayRange> days) {
        this.days = days;
    }

    public void setTimes(@Nullable List<TimeSpan> times) {
        this.times = times;
    }

    public void setModifier(RuleModifier modifier) {
        this.modifier = modifier;
    }

    public boolean isEmpty() {
        if (this.twentyfourseven) {
            return false;
        }
        if (this.comment != null && !"".equals(this.comment)) {
            return false;
        }
        if (this.years != null && !this.years.isEmpty()) {
            return false;
        }
        if (this.weeks != null && !this.weeks.isEmpty()) {
            return false;
        }
        if (this.dates != null && !this.dates.isEmpty()) {
            return false;
        }
        if (this.holidays != null && !this.holidays.isEmpty()) {
            return false;
        }
        if (this.days != null && !this.days.isEmpty()) {
            return false;
        }
        if (this.times != null && !this.times.isEmpty()) {
            return false;
        }
        return this.modifier == null;
    }

    @Override
    public Rule copy() {
        return new Rule(this);
    }
}

