/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.imagery;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.MapPolygonImpl;
import org.openstreetmap.gui.jmapviewer.MapRectangleImpl;
import org.openstreetmap.gui.jmapviewer.interfaces.MapPolygon;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.Shape;
import org.openstreetmap.josm.data.preferences.NamedColorProperty;
import org.openstreetmap.josm.data.sources.SourceInfo;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.bbox.JosmMapViewer;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryDialog;
import org.openstreetmap.josm.gui.preferences.imagery.AddImageryPanel;
import org.openstreetmap.josm.gui.preferences.imagery.AddMVTLayerPanel;
import org.openstreetmap.josm.gui.preferences.imagery.AddTMSLayerPanel;
import org.openstreetmap.josm.gui.preferences.imagery.AddWMSLayerPanel;
import org.openstreetmap.josm.gui.preferences.imagery.AddWMTSLayerPanel;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.TableHelper;
import org.openstreetmap.josm.gui.widgets.FilterField;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.JosmEditorPane;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class ImageryProvidersPanel
extends JPanel {
    public final JTable activeTable;
    public final JTable defaultTable;
    private final FilterField defaultFilter;
    private final transient DefListSelectionListener defaultTableListener;
    public final JosmMapViewer defaultMap;
    public final ImageryLayerTableModel activeModel;
    public final ImageryDefaultLayerTableModel defaultModel;
    public final JToolBar activeToolbar;
    public final JToolBar middleToolbar;
    private final PreferenceTabbedPane gui;
    private final transient ImageryLayerInfo layerInfo;

    public ImageryProvidersPanel(PreferenceTabbedPane gui, ImageryLayerInfo layerInfoArg) {
        super(new GridBagLayout());
        this.gui = gui;
        this.layerInfo = layerInfoArg;
        this.activeModel = new ImageryLayerTableModel();
        this.activeTable = new JTable(this.activeModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                Point p = e.getPoint();
                try {
                    return ImageryProvidersPanel.this.activeModel.getValueAt(this.rowAtPoint(p), this.columnAtPoint(p)).toString();
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    Logging.debug(ex);
                    return null;
                }
            }
        };
        TableHelper.setFont(this.activeTable, this.getClass());
        this.activeTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.defaultModel = new ImageryDefaultLayerTableModel();
        this.defaultTable = new JTable(this.defaultModel);
        TableHelper.setFont(this.defaultTable, this.getClass());
        this.defaultTable.setAutoCreateRowSorter(true);
        this.defaultFilter = new FilterField().filter(this.defaultTable, this.defaultModel);
        this.defaultModel.addTableModelListener(e -> this.activeTable.repaint());
        this.activeModel.addTableModelListener(e -> this.defaultTable.repaint());
        TableColumnModel mod = this.defaultTable.getColumnModel();
        mod.getColumn(3).setPreferredWidth(775);
        mod.getColumn(3).setCellRenderer(new ImageryURLTableCellRenderer(this.layerInfo.getLayers()));
        mod.getColumn(2).setPreferredWidth(475);
        mod.getColumn(2).setCellRenderer(new ImageryNameTableCellRenderer());
        mod.getColumn(1).setCellRenderer(new ImageryCountryTableCellRenderer());
        mod.getColumn(0).setPreferredWidth(50);
        mod.getColumn(0).setCellRenderer(new ImageryCategoryTableCellRenderer());
        mod.getColumn(0).setPreferredWidth(50);
        mod = this.activeTable.getColumnModel();
        mod.getColumn(1).setPreferredWidth(800);
        mod.getColumn(1).setCellRenderer(new ImageryURLTableCellRenderer(this.layerInfo.getAllDefaultLayers()));
        mod.getColumn(0).setPreferredWidth(200);
        RemoveEntryAction remove = new RemoveEntryAction();
        this.activeTable.getSelectionModel().addListSelectionListener(remove);
        this.add((Component)new JLabel(I18n.tr("Available default entries:", new Object[0])), GBC.std().insets(5, 5, 0, 0));
        this.add((Component)new JLabel(I18n.tr("Boundaries of selected imagery entries:", new Object[0])), GBC.eol().insets(5, 5, 0, 0));
        JPanel defaultPane = new JPanel(new GridBagLayout());
        JScrollPane scrolldef = new JScrollPane(this.defaultTable);
        defaultPane.add((Component)this.defaultFilter, GBC.eol().insets(0, 0, 0, 0).fill(2));
        defaultPane.add((Component)scrolldef, GBC.eol().insets(0, 0, 0, 0).fill(1));
        this.add((Component)defaultPane, GBC.std().fill(1).weight(1.0, 0.6).insets(5, 0, 0, 0));
        this.defaultMap = new JosmMapViewer();
        this.defaultMap.setTileSource(JosmMapViewer.DefaultOsmTileSourceProvider.get());
        this.defaultMap.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    ImageryProvidersPanel.this.defaultMap.getAttribution().handleAttribution(e.getPoint(), true);
                }
            }
        });
        this.defaultMap.setZoomControlsVisible(false);
        this.defaultMap.setMinimumSize(new Dimension(100, 200));
        this.add((Component)this.defaultMap, GBC.eol().fill(1).weight(0.33, 0.6).insets(5, 0, 0, 0));
        this.defaultTableListener = new DefListSelectionListener();
        this.defaultTable.getSelectionModel().addListSelectionListener(this.defaultTableListener);
        HtmlPanel help = new HtmlPanel(I18n.tr("New default entries can be added in the <a href=\"{0}\">Wiki</a>.", Config.getUrls().getJOSMWebsite() + "/wiki/Maps"));
        help.enableClickableHyperlinks();
        this.add((Component)help, GBC.eol().insets(5, 0, 0, 0).fill(2));
        ActivateAction activate = new ActivateAction();
        this.defaultTable.getSelectionModel().addListSelectionListener(activate);
        JButton btnActivate = new JButton(activate);
        this.middleToolbar = new JToolBar(0);
        this.middleToolbar.setFloatable(false);
        this.middleToolbar.setBorderPainted(false);
        this.middleToolbar.setOpaque(false);
        this.middleToolbar.add(new ReloadAction());
        this.middleToolbar.add(btnActivate);
        this.add((Component)this.middleToolbar, GBC.eol().anchor(10).insets(5, 5, 5, 0));
        this.add(Box.createHorizontalGlue(), GBC.eol().fill(2));
        JPanel activePanel = new JPanel(new BorderLayout());
        activePanel.add((Component)new JLabel(I18n.tr("Selected entries:", new Object[0])), "North");
        JScrollPane scroll = new JScrollPane(this.activeTable);
        activePanel.add((Component)scroll, "Center");
        this.activeToolbar = new JToolBar(1);
        this.activeToolbar.setFloatable(false);
        this.activeToolbar.setBorderPainted(false);
        this.activeToolbar.setOpaque(false);
        this.activeToolbar.add(new NewEntryAction(ImageryInfo.ImageryType.WMS));
        this.activeToolbar.add(new NewEntryAction(ImageryInfo.ImageryType.TMS));
        this.activeToolbar.add(new NewEntryAction(ImageryInfo.ImageryType.WMTS));
        this.activeToolbar.add(new NewEntryAction(ImageryInfo.ImageryType.MVT));
        this.activeToolbar.add(remove);
        activePanel.add((Component)this.activeToolbar, "East");
        this.add((Component)activePanel, GBC.eol().fill(1).weight(2.0, 0.4).insets(5, 0, 0, 5));
    }

    private static boolean confirmEulaAcceptance(PreferenceTabbedPane gui, String eulaUrl) {
        try {
            JosmEditorPane htmlPane;
            URL url = new URL(eulaUrl.replaceAll("\\{lang}", LanguageInfo.getWikiLanguagePrefix()));
            try {
                htmlPane = new JosmEditorPane(url);
            }
            catch (IOException e1) {
                Logging.trace(e1);
                try {
                    url = new URL(eulaUrl.replaceAll("\\{lang}", ""));
                    htmlPane = new JosmEditorPane(url);
                }
                catch (IOException e2) {
                    Logging.debug(e2);
                    JOptionPane.showMessageDialog(gui, I18n.tr("EULA license URL not available: {0}", eulaUrl));
                    return false;
                }
            }
            Box box = Box.createVerticalBox();
            htmlPane.setEditable(false);
            JScrollPane scrollPane = new JScrollPane(htmlPane);
            scrollPane.setPreferredSize(new Dimension(400, 400));
            box.add(scrollPane);
            int option = JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), box, I18n.tr("Please abort if you are not sure", new Object[0]), 0, 2);
            if (option == 0) {
                return true;
            }
        }
        catch (MalformedURLException e2) {
            JOptionPane.showMessageDialog(gui, I18n.tr("Malformed URL for the EULA licence: {0}", eulaUrl));
        }
        return false;
    }

    public class ImageryLayerTableModel
    extends DefaultTableModel {
        public ImageryLayerTableModel() {
            this.setColumnIdentifiers(new String[]{I18n.tr("Menu Name", new Object[0]), I18n.tr("Imagery URL", new Object[0])});
        }

        public ImageryInfo getRow(int row) {
            return ImageryProvidersPanel.this.layerInfo.getLayers().get(row);
        }

        public void addRow(ImageryInfo i) {
            ImageryProvidersPanel.this.layerInfo.add(i);
            int p = this.getRowCount() - 1;
            this.fireTableRowsInserted(p, p);
        }

        @Override
        public void removeRow(int i) {
            ImageryProvidersPanel.this.layerInfo.remove(this.getRow(i));
            this.fireTableRowsDeleted(i, i);
        }

        @Override
        public int getRowCount() {
            return ImageryProvidersPanel.this.layerInfo.getLayers().size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            ImageryInfo info = ImageryProvidersPanel.this.layerInfo.getLayers().get(row);
            switch (column) {
                case 0: {
                    return info.getName();
                }
                case 1: {
                    return info.getExtendedUrl();
                }
            }
            throw new ArrayIndexOutOfBoundsException(Integer.toString(column));
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            if (ImageryProvidersPanel.this.layerInfo.getLayers().size() <= row) {
                return;
            }
            ImageryInfo info = ImageryProvidersPanel.this.layerInfo.getLayers().get(row);
            switch (column) {
                case 0: {
                    info.setName((String)o);
                    info.clearId();
                    break;
                }
                case 1: {
                    info.setExtendedUrl((String)o);
                    info.clearId();
                    break;
                }
                default: {
                    throw new ArrayIndexOutOfBoundsException(Integer.toString(column));
                }
            }
        }
    }

    public class ImageryDefaultLayerTableModel
    extends DefaultTableModel {
        public ImageryDefaultLayerTableModel() {
            this.setColumnIdentifiers(new String[]{"", "", I18n.tr("Menu Name (Default)", new Object[0]), I18n.tr("Imagery URL (Default)", new Object[0])});
        }

        public ImageryInfo getRow(int row) {
            return ImageryProvidersPanel.this.layerInfo.getAllDefaultLayers().get(row);
        }

        @Override
        public int getRowCount() {
            return ImageryProvidersPanel.this.layerInfo.getAllDefaultLayers().size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return ImageryInfo.ImageryCategory.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return ImageryInfo.class;
                }
                case 3: {
                    return String.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public Object getValueAt(int row, int column) {
            ImageryInfo info = ImageryProvidersPanel.this.layerInfo.getAllDefaultLayers().get(row);
            switch (column) {
                case 0: {
                    return Optional.ofNullable(info.getImageryCategory()).orElse(ImageryInfo.ImageryCategory.OTHER);
                }
                case 1: {
                    return info.getCountryCode();
                }
                case 2: {
                    return info;
                }
                case 3: {
                    return info.getExtendedUrl();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    }

    private static class ImageryURLTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final NamedColorProperty IMAGERY_BACKGROUND_COLOR = new NamedColorProperty(I18n.marktr("Imagery Background: Default"), new Color(200, 255, 200));
        private final transient List<ImageryInfo> layers;

        ImageryURLTableCellRenderer(List<ImageryInfo> layers) {
            this.layers = layers;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            GuiHelper.setBackgroundReadable(label, UIManager.getColor("Table.background"));
            if (value != null) {
                if (this.layers.stream().anyMatch(l -> Objects.equals(l.getExtendedUrl(), value.toString()))) {
                    GuiHelper.setBackgroundReadable(label, IMAGERY_BACKGROUND_COLOR.get());
                }
                label.setToolTipText((String)value);
            }
            return label;
        }
    }

    private static class ImageryNameTableCellRenderer
    extends ImageryTableCellRenderer<ImageryInfo> {
        ImageryNameTableCellRenderer() {
            super((T info) -> info == null ? null : info.getName(), ImageryInfo::getToolTipText, null);
        }
    }

    private static class ImageryCountryTableCellRenderer
    extends ImageryTableCellRenderer<String> {
        ImageryCountryTableCellRenderer() {
            super((T code) -> code, SourceInfo::getLocalizedCountry, null);
        }
    }

    private static class ImageryCategoryTableCellRenderer
    extends ImageryTableCellRenderer<ImageryInfo.ImageryCategory> {
        ImageryCategoryTableCellRenderer() {
            super((T cat) -> null, (T cat) -> I18n.tr("Imagery category: {0}", cat.getDescription()), (cat, label) -> label.setIcon(cat.getIcon(ImageProvider.ImageSizes.TABLE)));
        }
    }

    private class RemoveEntryAction
    extends AbstractAction
    implements ListSelectionListener {
        RemoveEntryAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Remove entry", new Object[0]));
            new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this, true);
            this.updateEnabledState();
        }

        protected final void updateEnabledState() {
            this.setEnabled(ImageryProvidersPanel.this.activeTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            while ((i = ImageryProvidersPanel.this.activeTable.getSelectedRow()) != -1) {
                ImageryProvidersPanel.this.activeModel.removeRow(i);
            }
        }
    }

    private final class DefListSelectionListener
    implements ListSelectionListener {
        private final Map<Integer, MapRectangle> mapRectangles = new HashMap<Integer, MapRectangle>();
        private final Map<Integer, List<MapPolygon>> mapPolygons = new HashMap<Integer, List<MapPolygon>>();

        private DefListSelectionListener() {
        }

        private void clearMap() {
            ImageryProvidersPanel.this.defaultMap.removeAllMapRectangles();
            ImageryProvidersPanel.this.defaultMap.removeAllMapPolygons();
            this.mapRectangles.clear();
            this.mapPolygons.clear();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getFirstIndex() == -1) {
                this.clearMap();
            } else if (!e.getValueIsAdjusting()) {
                for (int i = e.getFirstIndex(); i <= e.getLastIndex(); ++i) {
                    if (i >= ImageryProvidersPanel.this.defaultTable.getRowCount()) continue;
                    this.updateBoundsAndShapes(ImageryProvidersPanel.this.defaultTable.convertRowIndexToModel(i));
                }
                this.cleanupResidualBounds();
                if (!this.mapRectangles.isEmpty() || !this.mapPolygons.isEmpty()) {
                    ImageryProvidersPanel.this.defaultMap.setDisplayToFitMapElements(false, true, true);
                    ImageryProvidersPanel.this.defaultMap.zoomOut();
                }
            }
        }

        private void updateBoundsAndShapes(int i) {
            ImageryInfo.ImageryBounds bounds = ImageryProvidersPanel.this.defaultModel.getRow(i).getBounds();
            if (bounds != null) {
                int viewIndex = ImageryProvidersPanel.this.defaultTable.convertRowIndexToView(i);
                List<Shape> shapes = bounds.getShapes();
                if (!Utils.isEmpty(shapes)) {
                    if (ImageryProvidersPanel.this.defaultTable.getSelectionModel().isSelectedIndex(viewIndex)) {
                        if (!this.mapPolygons.containsKey(i)) {
                            ArrayList<MapPolygonImpl> list = new ArrayList<MapPolygonImpl>();
                            this.mapPolygons.put(i, list);
                            for (Shape shape : shapes) {
                                MapPolygonImpl polygon = new MapPolygonImpl(shape.getPoints());
                                list.add(polygon);
                                ImageryProvidersPanel.this.defaultMap.addMapPolygon(polygon);
                            }
                        }
                    } else if (this.mapPolygons.containsKey(i)) {
                        for (MapPolygon polygon : this.mapPolygons.get(i)) {
                            ImageryProvidersPanel.this.defaultMap.removeMapPolygon(polygon);
                        }
                        this.mapPolygons.remove(i);
                    }
                } else if (ImageryProvidersPanel.this.defaultTable.getSelectionModel().isSelectedIndex(viewIndex)) {
                    if (!this.mapRectangles.containsKey(i)) {
                        Coordinate topLeft = new Coordinate(bounds.getMaxLat(), bounds.getMinLon());
                        Coordinate bottomRight = new Coordinate(bounds.getMinLat(), bounds.getMaxLon());
                        MapRectangleImpl rectangle = new MapRectangleImpl(topLeft, bottomRight);
                        this.mapRectangles.put(i, rectangle);
                        ImageryProvidersPanel.this.defaultMap.addMapRectangle(rectangle);
                    }
                } else if (this.mapRectangles.containsKey(i)) {
                    ImageryProvidersPanel.this.defaultMap.removeMapRectangle(this.mapRectangles.get(i));
                    this.mapRectangles.remove(i);
                }
            }
        }

        private <T> void doCleanupResidualBounds(Map<Integer, T> map, Consumer<T> removalEffect) {
            Iterator<Map.Entry<Integer, T>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, T> e = it.next();
                int viewIndex = ImageryProvidersPanel.this.defaultTable.convertRowIndexToView(e.getKey());
                if (ImageryProvidersPanel.this.defaultTable.getSelectionModel().isSelectedIndex(viewIndex)) continue;
                it.remove();
                removalEffect.accept(e.getValue());
            }
        }

        private void cleanupResidualBounds() {
            this.doCleanupResidualBounds(this.mapPolygons, l -> l.forEach(ImageryProvidersPanel.this.defaultMap::removeMapPolygon));
            this.doCleanupResidualBounds(this.mapRectangles, ImageryProvidersPanel.this.defaultMap::removeMapRectangle);
        }
    }

    private class ActivateAction
    extends AbstractAction
    implements ListSelectionListener {
        ActivateAction() {
            this.putValue("Name", I18n.tr("Activate", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Copy selected default entries from the list above into the list below.", new Object[0]));
            new ImageProvider("preferences", "activate-down").getResource().attachImageIcon(this, true);
        }

        protected void updateEnabledState() {
            this.setEnabled(ImageryProvidersPanel.this.defaultTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] lines = ImageryProvidersPanel.this.defaultTable.getSelectedRows();
            if (lines.length == 0) {
                JOptionPane.showMessageDialog(ImageryProvidersPanel.this.gui, I18n.tr("Please select at least one row to copy.", new Object[0]), I18n.tr("Information", new Object[0]), 1);
                return;
            }
            HashSet<String> acceptedEulas = new HashSet<String>();
            block0: for (int line : lines) {
                ImageryInfo info = ImageryProvidersPanel.this.defaultModel.getRow(ImageryProvidersPanel.this.defaultTable.convertRowIndexToModel(line));
                for (int j = 0; j < ImageryProvidersPanel.this.activeModel.getRowCount(); ++j) {
                    if (!info.equalsBaseValues(ImageryProvidersPanel.this.activeModel.getRow(j))) continue;
                    ImageryProvidersPanel.this.activeTable.getSelectionModel().setSelectionInterval(j, j);
                    ImageryProvidersPanel.this.activeTable.scrollRectToVisible(ImageryProvidersPanel.this.activeTable.getCellRect(j, 0, true));
                    continue block0;
                }
                String eulaURL = info.getEulaAcceptanceRequired();
                if (eulaURL != null && !acceptedEulas.contains(eulaURL)) {
                    if (!ImageryProvidersPanel.confirmEulaAcceptance(ImageryProvidersPanel.this.gui, eulaURL)) continue;
                    acceptedEulas.add(eulaURL);
                }
                ImageryProvidersPanel.this.activeModel.addRow(new ImageryInfo(info));
                int lastLine = ImageryProvidersPanel.this.activeModel.getRowCount() - 1;
                ImageryProvidersPanel.this.activeTable.getSelectionModel().setSelectionInterval(lastLine, lastLine);
                ImageryProvidersPanel.this.activeTable.scrollRectToVisible(ImageryProvidersPanel.this.activeTable.getCellRect(lastLine, 0, true));
            }
        }
    }

    private class ReloadAction
    extends AbstractAction {
        ReloadAction() {
            this.putValue("ShortDescription", I18n.tr("Update default entries", new Object[0]));
            new ImageProvider("dialogs", "refresh").getResource().attachImageIcon(this, true);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ImageryProvidersPanel.this.layerInfo.loadDefaults(true, MainApplication.worker, false);
            this.updateTableArea();
            MainApplication.worker.execute(() -> GuiHelper.runInEDTAndWait(this::updateTableArea));
        }

        private void updateTableArea() {
            ImageryProvidersPanel.this.defaultModel.fireTableDataChanged();
            ImageryProvidersPanel.this.defaultTable.getSelectionModel().clearSelection();
            ImageryProvidersPanel.this.defaultTableListener.clearMap();
            ImageryProvidersPanel.this.activeModel.fireTableDataChanged();
        }
    }

    private class NewEntryAction
    extends AbstractAction {
        private final ImageryInfo.ImageryType type;

        NewEntryAction(ImageryInfo.ImageryType type) {
            this.putValue("Name", type.toString());
            this.putValue("ShortDescription", I18n.tr("Add a new {0} entry by entering the URL", type.toString()));
            String icon = "add";
            switch (type) {
                case WMS: {
                    icon = "add_wms";
                    break;
                }
                case TMS: {
                    icon = "add_tms";
                    break;
                }
                case WMTS: {
                    icon = "add_wmts";
                    break;
                }
                case MVT: {
                    icon = "add_mvt";
                    break;
                }
            }
            new ImageProvider("dialogs", icon).getResource().attachImageIcon(this, true);
            this.type = type;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AddImageryPanel p;
            switch (this.type) {
                case WMS: {
                    p = new AddWMSLayerPanel();
                    break;
                }
                case TMS: {
                    p = new AddTMSLayerPanel();
                    break;
                }
                case WMTS: {
                    p = new AddWMTSLayerPanel();
                    break;
                }
                case MVT: {
                    p = new AddMVTLayerPanel();
                    break;
                }
                default: {
                    throw new IllegalStateException("Type " + String.valueOf(this.type) + " not supported");
                }
            }
            AddImageryDialog addDialog = new AddImageryDialog(ImageryProvidersPanel.this.gui, p);
            addDialog.showDialog();
            if (addDialog.getValue() == 1) {
                try {
                    ImageryProvidersPanel.this.activeModel.addRow(p.getImageryInfo());
                }
                catch (IllegalArgumentException ex) {
                    if (Utils.isEmpty(ex.getMessage())) {
                        throw ex;
                    }
                    JOptionPane.showMessageDialog(MainApplication.getMainFrame(), ex.getMessage(), I18n.tr("Error", new Object[0]), 0);
                }
            }
        }
    }

    private static class ImageryTableCellRenderer<T>
    extends DefaultTableCellRenderer {
        private final Function<T, Object> mapper;
        private final Function<T, String> tooltip;
        private final BiConsumer<T, JLabel> decorator;

        ImageryTableCellRenderer(Function<T, Object> mapper, Function<T, String> tooltip, BiConsumer<T, JLabel> decorator) {
            this.mapper = mapper;
            this.tooltip = tooltip;
            this.decorator = decorator;
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object obj = value;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, this.mapper.apply(obj), isSelected, hasFocus, row, column);
            GuiHelper.setBackgroundReadable(label, isSelected ? UIManager.getColor("Table.selectionBackground") : UIManager.getColor("Table.background"));
            if (obj != null) {
                label.setToolTipText(this.tooltip.apply(obj));
                if (this.decorator != null) {
                    this.decorator.accept(obj, label);
                }
            }
            return label;
        }
    }
}

